/* /home4/luszczek/mscratch/build/SCALAPACK/SRC/pcheevx.f -- translated by f2c (version 20031025).
   You must link the resulting object file with libf2c:
	on Microsoft Windows system, link with libf2c.lib;
	on Linux or Unix systems, link with .../path/to/libf2c.a -lm
	or, if you install libf2c.a in a standard place, with -lf2c -lm
	-- in that order, at the end of the command line, as in
		cc *.o -lf2c -lm
	Source for libf2c is in /netlib/f2c/libf2c.zip, e.g.,

		http://www.netlib.org/f2c/libf2c.zip
*/

#include "f2c.h"

/* Table of constant values */

static integer c__4 = 4;
static integer c__8 = 8;
static integer c__21 = 21;
static integer c__1 = 1;
static integer c__0 = 0;
static integer c__3 = 3;
static real c_b71 = 1.f;
static integer c_n1 = -1;

/* Subroutine */ int pcheevx_(char *jobz, char *range, char *uplo, integer *n,
	 complex *a, integer *ia, integer *ja, integer *desca, real *vl, real 
	*vu, integer *il, integer *iu, real *abstol, integer *m, integer *nz, 
	real *w, real *orfac, complex *z__, integer *iz, integer *jz, integer 
	*descz, complex *work, integer *lwork, real *rwork, integer *lrwork, 
	integer *iwork, integer *liwork, integer *ifail, integer *iclustr, 
	real *gap, integer *info, ftnlen jobz_len, ftnlen range_len, ftnlen 
	uplo_len)
{
    /* System generated locals */
    integer i__1, i__2, i__3;
    real r__1, r__2;
    complex q__1;

    /* Builtin functions */
    double sqrt(doublereal);

    /* Local variables */
    extern /* Subroutine */ int pchentrd_(char *, integer *, complex *, 
	    integer *, integer *, integer *, real *, real *, complex *, 
	    complex *, integer *, real *, integer *, integer *, ftnlen);
    integer lallwork, indrwork;
    extern /* Subroutine */ int pslared1d_(integer *, integer *, integer *, 
	    integer *, real *, real *, real *, integer *);
    integer i__, sizeheevx, sizestein, nb, nn, mq0, np0, nq0, isizestein, 
	    isizestebz, anb;
    real eps;
    integer nnp;
    real vll;
    integer nps;
    real vuu;
    integer nzz, mb_a__, nb_a__;
    logical quickreturn;
    integer indd, inde, neig;
    real anrm, rmin, rmax;
    integer indd2, inde2, idum1[4], idum2[4], nhetrd_lwopt__;
    extern integer iceil_(integer *, integer *);
    real sigma;
    extern logical lsame_(char *, char *, ftnlen, ftnlen);
    integer iinfo;
    extern /* Subroutine */ int lfc_SLsscal(integer *, real *, real *, integer *);
    char order[1];
    integer npcol, iarow, mycol, sqnpc, lwmin;
    logical lower;
    integer ictxt;
    logical wantz;
    integer lwopt, nprow, izrow, myrow, icoffa, csrc_a__;
    logical alleig, indeig;
    integer iscale, indibl, iroffa;
    logical valeig;
    integer rsrc_a__;
    real safmin, abstll, bignum;
    integer indisp, indtau, offset, iroffz, liwmin, rsrc_z__;
    extern integer numroc_(integer *, integer *, integer *, integer *, 
	    integer *);
    integer nprocs;
    extern /* Subroutine */ int blacs_gridinfo__(integer *, integer *, 
	    integer *, integer *, integer *);
    integer lrwmin, nsplit, llwork;
    real smlnum;
    extern /* Subroutine */ int slasrt_(char *, integer *, real *, integer *, 
	    ftnlen);
    logical lquery;
    extern /* Subroutine */ int igamn2d_(integer *, char *, char *, integer *,
	     integer *, integer *, integer *, integer *, integer *, integer *,
	     integer *, integer *, ftnlen, ftnlen);
    integer lrwopt;
    extern /* Subroutine */ int chk1mat_(integer *, integer *, integer *, 
	    integer *, integer *, integer *, integer *, integer *, integer *),
	     sgebr2d_(integer *, char *, char *, integer *, integer *, real *,
	     integer *, integer *, integer *, ftnlen, ftnlen), sgebs2d_(
	    integer *, char *, char *, integer *, integer *, real *, integer *
	    , ftnlen, ftnlen);
    extern integer indxg2p_(integer *, integer *, integer *, integer *, 
	    integer *);
    extern doublereal pclanhe_(char *, char *, integer *, complex *, integer *
	    , integer *, integer *, real *, ftnlen, ftnlen);
    extern /* Subroutine */ int pclascl_(char *, real *, real *, integer *, 
	    integer *, complex *, integer *, integer *, integer *, integer *, 
	    ftnlen), pcelget_(char *, char *, complex *, complex *, integer *,
	     integer *, integer *, ftnlen, ftnlen);
    extern doublereal pslamch_(integer *, char *, ftnlen);
    integer maxeigs;
    extern integer pjlaenv_(integer *, integer *, char *, char *, integer *, 
	    integer *, integer *, integer *, ftnlen, ftnlen);
    extern /* Subroutine */ int pxerbla_(integer *, char *, integer *, ftnlen)
	    , pcstein_(integer *, real *, real *, integer *, real *, integer *
	    , integer *, real *, complex *, integer *, integer *, integer *, 
	    real *, integer *, integer *, integer *, integer *, integer *, 
	    real *, integer *);
    integer indwork;
    extern /* Subroutine */ int pcunmtr_(char *, char *, char *, integer *, 
	    integer *, complex *, integer *, integer *, integer *, complex *, 
	    complex *, integer *, integer *, integer *, complex *, integer *, 
	    integer *, ftnlen, ftnlen, ftnlen), psstebz_(integer *, char *, 
	    char *, integer *, real *, real *, integer *, integer *, real *, 
	    real *, real *, integer *, integer *, real *, integer *, integer *
	    , real *, integer *, integer *, integer *, integer *, ftnlen, 
	    ftnlen);
    integer llrwork;
    extern /* Subroutine */ int pchk1mat_(integer *, integer *, integer *, 
	    integer *, integer *, integer *, integer *, integer *, integer *, 
	    integer *, integer *, integer *), pchk2mat_(integer *, integer *, 
	    integer *, integer *, integer *, integer *, integer *, integer *, 
	    integer *, integer *, integer *, integer *, integer *, integer *, 
	    integer *, integer *, integer *, integer *, integer *, integer *);


/*  -- ScaLAPACK routine (version 1.7) -- */
/*     University of Tennessee, Knoxville, Oak Ridge National Laboratory, */
/*     and University of California, Berkeley. */
/*     May 25, 2001 */

/*     .. Scalar Arguments .. */
/*     .. */
/*     .. Array Arguments .. */
/*     .. */

/*  Purpose */
/*  ======= */

/*  PCHEEVX computes selected eigenvalues and, optionally, eigenvectors */
/*  of a complex hermitian matrix A by calling the recommended sequence */
/*  of ScaLAPACK routines.  Eigenvalues/vectors can be selected by */
/*  specifying a range of values or a range of indices for the desired */
/*  eigenvalues. */

/*  Notes */
/*  ===== */

/*  Each global data object is described by an associated description */
/*  vector.  This vector stores the information required to establish */
/*  the mapping between an object element and its corresponding process */
/*  and memory location. */

/*  Let A be a generic term for any 2D block cyclicly distributed array. */
/*  Such a global array has an associated description vector DESCA. */
/*  In the following comments, the character _ should be read as */
/*  "of the global array". */

/*  NOTATION        STORED IN      EXPLANATION */
/*  --------------- -------------- -------------------------------------- */
/*  DTYPE_A(global) DESCA( DTYPE_ )The descriptor type.  In this case, */
/*                                 DTYPE_A = 1. */
/*  CTXT_A (global) DESCA( CTXT_ ) The BLACS context handle, indicating */
/*                                 the BLACS process grid A is distribu- */
/*                                 ted over. The context itself is glo- */
/*                                 bal, but the handle (the integer */
/*                                 value) may vary. */
/*  M_A    (global) DESCA( M_ )    The number of rows in the global */
/*                                 array A. */
/*  N_A    (global) DESCA( N_ )    The number of columns in the global */
/*                                 array A. */
/*  MB_A   (global) DESCA( MB_ )   The blocking factor used to distribute */
/*                                 the rows of the array. */
/*  NB_A   (global) DESCA( NB_ )   The blocking factor used to distribute */
/*                                 the columns of the array. */
/*  RSRC_A (global) DESCA( RSRC_ ) The process row over which the first */
/*                                 row of the array A is distributed. */
/*  CSRC_A (global) DESCA( CSRC_ ) The process column over which the */
/*                                 first column of the array A is */
/*                                 distributed. */
/*  LLD_A  (local)  DESCA( LLD_ )  The leading dimension of the local */
/*                                 array.  LLD_A >= MAX(1,LOCr(M_A)). */

/*  Let K be the number of rows or columns of a distributed matrix, */
/*  and assume that its process grid has dimension p x q. */
/*  LOCr( K ) denotes the number of elements of K that a process */
/*  would receive if K were distributed over the p processes of its */
/*  process column. */
/*  Similarly, LOCc( K ) denotes the number of elements of K that a */
/*  process would receive if K were distributed over the q processes of */
/*  its process row. */
/*  The values of LOCr() and LOCc() may be determined via a call to the */
/*  ScaLAPACK tool function, NUMROC: */
/*          LOCr( M ) = NUMROC( M, MB_A, MYROW, RSRC_A, NPROW ), */
/*          LOCc( N ) = NUMROC( N, NB_A, MYCOL, CSRC_A, NPCOL ). */
/*  An upper bound for these quantities may be computed by: */
/*          LOCr( M ) <= ceil( ceil(M/MB_A)/NPROW )*MB_A */
/*          LOCc( N ) <= ceil( ceil(N/NB_A)/NPCOL )*NB_A */

/*  PCHEEVX assumes IEEE 754 standard compliant arithmetic.  To port */
/*  to a system which does not have IEEE 754 arithmetic, modify */
/*  the appropriate SLmake.inc file to include the compiler switch */
/*  -DNO_IEEE.  This switch only affects the compilation of pslaiect.c. */

/*  Arguments */
/*  ========= */

/*     NP = the number of rows local to a given process. */
/*     NQ = the number of columns local to a given process. */

/*  JOBZ    (global input) CHARACTER*1 */
/*          Specifies whether or not to compute the eigenvectors: */
/*          = 'N':  Compute eigenvalues only. */
/*          = 'V':  Compute eigenvalues and eigenvectors. */

/*  RANGE   (global input) CHARACTER*1 */
/*          = 'A': all eigenvalues will be found. */
/*          = 'V': all eigenvalues in the interval [VL,VU] will be found. */
/*          = 'I': the IL-th through IU-th eigenvalues will be found. */

/*  UPLO    (global input) CHARACTER*1 */
/*          Specifies whether the upper or lower triangular part of the */
/*          Hermitian matrix A is stored: */
/*          = 'U':  Upper triangular */
/*          = 'L':  Lower triangular */

/*  N       (global input) INTEGER */
/*          The number of rows and columns of the matrix A.  N >= 0. */

/*  A       (local input/workspace) block cyclic COMPLEX array, */
/*          global dimension (N, N), */
/*          local dimension ( LLD_A, LOCc(JA+N-1) ) */

/*          On entry, the Hermitian matrix A.  If UPLO = 'U', only the */
/*          upper triangular part of A is used to define the elements of */
/*          the Hermitian matrix.  If UPLO = 'L', only the lower */
/*          triangular part of A is used to define the elements of the */
/*          Hermitian matrix. */

/*          On exit, the lower triangle (if UPLO='L') or the upper */
/*          triangle (if UPLO='U') of A, including the diagonal, is */
/*          destroyed. */

/*  IA      (global input) INTEGER */
/*          A's global row index, which points to the beginning of the */
/*          submatrix which is to be operated on. */

/*  JA      (global input) INTEGER */
/*          A's global column index, which points to the beginning of */
/*          the submatrix which is to be operated on. */

/*  DESCA   (global and local input) INTEGER array of dimension DLEN_. */
/*          The array descriptor for the distributed matrix A. */
/*          If DESCA( CTXT_ ) is incorrect, PCHEEVX cannot guarantee */
/*          correct error reporting. */

/*  VL      (global input) REAL */
/*          If RANGE='V', the lower bound of the interval to be searched */
/*          for eigenvalues.  Not referenced if RANGE = 'A' or 'I'. */

/*  VU      (global input) REAL */
/*          If RANGE='V', the upper bound of the interval to be searched */
/*          for eigenvalues.  Not referenced if RANGE = 'A' or 'I'. */

/*  IL      (global input) INTEGER */
/*          If RANGE='I', the index (from smallest to largest) of the */
/*          smallest eigenvalue to be returned.  IL >= 1. */
/*          Not referenced if RANGE = 'A' or 'V'. */

/*  IU      (global input) INTEGER */
/*          If RANGE='I', the index (from smallest to largest) of the */
/*          largest eigenvalue to be returned.  min(IL,N) <= IU <= N. */
/*          Not referenced if RANGE = 'A' or 'V'. */

/*  ABSTOL  (global input) REAL */
/*          If JOBZ='V', setting ABSTOL to PSLAMCH( CONTEXT, 'U') yields */
/*          the most orthogonal eigenvectors. */

/*          The absolute error tolerance for the eigenvalues. */
/*          An approximate eigenvalue is accepted as converged */
/*          when it is determined to lie in an interval [a,b] */
/*          of width less than or equal to */

/*                  ABSTOL + EPS *   max( |a|,|b| ) , */

/*          where EPS is the machine precision.  If ABSTOL is less than */
/*          or equal to zero, then EPS*norm(T) will be used in its place, */
/*          where norm(T) is the 1-norm of the tridiagonal matrix */
/*          obtained by reducing A to tridiagonal form. */

/*          Eigenvalues will be computed most accurately when ABSTOL is */
/*          set to twice the underflow threshold 2*PSLAMCH('S') not zero. */
/*          If this routine returns with ((MOD(INFO,2).NE.0) .OR. */
/*          (MOD(INFO/8,2).NE.0)), indicating that some eigenvalues or */
/*          eigenvectors did not converge, try setting ABSTOL to */
/*          2*PSLAMCH('S'). */

/*          See "Computing Small Singular Values of Bidiagonal Matrices */
/*          with Guaranteed High Relative Accuracy," by Demmel and */
/*          Kahan, LAPACK Working Note #3. */

/*          See "On the correctness of Parallel Bisection in Floating */
/*          Point" by Demmel, Dhillon and Ren, LAPACK Working Note #70 */

/*  M       (global output) INTEGER */
/*          Total number of eigenvalues found.  0 <= M <= N. */

/*  NZ      (global output) INTEGER */
/*          Total number of eigenvectors computed.  0 <= NZ <= M. */
/*          The number of columns of Z that are filled. */
/*          If JOBZ .NE. 'V', NZ is not referenced. */
/*          If JOBZ .EQ. 'V', NZ = M unless the user supplies */
/*          insufficient space and PCHEEVX is not able to detect this */
/*          before beginning computation.  To get all the eigenvectors */
/*          requested, the user must supply both sufficient */
/*          space to hold the eigenvectors in Z (M .LE. DESCZ(N_)) */
/*          and sufficient workspace to compute them.  (See LWORK below.) */
/*          PCHEEVX is always able to detect insufficient space without */
/*          computation unless RANGE .EQ. 'V'. */

/*  W       (global output) REAL array, dimension (N) */
/*          On normal exit, the first M entries contain the selected */
/*          eigenvalues in ascending order. */

/*  ORFAC   (global input) REAL */
/*          Specifies which eigenvectors should be reorthogonalized. */
/*          Eigenvectors that correspond to eigenvalues which are within */
/*          tol=ORFAC*norm(A) of each other are to be reorthogonalized. */
/*          However, if the workspace is insufficient (see LWORK), */
/*          tol may be decreased until all eigenvectors to be */
/*          reorthogonalized can be stored in one process. */
/*          No reorthogonalization will be done if ORFAC equals zero. */
/*          A default value of 10^-3 is used if ORFAC is negative. */
/*          ORFAC should be identical on all processes. */

/*  Z       (local output) COMPLEX array, */
/*          global dimension (N, N), */
/*          local dimension ( LLD_Z, LOCc(JZ+N-1) ) */
/*          If JOBZ = 'V', then on normal exit the first M columns of Z */
/*          contain the orthonormal eigenvectors of the matrix */
/*          corresponding to the selected eigenvalues.  If an eigenvector */
/*          fails to converge, then that column of Z contains the latest */
/*          approximation to the eigenvector, and the index of the */
/*          eigenvector is returned in IFAIL. */
/*          If JOBZ = 'N', then Z is not referenced. */

/*  IZ      (global input) INTEGER */
/*          Z's global row index, which points to the beginning of the */
/*          submatrix which is to be operated on. */

/*  JZ      (global input) INTEGER */
/*          Z's global column index, which points to the beginning of */
/*          the submatrix which is to be operated on. */

/*  DESCZ   (global and local input) INTEGER array of dimension DLEN_. */
/*          The array descriptor for the distributed matrix Z. */
/*          DESCZ( CTXT_ ) must equal DESCA( CTXT_ ) */

/*  WORK    (local workspace/output) COMPLEX array, */
/*          dimension (LWORK) */
/*          WORK(1) returns workspace adequate workspace to allow */
/*          optimal performance. */

/*  LWORK   (local input) INTEGER */
/*          Size of WORK array.  If only eigenvalues are requested: */
/*            LWORK >= N + MAX( NB * ( NP0 + 1 ), 3 ) */
/*          If eigenvectors are requested: */
/*            LWORK >= N + ( NP0 + MQ0 + NB ) * NB */
/*          with NQ0 = NUMROC( NN, NB, 0, 0, NPCOL ). */

/*          For optimal performance, greater workspace is needed, i.e. */
/*            LWORK >= MAX( LWORK, NHETRD_LWORK ) */
/*          Where LWORK is as defined above, and */
/*          NHETRD_LWORK = N + 2*( ANB+1 )*( 4*NPS+2 ) + */
/*            ( NPS + 1 ) * NPS */

/*          ICTXT = DESCA( CTXT_ ) */
/*          ANB = PJLAENV( ICTXT, 3, 'PCHETTRD', 'L', 0, 0, 0, 0 ) */
/*          SQNPC = SQRT( DBLE( NPROW * NPCOL ) ) */
/*          NPS = MAX( NUMROC( N, 1, 0, 0, SQNPC ), 2*ANB ) */

/*          NUMROC is a ScaLAPACK tool functions; */
/*          PJLAENV is a ScaLAPACK envionmental inquiry function */
/*          MYROW, MYCOL, NPROW and NPCOL can be determined by calling */
/*          the subroutine BLACS_GRIDINFO. */

/*          If LWORK = -1, then LWORK is global input and a workspace */
/*          query is assumed; the routine only calculates the */
/*          optimal size for all work arrays. Each of these */
/*          values is returned in the first entry of the corresponding */
/*          work array, and no error message is issued by PXERBLA. */

/*  RWORK   (local workspace/output) REAL array, */
/*             dimension (LRWORK) */
/*          On return, WROK(1) contains the optimal amount of */
/*          workspace required for efficient execution. */
/*          if JOBZ='N' RWORK(1) = optimal amount of workspace */
/*             required to compute eigenvalues efficiently */
/*          if JOBZ='V' RWORK(1) = optimal amount of workspace */
/*             required to compute eigenvalues and eigenvectors */
/*             efficiently with no guarantee on orthogonality. */
/*             If RANGE='V', it is assumed that all eigenvectors */
/*             may be required. */

/*  LRWORK   (local input) INTEGER */
/*          Size of RWORK */
/*          See below for definitions of variables used to define LRWORK. */
/*          If no eigenvectors are requested (JOBZ = 'N') then */
/*             LRWORK >= 5 * NN + 4 * N */
/*          If eigenvectors are requested (JOBZ = 'V' ) then */
/*             the amount of workspace required to guarantee that all */
/*             eigenvectors are computed is: */
/*             LRWORK >= 4*N + MAX( 5*NN, NP0 * MQ0 ) + */
/*               ICEIL( NEIG, NPROW*NPCOL)*NN */

/*             The computed eigenvectors may not be orthogonal if the */
/*             minimal workspace is supplied and ORFAC is too small. */
/*             If you want to guarantee orthogonality (at the cost */
/*             of potentially poor performance) you should add */
/*             the following to LRWORK: */
/*                (CLUSTERSIZE-1)*N */
/*             where CLUSTERSIZE is the number of eigenvalues in the */
/*             largest cluster, where a cluster is defined as a set of */
/*             close eigenvalues: { W(K),...,W(K+CLUSTERSIZE-1) | */
/*                                  W(J+1) <= W(J) + ORFAC*2*norm(A) } */
/*          Variable definitions: */
/*             NEIG = number of eigenvectors requested */
/*             NB = DESCA( MB_ ) = DESCA( NB_ ) = */
/*                  DESCZ( MB_ ) = DESCZ( NB_ ) */
/*             NN = MAX( N, NB, 2 ) */
/*             DESCA( RSRC_ ) = DESCA( NB_ ) = DESCZ( RSRC_ ) = */
/*                              DESCZ( CSRC_ ) = 0 */
/*             NP0 = NUMROC( NN, NB, 0, 0, NPROW ) */
/*             MQ0 = NUMROC( MAX( NEIG, NB, 2 ), NB, 0, 0, NPCOL ) */
/*             ICEIL( X, Y ) is a ScaLAPACK function returning */
/*             ceiling(X/Y) */

/*          When LRWORK is too small: */
/*             If LRWORK is too small to guarantee orthogonality, */
/*             PCHEEVX attempts to maintain orthogonality in */
/*             the clusters with the smallest */
/*             spacing between the eigenvalues. */
/*             If LRWORK is too small to compute all the eigenvectors */
/*             requested, no computation is performed and INFO=-25 */
/*             is returned.  Note that when RANGE='V', PCHEEVX does */
/*             not know how many eigenvectors are requested until */
/*             the eigenvalues are computed.  Therefore, when RANGE='V' */
/*             and as long as LRWORK is large enough to allow PCHEEVX to */
/*             compute the eigenvalues, PCHEEVX will compute the */
/*             eigenvalues and as many eigenvectors as it can. */

/*          Relationship between workspace, orthogonality & performance: */
/*             If CLUSTERSIZE >= N/SQRT(NPROW*NPCOL), then providing */
/*             enough space to compute all the eigenvectors */
/*             orthogonally will cause serious degradation in */
/*             performance. In the limit (i.e. CLUSTERSIZE = N-1) */
/*             PCSTEIN will perform no better than CSTEIN on 1 */
/*             processor. */
/*             For CLUSTERSIZE = N/SQRT(NPROW*NPCOL) reorthogonalizing */
/*             all eigenvectors will increase the total execution time */
/*             by a factor of 2 or more. */
/*             For CLUSTERSIZE > N/SQRT(NPROW*NPCOL) execution time will */
/*             grow as the square of the cluster size, all other factors */
/*             remaining equal and assuming enough workspace.  Less */
/*             workspace means less reorthogonalization but faster */
/*             execution. */

/*          If LRWORK = -1, then LRWORK is global input and a workspace */
/*          query is assumed; the routine only calculates the size */
/*          required for optimal performance for all work arrays. Each of */
/*          these values is returned in the first entry of the */
/*          corresponding work arrays, and no error message is issued by */
/*          PXERBLA. */

/*  IWORK   (local workspace) INTEGER array */
/*          On return, IWORK(1) contains the amount of integer workspace */
/*          required. */

/*  LIWORK  (local input) INTEGER */
/*          size of IWORK */
/*          LIWORK >= 6 * NNP */
/*          Where: */
/*            NNP = MAX( N, NPROW*NPCOL + 1, 4 ) */
/*          If LIWORK = -1, then LIWORK is global input and a workspace */
/*          query is assumed; the routine only calculates the minimum */
/*          and optimal size for all work arrays. Each of these */
/*          values is returned in the first entry of the corresponding */
/*          work array, and no error message is issued by PXERBLA. */

/*  IFAIL   (global output) INTEGER array, dimension (N) */
/*          If JOBZ = 'V', then on normal exit, the first M elements of */
/*          IFAIL are zero.  If (MOD(INFO,2).NE.0) on exit, then */
/*          IFAIL contains the */
/*          indices of the eigenvectors that failed to converge. */
/*          If JOBZ = 'N', then IFAIL is not referenced. */

/*  ICLUSTR (global output) integer array, dimension (2*NPROW*NPCOL) */
/*          This array contains indices of eigenvectors corresponding to */
/*          a cluster of eigenvalues that could not be reorthogonalized */
/*          due to insufficient workspace (see LWORK, ORFAC and INFO). */
/*          Eigenvectors corresponding to clusters of eigenvalues indexed */
/*          ICLUSTR(2*I-1) to ICLUSTR(2*I), could not be */
/*          reorthogonalized due to lack of workspace. Hence the */
/*          eigenvectors corresponding to these clusters may not be */
/*          orthogonal.  ICLUSTR() is a zero terminated array. */
/*          (ICLUSTR(2*K).NE.0 .AND. ICLUSTR(2*K+1).EQ.0) if and only if */
/*          K is the number of clusters */
/*          ICLUSTR is not referenced if JOBZ = 'N' */

/*  GAP     (global output) REAL array, */
/*             dimension (NPROW*NPCOL) */
/*          This array contains the gap between eigenvalues whose */
/*          eigenvectors could not be reorthogonalized. The output */
/*          values in this array correspond to the clusters indicated */
/*          by the array ICLUSTR. As a result, the dot product between */
/*          eigenvectors correspoding to the I^th cluster may be as high */
/*          as ( C * n ) / GAP(I) where C is a small constant. */

/*  INFO    (global output) INTEGER */
/*          = 0:  successful exit */
/*          < 0:  If the i-th argument is an array and the j-entry had */
/*                an illegal value, then INFO = -(i*100+j), if the i-th */
/*                argument is a scalar and had an illegal value, then */
/*                INFO = -i. */
/*          > 0:  if (MOD(INFO,2).NE.0), then one or more eigenvectors */
/*                  failed to converge.  Their indices are stored */
/*                  in IFAIL.  Ensure ABSTOL=2.0*PSLAMCH( 'U' ) */
/*                  Send e-mail to scalapack@cs.utk.edu */
/*                if (MOD(INFO/2,2).NE.0),then eigenvectors corresponding */
/*                  to one or more clusters of eigenvalues could not be */
/*                  reorthogonalized because of insufficient workspace. */
/*                  The indices of the clusters are stored in the array */
/*                  ICLUSTR. */
/*                if (MOD(INFO/4,2).NE.0), then space limit prevented */
/*                  PCHEEVX from computing all of the eigenvectors */
/*                  between VL and VU.  The number of eigenvectors */
/*                  computed is returned in NZ. */
/*                if (MOD(INFO/8,2).NE.0), then PCSTEBZ failed to compute */
/*                  eigenvalues.  Ensure ABSTOL=2.0*PSLAMCH( 'U' ) */
/*                  Send e-mail to scalapack@cs.utk.edu */

/*  Alignment requirements */
/*  ====================== */

/*  The distributed submatrices A(IA:*, JA:*) and C(IC:IC+M-1,JC:JC+N-1) */
/*  must verify some alignment properties, namely the following */
/*  expressions should be true: */

/*  ( MB_A.EQ.NB_A.EQ.MB_Z .AND. IROFFA.EQ.IROFFZ .AND. IROFFA.EQ.0 .AND. */
/*    IAROW.EQ.IZROW ) */
/*  where */
/*  IROFFA = MOD( IA-1, MB_A ) and ICOFFA = MOD( JA-1, NB_A ). */

/*  ===================================================================== */

/*  Differences between PCHEEVX and CHEEVX */
/*  ====================================== */

/*  A, LDA -> A, IA, JA, DESCA */
/*  Z, LDZ -> Z, IZ, JZ, DESCZ */
/*  WORKSPACE needs are larger for PCHEEVX. */
/*  LIWORK parameter added */

/*  ORFAC, ICLUSTER() and GAP() parameters added */
/*  meaning of INFO is changed */

/*  Functional differences: */
/*  PCHEEVX does not promise orthogonality for eigenvectors associated */
/*  with tighly clustered eigenvalues. */
/*  PCHEEVX does not reorthogonalize eigenvectors */
/*  that are on different processes. The extent of reorthogonalization */
/*  is controlled by the input parameter LWORK. */

/*  Version 1.4 limitations: */
/*     DESCA(MB_) = DESCA(NB_) */
/*     DESCA(M_) = DESCZ(M_) */
/*     DESCA(N_) = DESCZ(N_) */
/*     DESCA(MB_) = DESCZ(MB_) */
/*     DESCA(NB_) = DESCZ(NB_) */
/*     DESCA(RSRC_) = DESCZ(RSRC_) */

/*     .. Parameters .. */
/*     .. */
/*     .. Local Scalars .. */
/*     .. */
/*     .. Local Arrays .. */
/*     .. */
/*     .. External Functions .. */
/*     .. */
/*     .. External Subroutines .. */
/*     .. */
/*     .. Intrinsic Functions .. */
/*     .. */
/*     .. Executable Statements .. */
/*       This is just to keep ftnchek and toolpack/1 happy */
    /* Parameter adjustments */
    --gap;
    --iclustr;
    --ifail;
    --iwork;
    --rwork;
    --work;
    --descz;
    --z__;
    --w;
    --desca;
    --a;

    /* Function Body */
    if (FALSE_) {
	return 0;
    }

    quickreturn = *n == 0;

/*     Test the input arguments. */

    ictxt = desca[2];
    blacs_gridinfo__(&ictxt, &nprow, &npcol, &myrow, &mycol);
    *info = 0;

    wantz = lsame_(jobz, "V", (ftnlen)1, (ftnlen)1);
    if (nprow == -1) {
	*info = -802;
    } else if (wantz) {
	if (ictxt != descz[2]) {
	    *info = -2102;
	}
    }
    if (*info == 0) {
	chk1mat_(n, &c__4, n, &c__4, ia, ja, &desca[1], &c__8, info);
	if (wantz) {
	    chk1mat_(n, &c__4, n, &c__4, iz, jz, &descz[1], &c__21, info);
	}

	if (*info == 0) {

/*     Get machine constants. */

	    safmin = pslamch_(&ictxt, "Safe minimum", (ftnlen)12);
	    eps = pslamch_(&ictxt, "Precision", (ftnlen)9);
	    smlnum = safmin / eps;
	    bignum = 1.f / smlnum;
	    rmin = sqrt(smlnum);
/* Computing MIN */
	    r__1 = sqrt(bignum), r__2 = 1.f / sqrt(sqrt(safmin));
	    rmax = dmin(r__1,r__2);

	    nprocs = nprow * npcol;
	    lower = lsame_(uplo, "L", (ftnlen)1, (ftnlen)1);
	    alleig = lsame_(range, "A", (ftnlen)1, (ftnlen)1);
	    valeig = lsame_(range, "V", (ftnlen)1, (ftnlen)1);
	    indeig = lsame_(range, "I", (ftnlen)1, (ftnlen)1);

/*     Set up pointers into the WORK array */

	    indtau = 1;
	    indwork = indtau + *n;
	    llwork = *lwork - indwork + 1;

/*     Set up pointers into the RWORK array */

	    inde = 1;
	    indd = inde + *n;
	    indd2 = indd + *n;
	    inde2 = indd2 + *n;
	    indrwork = inde2 + *n;
	    llrwork = *lrwork - indrwork + 1;

/*     Set up pointers into the IWORK array */

	    isizestein = *n * 3 + nprocs + 1;
/* Computing MAX */
	    i__1 = *n << 2, i__1 = max(i__1,14);
	    isizestebz = max(i__1,nprocs);
	    indibl = max(isizestein,isizestebz) + 1;
	    indisp = indibl + *n;

/*     Compute the total amount of space needed */

	    lquery = FALSE_;
	    if (*lwork == -1 || *liwork == -1 || *lrwork == -1) {
		lquery = TRUE_;
	    }

/* Computing MAX */
	    i__1 = *n, i__2 = nprocs + 1, i__1 = max(i__1,i__2);
	    nnp = max(i__1,4);
	    liwmin = nnp * 6;

	    nprocs = nprow * npcol;
	    nb_a__ = desca[6];
	    mb_a__ = desca[5];
	    nb = nb_a__;
/* Computing MAX */
	    i__1 = max(*n,nb);
	    nn = max(i__1,2);

	    rsrc_a__ = desca[7];
	    csrc_a__ = desca[8];
	    iroffa = (*ia - 1) % mb_a__;
	    icoffa = (*ja - 1) % nb_a__;
	    iarow = indxg2p_(&c__1, &nb_a__, &myrow, &rsrc_a__, &nprow);
	    i__1 = *n + iroffa;
	    np0 = numroc_(&i__1, &nb, &c__0, &c__0, &nprow);
	    i__1 = *n + icoffa;
	    mq0 = numroc_(&i__1, &nb, &c__0, &c__0, &npcol);
	    if (wantz) {
		rsrc_z__ = descz[7];
		iroffz = (*iz - 1) % mb_a__;
		izrow = indxg2p_(&c__1, &nb_a__, &myrow, &rsrc_z__, &nprow);
	    }

	    if (! wantz || valeig && ! lquery) {
/* Computing MAX */
		i__1 = nb * (np0 + 1);
		lwmin = *n + max(i__1,3);
		lwopt = lwmin;
		lrwmin = nn * 5 + (*n << 2);
		if (wantz) {
/* Computing MAX */
		    i__2 = max(*n,nb);
		    i__1 = max(i__2,2);
		    mq0 = numroc_(&i__1, &nb, &c__0, &c__0, &npcol);
/* Computing MAX */
		    i__1 = nn * 5, i__2 = np0 * mq0;
		    i__3 = nprow * npcol;
		    lrwopt = (*n << 2) + max(i__1,i__2) + iceil_(n, &i__3) * 
			    nn;
		} else {
		    lrwopt = lrwmin;
		}
		neig = 0;
	    } else {
		if (alleig || valeig) {
		    neig = *n;
		} else if (indeig) {
		    neig = *iu - *il + 1;
		}
/* Computing MAX */
		i__2 = max(neig,nb);
		i__1 = max(i__2,2);
		mq0 = numroc_(&i__1, &nb, &c__0, &c__0, &npcol);
		nq0 = numroc_(&nn, &nb, &c__0, &c__0, &npcol);
		lwmin = *n + (np0 + nq0 + nb) * nb;
/* Computing MAX */
		i__1 = nn * 5, i__2 = np0 * mq0;
		i__3 = nprow * npcol;
		lrwmin = (*n << 2) + max(i__1,i__2) + iceil_(&neig, &i__3) * 
			nn;
		lrwopt = lrwmin;
		lwopt = lwmin;

	    }

/*           Conpute how much workspace is needed to use the */
/*           new TRD code */

	    anb = pjlaenv_(&ictxt, &c__3, "PCHETTRD", "L", &c__0, &c__0, &
		    c__0, &c__0, (ftnlen)8, (ftnlen)1);
	    sqnpc = (integer) sqrt((doublereal) (nprow * npcol));
/* Computing MAX */
	    i__1 = numroc_(n, &c__1, &c__0, &c__0, &sqnpc), i__2 = anb << 1;
	    nps = max(i__1,i__2);
	    nhetrd_lwopt__ = (anb + 1 << 1) * ((nps << 2) + 2) + (nps + 2) * 
		    nps;
/* Computing MAX */
	    i__1 = lwopt, i__2 = *n + nhetrd_lwopt__;
	    lwopt = max(i__1,i__2);

	}
	if (*info == 0) {
	    if (myrow == 0 && mycol == 0) {
		rwork[1] = *abstol;
		if (valeig) {
		    rwork[2] = *vl;
		    rwork[3] = *vu;
		} else {
		    rwork[2] = 0.f;
		    rwork[3] = 0.f;
		}
		sgebs2d_(&ictxt, "ALL", " ", &c__3, &c__1, &rwork[1], &c__3, (
			ftnlen)3, (ftnlen)1);
	    } else {
		sgebr2d_(&ictxt, "ALL", " ", &c__3, &c__1, &rwork[1], &c__3, &
			c__0, &c__0, (ftnlen)3, (ftnlen)1);
	    }
	    if (! (wantz || lsame_(jobz, "N", (ftnlen)1, (ftnlen)1))) {
		*info = -1;
	    } else if (! (alleig || valeig || indeig)) {
		*info = -2;
	    } else if (! (lower || lsame_(uplo, "U", (ftnlen)1, (ftnlen)1))) {
		*info = -3;
	    } else if (valeig && *n > 0 && *vu <= *vl) {
		*info = -10;
	    } else if (indeig && (*il < 1 || *il > max(1,*n))) {
		*info = -11;
	    } else if (indeig && (*iu < min(*n,*il) || *iu > *n)) {
		*info = -12;
	    } else if (*lwork < lwmin && *lwork != -1) {
		*info = -23;
	    } else if (*lrwork < lrwmin && *lrwork != -1) {
		*info = -25;
	    } else if (*liwork < liwmin && *liwork != -1) {
		*info = -27;
	    } else if (valeig && (r__1 = rwork[2] - *vl, dabs(r__1)) > eps * 
		    5.f * dabs(*vl)) {
		*info = -9;
	    } else if (valeig && (r__1 = rwork[3] - *vu, dabs(r__1)) > eps * 
		    5.f * dabs(*vu)) {
		*info = -10;
	    } else if ((r__1 = rwork[1] - *abstol, dabs(r__1)) > eps * 5.f * 
		    dabs(*abstol)) {
		*info = -13;
	    } else if (iroffa != 0) {
		*info = -6;
	    } else if (desca[5] != desca[6]) {
		*info = -806;
	    }
	    if (wantz) {
		if (iroffa != iroffz) {
		    *info = -19;
		} else if (iarow != izrow) {
		    *info = -19;
		} else if (desca[3] != descz[3]) {
		    *info = -2103;
		} else if (desca[4] != descz[4]) {
		    *info = -2104;
		} else if (desca[5] != descz[5]) {
		    *info = -2105;
		} else if (desca[6] != descz[6]) {
		    *info = -2106;
		} else if (desca[7] != descz[7]) {
		    *info = -2107;
		} else if (desca[8] != descz[8]) {
		    *info = -2108;
		} else if (ictxt != descz[2]) {
		    *info = -2102;
		}
	    }
	}
	if (wantz) {
	    idum1[0] = 'V';
	} else {
	    idum1[0] = 'N';
	}
	idum2[0] = 1;
	if (lower) {
	    idum1[1] = 'L';
	} else {
	    idum1[1] = 'U';
	}
	idum2[1] = 2;
	if (alleig) {
	    idum1[2] = 'A';
	} else if (indeig) {
	    idum1[2] = 'I';
	} else {
	    idum1[2] = 'V';
	}
	idum2[2] = 3;
	if (lquery) {
	    idum1[3] = -1;
	} else {
	    idum1[3] = 1;
	}
	idum2[3] = 4;
	if (wantz) {
	    pchk2mat_(n, &c__4, n, &c__4, ia, ja, &desca[1], &c__8, n, &c__4, 
		    n, &c__4, iz, jz, &descz[1], &c__21, &c__4, idum1, idum2, 
		    info);
	} else {
	    pchk1mat_(n, &c__4, n, &c__4, ia, ja, &desca[1], &c__8, &c__4, 
		    idum1, idum2, info);
	}
	q__1.r = (real) lwopt, q__1.i = 0.f;
	work[1].r = q__1.r, work[1].i = q__1.i;
	rwork[1] = (real) lrwopt;
	iwork[1] = liwmin;
    }

    if (*info != 0) {
	i__1 = -(*info);
	pxerbla_(&ictxt, "PCHEEVX", &i__1, (ftnlen)7);
	return 0;
    } else if (lquery) {
	return 0;
    }

/*     Quick return if possible */

    if (quickreturn) {
	if (wantz) {
	    *nz = 0;
	    iclustr[1] = 0;
	}
	*m = 0;
	q__1.r = (real) lwopt, q__1.i = 0.f;
	work[1].r = q__1.r, work[1].i = q__1.i;
	rwork[1] = (real) lrwmin;
	iwork[1] = liwmin;
	return 0;
    }

/*     Scale matrix to allowable range, if necessary. */

    abstll = *abstol;
    iscale = 0;
    if (valeig) {
	vll = *vl;
	vuu = *vu;
    } else {
	vll = 0.f;
	vuu = 0.f;
    }

    anrm = pclanhe_("M", uplo, n, &a[1], ia, ja, &desca[1], &rwork[indrwork], 
	    (ftnlen)1, (ftnlen)1);

    if (anrm > 0.f && anrm < rmin) {
	iscale = 1;
	sigma = rmin / anrm;
	anrm *= sigma;
    } else if (anrm > rmax) {
	iscale = 1;
	sigma = rmax / anrm;
	anrm *= sigma;
    }

    if (iscale == 1) {
	pclascl_(uplo, &c_b71, &sigma, n, n, &a[1], ia, ja, &desca[1], &iinfo,
		 (ftnlen)1);
	if (*abstol > 0.f) {
	    abstll = *abstol * sigma;
	}
	if (valeig) {
	    vll = *vl * sigma;
	    vuu = *vu * sigma;
	    if (vuu == vll) {
/* Computing MAX */
		r__1 = dabs(vuu) * eps;
		vuu += dmax(r__1,safmin) * 2;
	    }
	}
    }

/*     Call PCHENTRD to reduce Hermitian matrix to tridiagonal form. */

    lallwork = llrwork;

    pchentrd_(uplo, n, &a[1], ia, ja, &desca[1], &rwork[indd], &rwork[inde], &
	    work[indtau], &work[indwork], &llwork, &rwork[indrwork], &llrwork,
	     &iinfo, (ftnlen)1);


/*     Copy the values of D, E to all processes */

/*     Here PxLARED1D is used to redistribute the tridiagonal matrix. */
/*     PxLARED1D, however, doesn't yet work with arbritary matrix */
/*     distributions so we have PxELGET as a backup. */

    offset = 0;
    if (*ia == 1 && *ja == 1 && rsrc_a__ == 0 && csrc_a__ == 0) {
	pslared1d_(n, ia, ja, &desca[1], &rwork[indd], &rwork[indd2], &rwork[
		indrwork], &llrwork);

	pslared1d_(n, ia, ja, &desca[1], &rwork[inde], &rwork[inde2], &rwork[
		indrwork], &llrwork);
	if (! lower) {
	    offset = 1;
	}
    } else {
	i__1 = *n;
	for (i__ = 1; i__ <= i__1; ++i__) {
	    i__2 = i__ + *ia - 1;
	    i__3 = i__ + *ja - 1;
	    pcelget_("A", " ", &work[indd2 + i__ - 1], &a[1], &i__2, &i__3, &
		    desca[1], (ftnlen)1, (ftnlen)1);
	    i__2 = indd2 + i__ - 1;
	    rwork[indd2 + i__ - 1] = work[i__2].r;
/* L10: */
	}
	if (lsame_(uplo, "U", (ftnlen)1, (ftnlen)1)) {
	    i__1 = *n - 1;
	    for (i__ = 1; i__ <= i__1; ++i__) {
		i__2 = i__ + *ia - 1;
		i__3 = i__ + *ja;
		pcelget_("A", " ", &work[inde2 + i__ - 1], &a[1], &i__2, &
			i__3, &desca[1], (ftnlen)1, (ftnlen)1);
		i__2 = inde2 + i__ - 1;
		rwork[inde2 + i__ - 1] = work[i__2].r;
/* L20: */
	    }
	} else {
	    i__1 = *n - 1;
	    for (i__ = 1; i__ <= i__1; ++i__) {
		i__2 = i__ + *ia;
		i__3 = i__ + *ja - 1;
		pcelget_("A", " ", &work[inde2 + i__ - 1], &a[1], &i__2, &
			i__3, &desca[1], (ftnlen)1, (ftnlen)1);
		i__2 = inde2 + i__ - 1;
		rwork[inde2 + i__ - 1] = work[i__2].r;
/* L30: */
	    }
	}
    }

/*     Call PSSTEBZ and, if eigenvectors are desired, PCSTEIN. */

    if (wantz) {
	*(unsigned char *)order = 'B';
    } else {
	*(unsigned char *)order = 'E';
    }

    psstebz_(&ictxt, range, order, n, &vll, &vuu, il, iu, &abstll, &rwork[
	    indd2], &rwork[inde2 + offset], m, &nsplit, &w[1], &iwork[indibl],
	     &iwork[indisp], &rwork[indrwork], &llrwork, &iwork[1], &
	    isizestebz, &iinfo, (ftnlen)1, (ftnlen)1);


/*     IF PSSTEBZ fails, the error propogates to INFO, but */
/*     we do not propogate the eigenvalue(s) which failed because: */
/*     1)  This should never happen if the user specifies */
/*         ABSTOL = 2 * PSLAMCH( 'U' ) */
/*     2)  PSSTEIN will confirm/deny whether the eigenvalues are */
/*         close enough. */

    if (iinfo != 0) {
	*info += 8;
	i__1 = *m;
	for (i__ = 1; i__ <= i__1; ++i__) {
	    iwork[indibl + i__ - 1] = (i__2 = iwork[indibl + i__ - 1], abs(
		    i__2));
/* L40: */
	}
    }
    if (wantz) {

	if (valeig) {

/*           Compute the maximum number of eigenvalues that we can */
/*           compute in the */
/*           workspace that we have, and that we can store in Z. */

/*           Loop through the possibilities looking for the largest */
/*           NZ that we can feed to PCSTEIN and PCUNMTR */

/*           Since all processes must end up with the same value */
/*           of NZ, we first compute the minimum of LALLWORK */

	    igamn2d_(&ictxt, "A", " ", &c__1, &c__1, &lallwork, &c__1, &c__1, 
		    &c__1, &c_n1, &c_n1, &c_n1, (ftnlen)1, (ftnlen)1);

	    maxeigs = descz[4];

	    for (*nz = min(maxeigs,*m); *nz >= 0; --(*nz)) {
		mq0 = numroc_(nz, &nb, &c__0, &c__0, &npcol);
/* Computing MAX */
		i__1 = *n * 5, i__2 = np0 * mq0;
		sizestein = iceil_(nz, &nprocs) * *n + max(i__1,i__2);
		sizeheevx = sizestein;
		if (sizeheevx <= lallwork) {
		    goto L60;
		}
/* L50: */
	    }
L60:
	    ;
	} else {
	    *nz = *m;
	}
	*nz = max(*nz,0);
	if (*nz != *m) {
	    *info += 4;

	    i__1 = *m;
	    for (i__ = 1; i__ <= i__1; ++i__) {
		ifail[i__] = 0;
/* L70: */
	    }

/*     The following code handles a rare special case */
/*       - NZ .NE. M means that we don't have enough room to store */
/*         all the vectors. */
/*       - NSPLIT .GT. 1 means that the matrix split */
/*     In this case, we cannot simply take the first NZ eigenvalues */
/*     because PSSTEBZ sorts the eigenvalues by block when */
/*     a split occurs.  So, we have to make another call to */
/*     PSSTEBZ with a new upper limit - VUU. */

	    if (nsplit > 1) {
		slasrt_("I", m, &w[1], &iinfo, (ftnlen)1);
		nzz = 0;
		if (*nz > 0) {

		    vuu = w[*nz] - (eps * anrm + safmin) * 10.f;
		    if (vll >= vuu) {
			nzz = 0;
		    } else {
			psstebz_(&ictxt, range, order, n, &vll, &vuu, il, iu, 
				&abstll, &rwork[indd2], &rwork[inde2 + offset]
				, &nzz, &nsplit, &w[1], &iwork[indibl], &
				iwork[indisp], &rwork[indrwork], &llrwork, &
				iwork[1], &isizestebz, &iinfo, (ftnlen)1, (
				ftnlen)1);
		    }

		    if (*info / 8 % 1 == 0) {
			if (nzz > *nz || iinfo != 0) {
			    *info += 8;
			}
		    }
		}
		*nz = min(*nz,nzz);

	    }
	}
	pcstein_(n, &rwork[indd2], &rwork[inde2 + offset], nz, &w[1], &iwork[
		indibl], &iwork[indisp], orfac, &z__[1], iz, jz, &descz[1], &
		rwork[indrwork], &lallwork, &iwork[1], &isizestein, &ifail[1],
		 &iclustr[1], &gap[1], &iinfo);

	if (iinfo >= *nz + 1) {
	    *info += 2;
	}
	if (iinfo % (*nz + 1) != 0) {
	    ++(*info);
	}

/*     Z = Q * Z */


	if (*nz > 0) {
	    pcunmtr_("L", uplo, "N", n, nz, &a[1], ia, ja, &desca[1], &work[
		    indtau], &z__[1], iz, jz, &descz[1], &work[indwork], &
		    llwork, &iinfo, (ftnlen)1, (ftnlen)1, (ftnlen)1);
	}

    }

/*     If matrix was scaled, then rescale eigenvalues appropriately. */

    if (iscale == 1) {
	r__1 = 1.f / sigma;
	lfc_SLsscal(m, &r__1, &w[1], &c__1);
    }

    q__1.r = (real) lwopt, q__1.i = 0.f;
    work[1].r = q__1.r, work[1].i = q__1.i;
    rwork[1] = (real) lrwopt;
    iwork[1] = liwmin;

    return 0;

/*     End of PCHEEVX */

} /* pcheevx_ */

