/* /home4/luszczek/mscratch/build/SCALAPACK/SRC/cpttrsv.f -- translated by f2c (version 20031025).
   You must link the resulting object file with libf2c:
	on Microsoft Windows system, link with libf2c.lib;
	on Linux or Unix systems, link with .../path/to/libf2c.a -lm
	or, if you install libf2c.a in a standard place, with -lf2c -lm
	-- in that order, at the end of the command line, as in
		cc *.o -lf2c -lm
	Source for libf2c is in /netlib/f2c/libf2c.zip, e.g.,

		http://www.netlib.org/f2c/libf2c.zip
*/

#include "f2c.h"

/* Subroutine */ int cpttrsv_(char *uplo, char *trans, integer *n, integer *
	nrhs, real *d__, complex *e, complex *b, integer *ldb, integer *info, 
	ftnlen uplo_len, ftnlen trans_len)
{
    /* System generated locals */
    integer b_dim1, b_offset, i__1, i__2, i__3, i__4, i__5, i__6;
    complex q__1, q__2, q__3;

    /* Builtin functions */
    void r_cnjg(complex *, complex *);

    /* Local variables */
    integer i__, j;
    extern logical lsame_(char *, char *, ftnlen, ftnlen);
    logical upper;
    extern /* Subroutine */ int xerbla_(char *, integer *, ftnlen);
    logical notran;


/*     Written by Andrew J. Cleary, University of Tennessee. */
/*     November, 1996. */
/*     Modified from CPTTRS: */
/*  -- LAPACK routine (preliminary version) -- */
/*     Univ. of Tennessee, Univ. of California Berkeley, NAG Ltd., */
/*     Courant Institute, Argonne National Lab, and Rice University */

/*     .. Scalar Arguments .. */
/*     .. */
/*     .. Array Arguments .. */
/*     .. */

/*  Purpose */
/*  ======= */

/*  CPTTRSV solves one of the triangular systems */
/*     L * X = B, or  L**H * X = B, */
/*     U * X = B, or  U**H * X = B, */
/*  where L or U is the Cholesky factor of a Hermitian positive */
/*  definite tridiagonal matrix A such that */
/*  A = U**H*D*U or A = L*D*L**H (computed by CPTTRF). */

/*  Arguments */
/*  ========= */

/*  UPLO    (input) CHARACTER*1 */
/*          Specifies whether the superdiagonal or the subdiagonal */
/*          of the tridiagonal matrix A is stored and the form of the */
/*          factorization: */
/*          = 'U':  E is the superdiagonal of U, and A = U'*D*U; */
/*          = 'L':  E is the subdiagonal of L, and A = L*D*L'. */
/*          (The two forms are equivalent if A is real.) */

/*  TRANS   (input) CHARACTER */
/*          Specifies the form of the system of equations: */
/*          = 'N':  L * X = B     (No transpose) */
/*          = 'N':  L * X = B     (No transpose) */
/*          = 'C':  U**H * X = B  (Conjugate transpose) */
/*          = 'C':  L**H * X = B  (Conjugate transpose) */

/*  N       (input) INTEGER */
/*          The order of the tridiagonal matrix A.  N >= 0. */

/*  NRHS    (input) INTEGER */
/*          The number of right hand sides, i.e., the number of columns */
/*          of the matrix B.  NRHS >= 0. */

/*  D       (input) REAL array, dimension (N) */
/*          The n diagonal elements of the diagonal matrix D from the */
/*          factorization computed by CPTTRF. */

/*  E       (input) COMPLEX array, dimension (N-1) */
/*          The (n-1) off-diagonal elements of the unit bidiagonal */
/*          factor U or L from the factorization computed by CPTTRF */
/*          (see UPLO). */

/*  B       (input/output) COMPLEX array, dimension (LDB,NRHS) */
/*          On entry, the right hand side matrix B. */
/*          On exit, the solution matrix X. */

/*  LDB     (input) INTEGER */
/*          The leading dimension of the array B.  LDB >= max(1,N). */

/*  INFO    (output) INTEGER */
/*          = 0:  successful exit */
/*          < 0:  if INFO = -i, the i-th argument had an illegal value */

/*  ===================================================================== */

/*     .. Local Scalars .. */
/*     .. */
/*     .. External Functions .. */
/*     .. */
/*     .. External Subroutines .. */
/*     .. */
/*     .. Intrinsic Functions .. */
/*     .. */
/*     .. Executable Statements .. */

/*     Test the input arguments. */

    /* Parameter adjustments */
    --d__;
    --e;
    b_dim1 = *ldb;
    b_offset = 1 + b_dim1;
    b -= b_offset;

    /* Function Body */
    *info = 0;
    notran = lsame_(trans, "N", (ftnlen)1, (ftnlen)1);
    upper = lsame_(uplo, "U", (ftnlen)1, (ftnlen)1);
    if (! upper && ! lsame_(uplo, "L", (ftnlen)1, (ftnlen)1)) {
	*info = -1;
    } else if (! notran && ! lsame_(trans, "C", (ftnlen)1, (ftnlen)1)) {
	*info = -2;
    } else if (*n < 0) {
	*info = -3;
    } else if (*nrhs < 0) {
	*info = -4;
    } else if (*ldb < max(1,*n)) {
	*info = -8;
    }
    if (*info != 0) {
	i__1 = -(*info);
	xerbla_("CPTTRS", &i__1, (ftnlen)6);
	return 0;
    }

/*     Quick return if possible */

    if (*n == 0) {
	return 0;
    }

    if (upper) {

	if (! notran) {

	    i__1 = *nrhs;
	    for (j = 1; j <= i__1; ++j) {

/*           Solve U**T (or H) * x = b. */

		i__2 = *n;
		for (i__ = 2; i__ <= i__2; ++i__) {
		    i__3 = i__ + j * b_dim1;
		    i__4 = i__ + j * b_dim1;
		    i__5 = i__ - 1 + j * b_dim1;
		    r_cnjg(&q__3, &e[i__ - 1]);
		    q__2.r = b[i__5].r * q__3.r - b[i__5].i * q__3.i, q__2.i =
			     b[i__5].r * q__3.i + b[i__5].i * q__3.r;
		    q__1.r = b[i__4].r - q__2.r, q__1.i = b[i__4].i - q__2.i;
		    b[i__3].r = q__1.r, b[i__3].i = q__1.i;
/* L10: */
		}
/* L30: */
	    }

	} else {

	    i__1 = *nrhs;
	    for (j = 1; j <= i__1; ++j) {

/*           Solve U * x = b. */

		for (i__ = *n - 1; i__ >= 1; --i__) {
		    i__2 = i__ + j * b_dim1;
		    i__3 = i__ + j * b_dim1;
		    i__4 = i__ + 1 + j * b_dim1;
		    i__5 = i__;
		    q__2.r = b[i__4].r * e[i__5].r - b[i__4].i * e[i__5].i, 
			    q__2.i = b[i__4].r * e[i__5].i + b[i__4].i * e[
			    i__5].r;
		    q__1.r = b[i__3].r - q__2.r, q__1.i = b[i__3].i - q__2.i;
		    b[i__2].r = q__1.r, b[i__2].i = q__1.i;
/* L20: */
		}
/* L35: */
	    }
	}

    } else {

	if (notran) {

	    i__1 = *nrhs;
	    for (j = 1; j <= i__1; ++j) {

/*           Solve L * x = b. */

		i__2 = *n;
		for (i__ = 2; i__ <= i__2; ++i__) {
		    i__3 = i__ + j * b_dim1;
		    i__4 = i__ + j * b_dim1;
		    i__5 = i__ - 1 + j * b_dim1;
		    i__6 = i__ - 1;
		    q__2.r = b[i__5].r * e[i__6].r - b[i__5].i * e[i__6].i, 
			    q__2.i = b[i__5].r * e[i__6].i + b[i__5].i * e[
			    i__6].r;
		    q__1.r = b[i__4].r - q__2.r, q__1.i = b[i__4].i - q__2.i;
		    b[i__3].r = q__1.r, b[i__3].i = q__1.i;
/* L40: */
		}
/* L60: */
	    }

	} else {

	    i__1 = *nrhs;
	    for (j = 1; j <= i__1; ++j) {

/*           Solve L**H * x = b. */

		for (i__ = *n - 1; i__ >= 1; --i__) {
		    i__2 = i__ + j * b_dim1;
		    i__3 = i__ + j * b_dim1;
		    i__4 = i__ + 1 + j * b_dim1;
		    r_cnjg(&q__3, &e[i__]);
		    q__2.r = b[i__4].r * q__3.r - b[i__4].i * q__3.i, q__2.i =
			     b[i__4].r * q__3.i + b[i__4].i * q__3.r;
		    q__1.r = b[i__3].r - q__2.r, q__1.i = b[i__3].i - q__2.i;
		    b[i__2].r = q__1.r, b[i__2].i = q__1.i;
/* L50: */
		}
/* L65: */
	    }
	}

    }

    return 0;

/*     End of CPTTRS */

} /* cpttrsv_ */

