/* /home4/luszczek/mscratch/build/SCALAPACK/PBLAS/SRC/PTZBLAS/zahemv.f -- translated by f2c (version 20031025).
   You must link the resulting object file with libf2c:
	on Microsoft Windows system, link with libf2c.lib;
	on Linux or Unix systems, link with .../path/to/libf2c.a -lm
	or, if you install libf2c.a in a standard place, with -lf2c -lm
	-- in that order, at the end of the command line, as in
		cc *.o -lf2c -lm
	Source for libf2c is in /netlib/f2c/libf2c.zip, e.g.,

		http://www.netlib.org/f2c/libf2c.zip
*/

#include "f2c.h"

/* Subroutine */ int zahemv_(char *uplo, integer *n, doublereal *alpha, 
	doublecomplex *a, integer *lda, doublecomplex *x, integer *incx, 
	doublereal *beta, doublereal *y, integer *incy, ftnlen uplo_len)
{
    /* System generated locals */
    integer a_dim1, a_offset, i__1, i__2, i__3;
    doublereal d__1, d__2;

    /* Builtin functions */
    double d_imag(doublecomplex *);

    /* Local variables */
    integer i__, j, ix, iy, jx, jy, kx, ky, info;
    doublereal temp0, temp1, temp2;
    extern logical lsame_(char *, char *, ftnlen, ftnlen);
    doublereal talpha;
    extern /* Subroutine */ int xerbla_(char *, integer *, ftnlen);


/*  -- PBLAS auxiliary routine (version 2.0) -- */
/*     University of Tennessee, Knoxville, Oak Ridge National Laboratory, */
/*     and University of California, Berkeley. */
/*     April 1, 1998 */

/*     .. Scalar Arguments .. */
/*     .. */
/*     .. Array Arguments .. */
/*     .. */

/*  Purpose */
/*  ======= */

/*  ZAHEMV performs the following matrix-vector operation */

/*     y := abs( alpha )*abs( A )*abs( x )+ abs( beta*y ), */

/*  where  alpha  and  beta  are real scalars, y is a real vector, x is a */
/*  vector and A is an n by n Hermitian matrix. */

/*  Arguments */
/*  ========= */

/*  UPLO    (input) CHARACTER*1 */
/*          On entry, UPLO  specifies whether the upper or lower triangu- */
/*          lar part of the array A is to be referenced as follows: */

/*             UPLO = 'U' or 'u'   Only the upper triangular part of A is */
/*                                 to be referenced. */
/*             UPLO = 'L' or 'l'   Only the lower triangular part of A is */
/*                                 to be referenced. */

/*  N       (input) INTEGER */
/*          On entry, N specifies the order of the matrix A. N must be at */
/*          least zero. */

/*  ALPHA   (input) DOUBLE PRECISION */
/*          On entry, ALPHA specifies the real scalar alpha. */

/*  A       (input) COMPLEX*16 array */
/*          On entry,  A  is an array of dimension (LDA,N).  Before entry */
/*          with UPLO = 'U' or 'u', the leading n by n part of the  array */
/*          A must contain the upper triangular part of the Hermitian ma- */
/*          trix and the strictly lower triangular part of A is not refe- */
/*          renced.  When  UPLO = 'L' or 'l',  the leading n by n part of */
/*          the array  A  must  contain  the lower triangular part of the */
/*          Hermitian matrix and the strictly upper trapezoidal part of A */
/*          is not referenced. */
/*          Note that the  imaginary parts  of the local entries  corres- */
/*          ponding to the offdiagonal elements of A need not  be set and */
/*          assumed to be zero. */

/*  LDA     (input) INTEGER */
/*          On entry, LDA specifies the leading dimension of the array A. */
/*          LDA must be at least max( 1, N ). */

/*  X       (input) COMPLEX*16 array of dimension at least */
/*          ( 1 + ( n - 1 )*abs( INCX ) ).  Before entry, the incremented */
/*          array X must contain the vector x. */

/*  INCX    (input) INTEGER */
/*          On entry, INCX specifies the increment for the elements of X. */
/*          INCX must not be zero. */

/*  BETA    (input) DOUBLE PRECISION */
/*          On entry,  BETA  specifies the real scalar beta. When BETA is */
/*          supplied as zero then Y need not be set on input. */

/*  Y       (input/output) DOUBLE PRECISION array of dimension at least */
/*          ( 1 + ( n - 1 )*abs( INCY ) ).  Before  entry with  BETA non- */
/*          zero, the  incremented array  Y must contain the vector y. On */
/*          exit, the  incremented array  Y is overwritten by the updated */
/*          vector y. */

/*  INCY    (input) INTEGER */
/*          On entry, INCY specifies the increment for the elements of Y. */
/*          INCY must not be zero. */

/*  -- Written on April 1, 1998 by */
/*     Antoine Petitet, University  of  Tennessee, Knoxville 37996, USA. */

/*  ===================================================================== */

/*     .. Parameters .. */
/*     .. */
/*     .. Local Scalars .. */
/*     .. */
/*     .. External Functions .. */
/*     .. */
/*     .. External Subroutines .. */
/*     .. */
/*     .. Intrinsic Functions .. */
/*     .. */
/*     .. Statement Functions .. */
/*     .. */
/*     .. Executable Statements .. */

/*     Test the input parameters. */

    /* Parameter adjustments */
    a_dim1 = *lda;
    a_offset = 1 + a_dim1;
    a -= a_offset;
    --x;
    --y;

    /* Function Body */
    info = 0;
    if (! lsame_(uplo, "U", (ftnlen)1, (ftnlen)1) && ! lsame_(uplo, "L", (
	    ftnlen)1, (ftnlen)1)) {
	info = 1;
    } else if (*n < 0) {
	info = 2;
    } else if (*lda < max(1,*n)) {
	info = 5;
    } else if (*incx == 0) {
	info = 7;
    } else if (*incy == 0) {
	info = 10;
    }
    if (info != 0) {
	xerbla_("ZAHEMV", &info, (ftnlen)6);
	return 0;
    }

/*     Quick return if possible. */

    if (*n == 0 || *alpha == 0. && *beta == 1.) {
	return 0;
    }

/*     Set up the start points in  X  and  Y. */

    if (*incx > 0) {
	kx = 1;
    } else {
	kx = 1 - (*n - 1) * *incx;
    }
    if (*incy > 0) {
	ky = 1;
    } else {
	ky = 1 - (*n - 1) * *incy;
    }

/*     Start the operations. In this version the elements of A are */
/*     accessed sequentially with one pass through the triangular part */
/*     of A. */

/*     First form  y := abs( beta * y ). */

    if (*beta != 1.) {
	if (*incy == 1) {
	    if (*beta == 0.) {
		i__1 = *n;
		for (i__ = 1; i__ <= i__1; ++i__) {
		    y[i__] = 0.;
/* L10: */
		}
	    } else {
		i__1 = *n;
		for (i__ = 1; i__ <= i__1; ++i__) {
		    y[i__] = (d__1 = *beta * y[i__], abs(d__1));
/* L20: */
		}
	    }
	} else {
	    iy = ky;
	    if (*beta == 0.) {
		i__1 = *n;
		for (i__ = 1; i__ <= i__1; ++i__) {
		    y[iy] = 0.;
		    iy += *incy;
/* L30: */
		}
	    } else {
		i__1 = *n;
		for (i__ = 1; i__ <= i__1; ++i__) {
		    y[iy] = (d__1 = *beta * y[iy], abs(d__1));
		    iy += *incy;
/* L40: */
		}
	    }
	}
    }

    if (*alpha == 0.) {
	return 0;
    }

    talpha = abs(*alpha);

    if (lsame_(uplo, "U", (ftnlen)1, (ftnlen)1)) {

/*        Form  y  when A is stored in upper triangle. */

	if (*incx == 1 && *incy == 1) {
	    i__1 = *n;
	    for (j = 1; j <= i__1; ++j) {
		i__2 = j;
		temp1 = talpha * ((d__1 = x[i__2].r, abs(d__1)) + (d__2 = 
			d_imag(&x[j]), abs(d__2)));
		temp2 = 0.;
		i__2 = j - 1;
		for (i__ = 1; i__ <= i__2; ++i__) {
		    i__3 = i__ + j * a_dim1;
		    temp0 = (d__1 = a[i__3].r, abs(d__1)) + (d__2 = d_imag(&a[
			    i__ + j * a_dim1]), abs(d__2));
		    y[i__] += temp1 * temp0;
		    i__3 = i__;
		    temp2 += temp0 * ((d__1 = x[i__3].r, abs(d__1)) + (d__2 = 
			    d_imag(&x[i__]), abs(d__2)));
/* L50: */
		}
		i__2 = j + j * a_dim1;
		y[j] = y[j] + temp1 * (d__1 = a[i__2].r, abs(d__1)) + *alpha *
			 temp2;

/* L60: */
	    }

	} else {

	    jx = kx;
	    jy = ky;

	    i__1 = *n;
	    for (j = 1; j <= i__1; ++j) {
		i__2 = jx;
		temp1 = talpha * ((d__1 = x[i__2].r, abs(d__1)) + (d__2 = 
			d_imag(&x[jx]), abs(d__2)));
		temp2 = 0.;
		ix = kx;
		iy = ky;

		i__2 = j - 1;
		for (i__ = 1; i__ <= i__2; ++i__) {
		    i__3 = i__ + j * a_dim1;
		    temp0 = (d__1 = a[i__3].r, abs(d__1)) + (d__2 = d_imag(&a[
			    i__ + j * a_dim1]), abs(d__2));
		    y[iy] += temp1 * temp0;
		    i__3 = ix;
		    temp2 += temp0 * ((d__1 = x[i__3].r, abs(d__1)) + (d__2 = 
			    d_imag(&x[ix]), abs(d__2)));
		    ix += *incx;
		    iy += *incy;
/* L70: */
		}
		i__2 = j + j * a_dim1;
		y[jy] = y[jy] + temp1 * (d__1 = a[i__2].r, abs(d__1)) + *
			alpha * temp2;
		jx += *incx;
		jy += *incy;

/* L80: */
	    }

	}

    } else {

/*        Form  y  when A is stored in lower triangle. */

	if (*incx == 1 && *incy == 1) {

	    i__1 = *n;
	    for (j = 1; j <= i__1; ++j) {

		i__2 = j;
		temp1 = talpha * ((d__1 = x[i__2].r, abs(d__1)) + (d__2 = 
			d_imag(&x[j]), abs(d__2)));
		temp2 = 0.;
		i__2 = j + j * a_dim1;
		y[j] += temp1 * (d__1 = a[i__2].r, abs(d__1));

		i__2 = *n;
		for (i__ = j + 1; i__ <= i__2; ++i__) {
		    i__3 = i__ + j * a_dim1;
		    temp0 = (d__1 = a[i__3].r, abs(d__1)) + (d__2 = d_imag(&a[
			    i__ + j * a_dim1]), abs(d__2));
		    y[i__] += temp1 * temp0;
		    i__3 = i__;
		    temp2 += temp0 * ((d__1 = x[i__3].r, abs(d__1)) + (d__2 = 
			    d_imag(&x[i__]), abs(d__2)));

/* L90: */
		}

		y[j] += *alpha * temp2;

/* L100: */
	    }

	} else {

	    jx = kx;
	    jy = ky;

	    i__1 = *n;
	    for (j = 1; j <= i__1; ++j) {
		i__2 = jx;
		temp1 = talpha * ((d__1 = x[i__2].r, abs(d__1)) + (d__2 = 
			d_imag(&x[jx]), abs(d__2)));
		temp2 = 0.;
		i__2 = j + j * a_dim1;
		y[jy] += temp1 * (d__1 = a[i__2].r, abs(d__1));
		ix = jx;
		iy = jy;

		i__2 = *n;
		for (i__ = j + 1; i__ <= i__2; ++i__) {

		    ix += *incx;
		    iy += *incy;
		    i__3 = i__ + j * a_dim1;
		    temp0 = (d__1 = a[i__3].r, abs(d__1)) + (d__2 = d_imag(&a[
			    i__ + j * a_dim1]), abs(d__2));
		    y[iy] += temp1 * temp0;
		    i__3 = ix;
		    temp2 += temp0 * ((d__1 = x[i__3].r, abs(d__1)) + (d__2 = 
			    d_imag(&x[ix]), abs(d__2)));

/* L110: */
		}

		y[jy] += *alpha * temp2;
		jx += *incx;
		jy += *incy;

/* L120: */
	    }

	}

    }

    return 0;

/*     End of ZAHEMV */

} /* zahemv_ */

