/* /home4/luszczek/mscratch/build/SCALAPACK/PBLAS/SRC/PTZBLAS/sset.f -- translated by f2c (version 20031025).
   You must link the resulting object file with libf2c:
	on Microsoft Windows system, link with libf2c.lib;
	on Linux or Unix systems, link with .../path/to/libf2c.a -lm
	or, if you install libf2c.a in a standard place, with -lf2c -lm
	-- in that order, at the end of the command line, as in
		cc *.o -lf2c -lm
	Source for libf2c is in /netlib/f2c/libf2c.zip, e.g.,

		http://www.netlib.org/f2c/libf2c.zip
*/

#include "f2c.h"

/* Subroutine */ int sset_(integer *n, real *alpha, real *x, integer *incx)
{
    /* System generated locals */
    integer i__1;

    /* Local variables */
    integer i__, m, ix, mp1, info;
    extern /* Subroutine */ int xerbla_(char *, integer *, ftnlen);


/*  -- PBLAS auxiliary routine (version 2.0) -- */
/*     University of Tennessee, Knoxville, Oak Ridge National Laboratory, */
/*     and University of California, Berkeley. */
/*     April 1, 1998 */

/*     .. Scalar Arguments .. */
/*     .. */
/*     .. Array Arguments .. */
/*     .. */

/*  Purpose */
/*  ======= */

/*  SSET sets the entries of an n vector x to the scalar alpha. */

/*  Arguments */
/*  ========= */

/*  N       (input) INTEGER */
/*          On entry, N specifies the length of the vector x. N  must  be */
/*          at least zero. */

/*  ALPHA   (input) REAL */
/*          On entry, ALPHA specifies the scalar alpha. */

/*  X       (input/output) REAL array of dimension at least */
/*          ( 1 + ( n - 1 )*abs( INCX ) ). Before entry,  the incremented */
/*          array  X  must  contain the vector x. On exit, entries of the */
/*          incremented array X are set to alpha. */

/*  INCX    (input) INTEGER */
/*          On entry, INCX specifies the increment for the elements of X. */
/*          INCX must not be zero. */

/*  -- Written on April 1, 1998 by */
/*     Antoine Petitet, University  of  Tennessee, Knoxville 37996, USA. */

/*  ===================================================================== */

/*     .. Local Scalars .. */
/*     .. */
/*     .. External Subroutines .. */
/*     .. */
/*     .. Intrinsic Functions .. */
/*     .. */
/*     .. Executable Statements .. */

/*     Test the input parameters. */

    /* Parameter adjustments */
    --x;

    /* Function Body */
    info = 0;
    if (*n < 0) {
	info = 1;
    } else if (*incx == 0) {
	info = 4;
    }
    if (info != 0) {
	xerbla_("SSET", &info, (ftnlen)4);
	return 0;
    }

/*     Quick return if possible. */

    if (*n <= 0) {
	return 0;
    }

/*     Form  x := alpha */

    if (*incx == 1) {
	goto L20;
    }

/*     code for increments not equal to 1 */

/*     Set up the start point in  X. */

    if (*incx > 0) {
	ix = 1;
    } else {
	ix = 1 - (*n - 1) * *incx;
    }

    i__1 = *n;
    for (i__ = 1; i__ <= i__1; ++i__) {
	x[ix] = *alpha;
	ix += *incx;
/* L10: */
    }

    return 0;

/*     code for increment equal to 1 */

/*     clean-up loop */

L20:
    m = *n % 4;

    if (m == 0) {
	goto L40;
    }

    i__1 = m;
    for (i__ = 1; i__ <= i__1; ++i__) {
	x[i__] = *alpha;
/* L30: */
    }
    if (*n < 4) {
	return 0;
    }

L40:
    mp1 = m + 1;
    i__1 = *n;
    for (i__ = mp1; i__ <= i__1; i__ += 4) {
	x[i__] = *alpha;
	x[i__ + 1] = *alpha;
	x[i__ + 2] = *alpha;
	x[i__ + 3] = *alpha;
/* L50: */
    }

    return 0;

/*     End of SSET */

} /* sset_ */

