/* /home4/luszczek/mscratch/build/SCALAPACK/PBLAS/SRC/PTZBLAS/scshft.f -- translated by f2c (version 20031025).
   You must link the resulting object file with libf2c:
	on Microsoft Windows system, link with libf2c.lib;
	on Linux or Unix systems, link with .../path/to/libf2c.a -lm
	or, if you install libf2c.a in a standard place, with -lf2c -lm
	-- in that order, at the end of the command line, as in
		cc *.o -lf2c -lm
	Source for libf2c is in /netlib/f2c/libf2c.zip, e.g.,

		http://www.netlib.org/f2c/libf2c.zip
*/

#include "f2c.h"

/* Subroutine */ int scshft_(integer *m, integer *n, integer *offset, real *a,
	 integer *lda)
{
    /* System generated locals */
    integer a_dim1, a_offset, i__1, i__2;

    /* Local variables */
    integer i__, j;


/*  -- PBLAS auxiliary routine (version 2.0) -- */
/*     University of Tennessee, Knoxville, Oak Ridge National Laboratory, */
/*     and University of California, Berkeley. */
/*     April 1, 1998 */

/*     .. Scalar Arguments .. */
/*     .. */
/*     .. Array Arguments .. */
/*     .. */

/*  Purpose */
/*  ======= */

/*  SCSHFT shifts columns of an m by n array A by OFFSET. */

/*  Arguments */
/*  ========= */

/*  M       (local input) INTEGER */
/*          On entry,  M  specifies the number of rows of A. M must be at */
/*          least zero. */

/*  N       (local input) INTEGER */
/*          On entry,  N  specifies  the  number of columns of  A  to  be */
/*          shifted. N must be at least zero. */

/*  OFFSET  (local input) INTEGER */
/*          On entry, OFFSET specifies the offset by which the columns of */
/*          A should be shifted. OFFSET  can be positive or negative (see */
/*          below for further details). When OFFSET  is positive, the co- */
/*          lumns are shifted to the right. When OFFSET  is negative, the */
/*          columns of A are shifted to the left. */

/*  A       (local input/local output) REAL array */
/*          On entry, A  is an array of dimension ( LDA, N+ABS(OFFSET) ). */
/*          On exit, A contains the shifted array. */

/*  LDA     (local input) INTEGER */
/*          On entry, LDA specifies the leading dimension of the array A. */
/*          LDA must be at least max( 1, M ). */

/*  Further Details */
/*  =============== */

/*             N=3     OFFSET=6                      -OFFSET=6     N=3 */
/*           -------------------                     ------------------- */
/*          | 1 2 3 4 5 6 7 8 9 |         M         | 1 2 3 4 5 6 7 8 9 | */
/*           -------------------                     ------------------- */
/*                    V                                       V */
/*           -------------------                     ------------------- */
/*          | 1 2 3 4 5 6 1 2 3 |         M         | 7 8 9 4 5 6 7 8 9 | */
/*           -------------------                     ------------------- */
/*               OFFSET >= 0                             OFFSET <= 0 */

/*  -- Written on April 1, 1998 by */
/*     Antoine Petitet, University  of  Tennessee, Knoxville 37996, USA. */

/*  ===================================================================== */

/*     .. Local Scalars .. */
/*     .. */
/*     .. Executable Statements .. */

    /* Parameter adjustments */
    a_dim1 = *lda;
    a_offset = 1 + a_dim1;
    a -= a_offset;

    /* Function Body */
    if (*offset == 0 || *m <= 0 || *n <= 0) {
	return 0;
    }

    if (*offset > 0) {
	for (j = *n; j >= 1; --j) {
	    i__1 = *m;
	    for (i__ = 1; i__ <= i__1; ++i__) {
		a[i__ + (j + *offset) * a_dim1] = a[i__ + j * a_dim1];
/* L10: */
	    }
/* L20: */
	}
    } else {
	i__1 = *n;
	for (j = 1; j <= i__1; ++j) {
	    i__2 = *m;
	    for (i__ = 1; i__ <= i__2; ++i__) {
		a[i__ + j * a_dim1] = a[i__ + (j - *offset) * a_dim1];
/* L30: */
	    }
/* L40: */
	}
    }

    return 0;

/*     End of SCSHFT */

} /* scshft_ */

