/* /home4/luszczek/mscratch/build/SCALAPACK/PBLAS/SRC/PTZBLAS/satrmv.f -- translated by f2c (version 20031025).
   You must link the resulting object file with libf2c:
	on Microsoft Windows system, link with libf2c.lib;
	on Linux or Unix systems, link with .../path/to/libf2c.a -lm
	or, if you install libf2c.a in a standard place, with -lf2c -lm
	-- in that order, at the end of the command line, as in
		cc *.o -lf2c -lm
	Source for libf2c is in /netlib/f2c/libf2c.zip, e.g.,

		http://www.netlib.org/f2c/libf2c.zip
*/

#include "f2c.h"

/* Subroutine */ int satrmv_(char *uplo, char *trans, char *diag, integer *n, 
	real *alpha, real *a, integer *lda, real *x, integer *incx, real *
	beta, real *y, integer *incy, ftnlen uplo_len, ftnlen trans_len, 
	ftnlen diag_len)
{
    /* System generated locals */
    integer a_dim1, a_offset, i__1, i__2;
    real r__1;

    /* Local variables */
    integer i__, j, ix, iy, jx, jy, kx, ky, info;
    real absx, temp;
    extern logical lsame_(char *, char *, ftnlen, ftnlen);
    real talpha;
    extern /* Subroutine */ int xerbla_(char *, integer *, ftnlen);
    logical nounit;


/*  -- PBLAS auxiliary routine (version 2.0) -- */
/*     University of Tennessee, Knoxville, Oak Ridge National Laboratory, */
/*     and University of California, Berkeley. */
/*     April 1, 1998 */

/*     .. Scalar Arguments .. */
/*     .. */
/*     .. Array Arguments .. */
/*     .. */

/*  Purpose */
/*  ======= */

/*  SATRMV performs one of the matrix-vector operations */

/*     y := abs( alpha )*abs( A )*abs( x )+ abs( beta*y ), */

/*     or */

/*     y := abs( alpha )*abs( A' )*abs( x ) + abs( beta*y ), */

/*  where  alpha  and  beta  are real scalars, y is a real vector, x is a */
/*  vector and A is an n by n unit or non-unit, upper or lower triangular */
/*  matrix. */

/*  Arguments */
/*  ========= */

/*  UPLO    (input) CHARACTER*1 */
/*          On entry,  UPLO  specifies  whether the matrix is an upper or */
/*          lower triangular matrix as follows: */

/*             UPLO = 'U' or 'u'   A is an upper triangular matrix. */

/*             UPLO = 'L' or 'l'   A is a lower triangular matrix. */

/*  TRANS   (input) CHARACTER*1 */
/*          On entry,  TRANS  specifies  the operation to be performed as */
/*          follows: */

/*             TRANS = 'N' or 'n': */
/*                y := abs( alpha )*abs( A )*abs( x )+ abs( beta*y ) */

/*             TRANS = 'T' or 't': */
/*                y := abs( alpha )*abs( A' )*abs( x ) + abs( beta*y ) */

/*             TRANS = 'C' or 'c': */
/*                y := abs( alpha )*abs( A' )*abs( x ) + abs( beta*y ) */

/*  DIAG    (input) CHARACTER*1 */
/*          On entry, DIAG  specifies whether or not A is unit triangular */
/*          as follows: */

/*             DIAG = 'U' or 'u'  A is assumed to be unit triangular. */

/*             DIAG = 'N' or 'n'  A is not assumed to be unit triangular. */

/*  N       (input) INTEGER */
/*          On entry, N specifies the order of the matrix A. N must be at */
/*          least zero. */

/*  ALPHA   (input) REAL */
/*          On entry, ALPHA specifies the real scalar alpha. */

/*  A       (input) REAL array */
/*          On entry,  A  is an array of dimension (LDA,N).  Before entry */
/*          with UPLO = 'U' or 'u', the leading n by n part of the  array */
/*          A must contain the upper triangular part of the matrix A  and */
/*          the  strictly  lower  triangular part of A is not referenced. */
/*          When  UPLO = 'L' or 'l', the leading n by n part of the array */
/*          A  must contain the lower triangular part of the matrix A and */
/*          the  strictly  upper trapezoidal part of A is not referenced. */
/*          Note that when  DIAG = 'U' or 'u', the diagonal elements of A */
/*          are not referenced either, but are assumed to be unity. */

/*  LDA     (input) INTEGER */
/*          On entry, LDA specifies the leading dimension of the array A. */
/*          LDA must be at least max( 1, N ). */

/*  X       (input) REAL array of dimension at least */
/*          ( 1 + ( n - 1 )*abs( INCX ) ).  Before entry, the incremented */
/*          array X must contain the vector x. */

/*  INCX    (input) INTEGER */
/*          On entry, INCX specifies the increment for the elements of X. */
/*          INCX must not be zero. */

/*  BETA    (input) REAL */
/*          On entry,  BETA  specifies the real scalar beta. When BETA is */
/*          supplied as zero then Y need not be set on input. */

/*  Y       (input/output) REAL array of dimension at least */
/*          ( 1 + ( n - 1 )*abs( INCY ) ).  Before  entry with  BETA non- */
/*          zero, the  incremented array  Y must contain the vector y. On */
/*          exit, the  incremented array  Y is overwritten by the updated */
/*          vector y. */

/*  INCY    (input) INTEGER */
/*          On entry, INCY specifies the increment for the elements of Y. */
/*          INCY must not be zero. */

/*  -- Written on April 1, 1998 by */
/*     Antoine Petitet, University  of  Tennessee, Knoxville 37996, USA. */

/*  ===================================================================== */

/*     .. Parameters .. */
/*     .. */
/*     .. Local Scalars .. */
/*     .. */
/*     .. External Functions .. */
/*     .. */
/*     .. External Subroutines .. */
/*     .. */
/*     .. Intrinsic Functions .. */
/*     .. */
/*     .. Executable Statements .. */

/*     Test the input parameters. */

    /* Parameter adjustments */
    a_dim1 = *lda;
    a_offset = 1 + a_dim1;
    a -= a_offset;
    --x;
    --y;

    /* Function Body */
    info = 0;
    if (! lsame_(uplo, "U", (ftnlen)1, (ftnlen)1) && ! lsame_(uplo, "L", (
	    ftnlen)1, (ftnlen)1)) {
	info = 1;
    } else if (! lsame_(trans, "N", (ftnlen)1, (ftnlen)1) && ! lsame_(trans, 
	    "T", (ftnlen)1, (ftnlen)1) && ! lsame_(trans, "C", (ftnlen)1, (
	    ftnlen)1)) {
	info = 2;
    } else if (! lsame_(diag, "U", (ftnlen)1, (ftnlen)1) && ! lsame_(diag, 
	    "N", (ftnlen)1, (ftnlen)1)) {
	info = 3;
    } else if (*n < 0) {
	info = 4;
    } else if (*lda < max(1,*n)) {
	info = 7;
    } else if (*incx == 0) {
	info = 9;
    } else if (*incy == 0) {
	info = 12;
    }
    if (info != 0) {
	xerbla_("SATRMV", &info, (ftnlen)6);
	return 0;
    }

/*     Quick return if possible. */

    if (*n == 0 || *alpha == 0.f && *beta == 1.f) {
	return 0;
    }

    nounit = lsame_(diag, "N", (ftnlen)1, (ftnlen)1);

/*     Set up the start points in  X  and  Y. */

    if (*incx > 0) {
	kx = 1;
    } else {
	kx = 1 - (*n - 1) * *incx;
    }
    if (*incy > 0) {
	ky = 1;
    } else {
	ky = 1 - (*n - 1) * *incy;
    }

/*     Start the operations. In this version the elements of A are */
/*     accessed sequentially with one pass through A. */

/*     First form  y := abs( beta*y ). */

    if (*incy == 1) {
	if (*beta == 0.f) {
	    i__1 = *n;
	    for (i__ = 1; i__ <= i__1; ++i__) {
		y[i__] = 0.f;
/* L10: */
	    }
	} else if (*beta == 1.f) {
	    i__1 = *n;
	    for (i__ = 1; i__ <= i__1; ++i__) {
		y[i__] = (r__1 = y[i__], dabs(r__1));
/* L20: */
	    }
	} else {
	    i__1 = *n;
	    for (i__ = 1; i__ <= i__1; ++i__) {
		y[i__] = (r__1 = *beta * y[i__], dabs(r__1));
/* L30: */
	    }
	}
    } else {
	iy = ky;
	if (*beta == 0.f) {
	    i__1 = *n;
	    for (i__ = 1; i__ <= i__1; ++i__) {
		y[iy] = 0.f;
		iy += *incy;
/* L40: */
	    }
	} else if (*beta == 1.f) {
	    i__1 = *n;
	    for (i__ = 1; i__ <= i__1; ++i__) {
		y[iy] = (r__1 = y[iy], dabs(r__1));
		iy += *incy;
/* L50: */
	    }
	} else {
	    i__1 = *n;
	    for (i__ = 1; i__ <= i__1; ++i__) {
		y[iy] = (r__1 = *beta * y[iy], dabs(r__1));
		iy += *incy;
/* L60: */
	    }
	}
    }

    if (*alpha == 0.f) {
	return 0;
    }

    talpha = dabs(*alpha);

    if (lsame_(trans, "N", (ftnlen)1, (ftnlen)1)) {

/*        Form  y := abs( alpha ) * abs( A ) * abs( x ) + y. */

	if (lsame_(uplo, "U", (ftnlen)1, (ftnlen)1)) {
	    jx = kx;
	    if (*incy == 1) {
		i__1 = *n;
		for (j = 1; j <= i__1; ++j) {
		    absx = (r__1 = x[jx], dabs(r__1));
		    if (absx != 0.f) {
			temp = talpha * absx;
			i__2 = j - 1;
			for (i__ = 1; i__ <= i__2; ++i__) {
			    y[i__] += temp * (r__1 = a[i__ + j * a_dim1], 
				    dabs(r__1));
/* L70: */
			}

			if (nounit) {
			    y[j] += temp * (r__1 = a[j + j * a_dim1], dabs(
				    r__1));
			} else {
			    y[j] += temp;
			}
		    }
		    jx += *incx;
/* L80: */
		}

	    } else {

		i__1 = *n;
		for (j = 1; j <= i__1; ++j) {
		    absx = (r__1 = x[jx], dabs(r__1));
		    if (absx != 0.f) {
			temp = talpha * absx;
			iy = ky;
			i__2 = j - 1;
			for (i__ = 1; i__ <= i__2; ++i__) {
			    y[iy] += temp * (r__1 = a[i__ + j * a_dim1], dabs(
				    r__1));
			    iy += *incy;
/* L90: */
			}

			if (nounit) {
			    y[iy] += temp * (r__1 = a[j + j * a_dim1], dabs(
				    r__1));
			} else {
			    y[iy] += temp;
			}
		    }
		    jx += *incx;
/* L100: */
		}

	    }

	} else {

	    jx = kx;
	    if (*incy == 1) {
		i__1 = *n;
		for (j = 1; j <= i__1; ++j) {
		    absx = (r__1 = x[jx], dabs(r__1));
		    if (absx != 0.f) {

			temp = talpha * absx;

			if (nounit) {
			    y[j] += temp * (r__1 = a[j + j * a_dim1], dabs(
				    r__1));
			} else {
			    y[j] += temp;
			}

			i__2 = *n;
			for (i__ = j + 1; i__ <= i__2; ++i__) {
			    y[i__] += temp * (r__1 = a[i__ + j * a_dim1], 
				    dabs(r__1));
/* L110: */
			}
		    }
		    jx += *incx;
/* L120: */
		}

	    } else {

		i__1 = *n;
		for (j = 1; j <= i__1; ++j) {
		    absx = (r__1 = x[jx], dabs(r__1));
		    if (absx != 0.f) {
			temp = talpha * absx;
			iy = ky + (j - 1) * *incy;

			if (nounit) {
			    y[iy] += temp * (r__1 = a[j + j * a_dim1], dabs(
				    r__1));
			} else {
			    y[iy] += temp;
			}

			i__2 = *n;
			for (i__ = j + 1; i__ <= i__2; ++i__) {
			    iy += *incy;
			    y[iy] += temp * (r__1 = a[i__ + j * a_dim1], dabs(
				    r__1));
/* L130: */
			}
		    }
		    jx += *incx;
/* L140: */
		}

	    }

	}

    } else {

/*        Form  y := abs( alpha ) * abs( A' ) * abs( x ) + y. */

	if (lsame_(uplo, "U", (ftnlen)1, (ftnlen)1)) {
	    jy = ky;
	    if (*incx == 1) {
		i__1 = *n;
		for (j = 1; j <= i__1; ++j) {

		    temp = 0.f;

		    i__2 = j - 1;
		    for (i__ = 1; i__ <= i__2; ++i__) {
			temp += (r__1 = a[i__ + j * a_dim1] * x[i__], dabs(
				r__1));
/* L150: */
		    }

		    if (nounit) {
			temp += (r__1 = a[j + j * a_dim1] * x[j], dabs(r__1));
		    } else {
			temp += (r__1 = x[j], dabs(r__1));
		    }

		    y[jy] += talpha * temp;
		    jy += *incy;

/* L160: */
		}

	    } else {

		i__1 = *n;
		for (j = 1; j <= i__1; ++j) {
		    temp = 0.f;
		    ix = kx;
		    i__2 = j - 1;
		    for (i__ = 1; i__ <= i__2; ++i__) {
			temp += (r__1 = a[i__ + j * a_dim1] * x[ix], dabs(
				r__1));
			ix += *incx;
/* L170: */
		    }

		    if (nounit) {
			temp += (r__1 = a[j + j * a_dim1] * x[ix], dabs(r__1))
				;
		    } else {
			temp += (r__1 = x[ix], dabs(r__1));
		    }

		    y[jy] += talpha * temp;
		    jy += *incy;

/* L180: */
		}

	    }

	} else {

	    jy = ky;
	    if (*incx == 1) {

		i__1 = *n;
		for (j = 1; j <= i__1; ++j) {

		    if (nounit) {
			temp = (r__1 = a[j + j * a_dim1] * x[j], dabs(r__1));
		    } else {
			temp = (r__1 = x[j], dabs(r__1));
		    }

		    i__2 = *n;
		    for (i__ = j + 1; i__ <= i__2; ++i__) {
			temp += (r__1 = a[i__ + j * a_dim1] * x[i__], dabs(
				r__1));
/* L190: */
		    }

		    y[jy] += talpha * temp;
		    jy += *incy;

/* L200: */
		}

	    } else {

		i__1 = *n;
		for (j = 1; j <= i__1; ++j) {

		    ix = kx + (j - 1) * *incx;

		    if (nounit) {
			temp = (r__1 = a[j + j * a_dim1] * x[ix], dabs(r__1));
		    } else {
			temp = (r__1 = x[ix], dabs(r__1));
		    }

		    i__2 = *n;
		    for (i__ = j + 1; i__ <= i__2; ++i__) {
			ix += *incx;
			temp += (r__1 = a[i__ + j * a_dim1] * x[ix], dabs(
				r__1));
/* L210: */
		    }
		    y[jy] += talpha * temp;
		    jy += *incy;
/* L220: */
		}
	    }
	}

    }

    return 0;

/*     End of SATRMV */

} /* satrmv_ */

