/* /home4/luszczek/mscratch/build/SCALAPACK/PBLAS/SRC/PTZBLAS/dtzpadcpy.f -- translated by f2c (version 20031025).
   You must link the resulting object file with libf2c:
	on Microsoft Windows system, link with libf2c.lib;
	on Linux or Unix systems, link with .../path/to/libf2c.a -lm
	or, if you install libf2c.a in a standard place, with -lf2c -lm
	-- in that order, at the end of the command line, as in
		cc *.o -lf2c -lm
	Source for libf2c is in /netlib/f2c/libf2c.zip, e.g.,

		http://www.netlib.org/f2c/libf2c.zip
*/

#include "f2c.h"

/* Subroutine */ int dtzpadcpy_(char *uplo, char *diag, integer *m, integer *
	n, integer *ioffd, doublereal *a, integer *lda, doublereal *b, 
	integer *ldb, ftnlen uplo_len, ftnlen diag_len)
{
    /* System generated locals */
    integer a_dim1, a_offset, b_dim1, b_offset, i__1, i__2;

    /* Local variables */
    integer i__, j, mn, itmp, jtmp;
    extern logical lsame_(char *, char *, ftnlen, ftnlen);


/*  -- PBLAS auxiliary routine (version 2.0) -- */
/*     University of Tennessee, Knoxville, Oak Ridge National Laboratory, */
/*     and University of California, Berkeley. */
/*     April 1, 1998 */

/*     .. Scalar Arguments .. */
/*     .. */
/*     .. Array Arguments .. */
/*     .. */

/*  Purpose */
/*  ======= */

/*  DTZPADCPY copies an array A into an array B.  The unchanged part of B */
/*  is padded with zeros. The diagonal of B specified by IOFFD may be set */
/*  to ones. */

/*  Arguments */
/*  ========= */

/*  UPLO    (input) CHARACTER*1 */
/*          On entry,  UPLO  specifies  which trapezoidal part of the ar- */
/*          ray A is to be copied as follows: */
/*             = 'L' or 'l':   Lower  triangular  part  is  copied;   the */
/*                             strictly  upper  triangular  part  of B is */
/*                             padded with zeros, */
/*             = 'U' or 'u':   Upper  triangular  part  is  copied;   the */
/*                             strictly  lower  triangular  part  of B is */
/*                             padded with zeros. */

/*  DIAG    (input) CHARACTER*1 */
/*          On entry, DIAG specifies whether or not the diagonal of B  is */
/*          to be set to ones or not as follows: */

/*          DIAG = 'N' or 'n': the diagonals of A  are  copied  into  the */
/*          diagonals of B, otherwise the diagonals of B are set to ones. */

/*  M       (input) INTEGER */
/*          On entry,  M  specifies the number of rows of the array A.  M */
/*          must be at least zero. */

/*  N       (input) INTEGER */
/*          On entry,  N  specifies the number of columns of the array A. */
/*          N must be at least zero. */

/*  IOFFD   (input) INTEGER */
/*          On entry, IOFFD specifies the position of the offdiagonal de- */
/*          limiting the upper and lower trapezoidal part of A as follows */
/*          (see the notes below): */

/*             IOFFD = 0  specifies the main diagonal A( i, i ), */
/*                        with i = 1 ... MIN( M, N ), */
/*             IOFFD > 0  specifies the subdiagonal   A( i+IOFFD, i ), */
/*                        with i = 1 ... MIN( M-IOFFD, N ), */
/*             IOFFD < 0  specifies the superdiagonal A( i, i-IOFFD ), */
/*                        with i = 1 ... MIN( M, N+IOFFD ). */

/*  A       (input) DOUBLE PRECISION array */
/*          On entry, A is an array of dimension  (LDA,N).  Before  entry */
/*          with UPLO = 'U', the leading m by n part of the array  A must */
/*          contain the upper trapezoidal part of the matrix to be copied */
/*          as specified by IOFFD, UPLO and DIAG, and  the strictly lower */
/*          trapezoidal part of A is not referenced; When  UPLO = 'L',the */
/*          leading m by n part of the array  A  must contain  the  lower */
/*          trapezoidal part of  the  matrix to be copied as specified by */
/*          IOFFD, UPLO and DIAG and the strictly upper trapezoidal  part */
/*          of A is not referenced. */

/*  LDA     (input) INTEGER */
/*          On entry, LDA specifies the leading dimension of the array A. */
/*          LDA must be at least max( 1, M ). */

/*  B       (output) DOUBLE PRECISION array */
/*          On entry, B  is  an array of dimension (LDB,N). On exit, this */
/*          array  contains  the  padded copy of A as specified by IOFFD, */
/*          UPLO and DIAG. */

/*  LDB     (input) INTEGER */
/*          On entry, LDB specifies the leading dimension of the array B. */
/*          LDB must be at least max( 1, M ). */

/*  Notes */
/*  ===== */
/*                           N                                    N */
/*             ----------------------------                  ----------- */
/*            |       d                    |                |           | */
/*          M |         d        'U'       |                |      'U'  | */
/*            |  'L'     'D'               |                |d          | */
/*            |             d              |              M |  d        | */
/*             ----------------------------                 |   'D'     | */
/*                                                          |      d    | */
/*               IOFFD < 0                                  | 'L'    d  | */
/*                                                          |          d| */
/*                  N                                       |           | */
/*             -----------                                   ----------- */
/*            |    d   'U'| */
/*            |      d    |                                   IOFFD > 0 */
/*          M |       'D' | */
/*            |          d|                              N */
/*            |  'L'      |                 ---------------------------- */
/*            |           |                |          'U'               | */
/*            |           |                |d                           | */
/*            |           |                | 'D'                        | */
/*            |           |                |    d                       | */
/*            |           |                |'L'   d                     | */
/*             -----------                  ---------------------------- */

/*  -- Written on April 1, 1998 by */
/*     Antoine Petitet, University  of  Tennessee, Knoxville 37996, USA. */

/*  ===================================================================== */

/*     .. Parameters .. */
/*     .. */
/*     .. Local Scalars .. */
/*     .. */
/*     .. External Functions .. */
/*     .. */
/*     .. Intrinsic Functions .. */
/*     .. Executable Statements .. */

/*     Quick return if possible */

    /* Parameter adjustments */
    a_dim1 = *lda;
    a_offset = 1 + a_dim1;
    a -= a_offset;
    b_dim1 = *ldb;
    b_offset = 1 + b_dim1;
    b -= b_offset;

    /* Function Body */
    if (*m <= 0 || *n <= 0) {
	return 0;
    }

/*     Start the operations */

    if (lsame_(uplo, "L", (ftnlen)1, (ftnlen)1)) {

/* Computing MAX */
	i__1 = 0, i__2 = -(*ioffd);
	mn = max(i__1,i__2);
	i__1 = min(mn,*n);
	for (j = 1; j <= i__1; ++j) {
	    i__2 = *m;
	    for (i__ = 1; i__ <= i__2; ++i__) {
		b[i__ + j * b_dim1] = a[i__ + j * a_dim1];
/* L10: */
	    }
/* L20: */
	}

/* Computing MIN */
	i__1 = *m - *ioffd;
	jtmp = min(i__1,*n);

	if (lsame_(diag, "N", (ftnlen)1, (ftnlen)1)) {
	    i__1 = jtmp;
	    for (j = mn + 1; j <= i__1; ++j) {
		itmp = j + *ioffd;
		i__2 = itmp - 1;
		for (i__ = 1; i__ <= i__2; ++i__) {
		    b[i__ + j * b_dim1] = 0.;
/* L30: */
		}
		i__2 = *m;
		for (i__ = itmp; i__ <= i__2; ++i__) {
		    b[i__ + j * b_dim1] = a[i__ + j * a_dim1];
/* L40: */
		}
/* L50: */
	    }
	} else {
	    i__1 = jtmp;
	    for (j = mn + 1; j <= i__1; ++j) {
		itmp = j + *ioffd;
		i__2 = itmp - 1;
		for (i__ = 1; i__ <= i__2; ++i__) {
		    b[i__ + j * b_dim1] = 0.;
/* L60: */
		}
		b[itmp + j * b_dim1] = 1.;
		i__2 = *m;
		for (i__ = itmp + 1; i__ <= i__2; ++i__) {
		    b[i__ + j * b_dim1] = a[i__ + j * a_dim1];
/* L70: */
		}
/* L80: */
	    }
	}

	i__1 = *n;
	for (j = jtmp + 1; j <= i__1; ++j) {
	    i__2 = *m;
	    for (i__ = 1; i__ <= i__2; ++i__) {
		b[i__ + j * b_dim1] = 0.;
/* L90: */
	    }
/* L100: */
	}

    } else if (lsame_(uplo, "U", (ftnlen)1, (ftnlen)1)) {

/* Computing MAX */
	i__1 = 0, i__2 = -(*ioffd);
	jtmp = max(i__1,i__2);

	i__1 = jtmp;
	for (j = 1; j <= i__1; ++j) {
	    i__2 = *m;
	    for (i__ = 1; i__ <= i__2; ++i__) {
		b[i__ + j * b_dim1] = 0.;
/* L110: */
	    }
/* L120: */
	}

/* Computing MIN */
	i__1 = *m - *ioffd;
	mn = min(i__1,*n);

	if (lsame_(diag, "N", (ftnlen)1, (ftnlen)1)) {
	    i__1 = mn;
	    for (j = jtmp + 1; j <= i__1; ++j) {
		itmp = j + *ioffd;
		i__2 = itmp;
		for (i__ = 1; i__ <= i__2; ++i__) {
		    b[i__ + j * b_dim1] = a[i__ + j * a_dim1];
/* L130: */
		}
		i__2 = *m;
		for (i__ = itmp + 1; i__ <= i__2; ++i__) {
		    b[i__ + j * b_dim1] = 0.;
/* L140: */
		}
/* L150: */
	    }
	} else {
	    i__1 = mn;
	    for (j = jtmp + 1; j <= i__1; ++j) {
		itmp = j + *ioffd;
		i__2 = itmp - 1;
		for (i__ = 1; i__ <= i__2; ++i__) {
		    b[i__ + j * b_dim1] = a[i__ + j * a_dim1];
/* L160: */
		}
		b[itmp + j * b_dim1] = 1.;
		i__2 = *m;
		for (i__ = itmp + 1; i__ <= i__2; ++i__) {
		    b[i__ + j * b_dim1] = 0.;
/* L170: */
		}
/* L180: */
	    }
	}

	i__1 = *n;
	for (j = max(0,mn) + 1; j <= i__1; ++j) {
	    i__2 = *m;
	    for (i__ = 1; i__ <= i__2; ++i__) {
		b[i__ + j * b_dim1] = a[i__ + j * a_dim1];
/* L190: */
	    }
/* L200: */
	}

    } else {

	i__1 = *n;
	for (j = 1; j <= i__1; ++j) {
	    i__2 = *m;
	    for (i__ = 1; i__ <= i__2; ++i__) {
		b[i__ + j * b_dim1] = a[i__ + j * a_dim1];
/* L210: */
	    }
/* L220: */
	}

    }

    return 0;

/*     End of DTZPADCPY */

} /* dtzpadcpy_ */

