/* /home4/luszczek/mscratch/build/SCALAPACK/PBLAS/SRC/PTZBLAS/dascal.f -- translated by f2c (version 20031025).
   You must link the resulting object file with libf2c:
	on Microsoft Windows system, link with libf2c.lib;
	on Linux or Unix systems, link with .../path/to/libf2c.a -lm
	or, if you install libf2c.a in a standard place, with -lf2c -lm
	-- in that order, at the end of the command line, as in
		cc *.o -lf2c -lm
	Source for libf2c is in /netlib/f2c/libf2c.zip, e.g.,

		http://www.netlib.org/f2c/libf2c.zip
*/

#include "f2c.h"

/* Subroutine */ int dascal_(integer *n, doublereal *alpha, doublereal *x, 
	integer *incx)
{
    /* System generated locals */
    integer i__1;
    doublereal d__1;

    /* Local variables */
    integer i__, m, ix, mp1, info;
    extern /* Subroutine */ int xerbla_(char *, integer *, ftnlen);


/*  -- PBLAS auxiliary routine (version 2.0) -- */
/*     University of Tennessee, Knoxville, Oak Ridge National Laboratory, */
/*     and University of California, Berkeley. */
/*     April 1, 1998 */

/*     .. Scalar Arguments .. */
/*     .. */
/*     .. Array Arguments .. */
/*     .. */

/*  Purpose */
/*  ======= */

/*  DASCAL performs the following operation: */

/*                   x := abs( alpha ) * abs( x ), */

/*  where alpha is a scalar and x is an n vector. */

/*  Arguments */
/*  ========= */

/*  N       (input) INTEGER */
/*          On entry, N specifies the length of the vector x. N  must  be */
/*          at least zero. */

/*  ALPHA   (input) DOUBLE PRECISION */
/*          On entry, ALPHA specifies the scalar alpha. */

/*  X       (input/output) DOUBLE PRECISION array of dimension at least */
/*          ( 1 + ( n - 1 )*abs( INCX ) ). Before entry,  the incremented */
/*          array  X  must  contain the vector x. On exit, entries of the */
/*          incremented array X are mutiplied by alpha in absolute value. */

/*  INCX    (input) INTEGER */
/*          On entry, INCX specifies the increment for the elements of X. */
/*          INCX must not be zero. */

/*  -- Written on April 1, 1998 by */
/*     Antoine Petitet, University  of  Tennessee, Knoxville 37996, USA. */

/*  ===================================================================== */

/*     .. Parameters .. */
/*     .. */
/*     .. Local Scalars .. */
/*     .. */
/*     .. External Subroutines .. */
/*     .. */
/*     .. Intrinsic Functions .. */
/*     .. */
/*     .. Executable Statements .. */

/*     Test the input parameters. */

    /* Parameter adjustments */
    --x;

    /* Function Body */
    info = 0;
    if (*n < 0) {
	info = 1;
    } else if (*incx == 0) {
	info = 4;
    }
    if (info != 0) {
	xerbla_("DASCAL", &info, (ftnlen)6);
	return 0;
    }

/*     Quick return if possible. */

    if (*n <= 0) {
	return 0;
    }

/*     Form  x := abs( alpha ) * abs( x ) */

    if (*incx == 1) {
	goto L40;
    }

/*     code for increments not equal to 1 */

/*     Set up the start point in  X. */

    if (*incx > 0) {
	ix = 1;
    } else {
	ix = 1 - (*n - 1) * *incx;
    }

    if (*alpha == 0.) {
	i__1 = *n;
	for (i__ = 1; i__ <= i__1; ++i__) {
	    x[ix] = 0.;
	    ix += *incx;
/* L10: */
	}
    } else if (*alpha == 1.) {
	i__1 = *n;
	for (i__ = 1; i__ <= i__1; ++i__) {
	    x[ix] = (d__1 = x[ix], abs(d__1));
	    ix += *incx;
/* L20: */
	}
    } else {
	i__1 = *n;
	for (i__ = 1; i__ <= i__1; ++i__) {
	    x[ix] = (d__1 = *alpha * x[ix], abs(d__1));
	    ix += *incx;
/* L30: */
	}
    }

    return 0;

/*     code for increment equal to 1 */

/*     clean-up loop */

L40:
    m = *n % 4;

    if (m == 0) {
	goto L80;
    }

    if (*alpha == 0.) {
	i__1 = m;
	for (i__ = 1; i__ <= i__1; ++i__) {
	    x[i__] = 0.;
/* L50: */
	}
    } else if (*alpha == 1.) {
	i__1 = m;
	for (i__ = 1; i__ <= i__1; ++i__) {
	    x[i__] = (d__1 = x[i__], abs(d__1));
/* L60: */
	}
    } else {
	i__1 = m;
	for (i__ = 1; i__ <= i__1; ++i__) {
	    x[i__] = (d__1 = *alpha * x[i__], abs(d__1));
/* L70: */
	}
    }

    if (*n < 4) {
	return 0;
    }

L80:
    mp1 = m + 1;

    if (*alpha == 0.) {
	i__1 = *n;
	for (i__ = mp1; i__ <= i__1; i__ += 4) {
	    x[i__] = 0.;
	    x[i__ + 1] = 0.;
	    x[i__ + 2] = 0.;
	    x[i__ + 3] = 0.;
/* L90: */
	}
    } else if (*alpha == 1.) {
	i__1 = *n;
	for (i__ = mp1; i__ <= i__1; i__ += 4) {
	    x[i__] = (d__1 = x[i__], abs(d__1));
	    x[i__ + 1] = (d__1 = x[i__ + 1], abs(d__1));
	    x[i__ + 2] = (d__1 = x[i__ + 2], abs(d__1));
	    x[i__ + 3] = (d__1 = x[i__ + 3], abs(d__1));
/* L100: */
	}
    } else {
	i__1 = *n;
	for (i__ = mp1; i__ <= i__1; i__ += 4) {
	    x[i__] = (d__1 = *alpha * x[i__], abs(d__1));
	    x[i__ + 1] = (d__1 = *alpha * x[i__ + 1], abs(d__1));
	    x[i__ + 2] = (d__1 = *alpha * x[i__ + 2], abs(d__1));
	    x[i__ + 3] = (d__1 = *alpha * x[i__ + 3], abs(d__1));
/* L110: */
	}
    }

    return 0;

/*     End of DASCAL */

} /* dascal_ */

