/* /home4/luszczek/mscratch/build/SCALAPACK/PBLAS/SRC/PTZBLAS/ctzpad.f -- translated by f2c (version 20031025).
   You must link the resulting object file with libf2c:
	on Microsoft Windows system, link with libf2c.lib;
	on Linux or Unix systems, link with .../path/to/libf2c.a -lm
	or, if you install libf2c.a in a standard place, with -lf2c -lm
	-- in that order, at the end of the command line, as in
		cc *.o -lf2c -lm
	Source for libf2c is in /netlib/f2c/libf2c.zip, e.g.,

		http://www.netlib.org/f2c/libf2c.zip
*/

#include "f2c.h"

/* Subroutine */ int ctzpad_(char *uplo, char *herm, integer *m, integer *n, 
	integer *ioffd, complex *alpha, complex *beta, complex *a, integer *
	lda, ftnlen uplo_len, ftnlen herm_len)
{
    /* System generated locals */
    integer a_dim1, a_offset, i__1, i__2, i__3, i__4;
    real r__1;
    complex q__1;

    /* Local variables */
    integer i__, j, mn, jtmp;
    extern logical lsame_(char *, char *, ftnlen, ftnlen);


/*  -- PBLAS auxiliary routine (version 2.0) -- */
/*     University of Tennessee, Knoxville, Oak Ridge National Laboratory, */
/*     and University of California, Berkeley. */
/*     April 1, 1998 */

/*     .. Scalar Arguments .. */
/*     .. */
/*     .. Array Arguments .. */
/*     .. */

/*  Purpose */
/*  ======= */

/*  CTZPAD  initializes a two-dimensional array A to beta on the diagonal */
/*  specified by IOFFD or zeros the imaginary part of those diagonals and */
/*  set the offdiagonals to alpha. */

/*  Arguments */
/*  ========= */

/*  UPLO    (input) CHARACTER*1 */
/*          On entry,  UPLO  specifies  which trapezoidal part of the ar- */
/*          ray A is to be set as follows: */
/*             = 'L' or 'l':   Lower triangular part is set; the strictly */
/*                             upper triangular part of A is not changed, */
/*             = 'D' or 'd':   diagonal  specified  by  IOFFD is set; the */
/*                             rest of the array A is unchanged, */
/*             = 'U' or 'u':   Upper triangular part is set; the strictly */
/*                             lower triangular part of A is not changed, */
/*             Otherwise:      All of the array A is set. */

/*  HERM    (input) CHARACTER*1 */
/*          On entry, HERM specifies what should be done to the diagonals */
/*          as follows.  When UPLO is 'L', 'l', 'D', 'd', 'U' or 'u'  and */
/*          HERM is  'Z'  or  'z', the imaginary part of the diagonals is */
/*          set  to  zero. Otherwise, the diagonals are set to beta. */

/*  M       (input) INTEGER */
/*          On entry,  M  specifies the number of rows of the array A.  M */
/*          must be at least zero. */

/*  N       (input) INTEGER */
/*          On entry,  N  specifies the number of columns of the array A. */
/*          N must be at least zero. */

/*  IOFFD   (input) INTEGER */
/*          On entry, IOFFD specifies the position of the offdiagonal de- */
/*          limiting the upper and lower trapezoidal part of A as follows */
/*          (see the notes below): */

/*             IOFFD = 0  specifies the main diagonal A( i, i ), */
/*                        with i = 1 ... MIN( M, N ), */
/*             IOFFD > 0  specifies the subdiagonal   A( i+IOFFD, i ), */
/*                        with i = 1 ... MIN( M-IOFFD, N ), */
/*             IOFFD < 0  specifies the superdiagonal A( i, i-IOFFD ), */
/*                        with i = 1 ... MIN( M, N+IOFFD ). */

/*  ALPHA   (input) COMPLEX */
/*          On entry,  ALPHA  specifies the scalar alpha, i.e., the value */
/*          to which the offdiagonal entries of the array A determined by */
/*          UPLO and IOFFD are set. */

/*  BETA    (input) COMPLEX */
/*          On entry, BETA  specifies the scalar beta, i.e., the value to */
/*          which the diagonal entries specified by IOFFD of the array  A */
/*          are set. BETA is not referenced when UPLO is 'L', 'l', 'U' or */
/*          'u' and HERM is 'Z'. */

/*  A       (input/output) COMPLEX array */
/*          On entry, A is an array of dimension  (LDA,N).  Before  entry */
/*          with UPLO = 'U', the leading m by n part of the array  A must */
/*          contain the upper trapezoidal part of the matrix to be set as */
/*          specified by  IOFFD,  and the strictly lower trapezoidal part */
/*          of A is not referenced;  When  UPLO = 'L', the leading m by n */
/*          part of the array A must contain the lower  trapezoidal  part */
/*          of  the  matrix  to  be  set  as  specified by IOFFD, and the */
/*          strictly upper  trapezoidal  part of A is not referenced.  On */
/*          exit, the entries  of the  trapezoid  part of A determined by */
/*          UPLO, HERM and IOFFD are set. */

/*  LDA     (input) INTEGER */
/*          On entry, LDA specifies the leading dimension of the array A. */
/*          LDA must be at least max( 1, M ). */

/*  Notes */
/*  ===== */
/*                           N                                    N */
/*             ----------------------------                  ----------- */
/*            |       d                    |                |           | */
/*          M |         d        'U'       |                |      'U'  | */
/*            |  'L'     'D'               |                |d          | */
/*            |             d              |              M |  d        | */
/*             ----------------------------                 |   'D'     | */
/*                                                          |      d    | */
/*               IOFFD < 0                                  | 'L'    d  | */
/*                                                          |          d| */
/*                  N                                       |           | */
/*             -----------                                   ----------- */
/*            |    d   'U'| */
/*            |      d    |                                   IOFFD > 0 */
/*          M |       'D' | */
/*            |          d|                              N */
/*            |  'L'      |                 ---------------------------- */
/*            |           |                |          'U'               | */
/*            |           |                |d                           | */
/*            |           |                | 'D'                        | */
/*            |           |                |    d                       | */
/*            |           |                |'L'   d                     | */
/*             -----------                  ---------------------------- */

/*  -- Written on April 1, 1998 by */
/*     Antoine Petitet, University  of  Tennessee, Knoxville 37996, USA. */

/*  ===================================================================== */

/*     .. Parameters .. */
/*     .. */
/*     .. Local Scalars .. */
/*     .. */
/*     .. External Functions .. */
/*     .. */
/*     .. Intrinsic Functions .. */
/*     .. */
/*     .. Executable Statements .. */

/*     Quick return if possible */

    /* Parameter adjustments */
    a_dim1 = *lda;
    a_offset = 1 + a_dim1;
    a -= a_offset;

    /* Function Body */
    if (*m <= 0 || *n <= 0) {
	return 0;
    }

/*     Start the operations */

    if (lsame_(uplo, "L", (ftnlen)1, (ftnlen)1)) {

/*        Set the diagonal to BETA or zero the imaginary part of the */
/*        diagonals and set the strictly lower triangular part of the */
/*        array to ALPHA. */

/* Computing MAX */
	i__1 = 0, i__2 = -(*ioffd);
	mn = max(i__1,i__2);
	i__1 = min(mn,*n);
	for (j = 1; j <= i__1; ++j) {
	    i__2 = *m;
	    for (i__ = 1; i__ <= i__2; ++i__) {
		i__3 = i__ + j * a_dim1;
		a[i__3].r = alpha->r, a[i__3].i = alpha->i;
/* L10: */
	    }
/* L20: */
	}

	if (lsame_(herm, "Z", (ftnlen)1, (ftnlen)1)) {
/* Computing MIN */
	    i__2 = *m - *ioffd;
	    i__1 = min(i__2,*n);
	    for (j = mn + 1; j <= i__1; ++j) {
		jtmp = j + *ioffd;
		i__2 = jtmp + j * a_dim1;
		i__3 = jtmp + j * a_dim1;
		r__1 = a[i__3].r;
		q__1.r = r__1, q__1.i = 0.f;
		a[i__2].r = q__1.r, a[i__2].i = q__1.i;
		i__2 = *m;
		for (i__ = jtmp + 1; i__ <= i__2; ++i__) {
		    i__3 = i__ + j * a_dim1;
		    a[i__3].r = alpha->r, a[i__3].i = alpha->i;
/* L30: */
		}
/* L40: */
	    }
	} else {
/* Computing MIN */
	    i__2 = *m - *ioffd;
	    i__1 = min(i__2,*n);
	    for (j = mn + 1; j <= i__1; ++j) {
		jtmp = j + *ioffd;
		i__2 = jtmp + j * a_dim1;
		a[i__2].r = beta->r, a[i__2].i = beta->i;
		i__2 = *m;
		for (i__ = jtmp + 1; i__ <= i__2; ++i__) {
		    i__3 = i__ + j * a_dim1;
		    a[i__3].r = alpha->r, a[i__3].i = alpha->i;
/* L50: */
		}
/* L60: */
	    }
	}

    } else if (lsame_(uplo, "U", (ftnlen)1, (ftnlen)1)) {

/*        Set the diagonal to BETA or zero the imaginary part of the */
/*        diagonals and set the strictly upper triangular part of the */
/*        array to ALPHA. */

/* Computing MIN */
	i__1 = *m - *ioffd;
	mn = min(i__1,*n);
	if (lsame_(herm, "Z", (ftnlen)1, (ftnlen)1)) {
/* Computing MAX */
	    i__1 = 0, i__2 = -(*ioffd);
	    i__3 = mn;
	    for (j = max(i__1,i__2) + 1; j <= i__3; ++j) {
		jtmp = j + *ioffd;
		i__1 = jtmp - 1;
		for (i__ = 1; i__ <= i__1; ++i__) {
		    i__2 = i__ + j * a_dim1;
		    a[i__2].r = alpha->r, a[i__2].i = alpha->i;
/* L70: */
		}
		i__1 = jtmp + j * a_dim1;
		i__2 = jtmp + j * a_dim1;
		r__1 = a[i__2].r;
		q__1.r = r__1, q__1.i = 0.f;
		a[i__1].r = q__1.r, a[i__1].i = q__1.i;
/* L80: */
	    }
	} else {
/* Computing MAX */
	    i__3 = 0, i__1 = -(*ioffd);
	    i__2 = mn;
	    for (j = max(i__3,i__1) + 1; j <= i__2; ++j) {
		jtmp = j + *ioffd;
		i__3 = jtmp - 1;
		for (i__ = 1; i__ <= i__3; ++i__) {
		    i__1 = i__ + j * a_dim1;
		    a[i__1].r = alpha->r, a[i__1].i = alpha->i;
/* L90: */
		}
		i__3 = jtmp + j * a_dim1;
		a[i__3].r = beta->r, a[i__3].i = beta->i;
/* L100: */
	    }
	}
	i__2 = *n;
	for (j = max(0,mn) + 1; j <= i__2; ++j) {
	    i__3 = *m;
	    for (i__ = 1; i__ <= i__3; ++i__) {
		i__1 = i__ + j * a_dim1;
		a[i__1].r = alpha->r, a[i__1].i = alpha->i;
/* L110: */
	    }
/* L120: */
	}

    } else if (lsame_(uplo, "D", (ftnlen)1, (ftnlen)1)) {

/*        Set the diagonal to BETA or zero the imaginary part of the */
/*        diagonals. */

	if (lsame_(herm, "Z", (ftnlen)1, (ftnlen)1)) {
	    if (*ioffd < *m && *ioffd > -(*n)) {
/* Computing MAX */
		i__2 = 0, i__3 = -(*ioffd);
/* Computing MIN */
		i__4 = *m - *ioffd;
		i__1 = min(i__4,*n);
		for (j = max(i__2,i__3) + 1; j <= i__1; ++j) {
		    jtmp = j + *ioffd;
		    i__2 = jtmp + j * a_dim1;
		    i__3 = jtmp + j * a_dim1;
		    r__1 = a[i__3].r;
		    q__1.r = r__1, q__1.i = 0.f;
		    a[i__2].r = q__1.r, a[i__2].i = q__1.i;
/* L130: */
		}
	    }
	} else {
	    if (*ioffd < *m && *ioffd > -(*n)) {
/* Computing MAX */
		i__1 = 0, i__2 = -(*ioffd);
/* Computing MIN */
		i__4 = *m - *ioffd;
		i__3 = min(i__4,*n);
		for (j = max(i__1,i__2) + 1; j <= i__3; ++j) {
		    i__1 = j + *ioffd + j * a_dim1;
		    a[i__1].r = beta->r, a[i__1].i = beta->i;
/* L140: */
		}
	    }
	}

    } else {

/*        Set the diagonals to BETA and the offdiagonals to ALPHA. */

	i__3 = *n;
	for (j = 1; j <= i__3; ++j) {
	    i__1 = *m;
	    for (i__ = 1; i__ <= i__1; ++i__) {
		i__2 = i__ + j * a_dim1;
		a[i__2].r = alpha->r, a[i__2].i = alpha->i;
/* L150: */
	    }
/* L160: */
	}
	if ((alpha->r != beta->r || alpha->i != beta->i) && *ioffd < *m && *
		ioffd > -(*n)) {
/* Computing MAX */
	    i__3 = 0, i__1 = -(*ioffd);
/* Computing MIN */
	    i__4 = *m - *ioffd;
	    i__2 = min(i__4,*n);
	    for (j = max(i__3,i__1) + 1; j <= i__2; ++j) {
		i__3 = j + *ioffd + j * a_dim1;
		a[i__3].r = beta->r, a[i__3].i = beta->i;
/* L170: */
	    }
	}

    }

    return 0;

/*     End of CTZPAD */

} /* ctzpad_ */

