/* /home4/luszczek/mscratch/build/SCALAPACK/PBLAS/SRC/PTZBLAS/cagemv.f -- translated by f2c (version 20031025).
   You must link the resulting object file with libf2c:
	on Microsoft Windows system, link with libf2c.lib;
	on Linux or Unix systems, link with .../path/to/libf2c.a -lm
	or, if you install libf2c.a in a standard place, with -lf2c -lm
	-- in that order, at the end of the command line, as in
		cc *.o -lf2c -lm
	Source for libf2c is in /netlib/f2c/libf2c.zip, e.g.,

		http://www.netlib.org/f2c/libf2c.zip
*/

#include "f2c.h"

/* Subroutine */ int cagemv_(char *trans, integer *m, integer *n, real *alpha,
	 complex *a, integer *lda, complex *x, integer *incx, real *beta, 
	real *y, integer *incy, ftnlen trans_len)
{
    /* System generated locals */
    integer a_dim1, a_offset, i__1, i__2, i__3, i__4;
    real r__1, r__2, r__3, r__4;

    /* Builtin functions */
    double r_imag(complex *);

    /* Local variables */
    integer i__, j, ix, iy, jx, jy, kx, ky, info;
    real absx, temp;
    integer lenx, leny;
    extern logical lsame_(char *, char *, ftnlen, ftnlen);
    real talpha;
    extern /* Subroutine */ int xerbla_(char *, integer *, ftnlen);


/*  -- PBLAS auxiliary routine (version 2.0) -- */
/*     University of Tennessee, Knoxville, Oak Ridge National Laboratory, */
/*     and University of California, Berkeley. */
/*     April 1, 1998 */

/*     .. Scalar Arguments .. */
/*     .. */
/*     .. Array Arguments .. */
/*     .. */

/*  Purpose */
/*  ======= */

/*  CAGEMV performs one of the matrix-vector operations */

/*     y := abs( alpha )*abs( A )*abs( x )+ abs( beta*y ), */

/*     or */

/*     y := abs( alpha )*abs( A' )*abs( x ) + abs( beta*y ), */

/*     or */

/*     y := abs( alpha )*abs( conjg( A' ) )*abs( x ) + abs( beta*y ), */

/*  where  alpha  and  beta  are real scalars, y is a real vector, x is a */
/*  vector and A is an m by n matrix. */

/*  Arguments */
/*  ========= */

/*  TRANS   (input) CHARACTER*1 */
/*          On entry,  TRANS  specifies the  operation to be performed as */
/*          follows: */

/*             TRANS = 'N' or 'n': */
/*                y := abs( alpha )*abs( A )*abs( x )+ abs( beta*y ) */

/*             TRANS = 'T' or 't': */
/*                y := abs( alpha )*abs( A' )*abs( x ) + abs( beta*y ) */

/*             TRANS = 'C' or 'c': */
/*                y := abs( alpha )*abs( conjg( A' ) )*abs( x ) + */
/*                     abs( beta*y ) */

/*  M       (input) INTEGER */
/*          On entry, M  specifies the number of rows of the matrix  A. M */
/*          must be at least zero. */

/*  N       (input) INTEGER */
/*          On entry, N  specifies the number of columns of the matrix A. */
/*          N must be at least zero. */

/*  ALPHA   (input) REAL */
/*          On entry, ALPHA specifies the real scalar alpha. */

/*  A       (input) COMPLEX array of dimension ( LDA, n ). */
/*          On entry, A  is an array of dimension ( LDA, N ). The leading */
/*          m by n part of the array  A  must contain the matrix of coef- */
/*          ficients. */

/*  LDA     (input) INTEGER */
/*          On entry, LDA specifies the leading dimension of the array A. */
/*          LDA must be at least max( 1, M ). */

/*  X       (input) COMPLEX array of dimension at least */
/*          ( 1 + ( n - 1 )*abs( INCX ) ) when TRANS = 'N' or 'n' and  at */
/*          least ( 1 + ( m - 1 )*abs( INCX ) ) otherwise.  Before entry, */
/*          the incremented array X must contain the vector x. */

/*  INCX    (input) INTEGER */
/*          On entry, INCX specifies the increment for the elements of X. */
/*          INCX must not be zero. */

/*  BETA    (input) REAL */
/*          On entry,  BETA  specifies the real scalar beta. When BETA is */
/*          supplied as zero then Y need not be set on input. */

/*  Y       (input/output) REAL array of dimension at least */
/*          ( 1 + ( m - 1 )*abs( INCY ) ) when TRANS = 'N' or 'n' and  at */
/*          least ( 1 + ( n - 1 )*abs( INCY ) ) otherwise.  Before  entry */
/*          with BETA non-zero, the incremented array  Y must contain the */
/*          vector y. On exit, the incremented array  Y is overwritten by */
/*          the updated vector y. */

/*  INCY    (input) INTEGER */
/*          On entry, INCY specifies the increment for the elements of Y. */
/*          INCY must not be zero. */

/*  -- Written on April 1, 1998 by */
/*     Antoine Petitet, University  of  Tennessee, Knoxville 37996, USA. */

/*  ===================================================================== */

/*     .. Parameters .. */
/*     .. */
/*     .. Local Scalars .. */
/*     .. */
/*     .. External Functions .. */
/*     .. */
/*     .. External Subroutines .. */
/*     .. */
/*     .. Intrinsic Functions .. */
/*     .. */
/*     .. Statement Functions .. */
/*     .. */
/*     .. Executable Statements .. */

/*     Test the input parameters. */

    /* Parameter adjustments */
    a_dim1 = *lda;
    a_offset = 1 + a_dim1;
    a -= a_offset;
    --x;
    --y;

    /* Function Body */
    info = 0;
    if (! lsame_(trans, "N", (ftnlen)1, (ftnlen)1) && ! lsame_(trans, "T", (
	    ftnlen)1, (ftnlen)1) && ! lsame_(trans, "C", (ftnlen)1, (ftnlen)1)
	    ) {
	info = 1;
    } else if (*m < 0) {
	info = 2;
    } else if (*n < 0) {
	info = 3;
    } else if (*lda < max(1,*m)) {
	info = 6;
    } else if (*incx == 0) {
	info = 8;
    } else if (*incy == 0) {
	info = 11;
    }
    if (info != 0) {
	xerbla_("CAGEMV", &info, (ftnlen)6);
	return 0;
    }

/*     Quick return if possible. */

    if (*m == 0 || *n == 0 || *alpha == 0.f && *beta == 1.f) {
	return 0;
    }

/*     Set  LENX  and  LENY, the lengths of the vectors x and y, and set */
/*     up the start points in  X  and  Y. */

    if (lsame_(trans, "N", (ftnlen)1, (ftnlen)1)) {
	lenx = *n;
	leny = *m;
    } else {
	lenx = *m;
	leny = *n;
    }
    if (*incx > 0) {
	kx = 1;
    } else {
	kx = 1 - (lenx - 1) * *incx;
    }
    if (*incy > 0) {
	ky = 1;
    } else {
	ky = 1 - (leny - 1) * *incy;
    }

/*     Start the operations. In this version the elements of A are */
/*     accessed sequentially with one pass through A. */

/*     First form  y := abs( beta*y ). */

    if (*incy == 1) {
	if (*beta == 0.f) {
	    i__1 = leny;
	    for (i__ = 1; i__ <= i__1; ++i__) {
		y[i__] = 0.f;
/* L10: */
	    }
	} else if (*beta == 1.f) {
	    i__1 = leny;
	    for (i__ = 1; i__ <= i__1; ++i__) {
		y[i__] = (r__1 = y[i__], dabs(r__1));
/* L20: */
	    }
	} else {
	    i__1 = leny;
	    for (i__ = 1; i__ <= i__1; ++i__) {
		y[i__] = (r__1 = *beta * y[i__], dabs(r__1));
/* L30: */
	    }
	}
    } else {
	iy = ky;
	if (*beta == 0.f) {
	    i__1 = leny;
	    for (i__ = 1; i__ <= i__1; ++i__) {
		y[iy] = 0.f;
		iy += *incy;
/* L40: */
	    }
	} else if (*beta == 1.f) {
	    i__1 = leny;
	    for (i__ = 1; i__ <= i__1; ++i__) {
		y[iy] = (r__1 = y[iy], dabs(r__1));
		iy += *incy;
/* L50: */
	    }
	} else {
	    i__1 = leny;
	    for (i__ = 1; i__ <= i__1; ++i__) {
		y[iy] = (r__1 = *beta * y[iy], dabs(r__1));
		iy += *incy;
/* L60: */
	    }
	}
    }

    if (*alpha == 0.f) {
	return 0;
    }

    talpha = dabs(*alpha);

    if (lsame_(trans, "N", (ftnlen)1, (ftnlen)1)) {

/*        Form  y := abs( alpha ) * abs( A ) * abs( x ) + y. */

	jx = kx;
	if (*incy == 1) {
	    i__1 = *n;
	    for (j = 1; j <= i__1; ++j) {
		i__2 = jx;
		absx = (r__1 = x[i__2].r, dabs(r__1)) + (r__2 = r_imag(&x[jx])
			, dabs(r__2));
		if (absx != 0.f) {
		    temp = talpha * absx;
		    i__2 = *m;
		    for (i__ = 1; i__ <= i__2; ++i__) {
			i__3 = i__ + j * a_dim1;
			y[i__] += temp * ((r__1 = a[i__3].r, dabs(r__1)) + (
				r__2 = r_imag(&a[i__ + j * a_dim1]), dabs(
				r__2)));
/* L70: */
		    }
		}
		jx += *incx;
/* L80: */
	    }
	} else {
	    i__1 = *n;
	    for (j = 1; j <= i__1; ++j) {
		i__2 = jx;
		absx = (r__1 = x[i__2].r, dabs(r__1)) + (r__2 = r_imag(&x[jx])
			, dabs(r__2));
		if (absx != 0.f) {
		    temp = talpha * absx;
		    iy = ky;
		    i__2 = *m;
		    for (i__ = 1; i__ <= i__2; ++i__) {
			i__3 = i__ + j * a_dim1;
			y[iy] += temp * ((r__1 = a[i__3].r, dabs(r__1)) + (
				r__2 = r_imag(&a[i__ + j * a_dim1]), dabs(
				r__2)));
			iy += *incy;
/* L90: */
		    }
		}
		jx += *incx;
/* L100: */
	    }
	}

    } else {

/*        Form  y := abs( alpha ) * abs( A' ) * abs( x ) + y. */

	jy = ky;
	if (*incx == 1) {
	    i__1 = *n;
	    for (j = 1; j <= i__1; ++j) {
		temp = 0.f;
		i__2 = *m;
		for (i__ = 1; i__ <= i__2; ++i__) {
		    i__3 = i__ + j * a_dim1;
		    i__4 = i__;
		    temp += ((r__1 = a[i__3].r, dabs(r__1)) + (r__2 = r_imag(&
			    a[i__ + j * a_dim1]), dabs(r__2))) * ((r__3 = x[
			    i__4].r, dabs(r__3)) + (r__4 = r_imag(&x[i__]), 
			    dabs(r__4)));
/* L110: */
		}
		y[jy] += talpha * temp;
		jy += *incy;
/* L120: */
	    }
	} else {
	    i__1 = *n;
	    for (j = 1; j <= i__1; ++j) {
		temp = 0.f;
		ix = kx;
		i__2 = *m;
		for (i__ = 1; i__ <= i__2; ++i__) {
		    i__3 = i__ + j * a_dim1;
		    i__4 = ix;
		    temp += ((r__1 = a[i__3].r, dabs(r__1)) + (r__2 = r_imag(&
			    a[i__ + j * a_dim1]), dabs(r__2))) * ((r__3 = x[
			    i__4].r, dabs(r__3)) + (r__4 = r_imag(&x[ix]), 
			    dabs(r__4)));
		    ix += *incx;
/* L130: */
		}
		y[jy] += talpha * temp;
		jy += *incy;
/* L140: */
	    }
	}
    }

    return 0;

/*     End of CAGEMV */

} /* cagemv_ */

