/* ---------------------------------------------------------------------
*
*  -- PBLAS auxiliary routine (version 2.0) --
*     University of Tennessee, Knoxville, Oak Ridge National Laboratory,
*     and University of California, Berkeley.
*     April 1, 1998
*
*  ---------------------------------------------------------------------
*/
/*
*  Include files
*/
#include "../pblas.h"
#include "../PBpblas.h"
#include "../PBtools.h"
#include "../PBblacs.h"
#include "../PBblas.h"

PBTYP_T * PB_Cstypeset()
{
/*
*  Purpose
*  =======
*
*  PB_Cstypeset on the first call initializes a static structure contai-
*  ning typed information and returns a pointer to it.  The  other calls
*  to this routine just returns this pointer.
*
*  -- Written on April 1, 1998 by
*     R. Clint Whaley, University of Tennessee, Knoxville 37996, USA.
*
*  ---------------------------------------------------------------------
*/
/*
*  .. Local Scalars ..
*/
   static int     setup=0;
   static PBTYP_T TypeStruct;
   static float   zero, one, negone;
/* ..
*  .. Executable Statements ..
*
*/
   if( setup ) return( &TypeStruct );

   setup = 1;

   TypeStruct.type = SREAL;
   TypeStruct.usiz = sizeof( float );
   TypeStruct.size = sizeof( float );

   zero   = ZERO;
   one    =  ONE;
   negone = -ONE;

   TypeStruct.zero      = (char *) (&zero);
   TypeStruct.one       = (char *) (&one);
   TypeStruct.negone    = (char *) (&negone);

   TypeStruct.Cgesd2d   = Csgesd2d;
   TypeStruct.Cgerv2d   = Csgerv2d;
   TypeStruct.Cgebs2d   = Csgebs2d;
   TypeStruct.Cgebr2d   = Csgebr2d;
   TypeStruct.Cgsum2d   = Csgsum2d;

   TypeStruct.Fmmadd    = smmadd_;
   TypeStruct.Fmmcadd   = smmcadd_;
   TypeStruct.Fmmtadd   = smmtadd_;
   TypeStruct.Fmmtcadd  = smmtcadd_;
   TypeStruct.Fmmdda    = smmdda_;
   TypeStruct.Fmmddac   = smmddac_;
   TypeStruct.Fmmddat   = smmddat_;
   TypeStruct.Fmmddact  = smmddact_;

   TypeStruct.Fcshft    = scshft_;
   TypeStruct.Frshft    = srshft_;

   TypeStruct.Fvvdotu   = svvdot_;
   TypeStruct.Fvvdotc   = svvdot_;

   TypeStruct.Fset      = sset_;

   TypeStruct.Ftzpad    = stzpad_;
   TypeStruct.Ftzpadcpy = stzpadcpy_;
   TypeStruct.Ftzscal   = stzscal_;
   TypeStruct.Fhescal   = stzscal_;
   TypeStruct.Ftzcnjg   = stzscal_;

   TypeStruct.Faxpy     = lfc_SLsaxpy;
   TypeStruct.Fcopy     = lfc_SLscopy;
   TypeStruct.Fswap     = lfc_SLsswap;

   TypeStruct.Fgemv     = lfc_SLsgemv;
   TypeStruct.Fsymv     = lfc_SLssymv;
   TypeStruct.Fhemv     = lfc_SLssymv;
   TypeStruct.Ftrmv     = lfc_SLstrmv;
   TypeStruct.Ftrsv     = lfc_SLstrsv;
   TypeStruct.Fagemv    = sagemv_;
   TypeStruct.Fasymv    = sasymv_;
   TypeStruct.Fahemv    = sasymv_;
   TypeStruct.Fatrmv    = satrmv_;

   TypeStruct.Fgerc     = lfc_SLsger;
   TypeStruct.Fgeru     = lfc_SLsger;
   TypeStruct.Fsyr      = lfc_SLssyr;
   TypeStruct.Fher      = lfc_SLssyr;
   TypeStruct.Fsyr2     = lfc_SLssyr2;
   TypeStruct.Fher2     = lfc_SLssyr2;

   TypeStruct.Fgemm     = lfc_SLsgemm;
   TypeStruct.Fsymm     = lfc_SLssymm;
   TypeStruct.Fhemm     = lfc_SLssymm;
   TypeStruct.Fsyrk     = lfc_SLssyrk;
   TypeStruct.Fherk     = lfc_SLssyrk;
   TypeStruct.Fsyr2k    = lfc_SLssyr2k;
   TypeStruct.Fher2k    = lfc_SLssyr2k;
   TypeStruct.Ftrmm     = lfc_SLstrmm;
   TypeStruct.Ftrsm     = lfc_SLstrsm;

   return( &TypeStruct );
/*
*  End of PB_Cstypeset
*/
}
