/* ---------------------------------------------------------------------
*
*  -- PBLAS auxiliary routine (version 2.0) --
*     University of Tennessee, Knoxville, Oak Ridge National Laboratory,
*     and University of California, Berkeley.
*     April 1, 1998
*
*  ---------------------------------------------------------------------
*/
/*
*  Include files
*/
#include "../pblas.h"
#include "../PBpblas.h"
#include "../PBtools.h"
#include "../PBblacs.h"
#include "../PBblas.h"

PBTYP_T * PB_Cdtypeset()
{
/*
*  Purpose
*  =======
*
*  PB_Cdtypeset on the first call initializes a static structure contai-
*  ning typed information and returns a pointer to it.  The  other calls
*  to this routine just returns this pointer.
*
*  -- Written on April 1, 1998 by
*     R. Clint Whaley, University of Tennessee, Knoxville 37996, USA.
*
*  ---------------------------------------------------------------------
*/
/*
*  .. Local Scalars ..
*/
   static int     setup=0;
   static PBTYP_T TypeStruct;
   static double  zero, one, negone;
/* ..
*  .. Executable Statements ..
*
*/
   if( setup ) return( &TypeStruct );

   setup = 1;

   TypeStruct.type = DREAL;
   TypeStruct.usiz = sizeof( double );
   TypeStruct.size = sizeof( double );

   zero   = ZERO;
   one    =  ONE;
   negone = -ONE;

   TypeStruct.zero      = (char *) (&zero);
   TypeStruct.one       = (char *) (&one);
   TypeStruct.negone    = (char *) (&negone);

   TypeStruct.Cgesd2d   = Cdgesd2d;
   TypeStruct.Cgerv2d   = Cdgerv2d;
   TypeStruct.Cgebs2d   = Cdgebs2d;
   TypeStruct.Cgebr2d   = Cdgebr2d;
   TypeStruct.Cgsum2d   = Cdgsum2d;

   TypeStruct.Fmmadd    = dmmadd_;
   TypeStruct.Fmmcadd   = dmmcadd_;
   TypeStruct.Fmmtadd   = dmmtadd_;
   TypeStruct.Fmmtcadd  = dmmtcadd_;
   TypeStruct.Fmmdda    = dmmdda_;
   TypeStruct.Fmmddac   = dmmddac_;
   TypeStruct.Fmmddat   = dmmddat_;
   TypeStruct.Fmmddact  = dmmddact_;

   TypeStruct.Fcshft    = dcshft_;
   TypeStruct.Frshft    = drshft_;

   TypeStruct.Fvvdotu   = dvvdot_;
   TypeStruct.Fvvdotc   = dvvdot_;

   TypeStruct.Fset      = dset_;

   TypeStruct.Ftzpad    = dtzpad_;
   TypeStruct.Ftzpadcpy = dtzpadcpy_;
   TypeStruct.Ftzscal   = dtzscal_;
   TypeStruct.Fhescal   = dtzscal_;
   TypeStruct.Ftzcnjg   = dtzscal_;

   TypeStruct.Faxpy     = lfc_SLdaxpy;
   TypeStruct.Fcopy     = lfc_SLdcopy;
   TypeStruct.Fswap     = lfc_SLdswap;

   TypeStruct.Fgemv     = lfc_SLdgemv;
   TypeStruct.Fsymv     = lfc_SLdsymv;
   TypeStruct.Fhemv     = lfc_SLdsymv;
   TypeStruct.Ftrmv     = lfc_SLdtrmv;
   TypeStruct.Ftrsv     = lfc_SLdtrsv;
   TypeStruct.Fagemv    = dagemv_;
   TypeStruct.Fasymv    = dasymv_;
   TypeStruct.Fahemv    = dasymv_;
   TypeStruct.Fatrmv    = datrmv_;

   TypeStruct.Fgerc     = lfc_SLdger;
   TypeStruct.Fgeru     = lfc_SLdger;
   TypeStruct.Fsyr      = lfc_SLdsyr;
   TypeStruct.Fher      = lfc_SLdsyr;
   TypeStruct.Fsyr2     = lfc_SLdsyr2;
   TypeStruct.Fher2     = lfc_SLdsyr2;

   TypeStruct.Fgemm     = lfc_SLdgemm;
   TypeStruct.Fsymm     = lfc_SLdsymm;
   TypeStruct.Fhemm     = lfc_SLdsymm;
   TypeStruct.Fsyrk     = lfc_SLdsyrk;
   TypeStruct.Fherk     = lfc_SLdsyrk;
   TypeStruct.Fsyr2k    = lfc_SLdsyr2k;
   TypeStruct.Fher2k    = lfc_SLdsyr2k;
   TypeStruct.Ftrmm     = lfc_SLdtrmm;
   TypeStruct.Ftrsm     = lfc_SLdtrsm;

   return( &TypeStruct );
/*
*  End of PB_Cdtypeset
*/
}
