/* ---------------------------------------------------------------------
*
*  -- PBLAS auxiliary routine (version 2.0) --
*     University of Tennessee, Knoxville, Oak Ridge National Laboratory,
*     and University of California, Berkeley.
*     April 1, 1998
*
*  ---------------------------------------------------------------------
*/
/*
*  Include files
*/
#include "../pblas.h"
#include "../PBpblas.h"
#include "../PBtools.h"
#include "../PBblacs.h"
#include "../PBblas.h"

PBTYP_T * PB_Cctypeset()
{
/*
*  Purpose
*  =======
*
*  PB_Cctypeset on the first call initializes a static structure contai-
*  ning typed information and returns a pointer to it.  The  other calls
*  to this routine just returns this pointer.
*
*  -- Written on April 1, 1998 by
*     R. Clint Whaley, University of Tennessee, Knoxville 37996, USA.
*
*  ---------------------------------------------------------------------
*/
/*
*  .. Local Scalars ..
*/
   static int     setup=0;
   static PBTYP_T TypeStruct;
   static cmplx   zero, one, negone;
/* ..
*  .. Executable Statements ..
*
*/
   if( setup ) return( &TypeStruct );

   setup = 1;

   TypeStruct.type = SCPLX;
   TypeStruct.usiz = sizeof( float );
   TypeStruct.size = sizeof( cmplx );

   zero  [REAL_PART] = ZERO;
   zero  [IMAG_PART] = ZERO;
   one   [REAL_PART] =  ONE;
   one   [IMAG_PART] = ZERO;
   negone[REAL_PART] = -ONE;
   negone[IMAG_PART] = ZERO;

   TypeStruct.zero      = ((char *) zero);
   TypeStruct.one       = ((char *) one);
   TypeStruct.negone    = ((char *) negone);

   TypeStruct.Cgesd2d   = Ccgesd2d;
   TypeStruct.Cgerv2d   = Ccgerv2d;
   TypeStruct.Cgebs2d   = Ccgebs2d;
   TypeStruct.Cgebr2d   = Ccgebr2d;
   TypeStruct.Cgsum2d   = Ccgsum2d;

   TypeStruct.Fmmadd    = cmmadd_;
   TypeStruct.Fmmcadd   = cmmcadd_;
   TypeStruct.Fmmtadd   = cmmtadd_;
   TypeStruct.Fmmtcadd  = cmmtcadd_;
   TypeStruct.Fmmdda    = cmmdda_;
   TypeStruct.Fmmddac   = cmmddac_;
   TypeStruct.Fmmddat   = cmmddat_;
   TypeStruct.Fmmddact  = cmmddact_;

   TypeStruct.Fcshft    = ccshft_;
   TypeStruct.Frshft    = crshft_;

   TypeStruct.Fvvdotu   = cvvdotu_;
   TypeStruct.Fvvdotc   = cvvdotc_;

   TypeStruct.Fset      = cset_;

   TypeStruct.Ftzpad    = ctzpad_;
   TypeStruct.Ftzpadcpy = ctzpadcpy_;
   TypeStruct.Ftzscal   = ctzscal_;
   TypeStruct.Fhescal   = chescal_;
   TypeStruct.Ftzcnjg   = ctzcnjg_;

   TypeStruct.Faxpy     = lfc_SLcaxpy;
   TypeStruct.Fcopy     = lfc_SLccopy;
   TypeStruct.Fswap     = lfc_SLcswap;

   TypeStruct.Fgemv     = lfc_SLcgemv;
   TypeStruct.Fsymv     = csymv_;
   TypeStruct.Fhemv     = lfc_SLchemv;
   TypeStruct.Ftrmv     = lfc_SLctrmv;
   TypeStruct.Ftrsv     = lfc_SLctrsv;
   TypeStruct.Fagemv    = cagemv_;
   TypeStruct.Fasymv    = casymv_;
   TypeStruct.Fahemv    = cahemv_;
   TypeStruct.Fatrmv    = catrmv_;

   TypeStruct.Fgerc     = lfc_SLcgerc;
   TypeStruct.Fgeru     = lfc_SLcgeru;
   TypeStruct.Fsyr      = csyr_;
   TypeStruct.Fher      = lfc_SLcher;
   TypeStruct.Fsyr2     = csyr2_;
   TypeStruct.Fher2     = lfc_SLcher2;

   TypeStruct.Fgemm     = lfc_SLcgemm;
   TypeStruct.Fsymm     = lfc_SLcsymm;
   TypeStruct.Fhemm     = lfc_SLchemm;
   TypeStruct.Fsyrk     = lfc_SLcsyrk;
   TypeStruct.Fherk     = lfc_SLcherk;
   TypeStruct.Fsyr2k    = lfc_SLcsyr2k;
   TypeStruct.Fher2k    = lfc_SLcher2k;
   TypeStruct.Ftrmm     = lfc_SLctrmm;
   TypeStruct.Ftrsm     = lfc_SLctrsm;

   return( &TypeStruct );
/*
*  End of PB_Cctypeset
*/
}
