/* ---------------------------------------------------------------------
*
*  -- PBLAS routine (version 2.0) --
*     University of Tennessee, Knoxville, Oak Ridge National Laboratory,
*     and University of California, Berkeley.
*     April 1, 1998
*
*  ---------------------------------------------------------------------
*/
/*
*  This file includes F77 BLAS definitions. All  PBLAS  routines include
*  this file.
*
*  ---------------------------------------------------------------------
*  #define macro constants
*  ---------------------------------------------------------------------
*/
#define    CNOTRAN             'N'
#define    CNOCONJG            'N'
#define    CTRAN               'T'
#define    CCONJG              'Z'
#define    CCOTRAN             'C'

#define    CALL                'A'
#define    CLOWER              'L'
#define    CUPPER              'U'
#define    CDIAGONAL           'D'

#define    CLEFT               'L'
#define    CRIGHT              'R'

#define    CUNIT               'U'
#define    CNOUNIT             'N'

#define    CINIT               'I'
#define    CNOINIT             'N'

#define    CFORWARD            'F'
#define    CBACKWARD           'B'

#define    CREUSE              'R'
#define    CALLOCATE           'A'

#define    NOTRAN              "N"
#define    NOCONJG             "N"
#define    TRAN                "T"
#define    CONJG               "Z"
#define    COTRAN              "C"

#define    ALL                 "A"
#define    LOWER               "L"
#define    UPPER               "U"
#define    DIAGONAL            "D"

#define    LEFT                "L"
#define    RIGHT               "R"

#define    UNIT                "U"
#define    NOUNIT              "N"

#define    INIT                "I"
#define    NOINIT              "N"

#define    FORWARD             "F"
#define    BACKWARD            "B"

#define    REUSE               "R"
#define    ALLOCATE            "A"

#if( _F2C_CALL_ == _F2C_ADD_ )
/*
*  These defines  set  up  the  naming scheme required to have a FORTRAN
*  routine called by a C routine. No redefinition is necessary  to  have
*  the following FORTRAN to C interface:
*
*           FORTRAN DECLARATION            C CALL
*           SUBROUTINE DGEMM(...)          lfc_SLdgemm(...)
*
*  This is the PBLAS default.
*/
#endif

#if( _F2C_CALL_ == _F2C_UPCASE )
/*
*  These defines  set  up  the  naming scheme required to have a FORTRAN
*  routine called by a C routine with the following  FORTRAN to C inter-
*  face:
*
*           FORTRAN DECLARATION            C CALL
*           SUBROUTINE DGEMM(...)          DGEMM(...)
*/
#define    lfc_SLsrot               SROT
#define    lfc_SLdrot               DROT

#define    lfc_SLsswap              SSWAP
#define    lfc_SLdswap              DSWAP
#define    lfc_SLcswap              CSWAP
#define    lfc_SLzswap              ZSWAP

#define    lfc_SLscopy              SCOPY
#define    lfc_SLdcopy              DCOPY
#define    lfc_SLccopy              CCOPY
#define    lfc_SLzcopy              ZCOPY

#define    lfc_SLsaxpy              SAXPY
#define    lfc_SLdaxpy              DAXPY
#define    lfc_SLcaxpy              CAXPY
#define    lfc_SLzaxpy              ZAXPY

#define    lfc_SLsscal              SSCAL
#define    lfc_SLdscal              DSCAL
#define    lfc_SLcscal              CSCAL
#define    lfc_SLzscal              ZSCAL
#define    lfc_SLcsscal             CSSCAL
#define    lfc_SLzdscal             ZDSCAL

#define    lfc_SLsasum              SASUM
#define    lfc_SLdasum              DASUM
#define    lfc_SLscasum             SCASUM
#define    lfc_SLdzasum             DZASUM

#define    lfc_SLsnrm2              SNRM2
#define    lfc_SLdnrm2              DNRM2
#define    lfc_SLscnrm2             SCNRM2
#define    lfc_SLdznrm2             DZNRM2

#define    lfc_SLsdot               SDOT
#define    lfc_SLddot               DDOT
#define    lfc_SLcdotu              CDOTU
#define    lfc_SLzdotu              ZDOTU
#define    lfc_SLcdotc              CDOTC
#define    lfc_SLzdotc              ZDOTC

#define    lfc_SLisamax             ISAMAX
#define    lfc_SLidamax             IDAMAX
#define    lfc_SLicamax             ICAMAX
#define    lfc_SLizamax             IZAMAX

#define    lfc_SLsgemv              SGEMV
#define    lfc_SLdgemv              DGEMV
#define    lfc_SLcgemv              CGEMV
#define    lfc_SLzgemv              ZGEMV

#define    lfc_SLssymv              SSYMV
#define    lfc_SLdsymv              DSYMV
#define    lfc_SLchemv              CHEMV
#define    lfc_SLzhemv              ZHEMV

#define    lfc_SLstrmv              STRMV
#define    lfc_SLdtrmv              DTRMV
#define    lfc_SLctrmv              CTRMV
#define    lfc_SLztrmv              ZTRMV

#define    lfc_SLstrsv              STRSV
#define    lfc_SLdtrsv              DTRSV
#define    lfc_SLctrsv              CTRSV
#define    lfc_SLztrsv              ZTRSV

#define    lfc_SLsger               SGER
#define    lfc_SLdger               DGER
#define    lfc_SLcgeru              CGERU
#define    lfc_SLzgeru              ZGERU
#define    lfc_SLcgerc              CGERC
#define    lfc_SLzgerc              ZGERC

#define    lfc_SLssyr               SSYR
#define    lfc_SLdsyr               DSYR
#define    lfc_SLcher               CHER
#define    lfc_SLzher               ZHER

#define    lfc_SLssyr2              SSYR2
#define    lfc_SLdsyr2              DSYR2
#define    lfc_SLcher2              CHER2
#define    lfc_SLzher2              ZHER2

#define    lfc_SLsgemm              SGEMM
#define    lfc_SLdgemm              DGEMM
#define    lfc_SLcgemm              CGEMM
#define    lfc_SLzgemm              ZGEMM

#define    lfc_SLssymm              SSYMM
#define    lfc_SLdsymm              DSYMM
#define    lfc_SLcsymm              CSYMM
#define    lfc_SLchemm              CHEMM
#define    lfc_SLzsymm              ZSYMM
#define    lfc_SLzhemm              ZHEMM

#define    lfc_SLstrmm              STRMM
#define    lfc_SLdtrmm              DTRMM
#define    lfc_SLctrmm              CTRMM
#define    lfc_SLztrmm              ZTRMM

#define    lfc_SLstrsm              STRSM
#define    lfc_SLdtrsm              DTRSM
#define    lfc_SLctrsm              CTRSM
#define    lfc_SLztrsm              ZTRSM

#define    lfc_SLssyrk              SSYRK
#define    lfc_SLdsyrk              DSYRK
#define    lfc_SLcsyrk              CSYRK
#define    lfc_SLcherk              CHERK
#define    lfc_SLzsyrk              ZSYRK
#define    lfc_SLzherk              ZHERK

#define    lfc_SLssyr2k             SSYR2K
#define    lfc_SLdsyr2k             DSYR2K
#define    lfc_SLcsyr2k             CSYR2K
#define    lfc_SLcher2k             CHER2K
#define    lfc_SLzsyr2k             ZSYR2K
#define    lfc_SLzher2k             ZHER2K

#endif

#if( _F2C_CALL_ == _F2C_NOCHANGE )
/*
*  These defines  set  up  the  naming scheme required to have a FORTRAN
*  routine called by a C routine with the following  FORTRAN to C inter-
*  face:
*
*           FORTRAN DECLARATION            C CALL
*           SUBROUTINE DGEMM(...)          dgemm(...)
*/
#define    lfc_SLsrot               srot
#define    lfc_SLdrot               drot

#define    lfc_SLsswap              sswap
#define    lfc_SLdswap              dswap
#define    lfc_SLcswap              cswap
#define    lfc_SLzswap              zswap

#define    lfc_SLscopy              scopy
#define    lfc_SLdcopy              dcopy
#define    lfc_SLccopy              ccopy
#define    lfc_SLzcopy              zcopy

#define    lfc_SLsaxpy              saxpy
#define    lfc_SLdaxpy              daxpy
#define    lfc_SLcaxpy              caxpy
#define    lfc_SLzaxpy              zaxpy

#define    lfc_SLsscal              sscal
#define    lfc_SLdscal              dscal
#define    lfc_SLcscal              cscal
#define    lfc_SLzscal              zscal
#define    lfc_SLcsscal             csscal
#define    lfc_SLzdscal             zdscal

#define    lfc_SLsasum              sasum
#define    lfc_SLdasum              dasum
#define    lfc_SLscasum             scasum
#define    lfc_SLdzasum             dzasum

#define    lfc_SLsnrm2              snrm2
#define    lfc_SLdnrm2              dnrm2
#define    lfc_SLscnrm2             scnrm2
#define    lfc_SLdznrm2             dznrm2

#define    lfc_SLsdot               sdot
#define    lfc_SLddot               ddot
#define    lfc_SLcdotu              cdotu
#define    lfc_SLzdotu              zdotu
#define    lfc_SLcdotc              cdotc
#define    lfc_SLzdotc              zdotc

#define    lfc_SLisamax             isamax
#define    lfc_SLidamax             idamax
#define    lfc_SLicamax             icamax
#define    lfc_SLizamax             izamax

#define    lfc_SLsgemv              sgemv
#define    lfc_SLdgemv              dgemv
#define    lfc_SLcgemv              cgemv
#define    lfc_SLzgemv              zgemv

#define    lfc_SLssymv              ssymv
#define    lfc_SLdsymv              dsymv
#define    lfc_SLchemv              chemv
#define    lfc_SLzhemv              zhemv

#define    lfc_SLstrmv              strmv
#define    lfc_SLdtrmv              dtrmv
#define    lfc_SLctrmv              ctrmv
#define    lfc_SLztrmv              ztrmv

#define    lfc_SLstrsv              strsv
#define    lfc_SLdtrsv              dtrsv
#define    lfc_SLctrsv              ctrsv
#define    lfc_SLztrsv              ztrsv

#define    lfc_SLsger               sger
#define    lfc_SLdger               dger
#define    lfc_SLcgeru              cgeru
#define    lfc_SLzgeru              zgeru
#define    lfc_SLcgerc              cgerc
#define    lfc_SLzgerc              zgerc

#define    lfc_SLssyr               ssyr
#define    lfc_SLdsyr               dsyr
#define    lfc_SLcher               cher
#define    lfc_SLzher               zher

#define    lfc_SLssyr2              ssyr2
#define    lfc_SLdsyr2              dsyr2
#define    lfc_SLcher2              cher2
#define    lfc_SLzher2              zher2

#define    lfc_SLsgemm              sgemm
#define    lfc_SLdgemm              dgemm
#define    lfc_SLcgemm              cgemm
#define    lfc_SLzgemm              zgemm

#define    lfc_SLssymm              ssymm
#define    lfc_SLdsymm              dsymm
#define    lfc_SLcsymm              csymm
#define    lfc_SLchemm              chemm
#define    lfc_SLzsymm              zsymm
#define    lfc_SLzhemm              zhemm

#define    lfc_SLstrmm              strmm
#define    lfc_SLdtrmm              dtrmm
#define    lfc_SLctrmm              ctrmm
#define    lfc_SLztrmm              ztrmm

#define    lfc_SLstrsm              strsm
#define    lfc_SLdtrsm              dtrsm
#define    lfc_SLctrsm              ctrsm
#define    lfc_SLztrsm              ztrsm

#define    lfc_SLssyrk              ssyrk
#define    lfc_SLdsyrk              dsyrk
#define    lfc_SLcsyrk              csyrk
#define    lfc_SLcherk              cherk
#define    lfc_SLzsyrk              zsyrk
#define    lfc_SLzherk              zherk

#define    lfc_SLssyr2k             ssyr2k
#define    lfc_SLdsyr2k             dsyr2k
#define    lfc_SLcsyr2k             csyr2k
#define    lfc_SLcher2k             cher2k
#define    lfc_SLzsyr2k             zsyr2k
#define    lfc_SLzher2k             zher2k

#endif
/*
*  ---------------------------------------------------------------------
*  Function prototypes
*  ---------------------------------------------------------------------
*/
#ifdef __STDC__

int            lfc_SLisamax         ( int *,     char *,    int * );
int            lfc_SLidamax         ( int *,     char *,    int * );
int            lfc_SLicamax         ( int *,     char *,    int * );
int            lfc_SLizamax         ( int *,     char *,    int * );

F_VOID_FCT     lfc_SLsaxpy          ( int *,     char *,    char *,
                                 int *,     char *,    int * );
F_VOID_FCT     lfc_SLdaxpy          ( int *,     char *,    char *,
                                 int *,     char *,    int * );
F_VOID_FCT     lfc_SLcaxpy          ( int *,     char *,    char *,
                                 int *,     char *,    int * );
F_VOID_FCT     lfc_SLzaxpy          ( int *,     char *,    char *,
                                 int *,     char *,    int * );

F_VOID_FCT     lfc_SLscopy          ( int *,     char *,    int *,
                                 char *,    int * );
F_VOID_FCT     lfc_SLdcopy          ( int *,     char *,    int *,
                                 char *,    int * );
F_VOID_FCT     lfc_SLccopy          ( int *,     char *,    int *,
                                 char *,    int * );
F_VOID_FCT     lfc_SLzcopy          ( int *,     char *,    int *,
                                 char *,    int * );

F_VOID_FCT     lfc_SLsscal          ( int *,     char *,    char *,
                                 int * );
F_VOID_FCT     lfc_SLdscal          ( int *,     char *,    char *,
                                 int * );
F_VOID_FCT     lfc_SLcscal          ( int *,     char *,    char *,
                                 int * );
F_VOID_FCT     lfc_SLcsscal         ( int *,     char *,    char *,
                                 int * );
F_VOID_FCT     lfc_SLzdscal         ( int *,     char *,    char *,
                                 int * );
F_VOID_FCT     lfc_SLzscal          ( int *,     char *,    char *,
                                 int * );

F_VOID_FCT     lfc_SLsswap          ( int *,     char *,    int *,
                                 char *,    int * );
F_VOID_FCT     lfc_SLdswap          ( int *,     char *,    int *,
                                 char *,    int * );
F_VOID_FCT     lfc_SLcswap          ( int *,     char *,    int *,
                                 char *,    int * );
F_VOID_FCT     lfc_SLzswap          ( int *,     char *,    int *,
                                 char *,    int * );

F_VOID_FCT     lfc_SLsgemv          ( F_CHAR_T,  int *,     int *,
                                 char *,    char *,    int *,
                                 char *,    int *,     char *,
                                 char *,    int * );
F_VOID_FCT     lfc_SLdgemv          ( F_CHAR_T,  int *,     int *,
                                 char *,    char *,    int *,
                                 char *,    int *,     char *,
                                 char *,    int * );
F_VOID_FCT     lfc_SLcgemv          ( F_CHAR_T,  int *,     int *,
                                 char *,    char *,    int *,
                                 char *,    int *,     char *,
                                 char *,    int * );
F_VOID_FCT     lfc_SLzgemv          ( F_CHAR_T,  int *,     int *,
                                 char *,    char *,    int *,
                                 char *,    int *,     char *,
                                 char *,    int * );

F_VOID_FCT     lfc_SLssymv          ( F_CHAR_T,  int *,     char *,
                                 char *,    int *,     char *,
                                 int *,     char *,    char *,
                                 int * );
F_VOID_FCT     lfc_SLdsymv          ( F_CHAR_T,  int *,     char *,
                                 char *,    int *,     char *,
                                 int *,     char *,    char *,
                                 int * );
F_VOID_FCT     lfc_SLchemv          ( F_CHAR_T,  int *,     char *,
                                 char *,    int *,     char *,
                                 int *,     char *,    char *,
                                 int * );
F_VOID_FCT     lfc_SLzhemv          ( F_CHAR_T,  int *,     char *,
                                 char *,    int *,     char *,
                                 int *,     char *,    char *,
                                 int * );

F_VOID_FCT     lfc_SLstrmv          ( F_CHAR_T,  F_CHAR_T,  F_CHAR_T,
                                 int *,     char *,    int *,
                                 char *,    int * );
F_VOID_FCT     lfc_SLdtrmv          ( F_CHAR_T,  F_CHAR_T,  F_CHAR_T,
                                 int *,     char *,    int *,
                                 char *,    int * );
F_VOID_FCT     lfc_SLctrmv          ( F_CHAR_T,  F_CHAR_T,  F_CHAR_T,
                                 int *,     char *,    int *,
                                 char *,    int * );
F_VOID_FCT     lfc_SLztrmv          ( F_CHAR_T,  F_CHAR_T,  F_CHAR_T,
                                 int *,     char *,    int *,
                                 char *,    int * );

F_VOID_FCT     lfc_SLstrsv          ( F_CHAR_T,  F_CHAR_T,  F_CHAR_T,
                                 int *,     char *,    int *,
                                 char *,    int * );
F_VOID_FCT     lfc_SLdtrsv          ( F_CHAR_T,  F_CHAR_T,  F_CHAR_T,
                                 int *,     char *,    int *,
                                 char *,    int * );
F_VOID_FCT     lfc_SLctrsv          ( F_CHAR_T,  F_CHAR_T,  F_CHAR_T,
                                 int *,     char *,    int *,
                                 char *,    int * );
F_VOID_FCT     lfc_SLztrsv          ( F_CHAR_T,  F_CHAR_T,  F_CHAR_T,
                                 int *,     char *,    int *,
                                 char *,    int * );

F_VOID_FCT     lfc_SLsger           ( int *,     int *,     char *,
                                 char *,    int *,     char *,
                                 int *,     char *,    int * );
F_VOID_FCT     lfc_SLdger           ( int *,     int *,     char *,
                                 char *,    int *,     char *,
                                 int *,     char *,    int * );
F_VOID_FCT     lfc_SLcgerc          ( int *,     int *,     char *,
                                 char *,    int *,     char *,
                                 int *,     char *,    int * );
F_VOID_FCT     lfc_SLcgeru          ( int *,     int *,     char *,
                                 char *,    int *,     char *,
                                 int *,     char *,    int * );
F_VOID_FCT     lfc_SLzgerc          ( int *,     int *,     char *,
                                 char *,    int *,     char *,
                                 int *,     char *,    int * );
F_VOID_FCT     lfc_SLzgeru          ( int *,     int *,     char *,
                                 char *,    int *,     char *,
                                 int *,     char *,    int * );

F_VOID_FCT     lfc_SLssyr           ( F_CHAR_T,  int *,     char *,
                                 char *,    int *,     char *,
                                 int * );
F_VOID_FCT     lfc_SLdsyr           ( F_CHAR_T,  int *,     char *,
                                 char *,    int *,     char *,
                                 int * );
F_VOID_FCT     lfc_SLcher           ( F_CHAR_T,  int *,     char *,
                                 char *,    int *,     char *,
                                 int * );
F_VOID_FCT     lfc_SLzher           ( F_CHAR_T,  int *,     char *,
                                 char *,    int *,     char *,
                                 int * );

F_VOID_FCT     lfc_SLssyr2          ( F_CHAR_T,  int *,     char *,
                                 char *,    int *,     char *,
                                 int *,     char *,    int * );
F_VOID_FCT     lfc_SLdsyr2          ( F_CHAR_T,  int *,     char *,
                                 char *,    int *,     char *,
                                 int *,     char *,    int * );
F_VOID_FCT     lfc_SLcher2          ( F_CHAR_T,  int *,     char *,
                                 char *,    int *,     char *,
                                 int *,     char *,    int * );
F_VOID_FCT     lfc_SLzher2          ( F_CHAR_T,  int *,     char *,
                                 char *,    int *,     char *,
                                 int *,     char *,    int * );

F_VOID_FCT     lfc_SLsgemm          ( F_CHAR_T,  F_CHAR_T,  int *,
                                 int *,     int *,     char *,
                                 char *,    int *,     char *,
                                 int *,     char *,    char *,
                                 int * );
F_VOID_FCT     lfc_SLdgemm          ( F_CHAR_T,  F_CHAR_T,  int *,
                                 int *,     int *,     char *,
                                 char *,    int *,     char *,
                                 int *,     char *,    char *,
                                 int * );
F_VOID_FCT     lfc_SLcgemm          ( F_CHAR_T,  F_CHAR_T,  int *,
                                 int *,     int *,     char *,
                                 char *,    int *,     char *,
                                 int *,     char *,    char *,
                                 int * );
F_VOID_FCT     lfc_SLzgemm          ( F_CHAR_T,  F_CHAR_T,  int *,
                                 int *,     int *,     char *,
                                 char *,    int *,     char *,
                                 int *,     char *,    char *,
                                 int * );

F_VOID_FCT     lfc_SLssymm          ( F_CHAR_T,  F_CHAR_T,  int *,
                                 int *,     char *,    char *,
                                 int *,     char *,    int *,
                                 char *,    char *,    int * );
F_VOID_FCT     lfc_SLdsymm          ( F_CHAR_T,  F_CHAR_T,  int *,
                                 int *,     char *,    char *,
                                 int *,     char *,    int *,
                                 char *,    char *,    int * );
F_VOID_FCT     lfc_SLcsymm          ( F_CHAR_T,  F_CHAR_T,  int *,
                                 int *,     char *,    char *,
                                 int *,     char *,    int *,
                                 char *,    char *,    int * );
F_VOID_FCT     lfc_SLzsymm          ( F_CHAR_T,  F_CHAR_T,  int *,
                                 int *,     char *,    char *,
                                 int *,     char *,    int *,
                                 char *,    char *,    int * );
F_VOID_FCT     lfc_SLchemm          ( F_CHAR_T,  F_CHAR_T,  int *,
                                 int *,     char *,    char *,
                                 int *,     char *,    int *,
                                 char *,    char *,    int * );
F_VOID_FCT     lfc_SLzhemm          ( F_CHAR_T,  F_CHAR_T,  int *,
                                 int *,     char *,    char *,
                                 int *,     char *,    int *,
                                 char *,    char *,    int * );

F_VOID_FCT     lfc_SLssyrk          ( F_CHAR_T,  F_CHAR_T,  int *,
                                 int *,     char *,    char *,
                                 int *,     char *,    char *,
                                 int * );
F_VOID_FCT     lfc_SLdsyrk          ( F_CHAR_T,  F_CHAR_T,  int *,
                                 int *,     char *,    char *,
                                 int *,     char *,    char *,
                                 int * );
F_VOID_FCT     lfc_SLcsyrk          ( F_CHAR_T,  F_CHAR_T,  int *,
                                 int *,     char *,    char *,
                                 int *,     char *,    char *,
                                 int * );
F_VOID_FCT     lfc_SLzsyrk          ( F_CHAR_T,  F_CHAR_T,  int *,
                                 int *,     char *,    char *,
                                 int *,     char *,    char *,
                                 int * );
F_VOID_FCT     lfc_SLcherk          ( F_CHAR_T,  F_CHAR_T,  int *,
                                 int *,     char *,    char *,
                                 int *,     char *,    char *,
                                 int * );
F_VOID_FCT     lfc_SLzherk          ( F_CHAR_T,  F_CHAR_T,  int *,
                                 int *,     char *,    char *,
                                 int *,     char *,    char *,
                                 int * );

F_VOID_FCT     lfc_SLssyr2k         ( F_CHAR_T,  F_CHAR_T,  int *,
                                 int *,     char *,    char *,
                                 int *,     char *,    int *,
                                 char *,    char *,    int * );
F_VOID_FCT     lfc_SLdsyr2k         ( F_CHAR_T,  F_CHAR_T,  int *,
                                 int *,     char *,    char *,
                                 int *,     char *,    int *,
                                 char *,    char *,    int * );
F_VOID_FCT     lfc_SLcsyr2k         ( F_CHAR_T,  F_CHAR_T,  int *,
                                 int *,     char *,    char *,
                                 int *,     char *,    int *,
                                 char *,    char *,    int * );
F_VOID_FCT     lfc_SLzsyr2k         ( F_CHAR_T,  F_CHAR_T,  int *,
                                 int *,     char *,    char *,
                                 int *,     char *,    int *,
                                 char *,    char *,    int * );
F_VOID_FCT     lfc_SLcher2k         ( F_CHAR_T,  F_CHAR_T,  int *,
                                 int *,     char *,    char *,
                                 int *,     char *,    int *,
                                 char *,    char *,    int * );
F_VOID_FCT     lfc_SLzher2k         ( F_CHAR_T,  F_CHAR_T,  int *,
                                 int *,     char *,    char *,
                                 int *,     char *,    int *,
                                 char *,    char *,    int * );

F_VOID_FCT     lfc_SLstrmm          ( F_CHAR_T,  F_CHAR_T,  F_CHAR_T,
                                 F_CHAR_T,  int *,     int *,
                                 char *,    char *,    int *,
                                 char *,    int * );
F_VOID_FCT     lfc_SLdtrmm          ( F_CHAR_T,  F_CHAR_T,  F_CHAR_T,
                                 F_CHAR_T,  int *,     int *,
                                 char *,    char *,    int *,
                                 char *,    int * );
F_VOID_FCT     lfc_SLctrmm          ( F_CHAR_T,  F_CHAR_T,  F_CHAR_T,
                                 F_CHAR_T,  int *,     int *,
                                 char *,    char *,    int *,
                                 char *,    int * );
F_VOID_FCT     lfc_SLztrmm          ( F_CHAR_T,  F_CHAR_T,  F_CHAR_T,
                                 F_CHAR_T,  int *,     int *,
                                 char *,    char *,    int *,
                                 char *,    int * );

F_VOID_FCT     lfc_SLstrsm          ( F_CHAR_T,  F_CHAR_T,  F_CHAR_T,
                                 F_CHAR_T,  int *,     int *,
                                 char *,    char *,    int *,
                                 char *,    int * );
F_VOID_FCT     lfc_SLdtrsm          ( F_CHAR_T,  F_CHAR_T,  F_CHAR_T,
                                 F_CHAR_T,  int *,     int *,
                                 char *,    char *,    int *,
                                 char *,    int * );
F_VOID_FCT     lfc_SLctrsm          ( F_CHAR_T,  F_CHAR_T,  F_CHAR_T,
                                 F_CHAR_T,  int *,     int *,
                                 char *,    char *,    int *,
                                 char *,    int * );
F_VOID_FCT     lfc_SLztrsm          ( F_CHAR_T,  F_CHAR_T,  F_CHAR_T,
                                 F_CHAR_T,  int *,     int *,
                                 char *,    char *,    int *,
                                 char *,    int * );

#else

int            lfc_SLisamax         ();
int            lfc_SLidamax         ();
int            lfc_SLicamax         ();
int            lfc_SLizamax         ();

F_VOID_FCT     lfc_SLsaxpy          ();
F_VOID_FCT     lfc_SLdaxpy          ();
F_VOID_FCT     lfc_SLcaxpy          ();
F_VOID_FCT     lfc_SLzaxpy          ();

F_VOID_FCT     lfc_SLscopy          ();
F_VOID_FCT     lfc_SLdcopy          ();
F_VOID_FCT     lfc_SLccopy          ();
F_VOID_FCT     lfc_SLzcopy          ();

F_VOID_FCT     lfc_SLsscal          ();
F_VOID_FCT     lfc_SLdscal          ();
F_VOID_FCT     lfc_SLcscal          ();
F_VOID_FCT     lfc_SLcsscal         ();
F_VOID_FCT     lfc_SLzscal          ();
F_VOID_FCT     lfc_SLzdscal         ();

F_VOID_FCT     lfc_SLsswap          ();
F_VOID_FCT     lfc_SLdswap          ();
F_VOID_FCT     lfc_SLcswap          ();
F_VOID_FCT     lfc_SLzswap          ();

F_VOID_FCT     lfc_SLsgemv          ();
F_VOID_FCT     lfc_SLdgemv          ();
F_VOID_FCT     lfc_SLcgemv          ();
F_VOID_FCT     lfc_SLzgemv          ();

F_VOID_FCT     lfc_SLssymv          ();
F_VOID_FCT     lfc_SLdsymv          ();
F_VOID_FCT     lfc_SLchemv          ();
F_VOID_FCT     lfc_SLzhemv          ();

F_VOID_FCT     lfc_SLstrmv          ();
F_VOID_FCT     lfc_SLdtrmv          ();
F_VOID_FCT     lfc_SLctrmv          ();
F_VOID_FCT     lfc_SLztrmv          ();

F_VOID_FCT     lfc_SLstrsv          ();
F_VOID_FCT     lfc_SLdtrsv          ();
F_VOID_FCT     lfc_SLctrsv          ();
F_VOID_FCT     lfc_SLztrsv          ();

F_VOID_FCT     lfc_SLsger           ();
F_VOID_FCT     lfc_SLdger           ();
F_VOID_FCT     lfc_SLcgerc          ();
F_VOID_FCT     lfc_SLcgeru          ();
F_VOID_FCT     lfc_SLzgerc          ();
F_VOID_FCT     lfc_SLzgeru          ();

F_VOID_FCT     lfc_SLssyr           ();
F_VOID_FCT     lfc_SLdsyr           ();
F_VOID_FCT     lfc_SLcher           ();
F_VOID_FCT     lfc_SLzher           ();

F_VOID_FCT     lfc_SLssyr2          ();
F_VOID_FCT     lfc_SLdsyr2          ();
F_VOID_FCT     lfc_SLcher2          ();
F_VOID_FCT     lfc_SLzher2          ();

F_VOID_FCT     lfc_SLsgemm          ();
F_VOID_FCT     lfc_SLdgemm          ();
F_VOID_FCT     lfc_SLcgemm          ();
F_VOID_FCT     lfc_SLzgemm          ();

F_VOID_FCT     lfc_SLssymm          ();
F_VOID_FCT     lfc_SLdsymm          ();
F_VOID_FCT     lfc_SLcsymm          ();
F_VOID_FCT     lfc_SLzsymm          ();
F_VOID_FCT     lfc_SLchemm          ();
F_VOID_FCT     lfc_SLzhemm          ();

F_VOID_FCT     lfc_SLssyrk          ();
F_VOID_FCT     lfc_SLdsyrk          ();
F_VOID_FCT     lfc_SLcsyrk          ();
F_VOID_FCT     lfc_SLzsyrk          ();
F_VOID_FCT     lfc_SLcherk          ();
F_VOID_FCT     lfc_SLzherk          ();

F_VOID_FCT     lfc_SLssyr2k         ();
F_VOID_FCT     lfc_SLdsyr2k         ();
F_VOID_FCT     lfc_SLcsyr2k         ();
F_VOID_FCT     lfc_SLzsyr2k         ();
F_VOID_FCT     lfc_SLcher2k         ();
F_VOID_FCT     lfc_SLzher2k         ();

F_VOID_FCT     lfc_SLstrmm          ();
F_VOID_FCT     lfc_SLdtrmm          ();
F_VOID_FCT     lfc_SLctrmm          ();
F_VOID_FCT     lfc_SLztrmm          ();

F_VOID_FCT     lfc_SLstrsm          ();
F_VOID_FCT     lfc_SLdtrsm          ();
F_VOID_FCT     lfc_SLctrsm          ();
F_VOID_FCT     lfc_SLztrsm          ();

#endif
