/* /home4/luszczek/mscratch/build/SCALAPACK/PBLAS/SRC/PBBLAS/pbsmatadd.f -- translated by f2c (version 20031025).
   You must link the resulting object file with libf2c:
	on Microsoft Windows system, link with libf2c.lib;
	on Linux or Unix systems, link with .../path/to/libf2c.a -lm
	or, if you install libf2c.a in a standard place, with -lf2c -lm
	-- in that order, at the end of the command line, as in
		cc *.o -lf2c -lm
	Source for libf2c is in /netlib/f2c/libf2c.zip, e.g.,

		http://www.netlib.org/f2c/libf2c.zip
*/

#include "f2c.h"

/* Table of constant values */

static integer c__1 = 1;

/* Subroutine */ int pbsmatadd_(integer *icontxt, char *mode, integer *m, 
	integer *n, real *alpha, real *a, integer *lda, real *beta, real *b, 
	integer *ldb, ftnlen mode_len)
{
    /* System generated locals */
    integer a_dim1, a_offset, b_dim1, b_offset, i__1, i__2;

    /* Local variables */
    integer i__, j;
    extern logical lsame_(char *, char *, ftnlen, ftnlen);
    extern /* Subroutine */ int lfc_SLsscal(integer *, real *, real *, integer *), 
	    lfc_SLscopy(integer *, real *, integer *, real *, integer *), lfc_SLsaxpy(
	    integer *, real *, real *, integer *, real *, integer *);


/*  -- PB-BLAS routine (version 2.1) -- */
/*     University of Tennessee, Knoxville, Oak Ridge National Laboratory. */
/*     April 28, 1996 */

/*     .. Scalar Arguments .. */
/*     .. */
/*     .. Array Arguments .. */
/*     .. */

/*  Purpose */
/*  ======= */

/*  PBSMATADD performs the matrix add operation B := alpha*A + beta*B, */
/*  where alpha and beta are scalars, and A and B are m-by-n */
/*  upper/lower trapezoidal matrices, or rectangular matrices. */

/*  Arguments */
/*  ========= */

/*  ICONTXT (input) INTEGER */
/*          ICONTXT is the BLACS mechanism for partitioning communication */
/*          space.  A defining property of a context is that a message in */
/*          a context cannot be sent or received in another context.  The */
/*          BLACS context includes the definition of a grid, and each */
/*          process' coordinates in it. */

/*  MODE    (input) CHARACTER*1 */
/*          Specifies the part of the matrix A, or (conjugate) transposed */
/*          matrix A to be added to the matrix B, */
/*          = 'U':  Upper triangular part */
/*                  up(B) = alpha*up(A) + beta*up(B) */
/*          = 'L':  Lower triangular part */
/*                  lo(B) = alpha*lo(A) + beta*lo(B) */
/*          = 'T':  Transposed matrix A */
/*                  B = alpha*A**T + beta*B */
/*          = 'C':  Conjugate transposed matrix A */
/*                  B = alpha*A**H + beta*B */
/*          Otherwise: B = alpha*A + beta*B */
/*              if M = LDA = LDB: use one BLAS loop */
/*              if MODE = 'V' :   columnwise copy using BLAS if possible */
/*              else :            use double loops */

/*  M       (input) INTEGER */
/*          M specifies the number of columns of the matrix A if */
/*          MODE != 'T'/'C', and it specifies the number of rows of the */
/*          matrix A otherwise.  It also specifies the number of rows of */
/*          the matrix B. M >= 0. */

/*  N       (input) INTEGER */
/*          N specifies the number of rows of the matrix A if */
/*          MODE != 'T'/'C', and it specifies the number of columns of */
/*          the matrix A otherwise. It also specifies the number of */
/*          columns of the matrix B. N >= 0. */

/*  ALPHA   (input) REAL */
/*          ALPHA specifies the scalar alpha. */

/*  A       (input) REAL array, dimension (LDA,N) */
/*          The m by n matrix A if MODE != 'T'/'C'. */
/*          If MODE = 'U', only the upper triangle or trapezoid is */
/*          accessed; if MODE = 'L', only the lower triangle or */
/*          trapezoid is accessed.  Otherwise all m-by-n data matrix */
/*          is accessed. */
/*          And the n by m matrix A if MODE = 'T'/'C'. */

/*  LDA     (input) INTEGER */
/*          The leading dimension of the array A.  LDA >= max(1,M) if */
/*          MODE != 'T'/'C'.  And LDA >= max(1,N) if MODE = 'T'/'C'. */

/*  BETA    (input) REAL */
/*          BETA specifies the scalar beta. */

/*  B       (input) REAL array, dimension (LDB,N) */
/*          On exit, B = alpha*A + beta*B */

/*  LDB     (input) INTEGER */
/*          The leading dimension of the array B.  LDB >= max(1,M). */

/*  ===================================================================== */

/*     .. Parameters .. */
/*     .. */
/*     .. Local Scalars .. */
/*     .. */
/*     .. External Functions .. */
/*     .. */
/*     .. External Subroutines .. */
/*     .. */
/*     .. Intrinsic Functions .. */
/*     .. */
/*     .. Executable Statements .. */

    /* Parameter adjustments */
    a_dim1 = *lda;
    a_offset = 1 + a_dim1;
    a -= a_offset;
    b_dim1 = *ldb;
    b_offset = 1 + b_dim1;
    b -= b_offset;

    /* Function Body */
    if (*m <= 0 || *n <= 0 || *alpha == 0.f && *beta == 1.f) {
	return 0;
    }

/*     A is upper triangular or upper trapezoidal, */

    if (lsame_(mode, "U", (ftnlen)1, (ftnlen)1)) {
	if (*alpha == 0.f) {
	    if (*beta == 0.f) {
		i__1 = *n;
		for (j = 1; j <= i__1; ++j) {
		    i__2 = min(j,*m);
		    for (i__ = 1; i__ <= i__2; ++i__) {
			b[i__ + j * b_dim1] = 0.f;
/* L10: */
		    }
/* L20: */
		}
	    } else {
		i__1 = *n;
		for (j = 1; j <= i__1; ++j) {
		    i__2 = min(j,*m);
		    for (i__ = 1; i__ <= i__2; ++i__) {
			b[i__ + j * b_dim1] = *beta * b[i__ + j * b_dim1];
/* L30: */
		    }
/* L40: */
		}
	    }

	} else if (*alpha == 1.f) {
	    if (*beta == 0.f) {
		i__1 = *n;
		for (j = 1; j <= i__1; ++j) {
		    i__2 = min(j,*m);
		    for (i__ = 1; i__ <= i__2; ++i__) {
			b[i__ + j * b_dim1] = a[i__ + j * a_dim1];
/* L50: */
		    }
/* L60: */
		}
	    } else if (*beta == 1.f) {
		i__1 = *n;
		for (j = 1; j <= i__1; ++j) {
		    i__2 = min(j,*m);
		    for (i__ = 1; i__ <= i__2; ++i__) {
			b[i__ + j * b_dim1] = a[i__ + j * a_dim1] + b[i__ + j 
				* b_dim1];
/* L70: */
		    }
/* L80: */
		}
	    } else {
		i__1 = *n;
		for (j = 1; j <= i__1; ++j) {
		    i__2 = min(j,*m);
		    for (i__ = 1; i__ <= i__2; ++i__) {
			b[i__ + j * b_dim1] = a[i__ + j * a_dim1] + *beta * b[
				i__ + j * b_dim1];
/* L90: */
		    }
/* L100: */
		}
	    }

	} else {
	    if (*beta == 0.f) {
		i__1 = *n;
		for (j = 1; j <= i__1; ++j) {
		    i__2 = min(j,*m);
		    for (i__ = 1; i__ <= i__2; ++i__) {
			b[i__ + j * b_dim1] = *alpha * a[i__ + j * a_dim1];
/* L110: */
		    }
/* L120: */
		}
	    } else if (*beta == 1.f) {
		i__1 = *n;
		for (j = 1; j <= i__1; ++j) {
		    i__2 = min(j,*m);
		    for (i__ = 1; i__ <= i__2; ++i__) {
			b[i__ + j * b_dim1] = *alpha * a[i__ + j * a_dim1] + 
				b[i__ + j * b_dim1];
/* L130: */
		    }
/* L140: */
		}
	    } else {
		i__1 = *n;
		for (j = 1; j <= i__1; ++j) {
		    i__2 = min(j,*m);
		    for (i__ = 1; i__ <= i__2; ++i__) {
			b[i__ + j * b_dim1] = *alpha * a[i__ + j * a_dim1] + *
				beta * b[i__ + j * b_dim1];
/* L150: */
		    }
/* L160: */
		}
	    }
	}

/*     A is lower triangular or upper trapezoidal, */

    } else if (lsame_(mode, "L", (ftnlen)1, (ftnlen)1)) {
	if (*alpha == 0.f) {
	    if (*beta == 0.f) {
		i__1 = *n;
		for (j = 1; j <= i__1; ++j) {
		    i__2 = *m;
		    for (i__ = j; i__ <= i__2; ++i__) {
			b[i__ + j * b_dim1] = 0.f;
/* L170: */
		    }
/* L180: */
		}
	    } else {
		i__1 = *n;
		for (j = 1; j <= i__1; ++j) {
		    i__2 = *m;
		    for (i__ = j; i__ <= i__2; ++i__) {
			b[i__ + j * b_dim1] = *beta * b[i__ + j * b_dim1];
/* L190: */
		    }
/* L200: */
		}
	    }

	} else if (*alpha == 1.f) {
	    if (*beta == 0.f) {
		i__1 = *n;
		for (j = 1; j <= i__1; ++j) {
		    i__2 = *m;
		    for (i__ = j; i__ <= i__2; ++i__) {
			b[i__ + j * b_dim1] = a[i__ + j * a_dim1];
/* L210: */
		    }
/* L220: */
		}
	    } else if (*beta == 1.f) {
		i__1 = *n;
		for (j = 1; j <= i__1; ++j) {
		    i__2 = *m;
		    for (i__ = j; i__ <= i__2; ++i__) {
			b[i__ + j * b_dim1] = a[i__ + j * a_dim1] + b[i__ + j 
				* b_dim1];
/* L230: */
		    }
/* L240: */
		}
	    } else {
		i__1 = *n;
		for (j = 1; j <= i__1; ++j) {
		    i__2 = *m;
		    for (i__ = j; i__ <= i__2; ++i__) {
			b[i__ + j * b_dim1] = a[i__ + j * a_dim1] + *beta * b[
				i__ + j * b_dim1];
/* L250: */
		    }
/* L260: */
		}
	    }

	} else {
	    if (*beta == 0.f) {
		i__1 = *n;
		for (j = 1; j <= i__1; ++j) {
		    i__2 = *m;
		    for (i__ = j; i__ <= i__2; ++i__) {
			b[i__ + j * b_dim1] = *alpha * a[i__ + j * a_dim1];
/* L270: */
		    }
/* L280: */
		}
	    } else if (*beta == 1.f) {
		i__1 = *n;
		for (j = 1; j <= i__1; ++j) {
		    i__2 = *m;
		    for (i__ = j; i__ <= i__2; ++i__) {
			b[i__ + j * b_dim1] = *alpha * a[i__ + j * a_dim1] + 
				b[i__ + j * b_dim1];
/* L290: */
		    }
/* L300: */
		}
	    } else {
		i__1 = *n;
		for (j = 1; j <= i__1; ++j) {
		    i__2 = *m;
		    for (i__ = j; i__ <= i__2; ++i__) {
			b[i__ + j * b_dim1] = *alpha * a[i__ + j * a_dim1] + *
				beta * b[i__ + j * b_dim1];
/* L310: */
		    }
/* L320: */
		}
	    }
	}

/*     If MODE = 'Transpose'/'Conjugate' */

    } else if (lsame_(mode, "T", (ftnlen)1, (ftnlen)1) || lsame_(mode, "C", (
	    ftnlen)1, (ftnlen)1)) {
	if (*alpha == 0.f) {
	    if (*beta == 0.f) {
		i__1 = *n;
		for (j = 1; j <= i__1; ++j) {
		    i__2 = *m;
		    for (i__ = 1; i__ <= i__2; ++i__) {
			b[i__ + j * b_dim1] = 0.f;
/* L330: */
		    }
/* L340: */
		}
	    } else {
		i__1 = *n;
		for (j = 1; j <= i__1; ++j) {
		    i__2 = *m;
		    for (i__ = 1; i__ <= i__2; ++i__) {
			b[i__ + j * b_dim1] = *beta * b[i__ + j * b_dim1];
/* L350: */
		    }
/* L360: */
		}
	    }

	} else if (*alpha == 1.f) {
	    if (*beta == 0.f) {
		i__1 = *n;
		for (j = 1; j <= i__1; ++j) {
		    i__2 = *m;
		    for (i__ = 1; i__ <= i__2; ++i__) {
			b[i__ + j * b_dim1] = a[j + i__ * a_dim1];
/* L370: */
		    }
/* L380: */
		}
	    } else if (*beta == 1.f) {
		i__1 = *n;
		for (j = 1; j <= i__1; ++j) {
		    i__2 = *m;
		    for (i__ = 1; i__ <= i__2; ++i__) {
			b[i__ + j * b_dim1] = a[j + i__ * a_dim1] + b[i__ + j 
				* b_dim1];
/* L390: */
		    }
/* L400: */
		}
	    } else {
		i__1 = *n;
		for (j = 1; j <= i__1; ++j) {
		    i__2 = *m;
		    for (i__ = 1; i__ <= i__2; ++i__) {
			b[i__ + j * b_dim1] = a[j + i__ * a_dim1] + *beta * b[
				i__ + j * b_dim1];
/* L410: */
		    }
/* L420: */
		}
	    }

	} else {
	    if (*beta == 0.f) {
		i__1 = *n;
		for (j = 1; j <= i__1; ++j) {
		    i__2 = *m;
		    for (i__ = 1; i__ <= i__2; ++i__) {
			b[i__ + j * b_dim1] = *alpha * a[j + i__ * a_dim1];
/* L430: */
		    }
/* L440: */
		}
	    } else if (*beta == 1.f) {
		i__1 = *n;
		for (j = 1; j <= i__1; ++j) {
		    i__2 = *m;
		    for (i__ = 1; i__ <= i__2; ++i__) {
			b[i__ + j * b_dim1] = *alpha * a[j + i__ * a_dim1] + 
				b[i__ + j * b_dim1];
/* L450: */
		    }
/* L460: */
		}
	    } else {
		i__1 = *n;
		for (j = 1; j <= i__1; ++j) {
		    i__2 = *m;
		    for (i__ = 1; i__ <= i__2; ++i__) {
			b[i__ + j * b_dim1] = *alpha * a[j + i__ * a_dim1] + *
				beta * b[i__ + j * b_dim1];
/* L470: */
		    }
/* L480: */
		}
	    }
	}

/*     Other cases (for genral matrix additions) */

    } else {
	if (*alpha == 0.f) {
	    if (*beta == 0.f) {
		i__1 = *n;
		for (j = 1; j <= i__1; ++j) {
		    i__2 = *m;
		    for (i__ = 1; i__ <= i__2; ++i__) {
			b[i__ + j * b_dim1] = 0.f;
/* L490: */
		    }
/* L500: */
		}

	    } else {
		if (*m == *ldb) {
		    i__1 = *m * *n;
		    lfc_SLsscal(&i__1, beta, &b[b_dim1 + 1], &c__1);
		} else if (lsame_(mode, "V", (ftnlen)1, (ftnlen)1)) {
		    i__1 = *n;
		    for (j = 1; j <= i__1; ++j) {
			lfc_SLsscal(m, beta, &b[j * b_dim1 + 1], &c__1);
/* L510: */
		    }
		} else {
		    i__1 = *n;
		    for (j = 1; j <= i__1; ++j) {
			i__2 = *m;
			for (i__ = 1; i__ <= i__2; ++i__) {
			    b[i__ + j * b_dim1] = *beta * b[i__ + j * b_dim1];
/* L520: */
			}
/* L530: */
		    }
		}
	    }

	} else if (*alpha == 1.f) {
	    if (*beta == 0.f) {
		if (*m == *lda && *m == *ldb) {
		    i__1 = *m * *n;
		    lfc_SLscopy(&i__1, &a[a_dim1 + 1], &c__1, &b[b_dim1 + 1], &
			    c__1);
		} else if (lsame_(mode, "V", (ftnlen)1, (ftnlen)1)) {
		    i__1 = *n;
		    for (j = 1; j <= i__1; ++j) {
			lfc_SLscopy(m, &a[j * a_dim1 + 1], &c__1, &b[j * b_dim1 + 
				1], &c__1);
/* L540: */
		    }
		} else {
		    i__1 = *n;
		    for (j = 1; j <= i__1; ++j) {
			i__2 = *m;
			for (i__ = 1; i__ <= i__2; ++i__) {
			    b[i__ + j * b_dim1] = a[i__ + j * a_dim1];
/* L550: */
			}
/* L560: */
		    }
		}

	    } else if (*beta == 1.f) {
		i__1 = *n;
		for (j = 1; j <= i__1; ++j) {
		    i__2 = *m;
		    for (i__ = 1; i__ <= i__2; ++i__) {
			b[i__ + j * b_dim1] = a[i__ + j * a_dim1] + b[i__ + j 
				* b_dim1];
/* L570: */
		    }
/* L580: */
		}

	    } else {
		i__1 = *n;
		for (j = 1; j <= i__1; ++j) {
		    i__2 = *m;
		    for (i__ = 1; i__ <= i__2; ++i__) {
			b[i__ + j * b_dim1] = a[i__ + j * a_dim1] + *beta * b[
				i__ + j * b_dim1];
/* L590: */
		    }
/* L600: */
		}
	    }

	} else {
	    if (*beta == 0.f) {
		i__1 = *n;
		for (j = 1; j <= i__1; ++j) {
		    i__2 = *m;
		    for (i__ = 1; i__ <= i__2; ++i__) {
			b[i__ + j * b_dim1] = *alpha * a[i__ + j * a_dim1];
/* L610: */
		    }
/* L620: */
		}

	    } else if (*beta == 1.f) {
		if (*m == *lda && *m == *ldb) {
		    i__1 = *m * *n;
		    lfc_SLsaxpy(&i__1, alpha, &a[a_dim1 + 1], &c__1, &b[b_dim1 + 1]
			    , &c__1);
		} else if (lsame_(mode, "V", (ftnlen)1, (ftnlen)1)) {
		    i__1 = *n;
		    for (j = 1; j <= i__1; ++j) {
			lfc_SLsaxpy(m, alpha, &a[j * a_dim1 + 1], &c__1, &b[j * 
				b_dim1 + 1], &c__1);
/* L630: */
		    }
		} else {
		    i__1 = *n;
		    for (j = 1; j <= i__1; ++j) {
			i__2 = *m;
			for (i__ = 1; i__ <= i__2; ++i__) {
			    b[i__ + j * b_dim1] = *alpha * a[i__ + j * a_dim1]
				     + b[i__ + j * b_dim1];
/* L640: */
			}
/* L650: */
		    }
		}

	    } else {
		i__1 = *n;
		for (j = 1; j <= i__1; ++j) {
		    i__2 = *m;
		    for (i__ = 1; i__ <= i__2; ++i__) {
			b[i__ + j * b_dim1] = *alpha * a[i__ + j * a_dim1] + *
				beta * b[i__ + j * b_dim1];
/* L660: */
		    }
/* L670: */
		}
	    }
	}
    }

    return 0;

/*     End of PBSMATADD */

} /* pbsmatadd_ */

