/* /home4/luszczek/mscratch/build/SCALAPACK/PBLAS/SRC/PBBLAS/pbdvecadd.f -- translated by f2c (version 20031025).
   You must link the resulting object file with libf2c:
	on Microsoft Windows system, link with libf2c.lib;
	on Linux or Unix systems, link with .../path/to/libf2c.a -lm
	or, if you install libf2c.a in a standard place, with -lf2c -lm
	-- in that order, at the end of the command line, as in
		cc *.o -lf2c -lm
	Source for libf2c is in /netlib/f2c/libf2c.zip, e.g.,

		http://www.netlib.org/f2c/libf2c.zip
*/

#include "f2c.h"

/* Subroutine */ int pbdvecadd_(integer *icontxt, char *mode, integer *n, 
	doublereal *alpha, doublereal *x, integer *incx, doublereal *beta, 
	doublereal *y, integer *incy, ftnlen mode_len)
{
    /* System generated locals */
    integer i__1;

    /* Local variables */
    integer i__, ix, iy;
    extern /* Subroutine */ int lfc_SLdscal(integer *, doublereal *, doublereal *, 
	    integer *);
    extern logical lsame_(char *, char *, ftnlen, ftnlen);
    extern /* Subroutine */ int lfc_SLdcopy(integer *, doublereal *, integer *, 
	    doublereal *, integer *), lfc_SLdaxpy(integer *, doublereal *, 
	    doublereal *, integer *, doublereal *, integer *);


/*  -- PB-BLAS routine (version 2.1) -- */
/*     University of Tennessee, Knoxville, Oak Ridge National Laboratory. */
/*     April 28, 1996 */

/*     .. Scalar Arguments .. */
/*     .. */
/*     .. Array Arguments .. */

/*     .. */

/*  Purpose */
/*  ======= */

/*  PBDVECADD performs a vector X to be added to Y */
/*    Y := alpha*op(X) + beta*Y, */
/*  where alpha and beta are scalars, and X and Y are n vectors, */
/*  and op(X) = X**H if MODE = 'C', */

/*  Arguments */
/*  ========= */

/*  ICONTXT (input) INTEGER */
/*          ICONTXT is the BLACS mechanism for partitioning communication */
/*          space.  A defining property of a context is that a message in */
/*          a context cannot be sent or received in another context.  The */
/*          BLACS context includes the definition of a grid, and each */
/*          process' coordinates in it. */

/*  MODE   (input) CHARACTER*1 */
/*          Specifies the transposed, or conjugate transposed vector X */
/*          to be added to the vector Y */
/*          = 'C': Conjugate vector X is added for complex data set. */
/*                 Y = alpha * X**H + beta * Y */
/*          ELSE : Vector X is added.  Y = alpha*X + beta*Y */
/*                 if MODE = 'V', BLAS routine may be used. */

/*  N       (input) INTEGER */
/*          The number of elements of the vectors X and Y to be added. */
/*          N >= 0. */

/*  ALPHA   (input) DOUBLE PRECISION */
/*          ALPHA specifies the scalar alpha. */

/*  X       (input) DOUBLE PRECISION array of DIMENSION at least */
/*          ( 1 + ( N - 1 )*abs( INCX ) ) */
/*          The incremented array X must contain the vector X. */

/*  INCX    (input) INTEGER */
/*          INCX specifies the increment for the elements of X. */
/*          INCX <> 0. */

/*  BETA    (input) DOUBLE PRECISION */
/*          BETA specifies the scalar beta. */

/*  Y       (input/output) DOUBLE PRECISION array of DIMENSION at least */
/*          ( 1 + ( N - 1 )*abs( INCY ) ) */
/*          On entry with BETA non-zero, the incremented array Y must */
/*          contain the vector Y. */
/*          On exit, Y is overwritten by the updated vector Y. */

/*  INCY  - (input) INTEGER */
/*          INCY specifies the increment for the elements of Y. */
/*          INCY <> 0. */

/*  ===================================================================== */

/*     .. */
/*     .. Parameters .. */
/*     .. */
/*     .. Local Scalars .. */
/*     .. */
/*     .. External Functions .. */
/*     .. */
/*     .. External Subroutines .. */
/*     .. */
/*     .. Executable Statements .. */

    /* Parameter adjustments */
    --y;
    --x;

    /* Function Body */
    if (*n <= 0 || *alpha == 0. && *beta == 1.) {
	return 0;
    }

    if (*alpha == 0.) {
	if (*beta == 0.) {
	    if (*incy == 1) {
		i__1 = *n;
		for (i__ = 1; i__ <= i__1; ++i__) {
		    y[i__] = 0.;
/* L10: */
		}
	    } else {
		iy = 1;
		i__1 = *n;
		for (i__ = 1; i__ <= i__1; ++i__) {
		    y[iy] = 0.;
		    iy += *incy;
/* L20: */
		}
	    }

	} else {
	    if (lsame_(mode, "V", (ftnlen)1, (ftnlen)1)) {
		lfc_SLdscal(n, beta, &y[1], incy);
	    } else if (*incy == 1) {
		i__1 = *n;
		for (i__ = 1; i__ <= i__1; ++i__) {
		    y[i__] = *beta * y[i__];
/* L30: */
		}
	    } else {
		iy = 1;
		i__1 = *n;
		for (i__ = 1; i__ <= i__1; ++i__) {
		    y[iy] = *beta * y[iy];
		    iy += *incy;
/* L40: */
		}
	    }
	}

    } else {
	if (*alpha == 1.) {
	    if (*beta == 0.) {
		if (lsame_(mode, "V", (ftnlen)1, (ftnlen)1)) {
		    lfc_SLdcopy(n, &x[1], incx, &y[1], incy);
		} else if (*incx == 1 && *incy == 1) {
		    i__1 = *n;
		    for (i__ = 1; i__ <= i__1; ++i__) {
			y[i__] = x[i__];
/* L50: */
		    }
		} else {
		    ix = 1;
		    iy = 1;
		    i__1 = *n;
		    for (i__ = 1; i__ <= i__1; ++i__) {
			y[iy] = x[ix];
			ix += *incx;
			iy += *incy;
/* L60: */
		    }
		}

	    } else if (*beta == 1.) {
		if (*incx == 1 && *incy == 1) {
		    i__1 = *n;
		    for (i__ = 1; i__ <= i__1; ++i__) {
			y[i__] = x[i__] + y[i__];
/* L70: */
		    }
		} else {
		    ix = 1;
		    iy = 1;
		    i__1 = *n;
		    for (i__ = 1; i__ <= i__1; ++i__) {
			y[iy] = x[ix] + y[iy];
			ix += *incx;
			iy += *incy;
/* L80: */
		    }
		}

	    } else {
		if (*incx == 1 && *incy == 1) {
		    i__1 = *n;
		    for (i__ = 1; i__ <= i__1; ++i__) {
			y[i__] = x[i__] + *beta * y[i__];
/* L90: */
		    }
		} else {
		    ix = 1;
		    iy = 1;
		    i__1 = *n;
		    for (i__ = 1; i__ <= i__1; ++i__) {
			y[iy] = x[ix] + *beta * y[iy];
			ix += *incx;
			iy += *incy;
/* L100: */
		    }
		}
	    }

	} else {
	    if (*beta == 0.) {
		if (*incx == 1 && *incy == 1) {
		    i__1 = *n;
		    for (i__ = 1; i__ <= i__1; ++i__) {
			y[i__] = *alpha * x[i__];
/* L110: */
		    }
		} else {
		    ix = 1;
		    iy = 1;
		    i__1 = *n;
		    for (i__ = 1; i__ <= i__1; ++i__) {
			y[iy] = x[ix];
			ix += *incx;
			iy += *incy;
/* L120: */
		    }
		}

	    } else if (*beta == 1.) {
		if (lsame_(mode, "V", (ftnlen)1, (ftnlen)1)) {
		    lfc_SLdaxpy(n, alpha, &x[1], incx, &y[1], incy);
		} else if (*incx == 1 && *incy == 1) {
		    i__1 = *n;
		    for (i__ = 1; i__ <= i__1; ++i__) {
			y[i__] = *alpha * x[i__] + y[i__];
/* L130: */
		    }
		} else {
		    ix = 1;
		    iy = 1;
		    i__1 = *n;
		    for (i__ = 1; i__ <= i__1; ++i__) {
			y[iy] = *alpha * x[ix] + y[iy];
			ix += *incx;
			iy += *incy;
/* L140: */
		    }
		}

	    } else {
		if (*incx == 1 && *incy == 1) {
		    i__1 = *n;
		    for (i__ = 1; i__ <= i__1; ++i__) {
			y[i__] = *alpha * x[i__] + *beta * y[i__];
/* L150: */
		    }
		} else {
		    ix = 1;
		    iy = 1;
		    i__1 = *n;
		    for (i__ = 1; i__ <= i__1; ++i__) {
			y[iy] = *alpha * x[ix] + *beta * y[iy];
			ix += *incx;
			iy += *incy;
/* L160: */
		    }
		}
	    }
	}
    }

    return 0;

/*     End of PBDVECADD */

} /* pbdvecadd_ */

