/* -*- C -*- */

#include <mpi.h>

extern void Cblacs_abort(int ConTxt, int ErrNo);
extern void Cblacs_barrier(int ConTxt, char *scope);
extern void Cblacs_exit(int NotDone);
extern void Cblacs_freebuff(int ConTxt, int Wait);
extern void Cblacs_get(int ConTxt, int what, int *val);
extern void Cblacs_gridexit(int ConTxt);
extern void Cblacs_gridinfo(int ConTxt, int *nprow, int *npcol, int *myrow, int *mycol);
extern int Cblacs_gridinit(int *ConTxt, char *order, int nprow, int npcol);
extern void Cblacs_gridmap(int *ConTxt, int *usermap, int ldup, int nprow0, int npcol0);
extern void Cblacs_pinfo(int *mypnum, int *nprocs);
extern int Cblacs_pnum(int ConTxt, int prow, int pcol);
extern void Cblacs_setup(int *mypnum, int *nprocs);
extern void Cblacs_set(int ConTxt, int what, int *val);

extern void Cdgamn2d(int ConTxt, char *scope, char *top, int m, int n, double *A,
  int lda, int *rA, int *cA, int ldia, int rdest, int cdest);
extern void Cigamn2d(int ConTxt, char *scope, char *top, int m, int n, int *A,
  int lda, int *rA, int *cA, int ldia, int rdest, int cdest);
extern void Csgamn2d(int ConTxt, char *scope, char *top, int m, int n, float *A,
  int lda, int *rA, int *cA, int ldia, int rdest, int cdest);

extern void Ccgamx2d(int ConTxt, char *scope, char *top, int m, int n, float *A,
  int lda, int *rA, int *cA, int ldia, int rdest, int cdest);
extern void Cdgamx2d(int ConTxt, char *scope, char *top, int m, int n, double *A,
  int lda, int *rA, int *cA, int ldia, int rdest, int cdest);
extern void Cigamx2d(int ConTxt, char *scope, char *top, int m, int n, int *A,
  int lda, int *rA, int *cA, int ldia, int rdest, int cdest);
extern void Csgamx2d(int ConTxt, char *scope, char *top, int m, int n, float *A,
  int lda, int *rA, int *cA, int ldia, int rdest, int cdest);
extern void Czgamx2d(int ConTxt, char *scope, char *top, int m, int n, double *A,
  int lda, int *rA, int *cA, int ldia, int rdest, int cdest);

extern void Ccgebs2d(int ConTxt, char *scope, char *top, int m, int n, float *A, int lda);
extern void Cdgebs2d(int ConTxt, char *scope, char *top, int m, int n, double *A, int lda);
extern void Cigebs2d(int ConTxt, char *scope, char *top, int m, int n, int *A, int lda);
extern void Csgebs2d(int ConTxt, char *scope, char *top, int m, int n, float *A, int lda);
extern void Czgebs2d(int ConTxt, char *scope, char *top, int m, int n, double *A, int lda);

extern void Ccgebr2d(int ConTxt, char *scope, char *top, int m, int n, float *A,
  int lda, int rsrc, int csrc);
extern void Cdgebr2d(int ConTxt, char *scope, char *top, int m, int n, double *A,
  int lda, int rsrc, int csrc);
extern void Cigebr2d(int ConTxt, char *scope, char *top, int m, int n, int *A,
  int lda, int rsrc, int csrc);
extern void Csgebr2d(int ConTxt, char *scope, char *top, int m, int n, float *A,
  int lda, int rsrc, int csrc);
extern void Czgebr2d(int ConTxt, char *scope, char *top, int m, int n, double *A,
  int lda, int rsrc, int csrc);

extern void Cctrbs2d(int ConTxt, char *scope, char *top, char *uplo, char *diag, int m, int n,
  float *A, int lda);
extern void Cdtrbs2d(int ConTxt, char *scope, char *top, char *uplo, char *diag, int m, int n,
  double *A, int lda);
extern void Cstrbs2d(int ConTxt, char *scope, char *top, char *uplo, char *diag, int m, int n,
  float *A, int lda);
extern void Cztrbs2d(int ConTxt, char *scope, char *top, char *uplo, char *diag, int m, int n,
  double *A, int lda);

extern void Cctrbr2d(int ConTxt, char *scope, char *top, char *uplo, char *diag, int m, int n,
  float *A, int lda, int rsrc, int csrc);
extern void Cdtrbr2d(int ConTxt, char *scope, char *top, char *uplo, char *diag, int m, int n,
  double *A, int lda, int rsrc, int csrc);
extern void Cstrbr2d(int ConTxt, char *scope, char *top, char *uplo, char *diag, int m, int n,
  float *A, int lda, int rsrc, int csrc);
extern void Cztrbr2d(int ConTxt, char *scope, char *top, char *uplo, char *diag, int m, int n,
  double *A, int lda, int rsrc, int csrc);

extern void Ccgerv2d(int ConTxt, int m, int n, float *A, int lda, int rsrc, int csrc);
extern void Cdgerv2d(int ConTxt, int m, int n, double *A, int lda, int rsrc, int csrc);
extern void Cigerv2d(int ConTxt, int m, int n, int *A, int lda, int rsrc, int csrc);
extern void Csgerv2d(int ConTxt, int m, int n, float *A, int lda, int rsrc, int csrc);
extern void Czgerv2d(int ConTxt, int m, int n, double *A, int lda, int rsrc, int csrc);
extern void Ccgesd2d(int ConTxt, int m, int n, float *A, int lda, int rdest, int cdest);
extern void Cdgesd2d(int ConTxt, int m, int n, double *A, int lda, int rdest, int cdest);
extern void Cigesd2d(int ConTxt, int m, int n, int *A, int lda, int rdest, int cdest);
extern void Csgesd2d(int ConTxt, int m, int n, float *A, int lda, int rdest, int cdest);
extern void Czgesd2d(int ConTxt, int m, int n, double *A, int lda, int rdest, int cdest);

extern void Cctrrv2d(int ConTxt, char *uplo, char *diag, int m, int n, float *A, int lda, int rsrc,
  int csrc);
extern void Cdtrrv2d(int ConTxt, char *uplo, char *diag, int m, int n, double *A, int lda, int rsrc,
  int csrc);
extern void Cstrrv2d(int ConTxt, char *uplo, char *diag, int m, int n, float *A, int lda, int rsrc,
  int csrc);
extern void Cztrrv2d(int ConTxt, char *uplo, char *diag, int m, int n, double *A, int lda, int rsrc,
  int csrc);

extern void Cctrsd2d(int ConTxt, char *uplo, char *diag, int m, int n, float *A, int lda, int rdest,
  int cdest);
extern void Cdtrsd2d(int ConTxt, char *uplo, char *diag, int m, int n, double *A, int lda, int rdest,
  int cdest);
extern void Cstrsd2d(int ConTxt, char *uplo, char *diag, int m, int n, float *A, int lda, int rdest,
  int cdest);
extern void Cztrsd2d(int ConTxt, char *uplo, char *diag, int m, int n, double *A, int lda, int rdest,
  int cdest);

extern void Ccgsum2d(int ConTxt, char *scope, char *top, int m, int n, float *A,
  int lda, int rdest, int cdest);
extern void Cdgsum2d(int ConTxt, char *scope, char *top, int m, int n, double *A,
  int lda, int rdest, int cdest);
extern void Cigsum2d(int ConTxt, char *scope, char *top, int m, int n, int *A,
  int lda, int rdest, int cdest);
extern void Csgsum2d(int ConTxt, char *scope, char *top, int m, int n, float *A,
  int lda, int rdest, int cdest);
extern void Czgsum2d(int ConTxt, char *scope, char *top, int m, int n, double *A,
  int lda, int rdest, int cdest);

void
dgamn2d_(int *ConTxt, char *scope, char *top, int *m, int *n, double *A, int *lda, int *rA,
  int *cA, int *ldia, int *rdest, int *cdest) {
  Cdgamn2d(*ConTxt, scope, top, *m, *n, A, *lda, rA, cA, *ldia, *rdest, *cdest);
}
void
igamn2d_(int *ConTxt, char *scope, char *top, int *m, int *n, int *A, int *lda, int *rA,
  int *cA, int *ldia, int *rdest, int *cdest) {
  Cigamn2d(*ConTxt, scope, top, *m, *n, A, *lda, rA, cA, *ldia, *rdest, *cdest);
}
void
sgamn2d_(int *ConTxt, char *scope, char *top, int *m, int *n, float *A, int *lda, int *rA,
  int *cA, int *ldia, int *rdest, int *cdest) {
  Csgamn2d(*ConTxt, scope, top, *m, *n, A, *lda, rA, cA, *ldia, *rdest, *cdest);
}

void
cgamx2d_(int *ConTxt, char *scope, char *top, int *m, int *n, float *A, int *lda, int *rA, int *cA,
  int *ldia, int *rdest, int *cdest) {
  Ccgamx2d(*ConTxt, scope, top, *m, *n, A, *lda, rA, cA, *ldia, *rdest, *cdest);
}
void
dgamx2d_(int *ConTxt, char *scope, char *top, int *m, int *n, double *A, int *lda, int *rA, int *cA,
  int *ldia, int *rdest, int *cdest) {
  Cdgamx2d(*ConTxt, scope, top, *m, *n, A, *lda, rA, cA, *ldia, *rdest, *cdest);
}
void
igamx2d_(int *ConTxt, char *scope, char *top, int *m, int *n, int *A, int *lda, int *rA, int *cA,
  int *ldia, int *rdest, int *cdest) {
  Cigamx2d(*ConTxt, scope, top, *m, *n, A, *lda, rA, cA, *ldia, *rdest, *cdest);
}
void
sgamx2d_(int *ConTxt, char *scope, char *top, int *m, int *n, float *A, int *lda, int *rA, int *cA,
  int *ldia, int *rdest, int *cdest) {
  Csgamx2d(*ConTxt, scope, top, *m, *n, A, *lda, rA, cA, *ldia, *rdest, *cdest);
}
void
zgamx2d_(int *ConTxt, char *scope, char *top, int *m, int *n, double *A, int *lda, int *rA, int *cA,
  int *ldia, int *rdest, int *cdest) {
  Czgamx2d(*ConTxt, scope, top, *m, *n, A, *lda, rA, cA, *ldia, *rdest, *cdest);
}

void
cgebs2d_(int *ConTxt, char *scope, char *top, int *m, int *n, float *A, int *lda) {
  Ccgebs2d(*ConTxt, scope, top, *m, *n, A, *lda);
}
void
dgebs2d_(int *ConTxt, char *scope, char *top, int *m, int *n, double *A, int *lda) {
  Cdgebs2d(*ConTxt, scope, top, *m, *n, A, *lda);
}
void
igebs2d_(int *ConTxt, char *scope, char *top, int *m, int *n, int *A, int *lda) {
  Cigebs2d(*ConTxt, scope, top, *m, *n, A, *lda);
}
void
sgebs2d_(int *ConTxt, char *scope, char *top, int *m, int *n, float *A, int *lda) {
  Csgebs2d(*ConTxt, scope, top, *m, *n, A, *lda);
}
void
zgebs2d_(int *ConTxt, char *scope, char *top, int *m, int *n, double *A, int *lda) {
  Czgebs2d(*ConTxt, scope, top, *m, *n, A, *lda);
}

void
cgebr2d_(int *ConTxt, char *scope, char *top, int *m, int *n, float *A, int *lda, int *rsrc,
  int *csrc) {
  Ccgebr2d(*ConTxt, scope, top, *m, *n, A, *lda, *rsrc, *csrc);
}
void
dgebr2d_(int *ConTxt, char *scope, char *top, int *m, int *n, double *A, int *lda, int *rsrc,
  int *csrc) {
  Cdgebr2d(*ConTxt, scope, top, *m, *n, A, *lda, *rsrc, *csrc);
}
void
igebr2d_(int *ConTxt, char *scope, char *top, int *m, int *n, int *A, int *lda, int *rsrc,
  int *csrc) {
  Cigebr2d(*ConTxt, scope, top, *m, *n, A, *lda, *rsrc, *csrc);
}
void
sgebr2d_(int *ConTxt, char *scope, char *top, int *m, int *n, float *A, int *lda, int *rsrc,
  int *csrc) {
  Csgebr2d(*ConTxt, scope, top, *m, *n, A, *lda, *rsrc, *csrc);
}
void
zgebr2d_(int *ConTxt, char *scope, char *top, int *m, int *n, double *A, int *lda, int *rsrc,
  int *csrc) {
  Czgebr2d(*ConTxt, scope, top, *m, *n, A, *lda, *rsrc, *csrc);
}

void ctrbs2d_(int *ConTxt, char *scope, char *top, char *uplo, char *diag, int *m, int *n, float *A,
  int *lda) {
  Cctrbs2d(*ConTxt, scope, top, uplo, diag, *m, *n, A, *lda);
}
void dtrbs2d_(int *ConTxt, char *scope, char *top, char *uplo, char *diag, int *m, int *n, double *A,
  int *lda) {
  Cdtrbs2d(*ConTxt, scope, top, uplo, diag, *m, *n, A, *lda);
}
void strbs2d_(int *ConTxt, char *scope, char *top, char *uplo, char *diag, int *m, int *n, float *A,
  int *lda) {
  Cstrbs2d(*ConTxt, scope, top, uplo, diag, *m, *n, A, *lda);
}
void ztrbs2d_(int *ConTxt, char *scope, char *top, char *uplo, char *diag, int *m, int *n, double *A,
  int *lda) {
  Cztrbs2d(*ConTxt, scope, top, uplo, diag, *m, *n, A, *lda);
}

void ctrbr2d_(int *ConTxt, char *scope, char *top, char *uplo, char *diag, int *m, int *n, float *A,
  int *lda, int *rsrc, int *csrc) {
  Cctrbr2d(*ConTxt, scope, top, uplo, diag, *m, *n, A, *lda, *rsrc, *csrc);
}
void dtrbr2d_(int *ConTxt, char *scope, char *top, char *uplo, char *diag, int *m, int *n, double *A,
  int *lda, int *rsrc, int *csrc) {
  Cdtrbr2d(*ConTxt, scope, top, uplo, diag, *m, *n, A, *lda, *rsrc, *csrc);
}
void strbr2d_(int *ConTxt, char *scope, char *top, char *uplo, char *diag, int *m, int *n, float *A,
  int *lda, int *rsrc, int *csrc) {
  Cstrbr2d(*ConTxt, scope, top, uplo, diag, *m, *n, A, *lda, *rsrc, *csrc);
}
void ztrbr2d_(int *ConTxt, char *scope, char *top, char *uplo, char *diag, int *m, int *n, double *A,
  int *lda, int *rsrc, int *csrc) {
  Cztrbr2d(*ConTxt, scope, top, uplo, diag, *m, *n, A, *lda, *rsrc, *csrc);
}

void cgerv2d_(int *ConTxt, int *m, int *n, float *A, int *lda, int *rsrc, int *csrc) {
  Ccgerv2d(*ConTxt, *m, *n, A, *lda, *rsrc, *csrc);
}
void dgerv2d_(int *ConTxt, int *m, int *n, double *A, int *lda, int *rsrc, int *csrc) {
  Cdgerv2d(*ConTxt, *m, *n, A, *lda, *rsrc, *csrc);
}
void igerv2d_(int *ConTxt, int *m, int *n, int *A, int *lda, int *rsrc, int *csrc) {
  Cigerv2d(*ConTxt, *m, *n, A, *lda, *rsrc, *csrc);
}
void sgerv2d_(int *ConTxt, int *m, int *n, float *A, int *lda, int *rsrc, int *csrc) {
  Csgerv2d(*ConTxt, *m, *n, A, *lda, *rsrc, *csrc);
}
void zgerv2d_(int *ConTxt, int *m, int *n, double *A, int *lda, int *rsrc, int *csrc) {
  Czgerv2d(*ConTxt, *m, *n, A, *lda, *rsrc, *csrc);
}

void cgesd2d_(int *ConTxt, int *m, int *n, float *A, int *lda, int *rdest, int *cdest) {
  Ccgesd2d(*ConTxt, *m, *n, A, *lda, *rdest, *cdest);
}
void dgesd2d_(int *ConTxt, int *m, int *n, double *A, int *lda, int *rdest, int *cdest) {
  Cdgesd2d(*ConTxt, *m, *n, A, *lda, *rdest, *cdest);
}
void igesd2d_(int *ConTxt, int *m, int *n, int *A, int *lda, int *rdest, int *cdest) {
  Cigesd2d(*ConTxt, *m, *n, A, *lda, *rdest, *cdest);
}
void sgesd2d_(int *ConTxt, int *m, int *n, float *A, int *lda, int *rdest, int *cdest) {
  Csgesd2d(*ConTxt, *m, *n, A, *lda, *rdest, *cdest);
}
void zgesd2d_(int *ConTxt, int *m, int *n, double *A, int *lda, int *rdest, int *cdest) {
  Czgesd2d(*ConTxt, *m, *n, A, *lda, *rdest, *cdest);
}

void ctrrv2d_(int *ConTxt, char *uplo, char *diag, int *m, int *n, float *A, int *lda, int *rsrc,
  int *csrc) {
  Cctrrv2d(*ConTxt, uplo, diag, *m, *n, A, *lda, *rsrc, *csrc);
}
void dtrrv2d_(int *ConTxt, char *uplo, char *diag, int *m, int *n, double *A, int *lda, int *rsrc,
  int *csrc) {
  Cdtrrv2d(*ConTxt, uplo, diag, *m, *n, A, *lda, *rsrc, *csrc);
}
void strrv2d_(int *ConTxt, char *uplo, char *diag, int *m, int *n, float *A, int *lda, int *rsrc,
  int *csrc) {
  Cstrrv2d(*ConTxt, uplo, diag, *m, *n, A, *lda, *rsrc, *csrc);
}
void ztrrv2d_(int *ConTxt, char *uplo, char *diag, int *m, int *n, double *A, int *lda, int *rsrc,
  int *csrc) {
  Cztrrv2d(*ConTxt, uplo, diag, *m, *n, A, *lda, *rsrc, *csrc);
}

void ctrsd2d_(int *ConTxt, char *uplo, char *diag, int *m, int *n, float *A, int *lda, int *rdest,
  int *cdest) {
  Cctrsd2d(*ConTxt, uplo, diag, *m, *n, A, *lda, *rdest, *cdest);
}
void dtrsd2d_(int *ConTxt, char *uplo, char *diag, int *m, int *n, double *A, int *lda, int *rdest,
  int *cdest) {
  Cdtrsd2d(*ConTxt, uplo, diag, *m, *n, A, *lda, *rdest, *cdest);
}
void strsd2d_(int *ConTxt, char *uplo, char *diag, int *m, int *n, float *A, int *lda, int *rdest,
  int *cdest) {
  Cstrsd2d(*ConTxt, uplo, diag, *m, *n, A, *lda, *rdest, *cdest);
}
void ztrsd2d_(int *ConTxt, char *uplo, char *diag, int *m, int *n, double *A, int *lda, int *rdest,
  int *cdest) {
  Cztrsd2d(*ConTxt, uplo, diag, *m, *n, A, *lda, *rdest, *cdest);
}

void cgsum2d_(int *ConTxt, char *scope, char *top, int *m, int *n, float *A, int *lda, int *rdest,
  int *cdest) {
  Ccgsum2d(*ConTxt, scope, top, *m, *n, A, *lda, *rdest, *cdest);
}
void dgsum2d_(int *ConTxt, char *scope, char *top, int *m, int *n, double *A, int *lda, int *rdest,
  int *cdest) {
  Cdgsum2d(*ConTxt, scope, top, *m, *n, A, *lda, *rdest, *cdest);
}
void igsum2d_(int *ConTxt, char *scope, char *top, int *m, int *n, int *A, int *lda, int *rdest,
  int *cdest) {
  Cigsum2d(*ConTxt, scope, top, *m, *n, A, *lda, *rdest, *cdest);
}
void sgsum2d_(int *ConTxt, char *scope, char *top, int *m, int *n, float *A, int *lda, int *rdest,
  int *cdest) {
  Csgsum2d(*ConTxt, scope, top, *m, *n, A, *lda, *rdest, *cdest);
}
void zgsum2d_(int *ConTxt, char *scope, char *top, int *m, int *n, double *A, int *lda, int *rdest,
  int *cdest) {
  Czgsum2d(*ConTxt, scope, top, *m, *n, A, *lda, *rdest, *cdest);
}

/* ------------------------------------------------------------ */

void
blacs_abort__(int *ConTxt, int *ErrNo) {
  Cblacs_abort(*ConTxt, *ErrNo);
}

void
blacs_barrier__(int *ConTxt, char *scope) {
  Cblacs_barrier(*ConTxt, scope);
} 

void
blacs_exit__(int *NotDone) {
  Cblacs_exit(*NotDone);
}

void
blacs_freebuff__(int *ConTxt, int *Wait) {
  Cblacs_freebuff(*ConTxt, *Wait);
}

void
blacs_get__(int *ConTxt, int *what, int *val) {
  Cblacs_get( *ConTxt, *what, val );
}

void
blacs_gridexit__(int *ConTxt) {
  Cblacs_gridexit(*ConTxt);
} 

void
blacs_gridinfo__(int *ConTxt, int *nprow, int *npcol, int *myrow, int *mycol) {
  Cblacs_gridinfo(*ConTxt, nprow, npcol, myrow, mycol);
}

void
blacs_gridinit__(int *ConTxt, char *order, int *nprow, int *npcol) {
  Cblacs_gridinit( ConTxt, order, *nprow, *npcol );
}

void 
blacs_gridmap__(int *ConTxt, int *usermap, int *ldup, int *nprow0, int *npcol0) {
  Cblacs_gridmap(ConTxt, usermap, *ldup, *nprow0, *npcol0);
}

void
blacs_pinfo__(int *mypnum, int *nprocs) {
  Cblacs_pinfo(mypnum, nprocs);
}


int blacs_pnum__(int *ConTxt, int *prow, int *pcol) {
  return Cblacs_pnum(*ConTxt, *prow, *pcol);
}

void
blacs_set__(int *ConTxt, int *what, int *val) {
  Cblacs_set(*ConTxt, *what, val);
}

void
blacs_setup__(int *mypnum, int *nprocs) {
  Cblacs_setup(mypnum, nprocs);
}

double
dcputime00_(void) {
  return -1.0;
}

double
dwalltime00_(void) {
   return MPI_Wtime();
}

void
bi_f77_get_constants__(int *f77commworld, int *setup, int *consts) {
  int i;
  *f77commworld = 0;
  if (*setup)
    for (i = 0; i < 23; i++) consts[i] = i + 1;
}
