/* f2c.h  --  Standard Fortran to C header file */

/**  barf  [ba:rf]  2.  "He suggested using FORTRAN, and everybody barfed."

	- From The Shogakukan DICTIONARY OF NEW ENGLISH (Second edition) */

#ifndef F2C_INCLUDE
#define F2C_INCLUDE

typedef int integer;
typedef unsigned int uinteger;
typedef char *address;
typedef short int shortint;
typedef float real;
typedef double doublereal;
typedef struct { real r, i; } complex;
typedef struct { doublereal r, i; } doublecomplex;
typedef int logical;
typedef short int shortlogical;
typedef char logical1;
typedef char integer1;
#ifdef INTEGER_STAR_8	/* Adjust for integer*8. */
typedef long longint;		/* system-dependent */
typedef unsigned long ulongint;	/* system-dependent */
#define qbit_clear(a,b)	((a) & ~((ulongint)1 << (b)))
#define qbit_set(a,b)	((a) |  ((ulongint)1 << (b)))
#endif

#define TRUE_ (1)
#define FALSE_ (0)

/* Extern is for use with -E */
#ifndef Extern
#define Extern extern
#endif

/* I/O stuff */

#ifdef f2c_i2
/* for -i2 */
typedef short flag;
typedef short ftnlen;
typedef short ftnint;
#else
typedef int flag;
typedef int ftnlen;
typedef int ftnint;
#endif

/*external read, write*/
typedef struct
{	flag cierr;
	ftnint ciunit;
	flag ciend;
	char *cifmt;
	ftnint cirec;
} cilist;

/*internal read, write*/
typedef struct
{	flag icierr;
	char *iciunit;
	flag iciend;
	char *icifmt;
	ftnint icirlen;
	ftnint icirnum;
} icilist;

/*open*/
typedef struct
{	flag oerr;
	ftnint ounit;
	char *ofnm;
	ftnlen ofnmlen;
	char *osta;
	char *oacc;
	char *ofm;
	ftnint orl;
	char *oblnk;
} olist;

/*close*/
typedef struct
{	flag cerr;
	ftnint cunit;
	char *csta;
} cllist;

/*rewind, backspace, endfile*/
typedef struct
{	flag aerr;
	ftnint aunit;
} alist;

/* inquire */
typedef struct
{	flag inerr;
	ftnint inunit;
	char *infile;
	ftnlen infilen;
	ftnint	*inex;	/*parameters in standard's order*/
	ftnint	*inopen;
	ftnint	*innum;
	ftnint	*innamed;
	char	*inname;
	ftnlen	innamlen;
	char	*inacc;
	ftnlen	inacclen;
	char	*inseq;
	ftnlen	inseqlen;
	char 	*indir;
	ftnlen	indirlen;
	char	*infmt;
	ftnlen	infmtlen;
	char	*inform;
	ftnint	informlen;
	char	*inunf;
	ftnlen	inunflen;
	ftnint	*inrecl;
	ftnint	*innrec;
	char	*inblank;
	ftnlen	inblanklen;
} inlist;

#define VOID void

union Multitype {	/* for multiple entry points */
	integer1 g;
	shortint h;
	integer i;
	/* longint j; */
	real r;
	doublereal d;
	complex c;
	doublecomplex z;
	};

typedef union Multitype Multitype;

/*typedef long int Long;*/	/* No longer used; formerly in Namelist */

struct Vardesc {	/* for Namelist */
	char *name;
	char *addr;
	ftnlen *dims;
	int  type;
	};
typedef struct Vardesc Vardesc;

struct Namelist {
	char *name;
	Vardesc **vars;
	int nvars;
	};
typedef struct Namelist Namelist;

#define abs(x) ((x) >= 0 ? (x) : -(x))
#define dabs(x) ((doublereal)abs(x))
#define min(a,b) ((a) <= (b) ? (a) : (b))
#define max(a,b) ((a) >= (b) ? (a) : (b))
#define dmin(a,b) ((doublereal)min(a,b))
#define dmax(a,b) ((doublereal)max(a,b))
#define bit_test(a,b)	((a) >> (b) & 1)
#define bit_clear(a,b)	((a) & ~((uinteger)1 << (b)))
#define bit_set(a,b)	((a) |  ((uinteger)1 << (b)))

/* procedure parameter types for -A and -C++ */

#define F2C_proc_par_types 1
#ifdef __cplusplus
typedef int /* Unknown procedure type */ (*U_fp)(...);
typedef shortint (*J_fp)(...);
typedef integer (*I_fp)(...);
typedef real (*R_fp)(...);
typedef doublereal (*D_fp)(...), (*E_fp)(...);
typedef /* Complex */ VOID (*C_fp)(...);
typedef /* Double Complex */ VOID (*Z_fp)(...);
typedef logical (*L_fp)(...);
typedef shortlogical (*K_fp)(...);
typedef /* Character */ VOID (*H_fp)(...);
typedef /* Subroutine */ int (*S_fp)(...);
#else
typedef int /* Unknown procedure type */ (*U_fp)();
typedef shortint (*J_fp)();
typedef integer (*I_fp)();
typedef real (*R_fp)();
typedef doublereal (*D_fp)(), (*E_fp)();
typedef /* Complex */ VOID (*C_fp)();
typedef /* Double Complex */ VOID (*Z_fp)();
typedef logical (*L_fp)();
typedef shortlogical (*K_fp)();
typedef /* Character */ VOID (*H_fp)();
typedef /* Subroutine */ int (*S_fp)();
#endif
/* E_fp is for real functions when -R is not specified */
typedef VOID C_f;	/* complex function */
typedef VOID H_f;	/* character function */
typedef VOID Z_f;	/* double complex function */
typedef doublereal E_f;	/* real function with -R not specified */

/* undef any lower-case symbols that your C compiler predefines, e.g.: */

#ifndef Skip_f2c_Undefs
#undef cray
#undef gcos
#undef mc68010
#undef mc68020
#undef mips
#undef pdp11
#undef sgi
#undef sparc
#undef sun
#undef sun2
#undef sun3
#undef sun4
#undef u370
#undef u3b
#undef u3b2
#undef u3b5
#undef unix
#undef vax
#endif
#endif

/*
#define main lfc_main
#define sig_die lfc_sig_die
#define f_exit lfc_f_exit
#define f_init lfc_f_init
#define f__cabs lfc_f__cabs
*/
#define s_rnge lfc_s_rnge
#define abort_ lfc_abort_
#define exit_ lfc_exit_
#define getarg_ lfc_getarg_
#define iargc_ lfc_iargc_
#define getenv_ lfc_getenv_
#define signal_ lfc_signal_
#define s_stop lfc_s_stop
#define s_paus lfc_s_paus
#define system_ lfc_system_
#define derf_ lfc_derf_
#define derfc_ lfc_derfc_
#define erf_ lfc_erf_
#define erfc_ lfc_erfc_
#define _uninit_f2c lfc__uninit_f2c
#define pow_ci lfc_pow_ci
#define pow_dd lfc_pow_dd
#define pow_di lfc_pow_di
#define pow_hh lfc_pow_hh
#define pow_ii lfc_pow_ii
#define pow_ri lfc_pow_ri
#define pow_zi lfc_pow_zi
#define pow_zz lfc_pow_zz
#define c_abs lfc_c_abs
#define c_cos lfc_c_cos
#define c_div lfc_c_div
#define c_exp lfc_c_exp
#define c_log lfc_c_log
#define c_sin lfc_c_sin
#define c_sqrt lfc_c_sqrt
#define z_abs lfc_z_abs
#define z_cos lfc_z_cos
#define z_div lfc_z_div
#define z_exp lfc_z_exp
#define z_log lfc_z_log
#define z_sin lfc_z_sin
#define z_sqrt lfc_z_sqrt
#define r_abs lfc_r_abs
#define r_acos lfc_r_acos
#define r_asin lfc_r_asin
#define r_atan lfc_r_atan
#define r_atn2 lfc_r_atn2
#define r_cnjg lfc_r_cnjg
#define r_cos lfc_r_cos
#define r_cosh lfc_r_cosh
#define r_dim lfc_r_dim
#define r_exp lfc_r_exp
#define r_imag lfc_r_imag
#define r_int lfc_r_int
#define r_lg10 lfc_r_lg10
#define r_log lfc_r_log
#define r_mod lfc_r_mod
#define r_nint lfc_r_nint
#define r_sign lfc_r_sign
#define r_sin lfc_r_sin
#define r_sinh lfc_r_sinh
#define r_sqrt lfc_r_sqrt
#define r_tan lfc_r_tan
#define r_tanh lfc_r_tanh
#define d_abs lfc_d_abs
#define d_acos lfc_d_acos
#define d_asin lfc_d_asin
#define d_atan lfc_d_atan
#define d_atn2 lfc_d_atn2
#define d_cnjg lfc_d_cnjg
#define d_cos lfc_d_cos
#define d_cosh lfc_d_cosh
#define d_dim lfc_d_dim
#define d_exp lfc_d_exp
#define d_imag lfc_d_imag
#define d_int lfc_d_int
#define d_lg10 lfc_d_lg10
#define d_log lfc_d_log
#define d_mod lfc_d_mod
#define d_nint lfc_d_nint
#define d_prod lfc_d_prod
#define d_sign lfc_d_sign
#define d_sin lfc_d_sin
#define d_sinh lfc_d_sinh
#define d_sqrt lfc_d_sqrt
#define d_tan lfc_d_tan
#define d_tanh lfc_d_tanh
#define i_abs lfc_i_abs
#define i_dim lfc_i_dim
#define i_dnnt lfc_i_dnnt
#define i_indx lfc_i_indx
#define i_len lfc_i_len
#define i_mod lfc_i_mod
#define i_nint lfc_i_nint
#define i_sign lfc_i_sign
#define lbit_bits lfc_lbit_bits
#define lbit_cshift lfc_lbit_cshift
#define lbit_shift lfc_lbit_shift
#define h_abs lfc_h_abs
#define h_dim lfc_h_dim
#define h_dnnt lfc_h_dnnt
#define h_indx lfc_h_indx
#define h_len lfc_h_len
#define h_mod lfc_h_mod
#define h_nint lfc_h_nint
#define h_sign lfc_h_sign
#define l_ge lfc_l_ge
#define l_gt lfc_l_gt
#define l_le lfc_l_le
#define l_lt lfc_l_lt
#define hl_ge lfc_hl_ge
#define hl_gt lfc_hl_gt
#define hl_le lfc_hl_le
#define hl_lt lfc_hl_lt
#define ef1asc_ lfc_ef1asc_
#define ef1cmc_ lfc_ef1cmc_
#define F77_aloc lfc_F77_aloc
#define s_cat lfc_s_cat
#define s_cmp lfc_s_cmp
#define s_copy lfc_s_copy
#define f_back lfc_f_back
#define f_clos lfc_f_clos
#define flush_ lfc_flush_
#define c_dfe lfc_c_dfe
#define e_rdfe lfc_e_rdfe
#define e_wdfe lfc_e_wdfe
#define s_rdfe lfc_s_rdfe
#define s_wdfe lfc_s_wdfe
#define y_getc lfc_y_getc
#define y_rsk lfc_y_rsk
#define do_lio lfc_do_lio
#define c_due lfc_c_due
#define e_rdue lfc_e_rdue
#define e_wdue lfc_e_wdue
#define s_rdue lfc_s_rdue
#define s_wdue lfc_s_wdue
#define f_end lfc_f_end
#define t_runc lfc_t_runc
#define err__fl lfc_err__fl
#define f__canseek lfc_f__canseek
#define f__fatal lfc_f__fatal
#define f__nowreading lfc_f__nowreading
#define f__nowwriting lfc_f__nowwriting
#define do_fio lfc_do_fio
#define en_fio lfc_en_fio
#define fmt_bg lfc_fmt_bg
#define pars_f lfc_pars_f
#define f__icvt lfc_f__icvt
#define fseek_ lfc_fseek_
#define ftell_ lfc_ftell_
#define c_si lfc_c_si
#define e_rsfi lfc_e_rsfi
#define e_wsfi lfc_e_wsfi
#define iw_rev lfc_iw_rev
#define s_rsfi lfc_s_rsfi
#define s_wsfi lfc_s_wsfi
#define z_getc lfc_z_getc
#define z_putc lfc_z_putc
#define z_rnew lfc_z_rnew
#define z_wnew lfc_z_wnew
#define e_wsli lfc_e_wsli
#define s_wsli lfc_s_wsli
#define s_wsni lfc_s_wsni
#define f_inqu lfc_f_inqu
#define c_le lfc_c_le
#define e_rsle lfc_e_rsle
#define l_read lfc_l_read
#define s_rsle lfc_s_rsle
#define t_getc lfc_t_getc
#define l_write lfc_l_write
#define f__putbuf lfc_f__putbuf
#define f_open lfc_f_open
#define fk_open lfc_fk_open
#define x_putc lfc_x_putc
#define rd_ed lfc_rd_ed
#define rd_ned lfc_rd_ned
#define f_rew lfc_f_rew
#define s_rsfe lfc_s_rsfe
#define x_endp lfc_x_endp
#define x_getc lfc_x_getc
#define x_rev lfc_x_rev
#define xrd_SL lfc_xrd_SL
#define e_rsli lfc_e_rsli
#define s_rsli lfc_s_rsli
#define s_rsni lfc_s_rsni
#define mk_hashtab lfc_mk_hashtab
#define s_rsne lfc_s_rsne
#define x_rsne lfc_x_rsne
#define c_sfe lfc_c_sfe
#define e_rsfe lfc_e_rsfe
#define e_wsfe lfc_e_wsfe
#define c_sue lfc_c_sue
#define e_rsue lfc_e_rsue
#define e_wsue lfc_e_wsue
#define s_rsue lfc_s_rsue
#define s_wsue lfc_s_wsue
#define do_ud lfc_do_ud
#define do_uio lfc_do_uio
#define do_us lfc_do_us
#define b_char lfc_b_char
#define f__inode lfc_f__inode
#define g_char lfc_g_char
#define wrt_E lfc_wrt_E
#define wrt_F lfc_wrt_F
#define w_ed lfc_w_ed
#define w_ned lfc_w_ned
#define wrt_L lfc_wrt_L
#define s_wsfe lfc_s_wsfe
#define x_wSL lfc_x_wSL
#define e_wsle lfc_e_wsle
#define s_wsle lfc_s_wsle
#define s_wsne lfc_s_wsne
#define x_wsne lfc_x_wsne
#define dtime_ lfc_dtime_
#define etime_ lfc_etime_

/*
extern void lfc_SLsrot(int *N_, char *X_, int *incX_, char *Y_, int *incY_, char *c_, char *s_);
extern void lfc_SLsger(int *M_, int *N_, char *alpha_, char *X_, int *incX_, char *Y_, int *incY_, char *A_, int *ldA_);
extern void lfc_SLssymv(char *uplo_, int *n_, char *alpha_, char *a_, int *lda_, char *x_, int *incx_, char *beta_, char *y_, int *incy_);
extern void lfc_SLssyr(char *uplo_, int *n_, char *alpha_, char *x_, int *incx_, char *a_, int *lda_);
extern void lfc_SLssyr2(char *uplo_, int *n_, char *alpha_, char *x_, int *incx_, char *y_, int *incy_, char *a_, int *lda_);
extern void lfc_SLssbmv(char *uplo_, int *n_, int *k_, char *alpha_, char *a_, int *lda_, char *x_, int *incx_, char *beta_, char *y_, int *incy_);
extern float lfc_SLsnrm2(int *N_, char *X_, int *incX_);
extern float lfc_SLsasum(int *N_, char *X_, int *incX_);
extern int lfc_SLisamax(int *N_, char *X_, int *incX_);
extern void lfc_SLsaxpy(int *N_, char *alpha_, char *X_, int *incX_, char *Y_, int *incY_);
extern void lfc_SLsswap(int *N_, char *X_, int *incX_, char *Y_, int *incY_);
extern void lfc_SLscopy(int *N_, char *X_, int *incX_, char *Y_, int *incY_);
extern void lfc_SLsscal(int *N_, char *alpha_, char *X_, int *incX_);
extern void lfc_SLsgbmv(char *ta_, int *m_, int *n_, int *kl_, int *ku_, char *alpha_, char *a_, int *lda_, char *x_, int *incx_, char *beta_, char *y_, int *incy_);
extern void lfc_SLsgemv(char *ta_, int *m_, int *n_, char *alpha_, char *a_, int *lda_, char *x_, int *incx_, char *beta_, char *y_, int *incy_);
extern void lfc_SLstrmv(char *uplo_, char *ta_, char *diag_, int *n_, char *a_, int *lda_, char *x_, int *incx_);
extern void lfc_SLstrsv(char *uplo_, char *ta_, char *diag_, int *n_, char *a_, int *lda_, char *x_, int *incx_);
extern void lfc_SLstbsv(char *uplo_, char *ta_, char *diag_, int *n_, int *k_, char *a_, int *lda_, char *x_, int *incx_);
extern void lfc_SLsgemm(char *ta_,  char *tb_,  int *m_, int *n_, int *k_, char *alpha_, char *a_, int *lda_, char *b_, int *ldb_, char *beta_, char *c_, int *ldc_);
extern void lfc_SLstrmm(char *side_,  char *uplo_, char *ta_, char *diag_, int *m_, int *n_, char *alpha_, char *a_, int *lda_, char *b_, int *ldb_);
extern void lfc_SLstrsm(char *side_,  char *uplo_, char *ta_, char *diag_, int *m_, int *n_, char *alpha_, char *a_, int *lda_, char *b_, int *ldb_);
extern void lfc_SLssyrk(char *uplo_, char *ta_, int *n_, int *k_, char *alpha_, char *a_, int *lda_, char *beta_, char *c_, int *ldc_);
extern void lfc_SLssymm(char *side_, char *uplo_, int *m_, int *n_, char *alpha_, char *a_, int *lda_, char *b_, int *ldb_, char *beta_, char *c_, int *ldc_);
extern void
lfc_SLssyr2k(char *uplo_, char *ta_, int *n_, int *k_, char *alpha_, char *a_, int *lda_, char *b_, int *ldb_, char *beta_, char *c_, int *ldc_);
*/
