/* -*- C -*- */

#ifndef LFC_UTIL_H
#define LFC_UTIL_H

#include <lfc/common.h>

#ifndef MAX
#define MAX(x,y) ((x)>(y)?(x):(y))
#endif
#ifndef MIN
#define MIN(x,y) ((x)<(y)?(x):(y))
#endif
#ifndef IABS
#define IABS(x) ((x)>0?(x):-(x))
#endif

LFC_BEGIN_C_DECLS

typedef struct LFC_datum {
  union {
    long double D;
    double d;
    float f;
    unsigned long L;
    long l;
    unsigned int I;
    int i;
    unsigned short S;
    short s;
    unsigned char C;
    char c;
    void *p;
  } data;
  char type;
} LFC_Datum;

typedef struct LFC_List_s {
  struct LFC_List_s *next, *prev;
  LFC_Datum data;
} LFC_List;

/* size of string buffers for 'int' and 'double' */
#define LFCIBUFL (sizeof(int)*3+1)
#define LFCDBUFL (sizeof(double)*4+1)

enum LFC_Datatype {LFC_DOUBLE, LFC_FLOAT, LFC_FCMPLX, LFC_DCMPLX, LFC_REAL,
	      LFC_DOUBLE_PRECISION, LFC_COMPLEX, LFC_COMPLEX_16, INTEGER,
	      INTEGER_8};
enum LFC_Solver {LFC_GESV, LFC_POSV, LFC_GELS};
#define ch2eDtype(x) ((x)=='z'?LFC_DCMPLX:((x)=='s'?LFC_FLOAT:LFC_DOUBLE))
#define ch2eSolver(x) ((x)=='G'?LFC_GESV:('C'==(x)?LFC_POSV:LFC_GELS))
#define ch2eTrans(x) (((x)=='C'||(x)=='c')?LFC_ConjTrans:(((x)=='T'||(x)=='t')?LFC_Trans:LFC_NoTrans))
#define ch2eUpLo(x) (((x)=='L'||(x)=='l')?LFC_Lower:LFC_Upper)
#define e2chDtype(e) (LFC_DCMPLX==(e)?'z':(LFC_FLOAT==(e)?'s':'d'))
#define e2chSolver(e) (LFC_GESV==(e)?'G':(LFC_POSV==(e)?'C':'Q'))
#define e2chTrans(e) (LFC_ConjTrans==(e)?'C':((LFC_Trans==(e))?'T':'N'))
#define e2chUpLo(e) (LFC_Lower==(e)?'L':'U')
#define e2szDtype(e) (LFC_DCMPLX==(e)?sizeof(double)*2:sizeof(double))

typedef struct {
  int n, nrhs;
  enum LFC_Datatype d;
  enum LFC_Solver s;
} LFC_;

/*
This is wrong (!!!):
struct Complex {double i, r;};

Read the following for the rationale:
http://www.netlib.org/blas/blast-forum/cinterface.ps
http://www.netlib.org/blas/blast-forum/cinterface.pdf
*/
typedef float LFC_sCmplx[2];
typedef float LFC_floatComplex[2];
typedef double LFC_doubleComplex[2];

extern int LFC_lst_new(LFC_List **l);
extern int LFC_lst_delete(LFC_List **l, void (*node_del)(LFC_List *l));
extern int LFC_lst_len(LFC_List *l);
extern int LFC_lst_append(LFC_List *l);

extern char *LFC_gopt(char *argv[], /*const*/ char *pfx, /*const*/ char *f, void *p);

extern void *LFC_calloc(size_t num, size_t size);
extern void *LFC_malloc(size_t num);
extern void *LFC_realloc(void *ptr, size_t size);

extern char *LFC_strdup(const char *s);
extern char *LFC_strmrg2(const char *s1, const char *s2);
extern char *LFC_strmrg3(const char *s1, const char *s2, const char *s3);

extern int LFC_dgesv_rsdl(int n, int nrhs, /*const*/ char *apath,
  /*const*/ char *xpath, /*const*/ char *bpath, LFC_Status *status);
extern int LFC_dgesv_file_all_x(int n, int nrhs, char *apath, int aopts,
  int *piv, char *bpath, int bopts, int gp, int gq, LFC_Status *ustatus);
extern int LFC_dgesv_rsdl_x(int n, int nrhs, char *apath,
  char *xpath, char *bpath, int gp, int gq, LFC_Status *status);

extern int LFC_linear_solve(enum LFC_Solver op, enum LFC_UpLo uplo, enum LFC_Transpose trans,
  enum LFC_Datatype dtype, int m, int n, int nrhs, void *a, int lda, int *piv, void *b, int ldb,
  int *info);

extern int LFC_argvAppend(char ***uargv, const char *fmt, void *data);
extern int LFC_argvDelete(char ***uargv);
extern int LFC_argvLen(char **argv, int *ulen);
extern int LFC_argvNew(char ***uargv, int initialLength);
extern int LFC_argvPop(char **argv);
extern int LFC_argvPrint(char **argv);
extern int LFC_mfile(int gp, int gq, char **machinefile);

extern int LFC_argv_mpi(char tmat, char *matf, char trhs, char *rhsf, char tsol, char *solf,
  char tluf, char *luff, char *machinefile, int m, int n, int nrhs, int nb,
  int gp, int gq, int opcode, char **addargv, char ***uargv);
extern int LFC_run_mpi(char **argv);
extern int LFC_memRule(int ndim, int nrhs, int size, int *ugp, int *ugq,
  char **umachinefile);
extern int LFC_schedule(int mdim, int ndim, int nrhs, int size, int *gp,
  int *gq, char **machinefile);

extern int LFC_Matrix_dwrite(const char *fname, int m, int n, double *da, int lda);
extern int LFC_Matrix_dread(const char *fname, int arow, int acol, double **a, int *m, int *n);
extern int LFC_Matrix_dwrite_urandom(int m, int n, const char *mat_fname,
  int seed, double valmin, double valmax);
extern int LFC_Matrix_swrite(const char *fname, int m, int n, float *da, int lda);
extern int LFC_Matrix_sread(const char *fname, int arow, int acol, float **a, int *m, int *n);
extern int LFC_Matrix_swrite_urandom(int m, int n, const char *mat_fname,
  int seed, float valmin, float valmax);

extern char * LFC_strchr(const char *s, int c);
extern char * LFC_strcpy(char *dest, const char *src);
extern size_t LFC_strlen(const char *s);
extern int    LFC_strcmp(const char *s1, const char *s2);
extern int    LFC_strncmp(const char *s1, const char *s2, size_t n);
extern char * LFC_strncpy(char *dest, const char *src, size_t n);
extern char * LFC_strstr(const char *haystack, const char *needle);
extern char * LFC_fieldStr(char *s, int fd, int *ufdlen);
extern int    LFC_fieldCount(const char *s, int *ucount);
extern char * LFC_StrSubst1(const char *fmt, void *arg1);

typedef struct {
  int fdRead, fdWrite, chid;
} LFC_PipeBuf;

extern int   LFC_pipeArgv(char **argv, LFC_PipeBuf *pbuf);
extern char *LFC_pipeReadLine(LFC_PipeBuf *pbuf);
extern int   LFC_pipeClose(LFC_PipeBuf *pbuf);
extern int   LFC_dpipe_matrix(int m, int n, double *a, int lda, int inout, int fd);
extern int   LFC_ipipe_matrix(int m, int n, int    *a, int lda, int inout, int fd);

extern int   LFC_confVarArgv(char *varName, char ***uargv);
extern char *LFC_confVarStr(char *varName);
extern char *LFC_get_libexec_dir();
extern char *LFC_getPDSLVpath();

typedef LFC_Host_array Host;
#define HNAMELEN LFCHNLEN
extern int LFC_getHostsNWS(Host **uhosts);
extern int LFC_getHosts(Host **uhosts);

extern int LFC_Version(); /* prints LFC version on stdout */

extern int LFC_report_node_names(const char *s);
extern int LFC_argvMpiBcast(char ***uargv, int root);

extern char *LFC_readline(FILE *f);

extern double LFC_dlamch(char *cmach);
extern float  LFC_slamch(char *cmach);

LFC_END_C_DECLS

#endif /* !LFC_UTIL_H */
