/* -*- C -*- */
/* usrconfg.c
 */

#include <lfc/lfci.h>

LFC_BEGIN_C_DECLS

/* this stores information where the executables will be installed */
#ifdef HAVE_STRINGIZE
#define xstr(x) str(x)
#define str(x) #x
#else
#ifdef QLIBEXECDIR
#define xstr(x) QLIBEXECDIR
#else
#define xstr(x) ""
#endif
#endif
char *
LFC_get_libexec_dir() {
  static char libexecdir[] = xstr(LIBEXECDIR);
  return libexecdir;
}

char *
LFC_getPDSLVpath() {
  static char *path = NULL;
  if (! path)
    path = LFC_StrSubst1( "%s/lfcpslvr", LFC_get_libexec_dir() );
  return path;
}

char *
LFC_confVarStr(char *varName) {
  char *null = NULL;
  char *valbuf, *confFname, *fld1, *chrEq, *evarbuf, *home, *fname;
  int fdlen, cnt, len;
  FILE *f;

  /*
  char buf[2048+1]; int nbuf;
  nbuf = (sizeof buf) / (sizeof *buf) - 1;
  */
  char *buf;

  /* try to get environment variable with LFC_ prefix */
  if (! varName) return null;
  evarbuf = LFC_StrSubst1( "LFC_%s", varName );

  /* not enough memory for variable name; bail out instead of trying to use
     config file */
  if (! evarbuf) return null;

  valbuf = getenv( evarbuf );
  LFC_FREE( evarbuf );

  if (valbuf) return LFC_strdup( valbuf );

  /* try to get variable from config file */
  confFname = "%s/.lfc/lfcrc"; /* FIXME: use configurable directory separator */

  home = getenv( "LFC_HOME" );
  if (! home) home = getenv( "HOME" );
  if (! home) return null;

  fname = LFC_StrSubst1( confFname, home );
  if (! fname) return null;

  f = fopen( fname, "r" );
  LFC_FREE( fname );

  if (! f) return null;

  /* while (fgets( buf, nbuf, f )) { */
  buf = null;
  while (1) {
    LFC_FREE( buf );
    buf = LFC_readline( f );
    if (! buf) break;

    fld1 = LFC_fieldStr( buf, 0, &fdlen );

    if ('#' == fld1[0]) continue; /* skip comments - starting with # */

    len = LFC_strlen( varName );
    if (LFC_strncmp( fld1, varName, len ) == 0) {

      fclose( f );

      chrEq = LFC_strchr( fld1, '=' );
      if (! chrEq) {
        LFC_FREE( buf );
        return null; /* if no '=' */
      }

      LFC_fieldCount( chrEq + 1, &cnt );

      if (! cnt) {
	LFC_FREE( buf );
	return null; /* if nothing after '=' */
      }

      valbuf = LFC_strdup( LFC_fieldStr( chrEq + 1, 0, &fdlen ) );
      LFC_FREE( buf );

      return valbuf;
    }
  }

  fclose( f );

  return null;
}	/* LFC_confVarStr */

int
LFC_confVarArgv(char *varName, char ***uargv) {
  char *varVal, *curField, *prvField;
  int i, rv, cnt, clen, flen;
  char buf[2048+1]; int nbuf;

  nbuf = (sizeof buf) / (sizeof *buf) - 1;

  varVal = LFC_confVarStr( varName );
  if (! varVal) return LFC_FAILURE;

  LFC_fieldCount( varVal, &cnt );
  if (! cnt) {
    LFC_FREE( varVal );
    return LFC_FAILURE;
  }

  rv = LFC_argvNew( uargv, cnt );
  if (rv) {
    LFC_FREE( varVal );
    return LFC_FAILURE;
  }

  prvField = varVal;
  for (i = 0; i < cnt; i++) {
    curField = LFC_fieldStr( prvField, (i ? 1 : 0), &flen );
    prvField = curField;

    clen = (flen <= nbuf ? flen : nbuf);
    LFC_strncpy( buf, curField, clen );
    buf[clen] = '\0';

    if (LFC_argvAppend( uargv, "%s", buf )) {
      LFC_FREE( varVal );
      LFC_argvDelete( uargv );
      return LFC_FAILURE;
    }
  }

  LFC_FREE( varVal );

  return LFC_SUCCESS;
}	/* LFC_confVarArgv */

LFC_END_C_DECLS
