/* -*- C -*- */
/* string.c
 */

#include <lfc/lfci.h>

LFC_BEGIN_C_DECLS

static char *snull = NULL;

char *
LFC_strchr(const char *s, int c) {return strchr( s, c );}

char *
LFC_strcpy(char *dest, const char *src) {return strcpy( dest, src );}

size_t
LFC_strlen(const char *s) {return strlen( s );}

int
LFC_strcmp(const char *s1, const char *s2) {return strcmp( s1, s2 );}

int
LFC_strncmp(const char *s1, const char *s2, size_t n) {return strncmp( s1, s2, n );}

char *
LFC_strncpy(char *dest, const char *src, size_t n) {return strncpy( dest, src, n );}

char *
LFC_strstr(const char *haystack, const char *needle) {return strstr( haystack, needle );}

/* clones string */
char *
LFC_strdup(const char *s) {
  char *x;
  if (! s) return snull;
  x = LFC_MALLOC( char, strlen( s ) + 1 );
  if (! x ) return x;
  return LFC_strcpy( x, s );
}	/* LFC_strdup */

/* merges 2 strings */
char *
LFC_strmrg2(const char *s1, const char *s2) {
  int n1, n2; char *s;

  if (! s1) return LFC_strdup( s2 );
  if (! s2) return LFC_strdup( s1 );
  n1 = LFC_strlen( s1 );
  n2 = LFC_strlen( s2 );
  s = LFC_MALLOC( char, n1 + n2 + 1 );
  if (! s) return s;
  LFC_strncpy( s,      s1, n1 );
  LFC_strncpy( s + n1, s2, n2 );
  s[n1 + n2] = '\0';
  return s;
}	/* LFC_strmrg2 */

/* merges 3 strings */
char *
LFC_strmrg3(const char *s1, const char *s2, const char *s3) {
  char *x1, *x2;
  /* FIXME: it can be done more clever */
  x1 = LFC_strmrg2( s1, s2 );
  x2 = LFC_strmrg2( x1, s3 );
  LFC_FREE( x1 );
  return x2;
}	/* LFC_strmrg3 */

/* finds a field (fields are seprated by one or more white spaces) in string
 * (first field is numbered 0). */
char *
LFC_fieldStr(char *s, int fd, int *ufdlen) {
  int cfd, wasspace, fdlen;
  char *null = NULL;
  char *s1;

  if (fd < 0) return null;

  if (0 == fd) {
    while (*s && isspace( *s )) s++;

    if (ufdlen) {
      for (s1 = s, fdlen = 0; *s1 && ! isspace( *s1 ); s1++, fdlen++) ;
      *ufdlen = fdlen;
    }

    if (! *s) return null;
    return s;
  }

  for (wasspace = 0, cfd = 0; *s; s++) {
    if (isspace( *s )) wasspace = 1;
    else {
      if (wasspace) {
        cfd++; wasspace = 0;

        if (fd == cfd) {
	  if (ufdlen) {
	    for (s1 = s, fdlen = 0; *s1 && ! isspace( *s1 ); s1++, fdlen++) ;
	    *ufdlen = fdlen;
	  }
	  return s;
	}
      }
    }
  }

  return null;
}	/* LFC_fieldStr */

int
LFC_fieldCount(const char *s, int *ucount) {
  int count, wasspace;

  if (! s) return LFC_FAILURE;

  for (wasspace = 1, count = 0; *s; s++) {
    if (isspace( *s )) wasspace = 1;
    else if (wasspace) {count++; wasspace = 0;}
  }

  if (ucount) *ucount = count;

  return LFC_SUCCESS;
}	/* LFC_fieldCount */

char *
LFC_StrSubst1(const char *fmt, void *arg1) {
  int i, tidx, pcnt, totalLength;
  char *cdata = (char *)arg1; int *idata = (int *)arg1;
  char *buf;

  /* FIXME: it doesn't check the correctness of 'fmt' */

  tidx = pcnt = 0;
  /* look for conversion specification: %d, %s, etc. */
  for (i = 0; fmt[i]; i++) {
    if ('%' == fmt[i]) pcnt++;
    else if (pcnt == 1) {
      pcnt = 0;
      tidx = i;
      break;
    }
    if (pcnt > 1) pcnt = 0;
  }

  while (fmt[i]) i++; /* get the length of the string */
  if (! tidx) tidx = i; /* no conversions */

  switch (fmt[tidx]) {
    case 'd':
      /* sizeof(integral_type) * 3 + 2 bytes is enough to store base 10
         representation */
      totalLength = sizeof(int) * 3 + 2;
      break;

    case 's':
      totalLength = strlen( cdata );
      break;

    case 'c':
      totalLength = 1;
      break;

    case '\0':
      totalLength = 0;
      break;

    default:
      return snull;
      break;
  }

  /* add the length of 'fmt' and '\0' (%[ds] and %%'s are not accounted for) */
  totalLength += i + 1;

  buf = LFC_MALLOC( char, totalLength );
  if (! buf) return snull;

  switch (fmt[tidx]) {
    case 'd':
      sprintf( buf, fmt, *idata );
      break;

    case 's':
      sprintf( buf, fmt, cdata );
      break;

    case 'c':
      sprintf( buf, fmt, *cdata );
      break;

    case '\0':
      sprintf( buf, fmt );
      break;

    /* no default: here -- it's done above and would require memory clean-up */
  }

  return buf;
}	/* LFC_StrSubst1 */

LFC_END_C_DECLS
