/* -*- C -*- */
/* sfileio.c
 */

#include <lfc/lfci.h>

LFC_BEGIN_C_DECLS

/*
  Metadata:
  LFCMATRIX
  VERSION 1.0
  STORAGE: native xdr
  Diagonal: unitary nonunitary
  uplo: upper lower both
  entry_size: 4 8 12
  type: long int short float double complex complex*16
  rows cols
 */

int
LFC_Matrix_swrite(const char *fname, int m, int n, float *da, int lda) {
  char line1[] = "LFCMATRIX"; /* this will be the magic number of the file */

  int i; FILE *f;

  /* FIXME: check arguments */

  if (! (f = fopen( fname, "wb" ))) return -1;

  fprintf( f, "%s\n", line1 );
  fprintf( f, "%d %d\n", m, n );

  for (i = 0; i < n; i++, da += lda) fwrite( da, sizeof *da, m, f );

  fclose( f );

  return 0;
}

int
LFC_Matrix_swrite_urandom(int m, int n, const char *mat_fname, int seed,
  float valmin, float valmax) {
  char line1[] = "LFCMATRIX"; /* this will be the magic number of the file */
  int i, j; FILE *f;
  float *x, scl = (valmax - valmin) / RAND_MAX;

  srand( seed );

  x = LFC_MALLOC( float, m );
  if (! x)
    return LFC_FAILURE;

  f = fopen( mat_fname, "wb" );
  if (! f) {
    LFC_FREE( x );
    return LFC_FAILURE;
  }

  fprintf( f, "%s\n", line1 );
  fprintf( f, "%d %d\n", m, n );

  for (j = 0; j < n; j++) {
    for (i = 0; i < m; i++) x[i] = scl * rand() + valmin;

    fwrite( x, sizeof *x, m, f );
  }

  fclose( f );

  LFC_FREE( x );

  return LFC_SUCCESS;
}	/* LFC_Matrix_dwrite_urandom */

int
LFC_Matrix_sread(const char *fname, int arow, int acol, float **a, int *m, int *n) {
  FILE *f; float *da; int chr;

  if (arow != 0) arow = 0;
  if (acol != 0) acol = 0;

  if (! (f = fopen( fname, "rb" ))) return LFC_FAILURE;

  /* skip the first line */
  for (chr = 1; chr != '\n' && chr != EOF; chr = fgetc( f )) ;

  if (2 != fscanf( f, "%d %d", m, n ) ) { fclose( f ); return LFC_FAILURE; }

  /* skip the rest of the second line */
  for (chr = 1; chr != '\n' && chr != EOF; chr = fgetc( f )) ;

  da = LFC_MALLOC( float, *m * *n );
  if (! da) { fclose( f ); return LFC_FAILURE; }

  fread( da, sizeof *da, *m * *n, f );

  fclose( f );

  *a = da;

  return LFC_SUCCESS;
}

LFC_END_C_DECLS
