/* -*- C -*- */
/* readline.c
 */

#include <lfc/lfci.h>

LFC_BEGIN_C_DECLS

typedef struct {
  void *stream;
  int (*ufunc)(void *iod, char *buf, int count);
  int fd;
} IOdata;

typedef struct {
  char *data;
  int len, size;
} string;

static int
string_new(string *s, int len) {
  char *cptr;

  if (! s) return LFC_FAILURE;

  cptr = LFC_MALLOC( char, len + 1 );
  if (! cptr) return LFC_FAILURE;

  s->data = cptr;
  s->len  = 0;
  s->size = len + 1;

  return LFC_SUCCESS;
}	/* string_new */

static int
string_delete(string *s) {
  if (! s) return LFC_FAILURE;

  LFC_FREE( s->data );
  s->len = s->size = 0;
  return LFC_SUCCESS;
}	/* string_delete */

static int
string_append(string *s, const char *src) {
  int n, l;

  /* no string */
  if (! s) return LFC_FAILURE;
  /* zero-size string */
  if (! src[0]) return LFC_SUCCESS;

  for (n = 0; src[n]; n++) ;

  if (s->len + n + 1 > s->size) {
    char *p;

    l = s->len;
    for (l = (l ? l : 1); l > 0 && n + s->len > l; l <<= 1) ;

    if (l <= 0) l = n + s->len;
    if ((l + 1) <= 0) return LFC_FAILURE;

    p = LFC_REALLOC( char, s->data, l + 1 );
    if (! p) return LFC_FAILURE;

    s->data = p;
    s->size = l + 1;
  }
  for (n = 0; src[n]; n++) s->data[s->len + n] = src[n];
  s->len += n;

  return LFC_SUCCESS;
}	/* string_append */

static int
string_chararr(string *s, char **uline) {
  if (! s || ! uline) return LFC_FAILURE;

  s->data[s->len] = '\0';
  *uline = s->data;
  s->data = NULL;
  s->len = s->size = 0;

  return LFC_SUCCESS;
}	/* string_chararr */

static char *
xfgets(FILE *f) {
  int nbuf; char buf[2048+1];
  char *p, *line; void *null = (char*)(NULL); string ls, *s; int l;

  nbuf = (sizeof buf) / (sizeof *buf);
  s = (string *)null;

  if (! f) return null;

  while (1) {
    p = fgets( buf, nbuf, f );

    if (! p) { /* EOF */
      if (! s) return null;
      break;
    }

    l = strlen( buf );
    if (! s) {
      s = &ls;

      /* couldn't create */
      if (string_new( s, l ) == LFC_FAILURE) return null;
    }

    /* couldn't append */
    if (string_append( s, buf ) == LFC_FAILURE) {
      string_delete( s );
      return null;
    }

    if (buf[l-1] == '\n') break; /* EOL */
  }

  if (string_chararr( s, &line ) == LFC_FAILURE) return null;

  if ('\0' == line[0]) { /* zero length */
    LFC_FREE( line );
    return null;
  }

  return line;
}	/* xfgets */

char *
LFC_readline(FILE *f) {
  return xfgets( f );
}

#if 0
void
tst2(char *fname) {
  int lno; char *ll; FILE *f;

  if (! fname) return;
  f = fopen( fname, "r" );
  if (! f) {
    fprintf( stderr, "File %s cannot be opened.\n", fname );
    return;
  }

  lno = 0;
  while (1) {
    lno += 1;
    ll = xfgets( f );
    if (! ll || ! ll[0]) break;
    printf( "%s", ll );
    LFC_FREE( ll );
  }

  fclose( f );
}

int
main(int argc, char *argv[]) {
  int i;

  if (argc < 2) {
    printf( "\n%s file1 file2 ... \n\n", argv[0] );
    return 1;
  }

  for (i = 1; i < argc && argv[i]; i++) tst2( argv[i] );

  return 0;
}
#endif

LFC_END_C_DECLS
