/* -*- C -*- */
/* nwsutil.c
 */

#include <lfc/lfci.h>

LFC_BEGIN_C_DECLS

static int
LFC_getNWSsearchCmd(char ***uargv) {
  int rv;

  rv = LFC_confVarArgv( "NWS_SEARCH", uargv );
  if (! rv) return LFC_SUCCESS;

  /*
  LFC_argvNew( uargv, 2 );

  if (LFC_argvAppend( uargv, "%s", "nws_search" )) goto failure1;
  if (LFC_argvAppend( uargv, "%s", "skills" ))     goto failure1;

  return LFC_SUCCESS;

  failure1:

  LFC_argvDelete( uargv );
  */

  return LFC_FAILURE;
}	/* LFC_getNWSsearchCmd */

static int
LFC_getNWSextractCmd(char ***uargv) {
  int rv;

  rv = LFC_confVarArgv( "NWS_EXTRACT", uargv );
  if (! rv) return LFC_SUCCESS;

  /*
  LFC_argvNew( uargv, 2 );

  if (LFC_argvAppend( uargv, "%s", "nws_extract" )) {
    LFC_argvDelete( uargv );
    return LFC_FAILURE;
  }

  return LFC_SUCCESS;
  */

  return LFC_FAILURE;
}	/* LFC_getNWSextractCmd */

static int
LFC_getLastLine2ndDouble(char **argv, double *uval) {
  int rv, len;
  char *line, *fld2, fmt[4] = "%lf";
  double val;

  LFC_PipeBuf pbuf;

  rv = LFC_pipeArgv( argv, &pbuf );

  while (1) {
    line = LFC_pipeReadLine( &pbuf );
    if (! line) break;

    fld2 = LFC_fieldStr( line, 1, &len );
    if (! fld2) continue;

    if (sscanf( fld2, fmt, &val ) != 1) continue;
  }

  LFC_pipeClose( &pbuf );

  if (val == -0.0) val = 0.0;

  if (uval) *uval = val;

  return LFC_SUCCESS;
}	/* LFC_getLastLine2ndDouble */

static int
LFC_getHostDataNWS(Host *hosts) {
  char **argv;
  int i, rv;
  double val, freeCPU, freeMem;

  if (! hosts) return LFC_FAILURE;

  rv = LFC_getNWSextractCmd( &argv );
  if (rv) return LFC_FAILURE;

  for (i = 0; ! hosts[i].last; i++) {
    hosts[i].freeCPU = 0.0;
    hosts[i].freeMem = 0.0;

    if (LFC_argvAppend( &argv, "%s", "availableCpu" )) continue;
    if (LFC_argvAppend( &argv, "%s", hosts[i].name )) {
      LFC_argvPop( argv );
      continue;
    }

    rv = LFC_getLastLine2ndDouble( argv, &val );
    LFC_argvPop( argv );
    LFC_argvPop( argv );

    if (rv) continue;

    freeCPU = val < 0.0 ? 0.0 : val;

    if (LFC_argvAppend( &argv, "%s", "freeMemory" )) continue;
    if (LFC_argvAppend( &argv, "%s", hosts[i].name )) {
      LFC_argvPop( argv );
      continue;
    }

    rv = LFC_getLastLine2ndDouble( argv, &val );
    LFC_argvPop( argv );
    LFC_argvPop( argv );

    if (rv) continue;

    freeMem = val < 0.0 ? 0.0 : val;

    if (0.0 >= freeCPU || 0.0 >= freeMem) {
      freeCPU = 0.0;
      freeMem = 0.0;
    }

    hosts[i].freeCPU = freeCPU;
    hosts[i].freeMem = freeMem;
  }

  return LFC_SUCCESS;
}	/* LFC_getHostDataNWS */

static int
LFC_getHostNamesNWS(Host **uhosts) {
  char **argv, *line, hname[HNAMELEN + 1], *colon1, *colon2;
  int i, len, rv;
  Host *hosts;
  LFC_PipeBuf pbuf;

  rv = LFC_getNWSsearchCmd( &argv );
  if (rv) return LFC_FAILURE;

  rv = LFC_pipeArgv( argv, &pbuf );

  LFC_argvDelete( &argv );

  if (rv) return LFC_FAILURE;

  rv = LFC_argvNew( &argv, 50 );
  if (rv) {
    LFC_pipeClose( &pbuf );
    return LFC_FAILURE;
  }

  while (1) {
    line = LFC_pipeReadLine( &pbuf );
    if (! line) break;

    /* if the line starts with `name' and contains `memory' - it's a memory
       sensor */
    if (LFC_strncmp( line, "name", 4 ) == 0 && LFC_strstr( line, "memory" )) {
      colon1 = LFC_strchr( line, ':' );
      if (! colon1) continue;
      colon2 = LFC_strchr( colon1 + 1, ':' );
      if (! colon2) continue;
      len = colon2 - colon1 - 1;
      if (len < 1) continue;

      if (len > HNAMELEN) continue; /* FIXME: what if name too long? handle more gracefully */

      LFC_strncpy( hname, colon1 + 1, len );
      hname[len] = '\0';

      /* FIXME: what a host occurs multiple times */

      if (LFC_argvAppend( &argv, "%s", hname )) {
	/* FIXME: let people know hosts got truncated */
	break;
      }
    }
  }
  LFC_pipeClose( &pbuf );

  LFC_argvLen( argv, &len );
  hosts = LFC_MALLOC( Host, len + 1 );
  if (! hosts) {
    LFC_argvDelete( &argv );
    return LFC_FAILURE;
  }

  for (i = 0; i < len; i++) {
    hosts[i].freeCPU = -1.0;
    hosts[i].freeMem = -1.0;
    LFC_strcpy( hosts[i].name, argv[i] );
    hosts[i].last = 0;
  }
  hosts[i].last = 1;
  hosts[i].freeCPU = hosts[i].freeMem = -1.0; /* sentinel */

  LFC_argvDelete( &argv );

  *uhosts = hosts;

  return LFC_SUCCESS;
}	/* LFC_getHostNamesNWS */

int
LFC_getHostsNWS(Host **uhosts) {
  Host *hosts;
  int rv;

  rv = LFC_getHostNamesNWS( &hosts );
  if (rv) return rv;

  rv = LFC_getHostDataNWS( hosts );
  if (rv) {
    LFC_FREE( hosts );
    return LFC_FAILURE;
  }

  if (uhosts) *uhosts = hosts;
  else LFC_FREE( hosts );

  return LFC_SUCCESS;
}	/* LFC_getHostsNWS */

LFC_END_C_DECLS
