/* -*- C -*- */

#ifndef LFC_LFC_H
#define LFC_LFC_H 1

#define LFC_SUCCESS  0
#define LFC_FAILURE  1

#ifdef __cplusplus
#  include <lfc/externc.h>
#else /* !__cplusplus */
#  define LFC_BEGIN_C_DECLS
#  define LFC_END_C_DECLS
#endif /* __cplusplus */

#define LFC_RDONLY    1
#define LFC_NOSEEK    2

LFC_BEGIN_C_DECLS

typedef struct {
  int info;
} LFC_Status;

enum LFC_Order {LFC_RowMajor=101, LFC_ColMajor=102};
enum LFC_Transpose {LFC_NoTrans=111, LFC_Trans=112, LFC_ConjTrans=113};
enum LFC_UpLo {LFC_Upper=121, LFC_Lower=122};
enum LFC_Diag {LFC_NonUnit=131, LFC_Unit=132};
enum LFC_Side {LFC_Left=141, LFC_Right=142};

/*
 The matrix elements are stored in a file. Storage layout structure
 describes where to look for the matrix elements. A file is a matrix
 of records.  Each record contains real and (optionally) imaginary
 part of a matrix element. */
typedef struct {
  /* offset from the begining of the file */
  long offset;

  /* size of each record */
  long record_size;

  /* offset (within each record) where real and imaginary parts of the
     matrix element are located */
  long real_offset, imag_offset;

  /* row and column (0-based numbering) number of the first record to
     be used (records whose row or column number are smaller are
     removed) */
  int row, col;

  long ld; /* leading dimension */

  /* */
  enum LFC_Order order;
  enum LFC_Transpose trans;
  enum LFC_UpLo uplo;
  enum LFC_Diag diag;

  int opts;
} LFC_Layout;

extern int LFC_sgels(enum LFC_Order order, enum LFC_Transpose trans, int m,
  int n, int nrhs, float *a, int lda, float *b, int ldb, float *Uwork,
  int *Ulwork, int *info);
extern int LFC_sgesv(enum LFC_Order order, int n, int nrhs, float *a, int lda,
  int *piv, float *b, int ldb, int *info);
extern int LFC_sposv(enum LFC_Order order, enum LFC_UpLo uplo, int n, int nrhs,
  float *a, int lda, float *b, int ldb, int *info);

extern int LFC_dgels(enum LFC_Order order, enum LFC_Transpose trans, int m,
  int n, int nrhs, double *a, int lda, double *b, int ldb, double *Uwork,
  int *Ulwork, int *Uinfo);
extern int LFC_dgesv(enum LFC_Order order, int n, int nrhs, double *a, int lda,
  int *ipiv, double *b, int ldb, int *info);
extern int LFC_dposv(enum LFC_Order order, enum LFC_UpLo uplo, int n, int nrhs,
  double *a, int lda, double *b, int ldb, int *info);

extern int LFC_sgels_file_all(enum LFC_Transpose trans, int m, int n, int nrhs,
  /*const*/ char *apath, LFC_Layout *alout, /*const*/ char *bpath,
  LFC_Layout *blout, LFC_Status *ustatus);
extern int LFC_sgesv_file_all(int n, int nrhs, /*const*/ char *apath,
  LFC_Layout *alout, int *piv, /*const*/ char *bpath,
  LFC_Layout *blout, LFC_Status *status);
extern int LFC_sposv_file_all(enum LFC_UpLo uplo, int n, int nrhs,
  /*const*/ char *apath, LFC_Layout *alout, /*const*/ char *bpath,
  LFC_Layout *blout, LFC_Status *status);

extern int LFC_dgels_file_all(enum LFC_Transpose trans, int m, int n, int nrhs,
  /*const*/ char *apath, LFC_Layout *alout, /*const*/ char *bpath,
  LFC_Layout *blout, LFC_Status *ustatus);
extern int LFC_dgesv_file_all(int n, int nrhs, /*const*/ char *apath,
  LFC_Layout *alout, int *piv, /*const*/ char *bpath,
  LFC_Layout *blout, LFC_Status *status);
extern int LFC_dposv_file_all(enum LFC_UpLo uplo, int n, int nrhs,
  /*const*/ char *apath, LFC_Layout *alout, /*const*/ char *bpath,
  LFC_Layout *blout, LFC_Status *status);

#define LFCHNLEN 80
typedef struct {
  double freeCPU;
  double freeMem;
  char name[LFCHNLEN + 1];
  char last;
} LFC_Host_array;

typedef struct {
  LFC_Host_array *host;
  int n;
} LFC_Hosts;

extern int LFC_Hosts_create(LFC_Hosts *hosts, int *count);
extern int LFC_Hosts_free(LFC_Hosts *hosts);
extern int LFC_Hosts_get_available_CPU(LFC_Hosts *hosts, int indx, double *acpu);
/* amount of free memory in mega bytes */
extern int LFC_Hosts_get_free_memory(LFC_Hosts *hosts, int indx, double *fmem);

LFC_END_C_DECLS

#endif /* !LFC_LFC_H */
