/* -*- C -*- */
/* common.h
 */

#ifndef LFC_COMMON_H
#define LFC_COMMON_H 1

#ifdef HAVE_CONFIG_H
#ifdef HAVE_LFCMPICF_H
#include "lfcmpicf.h"
#else
#include "lfconfig.h"
#endif
#endif

#ifdef __cplusplus
#include <lfc/externc.h>
#else
#define LFC_BEGIN_C_DECLS
#define LFC_END_C_DECLS
#endif

/* all systems seem to have this one */
#include <stdio.h>

#ifdef HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif

#ifdef HAVE_SYS_STAT_H
#include <sys/stat.h>
#endif

#ifdef HAVE_VFORK_H
#include <vfork.h>
#endif
#if !HAVE_WORKING_VFORK
#ifndef vfork
#define vfork fork
#endif
#endif

#ifdef STDC_HEADERS
#include <stdlib.h>
#include <stddef.h>
#include <ctype.h>
#include <math.h>
#else
#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif
#endif

#ifdef HAVE_STRING_H
#include <string.h>
#if !STDC_HEADERS && HAVE_MEMORY_H
#include <memory.h>
#endif
#endif

#ifndef NULL
#define NULL ((void*)0)
#endif

#ifdef HAVE_STRINGS_H
#include <strings.h>
#endif

#ifdef HAVE_INTTYPES_H
#include <inttypes.h>
#else
#ifdef HAVE_STDINT_H
#include <stdint.h>
#endif
#endif

#ifdef TIME_WITH_SYS_TIME
#include <sys/time.h>
#include <time.h>
#else
#ifdef HAVE_SYS_TIME_H
#include <sys/time.h>
#else
#include <time.h>
#endif
#endif

#ifdef HAVE_SYS_WAIT_H
#include <sys/wait.h>
#endif
#ifndef WEXITSTATUS
#define WEXITSTATUS(stat_val) ((unsigned)(stat_val) >> 8)
#endif
#ifndef WIFEXITED
#define WIFEXITED(stat_val) (((stat_val) & 255) == 0)
#endif

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#if !HAVE_STRCHR
#define strchr index
#endif

#if !HAVE_STRRCHR
#define strrchr rindex
#endif

#ifndef EXIT_SUCCESS
#define EXIT_SUCCESS  0
#define EXIT_FAILURE  1
#endif

#if !HAVE_BZERO && HAVE_MEMSET
#define bzero(buf, bytes)      ((void) memset (buf, 0, bytes))
#endif

#define LFC_CALLOC(type, num) ((type *) LFC_calloc ((num), sizeof(type)))
#define LFC_MALLOC(type, num) ((type *) LFC_malloc (sizeof(type) * (num)))
#define LFC_REALLOC(type, p, num) ((type *)LFC_realloc((p),sizeof(type)*(num)))
#define LFC_FREE(stale) do{if(stale){free(stale);stale = 0;}}while(0)

#endif
