/* -*- C -*- */
/* clstrinf.c
 */

#include <lfc/lfci.h>

LFC_BEGIN_C_DECLS

static int
LFC_getHostsConfig(Host **uhosts) {
  char *s, *curField, *prvField, *colon1, *colon2, fmt[4] = "%lf";
  int i, j, cnt, fdlen, len, chr, rv, validHosts;
  double val, freeCPU, freeMem;
  Host *hosts;

  s = LFC_confVarStr( "MACHINE_LIST" );
  if (! s) return LFC_FAILURE;

  LFC_fieldCount( s, &cnt );
  if (cnt < 1) {
    LFC_FREE( s );
    return LFC_FAILURE;
  }

  hosts = LFC_MALLOC( Host, cnt + 1 );
  if (! hosts) {
    LFC_FREE( s );
    return LFC_FAILURE;
  }

  validHosts = 0;
  prvField = s;
  for (i = 0; i < cnt; i++) {
    hosts[i].name[0] = '\0';
    hosts[i].freeCPU = 0.0;
    hosts[i].freeMem = 0.0;
    hosts[i].last = 0;

    curField = LFC_fieldStr( prvField, (i ? 1 : 0), &fdlen );
    prvField = curField;

    /* FIXME: report bogus entries */
    /* skip bogus entries */
    colon1 = LFC_strchr( curField, ':' );
    if (! colon1) continue;
    colon2 = LFC_strchr( colon1 + 1, ':' );
    if (! colon2) continue;
    if (colon1 - curField > fdlen || colon2 - curField > fdlen) continue;

    len = HNAMELEN;
    j = colon1 - curField;
    len = j > len ? len : j;

    colon1[0] = '\0';
    LFC_strncpy( hosts[i].name, curField, len );
    hosts[i].name[len] = '\0';
    colon1[0] = ':';

    colon2[0] = '\0';
    rv = sscanf( colon1 + 1, fmt, &val );
    colon2[0] = ':';
    freeCPU = val < 0.0 ? 0.0 : val;
    if (rv != 1) continue;

    chr = curField[fdlen];
    curField[fdlen] = '\0';
    rv = sscanf( colon2 + 1, fmt, &val );
    curField[fdlen] = chr;
    freeMem = val < 0.0 ? 0.0 : val;
    if (rv != 1) continue;

    validHosts++;
    hosts[i].freeCPU = freeCPU;
    hosts[i].freeMem = freeMem;
  }
  hosts[cnt].last = 1;

  LFC_FREE( s );

  if (validHosts < 1) {
    LFC_FREE( hosts );
    return LFC_FAILURE;
  }

  if (uhosts) *uhosts = hosts;
  else LFC_FREE( hosts );

  return LFC_SUCCESS;
}	/* LFC_getHostsConfig */

int
LFC_getHosts(Host **uhosts) {
  Host *hosts;
  int i, rv;

  if (! uhosts) return LFC_FAILURE;

  rv = LFC_getHostsNWS( &hosts );
  if (! rv) {
    *uhosts = hosts;

    /*
    for (i = 0; ! hosts[i].last; i++)
      printf( "%s %g %g\n", hosts[i].name, hosts[i].freeCPU, hosts[i].freeMem);
    */
    return LFC_SUCCESS;
  }

  rv = LFC_getHostsConfig( &hosts );
  if (! rv) {
    *uhosts = hosts;

    return LFC_SUCCESS;
  }

  return LFC_FAILURE;
}	/* LFC_getHosts */

int
LFC_Hosts_create(LFC_Hosts *hosts, int *count) {
  Host *lhsts; int rv, i;

  if (! hosts || ! count) return LFC_FAILURE;

  rv = LFC_getHosts( &lhsts );
  if (rv) return LFC_FAILURE;

  for (i = 0; ! lhsts[i].last; i++) ;

  hosts->host = lhsts;
  hosts->n = i;
  *count = i;

  return LFC_SUCCESS;
}	/* LFC_Hosts_create */

int
LFC_Hosts_free(LFC_Hosts *hosts) {
  if (! hosts) return LFC_FAILURE;
  LFC_FREE( hosts->host );
  hosts->n = 0;
  return LFC_SUCCESS;
}	/* LFC_Hosts_free */

int
LFC_Hosts_get_available_CPU(LFC_Hosts *hosts, int indx, double *acpu) {
  if (! hosts || hosts->n <= indx || ! acpu) return LFC_FAILURE;
  *acpu = hosts->host[indx].freeCPU;
  return LFC_SUCCESS;
}

int
LFC_Hosts_get_free_memory(LFC_Hosts *hosts, int indx, double *fmem) {
  if (! hosts || hosts->n <= indx || ! fmem) return LFC_FAILURE;
  *fmem = hosts->host[indx].freeMem;
  return LFC_SUCCESS;
}

LFC_END_C_DECLS
