/* -*- C -*- */

#ifndef LFC_CBLAS_H
#define LFC_CBLAS_H

#include <lfc/common.h>

LFC_BEGIN_C_DECLS

enum LFC_CBLAS_ORDER {LFC_CblasRowMajor=101, LFC_CblasColMajor=102};
enum LFC_CBLAS_TRANSPOSE {LFC_CblasNoTrans=111, LFC_CblasTrans=112,
			  LFC_CblasConjTrans=113, LFC_AtlasConj=114};
enum LFC_CBLAS_SIDE {LFC_CblasLeft=141, LFC_CblasRight=142};
enum LFC_CBLAS_UPLO {LFC_CblasUpper=121, LFC_CblasLower=122};
enum LFC_CBLAS_DIAG {LFC_CblasNonUnit=131, LFC_CblasUnit=132};

#ifdef HAVE_CBLAS
#define lfc_cblas_dasum cblas_dasum
#define lfc_cblas_dtrsv cblas_dtrsv
#define lfc_cblas_dgbmv cblas_dgbmv
#define lfc_cblas_dtbsv cblas_dtbsv
#define lfc_cblas_dsyr2k cblas_dsyr2k

#define lfc_cblas_dger  cblas_dger
#define lfc_cblas_drot  cblas_drot
#define lfc_cblas_dsymv cblas_dsymv
#define lfc_cblas_dsyr  cblas_dsyr
#define lfc_cblas_dsyr2 cblas_dsyr2
#define lfc_cblas_dsbmv cblas_dsbmv

#define lfc_cblas_daxpy cblas_daxpy
#define lfc_cblas_dcopy cblas_dcopy
#define lfc_cblas_ddot  cblas_ddot
#define lfc_cblas_dnrm2 cblas_dnrm2
#define lfc_cblas_dscal cblas_dscal
#define lfc_cblas_dswap cblas_dswap
#define lfc_cblas_idamax cblas_idamax
#define lfc_cblas_dgemv cblas_dgemv
#define lfc_cblas_dtrmv cblas_dtrmv
#define lfc_cblas_dgemm cblas_dgemm
#define lfc_cblas_dtrmm cblas_dtrmm
#define lfc_cblas_dtrsm cblas_dtrsm
#define lfc_cblas_dsyrk cblas_dsyrk
#define lfc_cblas_dsymm cblas_dsymm

#define lfc_cblas_sasum cblas_sasum
#define lfc_cblas_strsv cblas_strsv
#define lfc_cblas_sgbmv cblas_sgbmv
#define lfc_cblas_stbsv cblas_stbsv
#define lfc_cblas_ssyr2k cblas_ssyr2k

#define lfc_cblas_saxpy cblas_saxpy
#define lfc_cblas_scopy cblas_scopy
#define lfc_cblas_snrm2 cblas_snrm2
#define lfc_cblas_sscal cblas_sscal
#define lfc_cblas_sswap cblas_sswap
#define lfc_cblas_isamax cblas_isamax
#define lfc_cblas_sgemv cblas_sgemv
#define lfc_cblas_strmv cblas_strmv
#define lfc_cblas_sgemm cblas_sgemm
#define lfc_cblas_strmm cblas_strmm
#define lfc_cblas_strsm cblas_strsm
#define lfc_cblas_ssyrk cblas_ssyrk
#define lfc_cblas_ssymm cblas_ssymm


#define lfc_cblas_sger  cblas_sger
#define lfc_cblas_srot  cblas_srot
#define lfc_cblas_ssymv cblas_ssymv
#define lfc_cblas_ssyr  cblas_ssyr
#define lfc_cblas_ssyr2 cblas_ssyr2
#define lfc_cblas_ssbmv cblas_ssbmv

#define lfc_cblas_scasum cblas_scasum
#define lfc_cblas_ctrsv cblas_ctrsv
#define lfc_cblas_cgbmv cblas_cgbmv
#define lfc_cblas_ctbsv cblas_ctbsv
#define lfc_cblas_csyr2k cblas_csyr2k

#define lfc_cblas_caxpy cblas_caxpy
#define lfc_cblas_ccopy cblas_ccopy
#define lfc_cblas_scnrm2 cblas_scnrm2
#define lfc_cblas_cscal cblas_cscal
#define lfc_cblas_cswap cblas_cswap
#define lfc_cblas_icamax cblas_icamax
#define lfc_cblas_cgemv cblas_cgemv
#define lfc_cblas_ctrmv cblas_ctrmv
#define lfc_cblas_cgemm cblas_cgemm
#define lfc_cblas_ctrmm cblas_ctrmm
#define lfc_cblas_ctrsm cblas_ctrsm
#define lfc_cblas_csyrk cblas_csyrk
#define lfc_cblas_csymm cblas_csymm


#define lfc_cblas_csscal cblas_csscal
#define lfc_cblas_cgeru cblas_cgeru
#define lfc_cblas_cgerc cblas_cgerc
#define lfc_cblas_cher cblas_cher
#define lfc_cblas_cher2 cblas_cher2
#define lfc_cblas_cherk cblas_cherk
#define lfc_cblas_cher2k cblas_cher2k
#define lfc_cblas_chemv cblas_chemv
#define lfc_cblas_chemm cblas_chemm
#define lfc_cblas_chbmv cblas_chbmv

#define lfc_cblas_dzasum cblas_dzasum
#define lfc_cblas_ztrsv cblas_ztrsv
#define lfc_cblas_zgbmv cblas_zgbmv
#define lfc_cblas_ztbsv cblas_ztbsv
#define lfc_cblas_zsyr2k cblas_zsyr2k

#define lfc_cblas_zaxpy cblas_zaxpy
#define lfc_cblas_zcopy cblas_zcopy
#define lfc_cblas_dznrm2 cblas_dznrm2
#define lfc_cblas_zscal cblas_zscal
#define lfc_cblas_zswap cblas_zswap
#define lfc_cblas_izamax cblas_izamax
#define lfc_cblas_zgemv cblas_zgemv
#define lfc_cblas_ztrmv cblas_ztrmv
#define lfc_cblas_zgemm cblas_zgemm
#define lfc_cblas_ztrmm cblas_ztrmm
#define lfc_cblas_ztrsm cblas_ztrsm
#define lfc_cblas_zsyrk cblas_zsyrk
#define lfc_cblas_zsymm cblas_zsymm



#define lfc_cblas_zdscal cblas_zdscal
#define lfc_cblas_zgeru cblas_zgeru
#define lfc_cblas_zgerc cblas_zgerc
#define lfc_cblas_zher cblas_zher
#define lfc_cblas_zher2 cblas_zher2
#define lfc_cblas_zherk cblas_zherk
#define lfc_cblas_zher2k cblas_zher2k
#define lfc_cblas_zhemv cblas_zhemv
#define lfc_cblas_zhemm cblas_zhemm
#define lfc_cblas_zhbmv cblas_zhbmv

#endif

#ifdef USE_LFC_BLAS
#define lfc_cblas_dasum LFC_dasum
#define lfc_cblas_dgbmv LFC_dgbmv
#define lfc_cblas_dsbmv LFC_dsbmv
#define lfc_cblas_dsymv LFC_dsymv
#define lfc_cblas_drot LFC_drot
#define lfc_cblas_dsyr LFC_dsyr
#define lfc_cblas_dsyr2 LFC_dsyr2
#define lfc_cblas_dsyr2k LFC_dsyr2k
#define lfc_cblas_dtbsv LFC_dtbsv
#define lfc_cblas_dtrsv LFC_dtrsv

#define lfc_cblas_daxpy LFC_daxpy
#define lfc_cblas_dcopy LFC_dcopy
#define lfc_cblas_ddot  LFC_ddot
#define lfc_cblas_dger  LFC_dger
#define lfc_cblas_dnrm2 LFC_dnrm2
#define lfc_cblas_dscal LFC_dscal
#define lfc_cblas_dswap LFC_dswap
#define lfc_cblas_idamax LFC_idamax
#define lfc_cblas_dgemv LFC_dgemv
#define lfc_cblas_dtrmv LFC_dtrmv
#define lfc_cblas_dgemm LFC_dgemm
#define lfc_cblas_dtrmm LFC_dtrmm
#define lfc_cblas_dtrsm LFC_dtrsm
#define lfc_cblas_dsyrk LFC_dsyrk
#define lfc_cblas_dsymm LFC_dsymm

#define lfc_cblas_sasum LFC_sasum
#define lfc_cblas_sgbmv LFC_sgbmv
#define lfc_cblas_ssbmv LFC_ssbmv
#define lfc_cblas_ssymv LFC_ssymv
#define lfc_cblas_srot LFC_srot
#define lfc_cblas_ssyr LFC_ssyr
#define lfc_cblas_ssyr2 LFC_ssyr2
#define lfc_cblas_ssyr2k LFC_ssyr2k
#define lfc_cblas_stbsv LFC_stbsv
#define lfc_cblas_strsv LFC_strsv

#define lfc_cblas_saxpy LFC_saxpy
#define lfc_cblas_scopy LFC_scopy
#define lfc_cblas_sdot  LFC_sdot
#define lfc_cblas_sger  LFC_sger
#define lfc_cblas_snrm2 LFC_snrm2
#define lfc_cblas_sscal LFC_sscal
#define lfc_cblas_sswap LFC_sswap
#define lfc_cblas_isamax LFC_isamax
#define lfc_cblas_sgemv LFC_sgemv
#define lfc_cblas_strmv LFC_strmv
#define lfc_cblas_sgemm LFC_sgemm
#define lfc_cblas_strmm LFC_strmm
#define lfc_cblas_strsm LFC_strsm
#define lfc_cblas_ssyrk LFC_ssyrk
#define lfc_cblas_ssymm LFC_ssymm

#define lfc_cblas_caxpy LFC_caxpy
#define lfc_cblas_ccopy LFC_ccopy
#define lfc_cblas_cgbmv LFC_cgbmv
#define lfc_cblas_cgemm LFC_cgemm
#define lfc_cblas_cgemv LFC_cgemv
#define lfc_cblas_cgerc LFC_cgerc
#define lfc_cblas_cgeru LFC_cgeru
#define lfc_cblas_chbmv LFC_chbmv
#define lfc_cblas_chemm LFC_chemm
#define lfc_cblas_chemv LFC_chemv
#define lfc_cblas_cher LFC_cher
#define lfc_cblas_cher2 LFC_cher2
#define lfc_cblas_cher2k LFC_cher2k
#define lfc_cblas_cherk LFC_cherk
#define lfc_cblas_cscal LFC_cscal
#define lfc_cblas_cswap LFC_cswap
#define lfc_cblas_csymm LFC_csymm
#define lfc_cblas_csyr2k LFC_csyr2k
#define lfc_cblas_csyrk LFC_csyrk
#define lfc_cblas_ctbsv LFC_ctbsv
#define lfc_cblas_ctrmm LFC_ctrmm
#define lfc_cblas_ctrmv LFC_ctrmv
#define lfc_cblas_ctrsm LFC_ctrsm
#define lfc_cblas_ctrsv LFC_ctrsv
#define lfc_cblas_icamax LFC_icamax
#define lfc_cblas_csscal LFC_csscal
#define lfc_cblas_scasum LFC_scasum
#define lfc_cblas_scnrm2 LFC_scnrm2

#define lfc_cblas_zaxpy LFC_zaxpy
#define lfc_cblas_zcopy LFC_zcopy
#define lfc_cblas_zgbmv LFC_zgbmv
#define lfc_cblas_zgemm LFC_zgemm
#define lfc_cblas_zgemv LFC_zgemv
#define lfc_cblas_zgerc LFC_zgerc
#define lfc_cblas_zgeru LFC_zgeru
#define lfc_cblas_zhbmv LFC_zhbmv
#define lfc_cblas_zhemm LFC_zhemm
#define lfc_cblas_zhemv LFC_zhemv
#define lfc_cblas_zher LFC_zher
#define lfc_cblas_zher2 LFC_zher2
#define lfc_cblas_zher2k LFC_zher2k
#define lfc_cblas_zherk LFC_zherk
#define lfc_cblas_zscal LFC_zscal
#define lfc_cblas_zswap LFC_zswap
#define lfc_cblas_zsymm LFC_zsymm
#define lfc_cblas_zsyr2k LFC_zsyr2k
#define lfc_cblas_zsyrk LFC_zsyrk
#define lfc_cblas_ztbsv LFC_ztbsv
#define lfc_cblas_ztrmm LFC_ztrmm
#define lfc_cblas_ztrmv LFC_ztrmv
#define lfc_cblas_ztrsm LFC_ztrsm
#define lfc_cblas_ztrsv LFC_ztrsv
#define lfc_cblas_izamax LFC_izamax
#define lfc_cblas_zdscal LFC_zdscal
#define lfc_cblas_dzasum LFC_dzasum
#define lfc_cblas_dznrm2 LFC_dznrm2

#define LFC_CBLAS_ORDER LFC_Order
#define LFC_CblasRowMajor LFC_RowMajor
#define LFC_CblasColMajor LFC_ColMajor
#define LFC_CBLAS_TRANSPOSE LFC_Transpose
#define LFC_CblasNoTrans LFC_NoTrans
#define LFC_CblasTrans LFC_Trans
#define LFC_CblasConjTrans LFC_ConjTrans
#define LFC_CBLAS_SIDE LFC_Side
#define LFC_CblasLeft LFC_Left
#define LFC_CblasRight LFC_Right
#define LFC_CBLAS_UPLO LFC_UpLo
#define LFC_CblasUpper LFC_Upper
#define LFC_CblasLower LFC_Lower
#define LFC_CBLAS_DIAG LFC_Diag
#define LFC_CblasNonUnit LFC_NonUnit
#define LFC_CblasUnit LFC_Unit

#endif

extern double lfc_cblas_dasum(/*const*/ int N, /*const*/ double *X, /*const*/ int incX);
extern void lfc_cblas_dtrsv(/*const*/ enum LFC_CBLAS_ORDER Order, /*const*/ enum LFC_CBLAS_UPLO Uplo,
                 /*const*/ enum LFC_CBLAS_TRANSPOSE TransA, /*const*/ enum LFC_CBLAS_DIAG Diag,
                 /*const*/ int N, /*const*/ double *A, /*const*/ int lda, double *X,
                 /*const*/ int incX);
extern void lfc_cblas_dgbmv(/*const*/ enum LFC_CBLAS_ORDER Order,
                 /*const*/ enum LFC_CBLAS_TRANSPOSE TransA, /*const*/ int M, /*const*/ int N,
                 /*const*/ int KL, /*const*/ int KU, /*const*/ double alpha,
                 /*const*/ double *A, /*const*/ int lda, /*const*/ double *X,
                 /*const*/ int incX, /*const*/ double beta, double *Y, /*const*/ int incY);
extern void lfc_cblas_dtbsv(/*const*/ enum LFC_CBLAS_ORDER Order, /*const*/ enum LFC_CBLAS_UPLO Uplo,
                 /*const*/ enum LFC_CBLAS_TRANSPOSE TransA, /*const*/ enum LFC_CBLAS_DIAG Diag,
                 /*const*/ int N, /*const*/ int K, /*const*/ double *A, /*const*/ int lda,
                 double *X, /*const*/ int incX);
extern void lfc_cblas_dsyr2k(/*const*/ enum LFC_CBLAS_ORDER Order, /*const*/ enum LFC_CBLAS_UPLO Uplo,
                  /*const*/ enum LFC_CBLAS_TRANSPOSE Trans, /*const*/ int N, /*const*/ int K,
                  /*const*/ double alpha, /*const*/ double *A, /*const*/ int lda,
                  /*const*/ double *B, /*const*/ int ldb, /*const*/ double beta,
                  double *C, /*const*/ int ldc);

extern void lfc_cblas_dger(enum LFC_CBLAS_ORDER Order, int M, int N,
  double alpha, /*const*/ double *X, int incX, double *Y, int incY, double *A,
  int lda);
extern void lfc_cblas_drot(/*const*/ int N, double *X, /*const*/ int incX,
                double *Y, /*const*/ int incY, /*const*/ double c, /*const*/ double s);
extern void lfc_cblas_dsymv(/*const*/ enum LFC_CBLAS_ORDER Order, /*const*/ enum LFC_CBLAS_UPLO Uplo,
                 /*const*/ int N, /*const*/ double alpha, /*const*/ double *A,
                 /*const*/ int lda, /*const*/ double *X, /*const*/ int incX,
                 /*const*/ double beta, double *Y, /*const*/ int incY);
extern void lfc_cblas_dsyr(/*const*/ enum LFC_CBLAS_ORDER Order, /*const*/ enum LFC_CBLAS_UPLO Uplo,
                /*const*/ int N, /*const*/ double alpha, /*const*/ double *X,
                /*const*/ int incX, double *A, /*const*/ int lda);
extern void lfc_cblas_dsyr2(/*const*/ enum LFC_CBLAS_ORDER Order, /*const*/ enum LFC_CBLAS_UPLO Uplo,
                /*const*/ int N, /*const*/ double alpha, /*const*/ double *X,
                /*const*/ int incX, /*const*/ double *Y, /*const*/ int incY, double *A,
                /*const*/ int lda);
extern void lfc_cblas_dsbmv(/*const*/ enum LFC_CBLAS_ORDER Order, /*const*/ enum LFC_CBLAS_UPLO Uplo,
                 /*const*/ int N, /*const*/ int K, /*const*/ double alpha, /*const*/ double *A,
                 /*const*/ int lda, /*const*/ double *X, /*const*/ int incX,
                 /*const*/ double beta, double *Y, /*const*/ int incY);

extern void lfc_cblas_daxpy(int N, double alpha, /*const*/ double *X,int incX,
  double *Y, int incY);
extern void lfc_cblas_dcopy(int N, /*const*/ double *X, int incX, double *Y,
  int incY);
extern double lfc_cblas_ddot(int N, /*const*/ double *X, int incX,
  /*const*/ double *Y, int incY);
extern double lfc_cblas_dnrm2(int N, double *X, int incX);
extern void lfc_cblas_dscal(int N, double alpha, double *X, int incX);
extern void lfc_cblas_dswap(int N, double *X, int incX, double *Y, int incY);
extern int lfc_cblas_idamax(int N, /*const*/ double *X, int incX);

extern void lfc_cblas_dgemv(enum LFC_CBLAS_ORDER Order,
  enum LFC_CBLAS_TRANSPOSE TransA, int M, int N, double alpha,
  /*const*/ double  *A, int ldA, /*const*/ double *X, int incX, double beta,
  double  *Y, int incY);
extern void lfc_cblas_dtrmv(enum LFC_CBLAS_ORDER Order,
  enum LFC_CBLAS_UPLO Uplo, enum LFC_CBLAS_TRANSPOSE TransA,
  enum LFC_CBLAS_DIAG Diag, int N, /* const */ double *A, int ldA, double *X,
  int incX);

extern void
lfc_cblas_dgemm(enum LFC_CBLAS_ORDER Order, enum LFC_CBLAS_TRANSPOSE TransA,
                enum LFC_CBLAS_TRANSPOSE TransB, int M, int N, int K,
                double alpha, /*const*/ double *A, int lda, /*const*/ double *B,
                int ldb, double beta, double *C, int ldc);
extern void lfc_cblas_dtrmm(enum LFC_CBLAS_ORDER Order, enum LFC_CBLAS_SIDE Side,
  enum LFC_CBLAS_UPLO Uplo, enum LFC_CBLAS_TRANSPOSE TransA,
  enum LFC_CBLAS_DIAG Diag, int M, int N, double alpha, /*const*/ double *A,
  int ldA, double *B, int ldB);
extern void
lfc_cblas_dtrsm(enum LFC_CBLAS_ORDER Order, enum LFC_CBLAS_SIDE Side,
                enum LFC_CBLAS_UPLO Uplo, enum LFC_CBLAS_TRANSPOSE TransA,
                enum LFC_CBLAS_DIAG Diag, int M, int N, double alpha,
                /*const*/ double *A, int lda, double *B, int ldb);
extern void
lfc_cblas_dsyrk(enum LFC_CBLAS_ORDER Order, enum LFC_CBLAS_UPLO Uplo,
		enum LFC_CBLAS_TRANSPOSE Trans, int N, int K, double alpha,
		/*const*/ double *A, int lda, double beta, double *C, int ldc);

extern void
lfc_cblas_dsymm(enum LFC_CBLAS_ORDER Order, enum LFC_CBLAS_SIDE Side,
                enum LFC_CBLAS_UPLO Uplo, int M, int N, double alpha,
		/*const*/ double *A, int lda, /*const*/ double *B, int ldb,
		double beta, double *C, int ldc);

extern float  lfc_cblas_sasum(/*const*/ int N, /*const*/ float *X, /*const*/ int incX);
extern void lfc_cblas_strsv(/*const*/ enum LFC_CBLAS_ORDER Order, /*const*/ enum LFC_CBLAS_UPLO Uplo,
                 /*const*/ enum LFC_CBLAS_TRANSPOSE TransA, /*const*/ enum LFC_CBLAS_DIAG Diag,
                 /*const*/ int N, /*const*/ float *A, /*const*/ int lda, float *X,
                 /*const*/ int incX);
extern void lfc_cblas_sgbmv(/*const*/ enum LFC_CBLAS_ORDER Order,
                 /*const*/ enum LFC_CBLAS_TRANSPOSE TransA, /*const*/ int M, /*const*/ int N,
                 /*const*/ int KL, /*const*/ int KU, /*const*/ float alpha,
                 /*const*/ float *A, /*const*/ int lda, /*const*/ float *X,
                 /*const*/ int incX, /*const*/ float beta, float *Y, /*const*/ int incY);
extern void lfc_cblas_stbsv(/*const*/ enum LFC_CBLAS_ORDER Order, /*const*/ enum LFC_CBLAS_UPLO Uplo,
                 /*const*/ enum LFC_CBLAS_TRANSPOSE TransA, /*const*/ enum LFC_CBLAS_DIAG Diag,
                 /*const*/ int N, /*const*/ int K, /*const*/ float *A, /*const*/ int lda,
                 float *X, /*const*/ int incX);
extern void lfc_cblas_ssyr2k(/*const*/ enum LFC_CBLAS_ORDER Order, /*const*/ enum LFC_CBLAS_UPLO Uplo,
                  /*const*/ enum LFC_CBLAS_TRANSPOSE Trans, /*const*/ int N, /*const*/ int K,
                  /*const*/ float alpha, /*const*/ float *A, /*const*/ int lda,
                  /*const*/ float *B, /*const*/ int ldb, /*const*/ float beta,
                  float *C, /*const*/ int ldc);

extern void lfc_cblas_saxpy(/*const*/ int N, /*const*/ float alpha, /*const*/ float *X,
                 /*const*/ int incX, float *Y, /*const*/ int incY);
extern void lfc_cblas_scopy(/*const*/ int N, /*const*/ float *X, /*const*/ int incX,
                 float *Y, /*const*/ int incY);
extern float  lfc_cblas_snrm2(/*const*/ int N, /*const*/ float *X, /*const*/ int incX);
extern void lfc_cblas_sscal(/*const*/ int N, /*const*/ float alpha, float *X, /*const*/ int incX);
extern void lfc_cblas_sswap(/*const*/ int N, float *X, /*const*/ int incX,
                 float *Y, /*const*/ int incY);
extern int lfc_cblas_isamax(/*const*/ int N, /*const*/ float  *X, /*const*/ int incX);
extern void lfc_cblas_sgemv(/*const*/ enum LFC_CBLAS_ORDER Order,
                 /*const*/ enum LFC_CBLAS_TRANSPOSE TransA, /*const*/ int M, /*const*/ int N,
                 /*const*/ float alpha, /*const*/ float *A, /*const*/ int lda,
                 /*const*/ float *X, /*const*/ int incX, /*const*/ float beta,
                 float *Y, /*const*/ int incY);
extern void lfc_cblas_strmv(/*const*/ enum LFC_CBLAS_ORDER Order, /*const*/ enum LFC_CBLAS_UPLO Uplo,
                 /*const*/ enum LFC_CBLAS_TRANSPOSE TransA, /*const*/ enum LFC_CBLAS_DIAG Diag,
                 /*const*/ int N, /*const*/ float *A, /*const*/ int lda,
                 float *X, /*const*/ int incX);
extern void lfc_cblas_sgemm(/*const*/ enum LFC_CBLAS_ORDER Order, /*const*/ enum LFC_CBLAS_TRANSPOSE TransA,
                 /*const*/ enum LFC_CBLAS_TRANSPOSE TransB, /*const*/ int M, /*const*/ int N,
                 /*const*/ int K, /*const*/ float alpha, /*const*/ float *A,
                 /*const*/ int lda, /*const*/ float *B, /*const*/ int ldb,
                 /*const*/ float beta, float *C, /*const*/ int ldc);
extern void lfc_cblas_strmm(/*const*/ enum LFC_CBLAS_ORDER Order, /*const*/ enum LFC_CBLAS_SIDE Side,
                 /*const*/ enum LFC_CBLAS_UPLO Uplo, /*const*/ enum LFC_CBLAS_TRANSPOSE TransA,
                 /*const*/ enum LFC_CBLAS_DIAG Diag, /*const*/ int M, /*const*/ int N,
                 /*const*/ float alpha, /*const*/ float *A, /*const*/ int lda,
                 float *B, /*const*/ int ldb);
extern void lfc_cblas_strsm(/*const*/ enum LFC_CBLAS_ORDER Order, /*const*/ enum LFC_CBLAS_SIDE Side,
                 /*const*/ enum LFC_CBLAS_UPLO Uplo, /*const*/ enum LFC_CBLAS_TRANSPOSE TransA,
                 /*const*/ enum LFC_CBLAS_DIAG Diag, /*const*/ int M, /*const*/ int N,
                 /*const*/ float alpha, /*const*/ float *A, /*const*/ int lda,
                 float *B, /*const*/ int ldb);
extern void lfc_cblas_ssyrk(/*const*/ enum LFC_CBLAS_ORDER Order, /*const*/ enum LFC_CBLAS_UPLO Uplo,
                 /*const*/ enum LFC_CBLAS_TRANSPOSE Trans, /*const*/ int N, /*const*/ int K,
                 /*const*/ float alpha, /*const*/ float *A, /*const*/ int lda,
                 /*const*/ float beta, float *C, /*const*/ int ldc);
extern void lfc_cblas_ssymm(/*const*/ enum LFC_CBLAS_ORDER Order, /*const*/ enum LFC_CBLAS_SIDE Side,
                 /*const*/ enum LFC_CBLAS_UPLO Uplo, /*const*/ int M, /*const*/ int N,
                 /*const*/ float alpha, /*const*/ float *A, /*const*/ int lda,
                 /*const*/ float *B, /*const*/ int ldb, /*const*/ float beta,
                 float *C, /*const*/ int ldc);

extern void lfc_cblas_sger(/*const*/ enum LFC_CBLAS_ORDER Order, /*const*/ int M, /*const*/ int N,
                /*const*/ float alpha, /*const*/ float *X, /*const*/ int incX,
                /*const*/ float *Y, /*const*/ int incY, float *A, /*const*/ int lda);
extern void lfc_cblas_srot(/*const*/ int N, float *X, /*const*/ int incX,
                float *Y, /*const*/ int incY, /*const*/ float c, /*const*/ float s);
extern void lfc_cblas_ssymv(/*const*/ enum LFC_CBLAS_ORDER Order, /*const*/ enum LFC_CBLAS_UPLO Uplo,
                 /*const*/ int N, /*const*/ float alpha, /*const*/ float *A,
                 /*const*/ int lda, /*const*/ float *X, /*const*/ int incX,
                 /*const*/ float beta, float *Y, /*const*/ int incY);
extern void lfc_cblas_ssyr(/*const*/ enum LFC_CBLAS_ORDER Order, /*const*/ enum LFC_CBLAS_UPLO Uplo,
                /*const*/ int N, /*const*/ float alpha, /*const*/ float *X,
                /*const*/ int incX, float *A, /*const*/ int lda);
extern void lfc_cblas_ssyr2(/*const*/ enum LFC_CBLAS_ORDER Order, /*const*/ enum LFC_CBLAS_UPLO Uplo,
                /*const*/ int N, /*const*/ float alpha, /*const*/ float *X,
                /*const*/ int incX, /*const*/ float *Y, /*const*/ int incY, float *A,
                /*const*/ int lda);
extern void lfc_cblas_ssbmv(/*const*/ enum LFC_CBLAS_ORDER Order, /*const*/ enum LFC_CBLAS_UPLO Uplo,
                 /*const*/ int N, /*const*/ int K, /*const*/ float alpha, /*const*/ float *A,
                 /*const*/ int lda, /*const*/ float *X, /*const*/ int incX,
                 /*const*/ float beta, float *Y, /*const*/ int incY);



extern float  lfc_cblas_scasum(/*const*/ int N, /*const*/ void *X, /*const*/ int incX);
extern void lfc_cblas_ctrsv(/*const*/ enum LFC_CBLAS_ORDER Order, /*const*/ enum LFC_CBLAS_UPLO Uplo,
                 /*const*/ enum LFC_CBLAS_TRANSPOSE TransA, /*const*/ enum LFC_CBLAS_DIAG Diag,
                 /*const*/ int N, /*const*/ void *A, /*const*/ int lda, void *X,
                 /*const*/ int incX);
extern void lfc_cblas_cgbmv(/*const*/ enum LFC_CBLAS_ORDER Order,
                 /*const*/ enum LFC_CBLAS_TRANSPOSE TransA, /*const*/ int M, /*const*/ int N,
                 /*const*/ int KL, /*const*/ int KU, /*const*/ void *alpha,
                 /*const*/ void *A, /*const*/ int lda, /*const*/ void *X,
                 /*const*/ int incX, /*const*/ void *beta, void *Y, /*const*/ int incY);
extern void lfc_cblas_ctbsv(/*const*/ enum LFC_CBLAS_ORDER Order, /*const*/ enum LFC_CBLAS_UPLO Uplo,
                 /*const*/ enum LFC_CBLAS_TRANSPOSE TransA, /*const*/ enum LFC_CBLAS_DIAG Diag,
                 /*const*/ int N, /*const*/ int K, /*const*/ void *A, /*const*/ int lda,
                 void *X, /*const*/ int incX);
extern void lfc_cblas_csyr2k(/*const*/ enum LFC_CBLAS_ORDER Order, /*const*/ enum LFC_CBLAS_UPLO Uplo,
                  /*const*/ enum LFC_CBLAS_TRANSPOSE Trans, /*const*/ int N, /*const*/ int K,
                  /*const*/ void *alpha, /*const*/ void *A, /*const*/ int lda,
                  /*const*/ void *B, /*const*/ int ldb, /*const*/ void *beta,
                  void *C, /*const*/ int ldc);

extern void lfc_cblas_caxpy(/*const*/ int N, /*const*/ void *alpha, /*const*/ void *X,
                 /*const*/ int incX, void *Y, /*const*/ int incY);
extern void lfc_cblas_ccopy(/*const*/ int N, /*const*/ void *X, /*const*/ int incX,
                 void *Y, /*const*/ int incY);

extern float  lfc_cblas_scnrm2(/*const*/ int N, /*const*/ void *X, /*const*/ int incX);
extern void lfc_cblas_cscal(/*const*/ int N, /*const*/ void *alpha, void *X, /*const*/ int incX);
extern void lfc_cblas_csscal(/*const*/ int N, /*const*/ float alpha, void *X, /*const*/ int incX);
extern void lfc_cblas_cgeru(/*const*/ enum LFC_CBLAS_ORDER Order, /*const*/ int M, /*const*/ int N,
                 /*const*/ void *alpha, /*const*/ void *X, /*const*/ int incX,
                 /*const*/ void *Y, /*const*/ int incY, void *A, /*const*/ int lda);
extern void lfc_cblas_cgerc(/*const*/ enum LFC_CBLAS_ORDER Order, /*const*/ int M, /*const*/ int N,
                 /*const*/ void *alpha, /*const*/ void *X, /*const*/ int incX,
                 /*const*/ void *Y, /*const*/ int incY, void *A, /*const*/ int lda);
extern void lfc_cblas_cher(/*const*/ enum LFC_CBLAS_ORDER Order, /*const*/ enum LFC_CBLAS_UPLO Uplo,
                /*const*/ int N, /*const*/ float alpha, /*const*/ void *X, /*const*/ int incX,
                void *A, /*const*/ int lda);
extern void lfc_cblas_cher2(/*const*/ enum LFC_CBLAS_ORDER Order, /*const*/ enum LFC_CBLAS_UPLO Uplo, /*const*/ int N,
                /*const*/ void *alpha, /*const*/ void *X, /*const*/ int incX,
                /*const*/ void *Y, /*const*/ int incY, void *A, /*const*/ int lda);
extern void lfc_cblas_cherk(/*const*/ enum LFC_CBLAS_ORDER Order, /*const*/ enum LFC_CBLAS_UPLO Uplo,
                 /*const*/ enum LFC_CBLAS_TRANSPOSE Trans, /*const*/ int N, /*const*/ int K,
                 /*const*/ float alpha, /*const*/ void *A, /*const*/ int lda,
                 /*const*/ float beta, void *C, /*const*/ int ldc);
extern void lfc_cblas_cher2k(/*const*/ enum LFC_CBLAS_ORDER Order, /*const*/ enum LFC_CBLAS_UPLO Uplo,
                  /*const*/ enum LFC_CBLAS_TRANSPOSE Trans, /*const*/ int N, /*const*/ int K,
                  /*const*/ void *alpha, /*const*/ void *A, /*const*/ int lda,
                  /*const*/ void *B, /*const*/ int ldb, /*const*/ float beta,
                  void *C, /*const*/ int ldc);
extern void lfc_cblas_chemv(/*const*/ enum LFC_CBLAS_ORDER Order, /*const*/ enum LFC_CBLAS_UPLO Uplo,
                 /*const*/ int N, /*const*/ void *alpha, /*const*/ void *A,
                 /*const*/ int lda, /*const*/ void *X, /*const*/ int incX,
                 /*const*/ void *beta, void *Y, /*const*/ int incY);
extern void lfc_cblas_chemm(/*const*/ enum LFC_CBLAS_ORDER Order, /*const*/ enum LFC_CBLAS_SIDE Side,
                 /*const*/ enum LFC_CBLAS_UPLO Uplo, /*const*/ int M, /*const*/ int N,
                 /*const*/ void *alpha, /*const*/ void *A, /*const*/ int lda,
                 /*const*/ void *B, /*const*/ int ldb, /*const*/ void *beta,
                 void *C, /*const*/ int ldc);
extern void lfc_cblas_chbmv(/*const*/ enum LFC_CBLAS_ORDER Order, /*const*/ enum LFC_CBLAS_UPLO Uplo,
                 /*const*/ int N, /*const*/ int K, /*const*/ void *alpha, /*const*/ void *A,
                 /*const*/ int lda, /*const*/ void *X, /*const*/ int incX,
                 /*const*/ void *beta, void *Y, /*const*/ int incY);

extern void lfc_cblas_cswap(/*const*/ int N, void *X, /*const*/ int incX,
                 void *Y, /*const*/ int incY);
extern int lfc_cblas_icamax(/*const*/ int N, /*const*/ void   *X, /*const*/ int incX);
extern void lfc_cblas_cgemv(/*const*/ enum LFC_CBLAS_ORDER Order,
                 /*const*/ enum LFC_CBLAS_TRANSPOSE TransA, /*const*/ int M, /*const*/ int N,
                 /*const*/ void *alpha, /*const*/ void *A, /*const*/ int lda,
                 /*const*/ void *X, /*const*/ int incX, /*const*/ void *beta,
                 void *Y, /*const*/ int incY);
extern void lfc_cblas_ctrmv(/*const*/ enum LFC_CBLAS_ORDER Order, /*const*/ enum LFC_CBLAS_UPLO Uplo,
                 /*const*/ enum LFC_CBLAS_TRANSPOSE TransA, /*const*/ enum LFC_CBLAS_DIAG Diag,
                 /*const*/ int N, /*const*/ void *A, /*const*/ int lda,
                 void *X, /*const*/ int incX);
extern void lfc_cblas_cgemm(/*const*/ enum LFC_CBLAS_ORDER Order, /*const*/ enum LFC_CBLAS_TRANSPOSE TransA,
                 /*const*/ enum LFC_CBLAS_TRANSPOSE TransB, /*const*/ int M, /*const*/ int N,
                 /*const*/ int K, /*const*/ void *alpha, /*const*/ void *A,
                 /*const*/ int lda, /*const*/ void *B, /*const*/ int ldb,
                 /*const*/ void *beta, void *C, /*const*/ int ldc);
extern void lfc_cblas_ctrmm(/*const*/ enum LFC_CBLAS_ORDER Order, /*const*/ enum LFC_CBLAS_SIDE Side,
                 /*const*/ enum LFC_CBLAS_UPLO Uplo, /*const*/ enum LFC_CBLAS_TRANSPOSE TransA,
                 /*const*/ enum LFC_CBLAS_DIAG Diag, /*const*/ int M, /*const*/ int N,
                 /*const*/ void *alpha, /*const*/ void *A, /*const*/ int lda,
                 void *B, /*const*/ int ldb);
extern void lfc_cblas_ctrsm(/*const*/ enum LFC_CBLAS_ORDER Order, /*const*/ enum LFC_CBLAS_SIDE Side,
                 /*const*/ enum LFC_CBLAS_UPLO Uplo, /*const*/ enum LFC_CBLAS_TRANSPOSE TransA,
                 /*const*/ enum LFC_CBLAS_DIAG Diag, /*const*/ int M, /*const*/ int N,
                 /*const*/ void *alpha, /*const*/ void *A, /*const*/ int lda,
                 void *B, /*const*/ int ldb);
extern void lfc_cblas_csyrk(/*const*/ enum LFC_CBLAS_ORDER Order, /*const*/ enum LFC_CBLAS_UPLO Uplo,
                 /*const*/ enum LFC_CBLAS_TRANSPOSE Trans, /*const*/ int N, /*const*/ int K,
                 /*const*/ void *alpha, /*const*/ void *A, /*const*/ int lda,
                 /*const*/ void *beta, void *C, /*const*/ int ldc);
extern void lfc_cblas_csymm(/*const*/ enum LFC_CBLAS_ORDER Order, /*const*/ enum LFC_CBLAS_SIDE Side,
                 /*const*/ enum LFC_CBLAS_UPLO Uplo, /*const*/ int M, /*const*/ int N,
                 /*const*/ void *alpha, /*const*/ void *A, /*const*/ int lda,
                 /*const*/ void *B, /*const*/ int ldb, /*const*/ void *beta,
                 void *C, /*const*/ int ldc);


extern double lfc_cblas_dzasum(/*const*/ int N, /*const*/ void *X, /*const*/ int incX);
extern void lfc_cblas_ztrsv(/*const*/ enum LFC_CBLAS_ORDER Order, /*const*/ enum LFC_CBLAS_UPLO Uplo,
                 /*const*/ enum LFC_CBLAS_TRANSPOSE TransA, /*const*/ enum LFC_CBLAS_DIAG Diag,
                 /*const*/ int N, /*const*/ void *A, /*const*/ int lda, void *X,
                 /*const*/ int incX);
extern void lfc_cblas_zgbmv(/*const*/ enum LFC_CBLAS_ORDER Order,
                 /*const*/ enum LFC_CBLAS_TRANSPOSE TransA, /*const*/ int M, /*const*/ int N,
                 /*const*/ int KL, /*const*/ int KU, /*const*/ void *alpha,
                 /*const*/ void *A, /*const*/ int lda, /*const*/ void *X,
                 /*const*/ int incX, /*const*/ void *beta, void *Y, /*const*/ int incY);
extern void lfc_cblas_ztbsv(/*const*/ enum LFC_CBLAS_ORDER Order, /*const*/ enum LFC_CBLAS_UPLO Uplo,
                 /*const*/ enum LFC_CBLAS_TRANSPOSE TransA, /*const*/ enum LFC_CBLAS_DIAG Diag,
                 /*const*/ int N, /*const*/ int K, /*const*/ void *A, /*const*/ int lda,
                 void *X, /*const*/ int incX);
extern void lfc_cblas_zsyr2k(/*const*/ enum LFC_CBLAS_ORDER Order, /*const*/ enum LFC_CBLAS_UPLO Uplo,
                  /*const*/ enum LFC_CBLAS_TRANSPOSE Trans, /*const*/ int N, /*const*/ int K,
                  /*const*/ void *alpha, /*const*/ void *A, /*const*/ int lda,
                  /*const*/ void *B, /*const*/ int ldb, /*const*/ void *beta,
                  void *C, /*const*/ int ldc);

extern void lfc_cblas_zaxpy(/*const*/ int N, /*const*/ void *alpha, /*const*/ void *X,
                 /*const*/ int incX, void *Y, /*const*/ int incY);
extern void lfc_cblas_zcopy(/*const*/ int N, /*const*/ void *X, /*const*/ int incX,
                 void *Y, /*const*/ int incY);
extern double lfc_cblas_dznrm2(/*const*/ int N, /*const*/ void *X, /*const*/ int incX);
extern void lfc_cblas_zscal(/*const*/ int N, /*const*/ void *alpha, void *X, /*const*/ int incX);
extern void lfc_cblas_zswap(/*const*/ int N, void *X, /*const*/ int incX,
                 void *Y, /*const*/ int incY);
extern int lfc_cblas_izamax(/*const*/ int N, /*const*/ void   *X, /*const*/ int incX);
extern void lfc_cblas_zgemv(/*const*/ enum LFC_CBLAS_ORDER Order,
                 /*const*/ enum LFC_CBLAS_TRANSPOSE TransA, /*const*/ int M, /*const*/ int N,
                 /*const*/ void *alpha, /*const*/ void *A, /*const*/ int lda,
                 /*const*/ void *X, /*const*/ int incX, /*const*/ void *beta,
                 void *Y, /*const*/ int incY);
extern void lfc_cblas_ztrmv(/*const*/ enum LFC_CBLAS_ORDER Order, /*const*/ enum LFC_CBLAS_UPLO Uplo,
                 /*const*/ enum LFC_CBLAS_TRANSPOSE TransA, /*const*/ enum LFC_CBLAS_DIAG Diag,
                 /*const*/ int N, /*const*/ void *A, /*const*/ int lda,
                 void *X, /*const*/ int incX);
extern void lfc_cblas_zgemm(/*const*/ enum LFC_CBLAS_ORDER Order, /*const*/ enum LFC_CBLAS_TRANSPOSE TransA,
                 /*const*/ enum LFC_CBLAS_TRANSPOSE TransB, /*const*/ int M, /*const*/ int N,
                 /*const*/ int K, /*const*/ void *alpha, /*const*/ void *A,
                 /*const*/ int lda, /*const*/ void *B, /*const*/ int ldb,
                 /*const*/ void *beta, void *C, /*const*/ int ldc);
extern void lfc_cblas_ztrmm(/*const*/ enum LFC_CBLAS_ORDER Order, /*const*/ enum LFC_CBLAS_SIDE Side,
                 /*const*/ enum LFC_CBLAS_UPLO Uplo, /*const*/ enum LFC_CBLAS_TRANSPOSE TransA,
                 /*const*/ enum LFC_CBLAS_DIAG Diag, /*const*/ int M, /*const*/ int N,
                 /*const*/ void *alpha, /*const*/ void *A, /*const*/ int lda,
                 void *B, /*const*/ int ldb);
extern void lfc_cblas_ztrsm(/*const*/ enum LFC_CBLAS_ORDER Order, /*const*/ enum LFC_CBLAS_SIDE Side,
                 /*const*/ enum LFC_CBLAS_UPLO Uplo, /*const*/ enum LFC_CBLAS_TRANSPOSE TransA,
                 /*const*/ enum LFC_CBLAS_DIAG Diag, /*const*/ int M, /*const*/ int N,
                 /*const*/ void *alpha, /*const*/ void *A, /*const*/ int lda,
                 void *B, /*const*/ int ldb);
extern void lfc_cblas_zsyrk(/*const*/ enum LFC_CBLAS_ORDER Order, /*const*/ enum LFC_CBLAS_UPLO Uplo,
                 /*const*/ enum LFC_CBLAS_TRANSPOSE Trans, /*const*/ int N, /*const*/ int K,
                 /*const*/ void *alpha, /*const*/ void *A, /*const*/ int lda,
                 /*const*/ void *beta, void *C, /*const*/ int ldc);
extern void lfc_cblas_zsymm(/*const*/ enum LFC_CBLAS_ORDER Order, /*const*/ enum LFC_CBLAS_SIDE Side,
                 /*const*/ enum LFC_CBLAS_UPLO Uplo, /*const*/ int M, /*const*/ int N,
                 /*const*/ void *alpha, /*const*/ void *A, /*const*/ int lda,
                 /*const*/ void *B, /*const*/ int ldb, /*const*/ void *beta,
                 void *C, /*const*/ int ldc);

extern void lfc_cblas_zdscal(/*const*/ int N, /*const*/ double alpha, void *X, /*const*/ int incX);
extern void lfc_cblas_zgeru(/*const*/ enum LFC_CBLAS_ORDER Order, /*const*/ int M, /*const*/ int N,
                 /*const*/ void *alpha, /*const*/ void *X, /*const*/ int incX,
                 /*const*/ void *Y, /*const*/ int incY, void *A, /*const*/ int lda);
extern void lfc_cblas_zgerc(/*const*/ enum LFC_CBLAS_ORDER Order, /*const*/ int M, /*const*/ int N,
                 /*const*/ void *alpha, /*const*/ void *X, /*const*/ int incX,
                 /*const*/ void *Y, /*const*/ int incY, void *A, /*const*/ int lda);
extern void lfc_cblas_zher(/*const*/ enum LFC_CBLAS_ORDER Order, /*const*/ enum LFC_CBLAS_UPLO Uplo,
                /*const*/ int N, /*const*/ double alpha, /*const*/ void *X, /*const*/ int incX,
                void *A, /*const*/ int lda);
extern void lfc_cblas_zher2(/*const*/ enum LFC_CBLAS_ORDER Order, /*const*/ enum LFC_CBLAS_UPLO Uplo, /*const*/ int N,
                /*const*/ void *alpha, /*const*/ void *X, /*const*/ int incX,
                /*const*/ void *Y, /*const*/ int incY, void *A, /*const*/ int lda);
extern void lfc_cblas_zherk(/*const*/ enum LFC_CBLAS_ORDER Order, /*const*/ enum LFC_CBLAS_UPLO Uplo,
                 /*const*/ enum LFC_CBLAS_TRANSPOSE Trans, /*const*/ int N, /*const*/ int K,
                 /*const*/ double alpha, /*const*/ void *A, /*const*/ int lda,
                 /*const*/ double beta, void *C, /*const*/ int ldc);
extern void lfc_cblas_zher2k(/*const*/ enum LFC_CBLAS_ORDER Order, /*const*/ enum LFC_CBLAS_UPLO Uplo,
                  /*const*/ enum LFC_CBLAS_TRANSPOSE Trans, /*const*/ int N, /*const*/ int K,
                  /*const*/ void *alpha, /*const*/ void *A, /*const*/ int lda,
                  /*const*/ void *B, /*const*/ int ldb, /*const*/ double beta,
                  void *C, /*const*/ int ldc);
extern void lfc_cblas_zhemv(/*const*/ enum LFC_CBLAS_ORDER Order, /*const*/ enum LFC_CBLAS_UPLO Uplo,
                 /*const*/ int N, /*const*/ void *alpha, /*const*/ void *A,
                 /*const*/ int lda, /*const*/ void *X, /*const*/ int incX,
                 /*const*/ void *beta, void *Y, /*const*/ int incY);
extern void lfc_cblas_zhemm(/*const*/ enum LFC_CBLAS_ORDER Order, /*const*/ enum LFC_CBLAS_SIDE Side,
                 /*const*/ enum LFC_CBLAS_UPLO Uplo, /*const*/ int M, /*const*/ int N,
                 /*const*/ void *alpha, /*const*/ void *A, /*const*/ int lda,
                 /*const*/ void *B, /*const*/ int ldb, /*const*/ void *beta,
                 void *C, /*const*/ int ldc);
extern void lfc_cblas_zhbmv(/*const*/ enum LFC_CBLAS_ORDER Order, /*const*/ enum LFC_CBLAS_UPLO Uplo,
                 /*const*/ int N, /*const*/ int K, /*const*/ void *alpha, /*const*/ void *A,
                 /*const*/ int lda, /*const*/ void *X, /*const*/ int incX,
                 /*const*/ void *beta, void *Y, /*const*/ int incY);

LFC_END_C_DECLS

#endif /* !LFC_CBLAS_H */
