/* ztrmm.f -- translated by f2c (version 20030320).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

#include "f2cblas.h"

/* Table of constant values */


/* Subroutine */ int ztrmm_(char *side, char *uplo, char *transa, char *diag, 
	integer *m, integer *n, doublecomplex *alpha, doublecomplex *a, 
	integer *lda, doublecomplex *c__, integer *ldc, ftnlen side_len, 
	ftnlen uplo_len, ftnlen transa_len, ftnlen diag_len)
{
doublecomplex c_b1 = {0.,0.};
doublecomplex c_b2 = {1.,0.};
integer c__0 = 0;
integer c__81 = 81;
integer c__82 = 82;
integer c__1 = 1;
integer c__44 = 44;
integer c__83 = 83;
    /* System generated locals */
    integer a_dim1, a_offset, c_dim1, c_offset, i__1, i__2, i__3, i__4;
    doublecomplex z__1;

    /* Builtin functions */
    void d_cnjg(doublecomplex *, doublecomplex *);

    /* Local variables */
    integer i__, j;
    doublecomplex t1[1936]	/* was [44][44] */, t2[1936]	/* was [44][
	    44] */, t3[1936]	/* was [44][44] */;
    integer ii, jj, ix, jx;
    logical cldc;
    integer offd, isec, jsec, info;
    extern logical zcld_(integer *);
    integer tsec;
    logical notr;
    doublecomplex gamma, delta;
    logical lside;
    
    extern /* Subroutine */ int zgemm_(char *, char *, integer *, integer *, 
	    integer *, doublecomplex *, doublecomplex *, integer *, 
	    doublecomplex *, integer *, doublecomplex *, doublecomplex *, 
	    integer *, ftnlen, ftnlen);
    integer nrowa;
    extern /* Subroutine */ int zgemv_(char *, integer *, integer *, 
	    doublecomplex *, doublecomplex *, integer *, doublecomplex *, 
	    integer *, doublecomplex *, doublecomplex *, integer *, ftnlen);
    logical upper, tinym, tinyn;
    extern /* Subroutine */ int zcopy_(integer *, doublecomplex *, integer *, 
	    doublecomplex *, integer *), ztrmv_(char *, char *, char *, 
	    integer *, doublecomplex *, integer *, doublecomplex *, integer *,
	     ftnlen, ftnlen, ftnlen);
    logical noconj, smalln, nounit;

/*     .. Scalar Arguments .. */
/*     .. Array Arguments .. */
/*     .. */

/*  Purpose */
/*  ======= */

/*  ZTRMM  performs one of the matrix-matrix operations */

/*     C := alpha*op( A )*C,   or   C := alpha*C*op( A ) */

/*  where  alpha  is a scalar,  C  is an m by n matrix,  A  is a unit, or */
/*  non-unit,  upper or lower triangular matrix  and  op( A )  is one  of */

/*     op( A ) = A   or   op( A ) = A'   or   op( A ) = conjg( A' ). */

/*  Parameters */
/*  ========== */

/*  SIDE   - CHARACTER*1. */
/*           On entry,  SIDE specifies whether  op( A ) multiplies C from */
/*           the left or right as follows: */

/*              SIDE = 'L' or 'l'   C := alpha*op( A )*C. */

/*              SIDE = 'R' or 'r'   C := alpha*C*op( A ). */

/*           Unchanged on exit. */

/*  UPLO   - CHARACTER*1. */
/*           On entry, UPLO specifies whether the matrix A is an upper or */
/*           lower triangular matrix as follows: */

/*              UPLO = 'U' or 'u'   A is an upper triangular matrix. */

/*              UPLO = 'L' or 'l'   A is a lower triangular matrix. */

/*           Unchanged on exit. */

/*  TRANSA - CHARACTER*1. */
/*           On entry, TRANSA specifies the form of op( A ) to be used in */
/*           the matrix multiplication as follows: */

/*              TRANSA = 'N' or 'n'   op( A ) = A. */

/*              TRANSA = 'T' or 't'   op( A ) = A'. */

/*              TRANSA = 'C' or 'c'   op( A ) = conjg( A' ). */

/*           Unchanged on exit. */

/*  DIAG   - CHARACTER*1. */
/*           On entry, DIAG specifies whether or not A is unit triangular */
/*           as follows: */

/*              DIAG = 'U' or 'u'   A is assumed to be unit triangular. */

/*              DIAG = 'N' or 'n'   A is not assumed to be unit */
/*                                  triangular. */

/*           Unchanged on exit. */

/*  M      - INTEGER. */
/*           On entry, M specifies the number of rows of C. M must be at */
/*           least zero. */
/*           Unchanged on exit. */

/*  N      - INTEGER. */
/*           On entry, N specifies the number of columns of C.  N must be */
/*           at least zero. */
/*           Unchanged on exit. */

/*  ALPHA  - COMPLEX*16      . */
/*           On entry,  ALPHA specifies the scalar  alpha. When  alpha is */
/*           zero then  A is not referenced and  C need not be set before */
/*           entry. */
/*           Unchanged on exit. */

/*  A      - COMPLEX*16       array of DIMENSION ( LDA, k ), where k is m */
/*           when  SIDE = 'L' or 'l'  and is  n  when  SIDE = 'R' or 'r'. */
/*           Before entry  with  UPLO = 'U' or 'u',  the  leading  k by k */
/*           upper triangular part of the array  A must contain the upper */
/*           triangular matrix  and the strictly lower triangular part of */
/*           A is not referenced. */
/*           Before entry  with  UPLO = 'L' or 'l',  the  leading  k by k */
/*           lower triangular part of the array  A must contain the lower */
/*           triangular matrix  and the strictly upper triangular part of */
/*           A is not referenced. */
/*           Note that when  DIAG = 'U' or 'u',  the diagonal elements of */
/*           A  are not referenced either,  but are assumed to be  unity. */
/*           Unchanged on exit. */

/*  LDA    - INTEGER. */
/*           On entry, LDA specifies the first dimension of A as declared */
/*           in the calling (sub) program.  When  SIDE = 'L' or 'l'  then */
/*           LDA  must be at least  max( 1, m ),  when  SIDE = 'R' or 'r' */
/*           then LDA must be at least max( 1, n ). */
/*           Unchanged on exit. */

/*  C      - COMPLEX*16       array of DIMENSION ( LDC, n ). */
/*           Before entry,  the leading  m by n part of the array  C must */
/*           contain the matrix  C,  and  on exit  is overwritten  by the */
/*           transformed matrix. */

/*  LDC    - INTEGER. */
/*           On entry, LDC specifies the first dimension of C as declared */
/*           in  the  calling  (sub)  program.   LDC  must  be  at  least */
/*           max( 1, m ). */
/*           Unchanged on exit. */


/*  Level 3 Blas routine. */

/*  -- Written on 8-February-1989. */
/*     Jack Dongarra, Argonne National Laboratory. */
/*     Iain Duff, AERE Harwell. */
/*     Jeremy Du Croz, Numerical Algorithms Group Ltd. */
/*     Sven Hammarling, Numerical Algorithms Group Ltd. */

/*  -- Rewritten in May-1994. */
/*     GEMM-Based Level 3 BLAS. */
/*     Per Ling, Institute of Information Processing, */
/*     University of Umea, Sweden. */


/*     .. Local Scalars .. */
/*     .. Intrinsic Functions .. */
/*     .. External Functions .. */
/*     .. External Subroutines .. */
/*     .. Parameters .. */
/*     .. User specified parameters for ZTRMM .. */
/*     .. */
/*     .. Executable Statements .. */

/*     Test the input parameters. */

    /* Parameter adjustments */
    a_dim1 = *lda;
    a_offset = 1 + a_dim1;
    a -= a_offset;
    c_dim1 = *ldc;
    c_offset = 1 + c_dim1;
    c__ -= c_offset;

    /* Function Body */
    lside = (side[0]=='L'?1:0);
    upper = (uplo[0]=='U'?1:0);
    notr = (transa[0]=='N'?1:0);
    noconj = (transa[0]=='T'?1:0);
    nounit = (diag[0]=='N'?1:0);
    if (nounit) {
	offd = 0;
    } else {
	offd = 1;
    }
    if (lside) {
	nrowa = *m;
    } else {
	nrowa = *n;
    }
    info = 0;
    if (! lside && ! (side[0]=='R'?1:0)) {
	info = 1;
    } else if (! upper && ! (uplo[0]=='L'?1:0)) {
	info = 2;
    } else if (! notr && ! noconj && ! (transa[0]=='C'?1:0)) {
	info = 3;
    } else if (! nounit && ! (diag[0]=='U'?1:0)) {
	info = 4;
    } else if (*m < 0) {
	info = 5;
    } else if (*n < 0) {
	info = 6;
    } else if (*lda < max(1,nrowa)) {
	info = 9;
    } else if (*ldc < max(1,*m)) {
	info = 11;
    }
    if (info != 0) {
	xerbla_("ZTRMM ", &info, (ftnlen)6);
	return 0;
    }

/*     Quick return if possible. */

    if (*m == 0 || *n == 0) {
	return 0;
    }

/*     And when alpha.eq.zero. */

    if (alpha->r == 0. && alpha->i == 0.) {
	i__1 = max(*lda,*ldc);
	i__2 = max(*lda,*ldc);
	zgemm_("N", "N", m, n, &c__0, &c_b1, &c__[c_offset], &i__1, &c__[
		c_offset], &i__2, &c_b1, &c__[c_offset], ldc, (ftnlen)1, (
		ftnlen)1);
	return 0;
    }

/*     Start the operations. */

    if (lside) {
	if (upper) {
	    if (notr) {

/*              Form  C := alpha*A*C. Left, Upper, No transpose. */

		smalln = ! zbigp_(&c__81, m, n);
		if (smalln) {
		    tinyn = ! zbigp_(&c__82, m, n);
		    i__1 = *m;
		    for (ii = 1; ii <= i__1; ii += 44) {
/* Computing MIN */
			i__2 = 44, i__3 = *m - ii + 1;
			isec = min(i__2,i__3);

/*                    C := alpha*C, scale the rectangular block of C */
/*                    with alpha. */

			if (alpha->r != 1. || alpha->i != 0.) {
			    zgemm_("N", "N", &isec, n, &c__0, &c_b1, &a[
				    a_offset], lda, &c__[c_offset], ldc, 
				    alpha, &c__[ii + c_dim1], ldc, (ftnlen)1, 
				    (ftnlen)1);
			}
			if (tinyn) {

/*                       C := A*C, triangular matrix multiply involving */
/*                       a upper triangular diagonal block of A. */

			    i__2 = *n;
			    for (j = 1; j <= i__2; ++j) {
				ztrmv_("U", "N", diag, &isec, &a[ii + ii * 
					a_dim1], lda, &c__[ii + j * c_dim1], &
					c__1, (ftnlen)1, (ftnlen)1, (ftnlen)1)
					;
/* L10: */
			    }
			} else {

/*                       T3 := A, a upper unit or non-unit triangular */
/*                       diagonal block of A is copied to the upper */
/*                       triangular part of T3. */

			    i__2 = ii + isec - 1;
			    for (i__ = ii + offd; i__ <= i__2; ++i__) {
				i__3 = i__ - ii + 1 - offd;
				zcopy_(&i__3, &a[ii + i__ * a_dim1], &c__1, &
					t3[(i__ - ii + 1) * 44 - 44], &c__1);
/* L20: */
			    }

/*                       C := T3*C, triangular matrix multiply involving */
/*                       a upper triangular diagonal block of A stored */
/*                       in T3. */

			    i__2 = *n;
			    for (j = 1; j <= i__2; ++j) {
				ztrmv_("U", "N", diag, &isec, t3, &c__44, &
					c__[ii + j * c_dim1], &c__1, (ftnlen)
					1, (ftnlen)1, (ftnlen)1);
/* L30: */
			    }
			}

/*                    C := alpha*A*C + C, general matrix multiply */
/*                    involving a rectangular block of A. */

			if (ii + isec <= *m) {
			    i__2 = *m - ii - isec + 1;
			    zgemm_("N", "N", &isec, n, &i__2, alpha, &a[ii + (
				    ii + isec) * a_dim1], lda, &c__[ii + isec 
				    + c_dim1], ldc, &c_b2, &c__[ii + c_dim1], 
				    ldc, (ftnlen)1, (ftnlen)1);
			}
/* L40: */
		    }
		} else {
		    delta.r = alpha->r, delta.i = alpha->i;
		    cldc = zcld_(ldc);
		    i__1 = *m;
		    for (ii = 1; ii <= i__1; ii += 44) {
/* Computing MIN */
			i__2 = 44, i__3 = *m - ii + 1;
			isec = min(i__2,i__3);

/*                    T2 := A', the transpose of a upper unit or non-unit */
/*                    triangular diagonal block of A is copied to the */
/*                    lower triangular part of T2. */

			i__2 = ii + isec - 1;
			for (i__ = ii + offd; i__ <= i__2; ++i__) {
			    i__3 = i__ - ii + 1 - offd;
			    zcopy_(&i__3, &a[ii + i__ * a_dim1], &c__1, &t2[
				    i__ - ii], &c__44);
/* L50: */
			}
			i__2 = *n;
			for (jj = 1; jj <= i__2; jj += 44) {
/* Computing MIN */
			    i__3 = 44, i__4 = *n - jj + 1;
			    jsec = min(i__3,i__4);

/*                       T1 := C', the transpose of a rectangular block */
/*                       of C is copied to T1. */

			    if (cldc) {
				i__3 = jj + jsec - 1;
				for (j = jj; j <= i__3; ++j) {
				    zcopy_(&isec, &c__[ii + j * c_dim1], &
					    c__1, &t1[j - jj], &c__44);
/* L60: */
				}
			    } else {
				i__3 = ii + isec - 1;
				for (i__ = ii; i__ <= i__3; ++i__) {
				    zcopy_(&jsec, &c__[i__ + jj * c_dim1], 
					    ldc, &t1[(i__ - ii + 1) * 44 - 44]
					    , &c__1);
/* L70: */
				}
			    }

/*                       T1 := gamma*T1*T2 + delta*T1, triangular matrix */
/*                       multiply where the value of delta depends on */
/*                       whether T2 stores a unit or non-unit triangular */
/*                       block. Gamma and tsec are used to compensate for */
/*                       a deficiency in ZGEMV that appears if the second */
/*                       dimension (tsec) is zero. */

			    i__3 = ii + isec - 1;
			    for (i__ = ii; i__ <= i__3; ++i__) {
				if (nounit) {
				    i__4 = i__ - ii + 1 + (i__ - ii + 1) * 44 
					    - 45;
				    z__1.r = alpha->r * t2[i__4].r - alpha->i 
					    * t2[i__4].i, z__1.i = alpha->r * 
					    t2[i__4].i + alpha->i * t2[i__4]
					    .r;
				    delta.r = z__1.r, delta.i = z__1.i;
				}
				gamma.r = alpha->r, gamma.i = alpha->i;
				tsec = ii + isec - 1 - i__;
				if (tsec == 0) {
				    tsec = 1;
				    gamma.r = 0., gamma.i = 0.;
				}
				zgemv_("N", &jsec, &tsec, &gamma, &t1[(i__ - 
					ii + 2) * 44 - 44], &c__44, &t2[i__ - 
					ii + 2 + (i__ - ii + 1) * 44 - 45], &
					c__1, &delta, &t1[(i__ - ii + 1) * 44 
					- 44], &c__1, (ftnlen)1);
/* L80: */
			    }

/*                       C := T1', the transpose of T1 is copied back */
/*                       to C. */

			    i__3 = jj + jsec - 1;
			    for (j = jj; j <= i__3; ++j) {
				zcopy_(&isec, &t1[j - jj], &c__44, &c__[ii + 
					j * c_dim1], &c__1);
/* L90: */
			    }
/* L100: */
			}

/*                    C := alpha*A*C + C, general matrix multiply */
/*                    involving a rectangular block of A. */

			if (ii + isec <= *m) {
			    i__2 = *m - ii - isec + 1;
			    zgemm_("N", "N", &isec, n, &i__2, alpha, &a[ii + (
				    ii + isec) * a_dim1], lda, &c__[ii + isec 
				    + c_dim1], ldc, &c_b2, &c__[ii + c_dim1], 
				    ldc, (ftnlen)1, (ftnlen)1);
			}
/* L110: */
		    }
		}
	    } else {

/*              Form  C := alpha*A'*C  or  C := alpha*conjg( A' )*C. */
/*              Left, Upper, Transpose or Conjugated transpose */

		smalln = ! zbigp_(&c__81, m, n);
		if (smalln) {
		    tinyn = ! zbigp_(&c__82, m, n);
		    for (ii = *m - (*m - 1) % 44; ii >= 1; ii += -44) {
/* Computing MIN */
			i__1 = 44, i__2 = *m - ii + 1;
			isec = min(i__1,i__2);

/*                    C := alpha*C, scale the rectangular block of C */
/*                    with alpha. */

			if (alpha->r != 1. || alpha->i != 0.) {
			    zgemm_(transa, "N", &isec, n, &c__0, &c_b1, &a[
				    a_offset], lda, &c__[c_offset], ldc, 
				    alpha, &c__[ii + c_dim1], ldc, (ftnlen)1, 
				    (ftnlen)1);
			}
			if (tinyn) {

/*                       C := A'*C  or  C := conjg( A' )*C, triangular */
/*                       matrix multiply involving a upper triangular */
/*                       diagonal block of A. */

			    i__1 = *n;
			    for (j = 1; j <= i__1; ++j) {
				ztrmv_("U", transa, diag, &isec, &a[ii + ii * 
					a_dim1], lda, &c__[ii + j * c_dim1], &
					c__1, (ftnlen)1, (ftnlen)1, (ftnlen)1)
					;
/* L120: */
			    }
			} else {

/*                       T3 :=  A, a upper unit or non-unit triangular */
/*                       diagonal block of A is copied to part of T3. */

			    i__1 = ii + isec - 1;
			    for (i__ = ii + offd; i__ <= i__1; ++i__) {
				i__2 = i__ - ii + 1 - offd;
				zcopy_(&i__2, &a[ii + i__ * a_dim1], &c__1, &
					t3[(i__ - ii + 1) * 44 - 44], &c__1);
/* L130: */
			    }

/*                       C := T3'*C  or  C := conjg( T3' )*C, triangular */
/*                       matrix multiply involving a upper triangular */
/*                       diagonal block of A stored in T3. */

			    i__1 = *n;
			    for (j = 1; j <= i__1; ++j) {
				ztrmv_("U", transa, diag, &isec, t3, &c__44, &
					c__[ii + j * c_dim1], &c__1, (ftnlen)
					1, (ftnlen)1, (ftnlen)1);
/* L140: */
			    }
			}

/*                    C := alpha*A'*C + C or */
/*                    C := alpha*conjg( A' )*C + C, matrix multiply */
/*                    involving the transpose of a rectangular block */
/*                    of A. */

			if (ii > 1) {
			    i__1 = ii - 1;
			    zgemm_(transa, "N", &isec, n, &i__1, alpha, &a[ii 
				    * a_dim1 + 1], lda, &c__[c_dim1 + 1], ldc,
				     &c_b2, &c__[ii + c_dim1], ldc, (ftnlen)1,
				     (ftnlen)1);
			}
/* L150: */
		    }
		} else {
		    delta.r = alpha->r, delta.i = alpha->i;
		    cldc = zcld_(ldc);
		    for (ii = *m - (*m - 1) % 44; ii >= 1; ii += -44) {
/* Computing MIN */
			i__1 = 44, i__2 = *m - ii + 1;
			isec = min(i__1,i__2);

/*                    T2 := A or T2 := conjg( A ), a unit or non-unit */
/*                    upper triangular diagonal block of A is copied to */
/*                    the upper triangular part of T2. */

			if (noconj) {
			    i__1 = ii + isec - 1;
			    for (j = ii + offd; j <= i__1; ++j) {
				i__2 = j - ii + 1 - offd;
				zcopy_(&i__2, &a[ii + j * a_dim1], &c__1, &t2[
					(j - ii + 1) * 44 - 44], &c__1);
/* L160: */
			    }
			} else {
			    i__1 = ii + isec - 1;
			    for (j = ii + offd; j <= i__1; ++j) {
				i__2 = j - offd;
				for (i__ = ii; i__ <= i__2; ++i__) {
				    i__3 = i__ - ii + 1 + (j - ii + 1) * 44 - 
					    45;
				    d_cnjg(&z__1, &a[i__ + j * a_dim1]);
				    t2[i__3].r = z__1.r, t2[i__3].i = z__1.i;
/* L170: */
				}
/* L180: */
			    }
			}
			i__1 = *n;
			for (jj = 1; jj <= i__1; jj += 44) {
/* Computing MIN */
			    i__2 = 44, i__3 = *n - jj + 1;
			    jsec = min(i__2,i__3);

/*                       T1 := C', the transpose of a rectangular block */
/*                       of C is copied to T1. */

			    if (cldc) {
				i__2 = jj + jsec - 1;
				for (j = jj; j <= i__2; ++j) {
				    zcopy_(&isec, &c__[ii + j * c_dim1], &
					    c__1, &t1[j - jj], &c__44);
/* L190: */
				}
			    } else {
				i__2 = ii + isec - 1;
				for (i__ = ii; i__ <= i__2; ++i__) {
				    zcopy_(&jsec, &c__[i__ + jj * c_dim1], 
					    ldc, &t1[(i__ - ii + 1) * 44 - 44]
					    , &c__1);
/* L200: */
				}
			    }

/*                       T1 := gamma*T1*A + delta*T1, triangular matrix */
/*                       multiply where the value of delta depends on */
/*                       whether A is a unit or non-unit triangular */
/*                       matrix. Gamma and tsec are used to compensate */
/*                       for a deficiency in ZGEMV that appears if the */
/*                       second dimension (tsec) is zero. */

			    i__2 = ii;
			    for (i__ = ii + isec - 1; i__ >= i__2; --i__) {
				if (nounit) {
				    i__3 = i__ - ii + 1 + (i__ - ii + 1) * 44 
					    - 45;
				    z__1.r = alpha->r * t2[i__3].r - alpha->i 
					    * t2[i__3].i, z__1.i = alpha->r * 
					    t2[i__3].i + alpha->i * t2[i__3]
					    .r;
				    delta.r = z__1.r, delta.i = z__1.i;
				}
				gamma.r = alpha->r, gamma.i = alpha->i;
				tsec = i__ - ii;
				if (tsec == 0) {
				    tsec = 1;
				    gamma.r = 0., gamma.i = 0.;
				}
				zgemv_("N", &jsec, &tsec, &gamma, t1, &c__44, 
					&t2[(i__ - ii + 1) * 44 - 44], &c__1, 
					&delta, &t1[(i__ - ii + 1) * 44 - 44],
					 &c__1, (ftnlen)1);
/* L210: */
			    }

/*                       C := T1', the transpose of T1 is copied back */
/*                       to C. */

			    i__2 = jj + jsec - 1;
			    for (j = jj; j <= i__2; ++j) {
				zcopy_(&isec, &t1[j - jj], &c__44, &c__[ii + 
					j * c_dim1], &c__1);
/* L220: */
			    }
/* L230: */
			}

/*                    C := alpha*A'*C + C or */
/*                    C := alpha*conjg( A' )*C + C, matrix multiply */
/*                    involving the transpose of a rectangular block */
/*                    of A. */

			if (ii > 1) {
			    i__1 = ii - 1;
			    zgemm_(transa, "N", &isec, n, &i__1, alpha, &a[ii 
				    * a_dim1 + 1], lda, &c__[c_dim1 + 1], ldc,
				     &c_b2, &c__[ii + c_dim1], ldc, (ftnlen)1,
				     (ftnlen)1);
			}
/* L240: */
		    }
		}
	    }
	} else {
	    if (notr) {

/*              Form  C := alpha*A*C. Left, Lower, No transpose. */

		smalln = ! zbigp_(&c__81, m, n);
		if (smalln) {
		    tinyn = ! zbigp_(&c__82, m, n);
		    for (ix = *m; ix >= 1; ix += -44) {
/* Computing MAX */
			i__1 = 1, i__2 = ix - 43;
			ii = max(i__1,i__2);
			isec = ix - ii + 1;

/*                    C := alpha*C, scale the rectangular block of C */
/*                    with alpha. */

			if (alpha->r != 1. || alpha->i != 0.) {
			    zgemm_("N", "N", &isec, n, &c__0, &c_b1, &a[
				    a_offset], lda, &c__[c_offset], ldc, 
				    alpha, &c__[ii + c_dim1], ldc, (ftnlen)1, 
				    (ftnlen)1);
			}
			if (tinyn) {

/*                       C := A*C, triangular matrix multiply involving */
/*                       a lower triangular diagonal block of A. */

			    i__1 = *n;
			    for (j = 1; j <= i__1; ++j) {
				ztrmv_("L", "N", diag, &isec, &a[ii + ii * 
					a_dim1], lda, &c__[ii + j * c_dim1], &
					c__1, (ftnlen)1, (ftnlen)1, (ftnlen)1)
					;
/* L250: */
			    }
			} else {

/*                       T3 := A, a lower unit or non-unit triangular */
/*                       diagonal block of A is copied to the lower */
/*                       triangular part of T3. */

			    i__1 = ii + isec - 1 - offd;
			    for (i__ = ii; i__ <= i__1; ++i__) {
				i__2 = ii + isec - i__ - offd;
				zcopy_(&i__2, &a[i__ + offd + i__ * a_dim1], &
					c__1, &t3[i__ - ii + 1 + offd + (i__ 
					- ii + 1) * 44 - 45], &c__1);
/* L260: */
			    }

/*                       C := T3*C, triangular matrix multiply involving */
/*                       a lower triangular diagonal block of A stored */
/*                       in T3. */

			    i__1 = *n;
			    for (j = 1; j <= i__1; ++j) {
				ztrmv_("L", "N", diag, &isec, t3, &c__44, &
					c__[ii + j * c_dim1], &c__1, (ftnlen)
					1, (ftnlen)1, (ftnlen)1);
/* L270: */
			    }
			}

/*                    C := alpha*A'*C + C, general matrix multiply */
/*                    involving a rectangular block of A. */

			if (ii > 1) {
			    i__1 = ii - 1;
			    zgemm_("N", "N", &isec, n, &i__1, alpha, &a[ii + 
				    a_dim1], lda, &c__[c_dim1 + 1], ldc, &
				    c_b2, &c__[ii + c_dim1], ldc, (ftnlen)1, (
				    ftnlen)1);
			}
/* L280: */
		    }
		} else {
		    delta.r = alpha->r, delta.i = alpha->i;
		    cldc = zcld_(ldc);
		    for (ix = *m; ix >= 1; ix += -44) {
/* Computing MAX */
			i__1 = 1, i__2 = ix - 43;
			ii = max(i__1,i__2);
			isec = ix - ii + 1;

/*                    T2 := A', the transpose of a lower unit or non-unit */
/*                    triangular diagonal block of A is copied to the */
/*                    upper triangular part of T2. */

			i__1 = ii + isec - 1 - offd;
			for (i__ = ii; i__ <= i__1; ++i__) {
			    i__2 = ii + isec - i__ - offd;
			    zcopy_(&i__2, &a[i__ + offd + i__ * a_dim1], &
				    c__1, &t2[i__ - ii + 1 + (i__ - ii + 1 + 
				    offd) * 44 - 45], &c__44);
/* L290: */
			}
			i__1 = *n;
			for (jj = 1; jj <= i__1; jj += 44) {
/* Computing MIN */
			    i__2 = 44, i__3 = *n - jj + 1;
			    jsec = min(i__2,i__3);

/*                       T1 := C', the transpose of a rectangular block */
/*                       of C is copied to T1. */

			    if (cldc) {
				i__2 = jj + jsec - 1;
				for (j = jj; j <= i__2; ++j) {
				    zcopy_(&isec, &c__[ii + j * c_dim1], &
					    c__1, &t1[j - jj], &c__44);
/* L300: */
				}
			    } else {
				i__2 = ii + isec - 1;
				for (i__ = ii; i__ <= i__2; ++i__) {
				    zcopy_(&jsec, &c__[i__ + jj * c_dim1], 
					    ldc, &t1[(i__ - ii + 1) * 44 - 44]
					    , &c__1);
/* L310: */
				}
			    }

/*                       T1 := gamma*T1*T2 + delta*T1, triangular matrix */
/*                       multiply where the value of delta depends on */
/*                       whether T2 stores a unit or non-unit triangular */
/*                       block. Gamma and tsec are used to compensate for */
/*                       a deficiency in ZGEMV that appears if the second */
/*                       dimension (tsec) is zero. */

			    i__2 = ii;
			    for (i__ = ii + isec - 1; i__ >= i__2; --i__) {
				if (nounit) {
				    i__3 = i__ - ii + 1 + (i__ - ii + 1) * 44 
					    - 45;
				    z__1.r = alpha->r * t2[i__3].r - alpha->i 
					    * t2[i__3].i, z__1.i = alpha->r * 
					    t2[i__3].i + alpha->i * t2[i__3]
					    .r;
				    delta.r = z__1.r, delta.i = z__1.i;
				}
				gamma.r = alpha->r, gamma.i = alpha->i;
				tsec = i__ - ii;
				if (tsec == 0) {
				    tsec = 1;
				    gamma.r = 0., gamma.i = 0.;
				}
				zgemv_("N", &jsec, &tsec, &gamma, t1, &c__44, 
					&t2[(i__ - ii + 1) * 44 - 44], &c__1, 
					&delta, &t1[(i__ - ii + 1) * 44 - 44],
					 &c__1, (ftnlen)1);
/* L320: */
			    }

/*                       C := T1', the transpose of T1 is copied back */
/*                       to C. */

			    i__2 = jj + jsec - 1;
			    for (j = jj; j <= i__2; ++j) {
				zcopy_(&isec, &t1[j - jj], &c__44, &c__[ii + 
					j * c_dim1], &c__1);
/* L330: */
			    }
/* L340: */
			}

/*                    C := alpha*A'*C + C, general matrix multiply */
/*                    involving a rectangular block of A. */

			if (ii > 1) {
			    i__1 = ii - 1;
			    zgemm_("N", "N", &isec, n, &i__1, alpha, &a[ii + 
				    a_dim1], lda, &c__[c_dim1 + 1], ldc, &
				    c_b2, &c__[ii + c_dim1], ldc, (ftnlen)1, (
				    ftnlen)1);
			}
/* L350: */
		    }
		}
	    } else {

/*              Form  C := alpha*A'*C  or  C := alpha*conjg( A' )*C. */
/*              Left, Lower, Transpose or Conjugated transpose */

		smalln = ! zbigp_(&c__81, m, n);
		if (smalln) {
		    tinyn = ! zbigp_(&c__82, m, n);
		    i__1 = *m;
		    for (ix = (*m - 1) % 44 + 1; ix <= i__1; ix += 44) {
/* Computing MAX */
			i__2 = 1, i__3 = ix - 43;
			ii = max(i__2,i__3);
			isec = ix - ii + 1;

/*                    C := alpha*C, scale the rectangular block of C */
/*                    with alpha. */

			if (alpha->r != 1. || alpha->i != 0.) {
			    zgemm_(transa, "N", &isec, n, &c__0, &c_b1, &a[
				    a_offset], lda, &c__[c_offset], ldc, 
				    alpha, &c__[ii + c_dim1], ldc, (ftnlen)1, 
				    (ftnlen)1);
			}
			if (tinyn) {

/*                       C := A'*C  or  C := conjg( A' )*C, triangular */
/*                       matrix multiply involving a lower triangular */
/*                       diagonal block of A. */

			    i__2 = *n;
			    for (j = 1; j <= i__2; ++j) {
				ztrmv_("L", transa, diag, &isec, &a[ii + ii * 
					a_dim1], lda, &c__[ii + j * c_dim1], &
					c__1, (ftnlen)1, (ftnlen)1, (ftnlen)1)
					;
/* L360: */
			    }
			} else {

/*                       T3 :=  A, a lower unit or non-unit triangular */
/*                       diagonal block of A is copied to part of T3. */

			    i__2 = ii + isec - 1 - offd;
			    for (i__ = ii; i__ <= i__2; ++i__) {
				i__3 = ii + isec - i__ - offd;
				zcopy_(&i__3, &a[i__ + offd + i__ * a_dim1], &
					c__1, &t3[i__ - ii + 1 + offd + (i__ 
					- ii + 1) * 44 - 45], &c__1);
/* L370: */
			    }

/*                       C := T3'*C  or  C := conjg( T3' )*C, triangular */
/*                       matrix multiply involving a upper triangular */
/*                       diagonal block of A stored in T3. */

			    i__2 = *n;
			    for (j = 1; j <= i__2; ++j) {
				ztrmv_("L", transa, diag, &isec, t3, &c__44, &
					c__[ii + j * c_dim1], &c__1, (ftnlen)
					1, (ftnlen)1, (ftnlen)1);
/* L380: */
			    }
			}

/*                    C := alpha*A'*C + C or */
/*                    C := alpha*conjg( A' )*C + C, matrix multiply */
/*                    involving the transpose of a rectangular block */
/*                    of A. */

			if (ii + isec <= *m) {
			    i__2 = *m - ii - isec + 1;
			    zgemm_(transa, "N", &isec, n, &i__2, alpha, &a[ii 
				    + isec + ii * a_dim1], lda, &c__[ii + 
				    isec + c_dim1], ldc, &c_b2, &c__[ii + 
				    c_dim1], ldc, (ftnlen)1, (ftnlen)1);
			}
/* L390: */
		    }
		} else {
		    delta.r = alpha->r, delta.i = alpha->i;
		    cldc = zcld_(ldc);
		    i__1 = *m;
		    for (ix = (*m - 1) % 44 + 1; ix <= i__1; ix += 44) {
/* Computing MAX */
			i__2 = 1, i__3 = ix - 43;
			ii = max(i__2,i__3);
			isec = ix - ii + 1;

/*                    T2 := A or T2 := conjg( A ), a unit or non-unit */
/*                    lower triangular diagonal block of A is copied to */
/*                    the lower triangular part of T2. */

			if (noconj) {
			    i__2 = ii + isec - 1 - offd;
			    for (j = ii; j <= i__2; ++j) {
				i__3 = ii + isec - j - offd;
				zcopy_(&i__3, &a[j + offd + j * a_dim1], &
					c__1, &t2[j - ii + 1 + offd + (j - ii 
					+ 1) * 44 - 45], &c__1);
/* L400: */
			    }
			} else {
			    i__2 = ii + isec - 1 - offd;
			    for (j = ii; j <= i__2; ++j) {
				i__3 = ii + isec - 1;
				for (i__ = j + offd; i__ <= i__3; ++i__) {
				    i__4 = i__ - ii + 1 + (j - ii + 1) * 44 - 
					    45;
				    d_cnjg(&z__1, &a[i__ + j * a_dim1]);
				    t2[i__4].r = z__1.r, t2[i__4].i = z__1.i;
/* L410: */
				}
/* L420: */
			    }
			}
			i__2 = *n;
			for (jj = 1; jj <= i__2; jj += 44) {
/* Computing MIN */
			    i__3 = 44, i__4 = *n - jj + 1;
			    jsec = min(i__3,i__4);

/*                       T1 := C', the transpose of a rectangular block */
/*                       of C is copied to T1. */

			    if (cldc) {
				i__3 = jj + jsec - 1;
				for (j = jj; j <= i__3; ++j) {
				    zcopy_(&isec, &c__[ii + j * c_dim1], &
					    c__1, &t1[j - jj], &c__44);
/* L430: */
				}
			    } else {
				i__3 = ii + isec - 1;
				for (i__ = ii; i__ <= i__3; ++i__) {
				    zcopy_(&jsec, &c__[i__ + jj * c_dim1], 
					    ldc, &t1[(i__ - ii + 1) * 44 - 44]
					    , &c__1);
/* L440: */
				}
			    }

/*                       T1 := gamma*T1*A + delta*T1, triangular matrix */
/*                       multiply where the value of delta depends on */
/*                       whether A is a unit or non-unit triangular */
/*                       matrix. Gamma and tsec are used to compensate */
/*                       for a deficiency in ZGEMV that appears if the */
/*                       second dimension (tsec) is zero. */

			    i__3 = ii + isec - 1;
			    for (i__ = ii; i__ <= i__3; ++i__) {
				if (nounit) {
				    i__4 = i__ - ii + 1 + (i__ - ii + 1) * 44 
					    - 45;
				    z__1.r = alpha->r * t2[i__4].r - alpha->i 
					    * t2[i__4].i, z__1.i = alpha->r * 
					    t2[i__4].i + alpha->i * t2[i__4]
					    .r;
				    delta.r = z__1.r, delta.i = z__1.i;
				}
				gamma.r = alpha->r, gamma.i = alpha->i;
				tsec = ii + isec - 1 - i__;
				if (tsec == 0) {
				    tsec = 1;
				    gamma.r = 0., gamma.i = 0.;
				}
				zgemv_("N", &jsec, &tsec, &gamma, &t1[(i__ - 
					ii + 2) * 44 - 44], &c__44, &t2[i__ - 
					ii + 2 + (i__ - ii + 1) * 44 - 45], &
					c__1, &delta, &t1[(i__ - ii + 1) * 44 
					- 44], &c__1, (ftnlen)1);
/* L450: */
			    }

/*                       C := T1', the transpose of T1 is copied back */
/*                       to C. */

			    i__3 = jj + jsec - 1;
			    for (j = jj; j <= i__3; ++j) {
				zcopy_(&isec, &t1[j - jj], &c__44, &c__[ii + 
					j * c_dim1], &c__1);
/* L460: */
			    }
/* L470: */
			}

/*                    C := alpha*A'*C + C or */
/*                    C := alpha*conjg( A' )*C + C, matrix multiply */
/*                    involving the transpose of a rectangular block */
/*                    of A. */

			if (ii + isec <= *m) {
			    i__2 = *m - ii - isec + 1;
			    zgemm_(transa, "N", &isec, n, &i__2, alpha, &a[ii 
				    + isec + ii * a_dim1], lda, &c__[ii + 
				    isec + c_dim1], ldc, &c_b2, &c__[ii + 
				    c_dim1], ldc, (ftnlen)1, (ftnlen)1);
			}
/* L480: */
		    }
		}
	    }
	}
    } else {
	if (upper) {
	    if (notr) {

/*              Form  C := alpha*C*A. Right, Upper, No transpose. */

		tinym = ! zbigp_(&c__83, m, n);
		if (tinym) {
		    for (jj = *n - (*n - 1) % 44; jj >= 1; jj += -44) {
/* Computing MIN */
			i__1 = 44, i__2 = *n - jj + 1;
			jsec = min(i__1,i__2);

/*                    C := alpha*C, scale the rectangular block of C */
/*                    with alpha. */

			if (alpha->r != 1. || alpha->i != 0.) {
			    zgemm_("N", "N", m, &jsec, &c__0, &c_b1, &c__[
				    c_offset], ldc, &a[a_offset], lda, alpha, 
				    &c__[jj * c_dim1 + 1], ldc, (ftnlen)1, (
				    ftnlen)1);
			}

/*                    C := C*A, triangular matrix multiply involving a */
/*                    upper triangular diagonal block of A. */

			i__1 = *m;
			for (i__ = 1; i__ <= i__1; ++i__) {
			    ztrmv_("U", "T", diag, &jsec, &a[jj + jj * a_dim1]
				    , lda, &c__[i__ + jj * c_dim1], ldc, (
				    ftnlen)1, (ftnlen)1, (ftnlen)1);
/* L490: */
			}

/*                    C := alpha*C*A + C, general matrix multiply */
/*                    involving a rectangular block of A. */

			if (jj > 1) {
			    i__1 = jj - 1;
			    zgemm_("N", "N", m, &jsec, &i__1, alpha, &c__[
				    c_dim1 + 1], ldc, &a[jj * a_dim1 + 1], 
				    lda, &c_b2, &c__[jj * c_dim1 + 1], ldc, (
				    ftnlen)1, (ftnlen)1);
			}
/* L500: */
		    }
		} else {
		    delta.r = alpha->r, delta.i = alpha->i;
		    for (jj = *n - (*n - 1) % 44; jj >= 1; jj += -44) {
/* Computing MIN */
			i__1 = 44, i__2 = *n - jj + 1;
			jsec = min(i__1,i__2);
			i__1 = *m;
			for (ii = 1; ii <= i__1; ii += 44) {
/* Computing MIN */
			    i__2 = 44, i__3 = *m - ii + 1;
			    isec = min(i__2,i__3);

/*                       T1 := C, a rectangular block of C is copied */
/*                       to T1. */

			    i__2 = jj + jsec - 1;
			    for (j = jj; j <= i__2; ++j) {
				zcopy_(&isec, &c__[ii + j * c_dim1], &c__1, &
					t1[(j - jj + 1) * 44 - 44], &c__1);
/* L510: */
			    }

/*                       C := gamma*T1*A + delta*C, triangular matrix */
/*                       multiply where the value of delta depends on */
/*                       whether A is a unit or non-unit triangular */
/*                       matrix. Gamma and tsec are used to compensate */
/*                       for a deficiency in ZGEMV that appears if the */
/*                       second dimension (tsec) is zero. */

			    i__2 = jj;
			    for (j = jj + jsec - 1; j >= i__2; --j) {
				if (nounit) {
				    i__3 = j + j * a_dim1;
				    z__1.r = alpha->r * a[i__3].r - alpha->i *
					     a[i__3].i, z__1.i = alpha->r * a[
					    i__3].i + alpha->i * a[i__3].r;
				    delta.r = z__1.r, delta.i = z__1.i;
				}
				gamma.r = alpha->r, gamma.i = alpha->i;
				tsec = j - jj;
				if (tsec == 0) {
				    tsec = 1;
				    gamma.r = 0., gamma.i = 0.;
				}
				zgemv_("N", &isec, &tsec, &gamma, t1, &c__44, 
					&a[jj + j * a_dim1], &c__1, &delta, &
					c__[ii + j * c_dim1], &c__1, (ftnlen)
					1);
/* L520: */
			    }
/* L530: */
			}

/*                    C := alpha*C*A + C, general matrix multiply */
/*                    involving a rectangular block of A. */

			if (jj > 1) {
			    i__1 = jj - 1;
			    zgemm_("N", "N", m, &jsec, &i__1, alpha, &c__[
				    c_dim1 + 1], ldc, &a[jj * a_dim1 + 1], 
				    lda, &c_b2, &c__[jj * c_dim1 + 1], ldc, (
				    ftnlen)1, (ftnlen)1);
			}
/* L540: */
		    }
		}
	    } else {

/*              Form  C := alpha*C*A' or  C := alpha*C*conjg( A' ). */
/*              Right, Upper, Transpose or Conjugated transpose. */

		tinym = ! zbigp_(&c__83, m, n);
		if (tinym) {
		    i__1 = *n;
		    for (jj = 1; jj <= i__1; jj += 44) {
/* Computing MIN */
			i__2 = 44, i__3 = *n - jj + 1;
			jsec = min(i__2,i__3);

/*                    C := alpha*C, scale the rectangular block of C */
/*                    with alpha. */

			if (alpha->r != 1. || alpha->i != 0.) {
			    zgemm_("N", transa, m, &jsec, &c__0, &c_b1, &c__[
				    c_offset], ldc, &a[a_offset], lda, alpha, 
				    &c__[jj * c_dim1 + 1], ldc, (ftnlen)1, (
				    ftnlen)1);
			}

/*                    T3 := A', the transpose of a upper unit or non-unit */
/*                    triangular diagonal block of A is copied to the */
/*                    lower triangular part of T3. */

			i__2 = jj + jsec - 1;
			for (j = jj + offd; j <= i__2; ++j) {
			    i__3 = j - jj + 1 - offd;
			    zcopy_(&i__3, &a[jj + j * a_dim1], &c__1, &t3[j - 
				    jj], &c__44);
/* L550: */
			}

/*                    C := C*T3' or C := C*conjg( T3' ), triangular */
/*                    matrix multiply involving a upper triangular */
/*                    diagonal block of T3. */

			i__2 = *m;
			for (i__ = 1; i__ <= i__2; ++i__) {
			    ztrmv_("L", transa, diag, &jsec, t3, &c__44, &c__[
				    i__ + jj * c_dim1], ldc, (ftnlen)1, (
				    ftnlen)1, (ftnlen)1);
/* L560: */
			}

/*                    C := alpha*C*A' + C or */
/*                    C := alpha*C*conjg( A' ) + C, matrix multiply */
/*                    involving the transpose of a rectangular block */
/*                    of A. */

			if (jj + jsec <= *n) {
			    i__2 = *n - jj - jsec + 1;
			    zgemm_("N", transa, m, &jsec, &i__2, alpha, &c__[(
				    jj + jsec) * c_dim1 + 1], ldc, &a[jj + (
				    jj + jsec) * a_dim1], lda, &c_b2, &c__[jj 
				    * c_dim1 + 1], ldc, (ftnlen)1, (ftnlen)1);
			}
/* L570: */
		    }
		} else {
		    delta.r = alpha->r, delta.i = alpha->i;
		    i__1 = *n;
		    for (jj = 1; jj <= i__1; jj += 44) {
/* Computing MIN */
			i__2 = 44, i__3 = *n - jj + 1;
			jsec = min(i__2,i__3);

/*                    T2 := A' or T2 := conjg( A' ), the transpose of a */
/*                    unit or non-unit upper triangular diagonal block of */
/*                    A is copied to the lower triangular part of T2. */

			if (noconj) {
			    i__2 = jj + jsec - 1;
			    for (j = jj + offd; j <= i__2; ++j) {
				i__3 = j - jj + 1 - offd;
				zcopy_(&i__3, &a[jj + j * a_dim1], &c__1, &t2[
					j - jj], &c__44);
/* L580: */
			    }
			} else {
			    i__2 = jj + jsec - 1;
			    for (j = jj + offd; j <= i__2; ++j) {
				i__3 = j - offd;
				for (i__ = jj; i__ <= i__3; ++i__) {
				    i__4 = j - jj + 1 + (i__ - jj + 1) * 44 - 
					    45;
				    d_cnjg(&z__1, &a[i__ + j * a_dim1]);
				    t2[i__4].r = z__1.r, t2[i__4].i = z__1.i;
/* L590: */
				}
/* L600: */
			    }
			}
			i__2 = *m;
			for (ii = 1; ii <= i__2; ii += 44) {
/* Computing MIN */
			    i__3 = 44, i__4 = *m - ii + 1;
			    isec = min(i__3,i__4);

/*                       T1 := C, a rectangular block of C is copied */
/*                       to T1. */

			    i__3 = jj + jsec - 1;
			    for (j = jj; j <= i__3; ++j) {
				zcopy_(&isec, &c__[ii + j * c_dim1], &c__1, &
					t1[(j - jj + 1) * 44 - 44], &c__1);
/* L610: */
			    }

/*                       C := gamma*T1*T2 + delta*C, triangular matrix */
/*                       multiply where the value of delta depends on */
/*                       whether T2 is a unit or non-unit triangular */
/*                       matrix. Gamma and tsec are used to compensate */
/*                       for a deficiency in ZGEMV that appears if the */
/*                       second dimension (tsec) is zero. */

			    i__3 = jj + jsec - 1;
			    for (j = jj; j <= i__3; ++j) {
				if (nounit) {
				    i__4 = j - jj + 1 + (j - jj + 1) * 44 - 
					    45;
				    z__1.r = alpha->r * t2[i__4].r - alpha->i 
					    * t2[i__4].i, z__1.i = alpha->r * 
					    t2[i__4].i + alpha->i * t2[i__4]
					    .r;
				    delta.r = z__1.r, delta.i = z__1.i;
				}
				gamma.r = alpha->r, gamma.i = alpha->i;
				tsec = jj + jsec - 1 - j;
				if (tsec == 0) {
				    tsec = 1;
				    gamma.r = 0., gamma.i = 0.;
				}
				zgemv_("N", &isec, &tsec, &gamma, &t1[(j - jj 
					+ 2) * 44 - 44], &c__44, &t2[j - jj + 
					2 + (j - jj + 1) * 44 - 45], &c__1, &
					delta, &c__[ii + j * c_dim1], &c__1, (
					ftnlen)1);
/* L620: */
			    }
/* L630: */
			}

/*                    C := alpha*C*A' + C or */
/*                    C := alpha*C*conjg( A' ) + C, matrix multiply */
/*                    involving the transpose of a rectangular block */
/*                    of A. */

			if (jj + jsec <= *n) {
			    i__2 = *n - jj - jsec + 1;
			    zgemm_("N", transa, m, &jsec, &i__2, alpha, &c__[(
				    jj + jsec) * c_dim1 + 1], ldc, &a[jj + (
				    jj + jsec) * a_dim1], lda, &c_b2, &c__[jj 
				    * c_dim1 + 1], ldc, (ftnlen)1, (ftnlen)1);
			}
/* L640: */
		    }
		}
	    }
	} else {
	    if (notr) {

/*              Form  C := alpha*C*A. Right, Lower, No transpose. */

		tinym = ! zbigp_(&c__83, m, n);
		if (tinym) {
		    i__1 = *n;
		    for (jx = (*n - 1) % 44 + 1; jx <= i__1; jx += 44) {
/* Computing MAX */
			i__2 = 1, i__3 = jx - 43;
			jj = max(i__2,i__3);
			jsec = jx - jj + 1;

/*                    C := alpha*C, scale the rectangular block of C */
/*                    with alpha. */

			if (alpha->r != 1. || alpha->i != 0.) {
			    zgemm_("N", "N", m, &jsec, &c__0, &c_b1, &c__[
				    c_offset], ldc, &a[a_offset], lda, alpha, 
				    &c__[jj * c_dim1 + 1], ldc, (ftnlen)1, (
				    ftnlen)1);
			}

/*                    C := C*A, triangular matrix multiply involving a */
/*                    lower triangular diagonal block of A. */

			i__2 = *m;
			for (i__ = 1; i__ <= i__2; ++i__) {
			    ztrmv_("L", "T", diag, &jsec, &a[jj + jj * a_dim1]
				    , lda, &c__[i__ + jj * c_dim1], ldc, (
				    ftnlen)1, (ftnlen)1, (ftnlen)1);
/* L650: */
			}

/*                    C := alpha*C*A + C, general matrix multiply */
/*                    involving a rectangular block of A. */

			if (jj + jsec <= *n) {
			    i__2 = *n - jj - jsec + 1;
			    zgemm_("N", "N", m, &jsec, &i__2, alpha, &c__[(jj 
				    + jsec) * c_dim1 + 1], ldc, &a[jj + jsec 
				    + jj * a_dim1], lda, &c_b2, &c__[jj * 
				    c_dim1 + 1], ldc, (ftnlen)1, (ftnlen)1);
			}
/* L660: */
		    }
		} else {
		    delta.r = alpha->r, delta.i = alpha->i;
		    i__1 = *n;
		    for (jx = (*n - 1) % 44 + 1; jx <= i__1; jx += 44) {
/* Computing MAX */
			i__2 = 1, i__3 = jx - 43;
			jj = max(i__2,i__3);
			jsec = jx - jj + 1;
			i__2 = *m;
			for (ii = 1; ii <= i__2; ii += 44) {
/* Computing MIN */
			    i__3 = 44, i__4 = *m - ii + 1;
			    isec = min(i__3,i__4);

/*                       T1 := C, a rectangular block of C is copied */
/*                       to T1. */

			    i__3 = jj + jsec - 1;
			    for (j = jj; j <= i__3; ++j) {
				zcopy_(&isec, &c__[ii + j * c_dim1], &c__1, &
					t1[(j - jj + 1) * 44 - 44], &c__1);
/* L670: */
			    }

/*                       C := gamma*T1*A + delta*C, triangular matrix */
/*                       multiply where the value of delta depends on */
/*                       whether A is a unit or non-unit triangular */
/*                       matrix. Gamma and tsec are used to compensate */
/*                       for a deficiency in ZGEMV that appears if the */
/*                       second dimension (tsec) is zero. */

			    i__3 = jj + jsec - 1;
			    for (j = jj; j <= i__3; ++j) {
				if (nounit) {
				    i__4 = j + j * a_dim1;
				    z__1.r = alpha->r * a[i__4].r - alpha->i *
					     a[i__4].i, z__1.i = alpha->r * a[
					    i__4].i + alpha->i * a[i__4].r;
				    delta.r = z__1.r, delta.i = z__1.i;
				}
				gamma.r = alpha->r, gamma.i = alpha->i;
				tsec = jj + jsec - 1 - j;
				if (tsec == 0) {
				    tsec = 1;
				    gamma.r = 0., gamma.i = 0.;
				}
				zgemv_("N", &isec, &tsec, &gamma, &t1[(j - jj 
					+ 2) * 44 - 44], &c__44, &a[j + 1 + j 
					* a_dim1], &c__1, &delta, &c__[ii + j 
					* c_dim1], &c__1, (ftnlen)1);
/* L680: */
			    }
/* L690: */
			}

/*                    C := alpha*C*A + C, general matrix multiply */
/*                    involving a rectangular block of A. */

			if (jj + jsec <= *n) {
			    i__2 = *n - jj - jsec + 1;
			    zgemm_("N", "N", m, &jsec, &i__2, alpha, &c__[(jj 
				    + jsec) * c_dim1 + 1], ldc, &a[jj + jsec 
				    + jj * a_dim1], lda, &c_b2, &c__[jj * 
				    c_dim1 + 1], ldc, (ftnlen)1, (ftnlen)1);
			}
/* L700: */
		    }
		}
	    } else {

/*              Form  C := alpha*C*A'. Right, Lower, Transpose. */

		tinym = ! zbigp_(&c__83, m, n);
		if (tinym) {
		    for (jx = *n; jx >= 1; jx += -44) {
/* Computing MAX */
			i__1 = 1, i__2 = jx - 43;
			jj = max(i__1,i__2);
			jsec = jx - jj + 1;

/*                    C := alpha*C, scale the rectangular block of C */
/*                    with alpha. */

			if (alpha->r != 1. || alpha->i != 0.) {
			    zgemm_("N", transa, m, &jsec, &c__0, &c_b1, &c__[
				    c_offset], ldc, &a[a_offset], lda, alpha, 
				    &c__[jj * c_dim1 + 1], ldc, (ftnlen)1, (
				    ftnlen)1);
			}

/*                    T3 := A', the transpose of a lower unit or non-unit */
/*                    triangular diagonal block of A is copied to the */
/*                    upper triangular part of T3. */

			i__1 = jj + jsec - 1 - offd;
			for (j = jj; j <= i__1; ++j) {
			    i__2 = jj + jsec - j - offd;
			    zcopy_(&i__2, &a[j + offd + j * a_dim1], &c__1, &
				    t3[j - jj + 1 + (j - jj + 1 + offd) * 44 
				    - 45], &c__44);
/* L710: */
			}

/*                    C := C*T3' or C := C*conjg( T3' ), triangular */
/*                    matrix multiply involving a lower triangular */
/*                    diagonal block of T3. */

			i__1 = *m;
			for (i__ = 1; i__ <= i__1; ++i__) {
			    ztrmv_("U", transa, diag, &jsec, t3, &c__44, &c__[
				    i__ + jj * c_dim1], ldc, (ftnlen)1, (
				    ftnlen)1, (ftnlen)1);
/* L720: */
			}

/*                    C := C*T3' or C := C*conjg( T3' ), triangular */
/*                    matrix multiply involving a lower triangular */
/*                    diagonal block of T3. */

			if (jj > 1) {
			    i__1 = jj - 1;
			    zgemm_("N", transa, m, &jsec, &i__1, alpha, &c__[
				    c_dim1 + 1], ldc, &a[jj + a_dim1], lda, &
				    c_b2, &c__[jj * c_dim1 + 1], ldc, (ftnlen)
				    1, (ftnlen)1);
			}
/* L730: */
		    }
		} else {
		    delta.r = alpha->r, delta.i = alpha->i;
		    for (jx = *n; jx >= 1; jx += -44) {
/* Computing MAX */
			i__1 = 1, i__2 = jx - 43;
			jj = max(i__1,i__2);
			jsec = jx - jj + 1;

/*                    T2 := A' or T2 := conjg( A' ), the transpose of a */
/*                    unit or non-unit lower triangular diagonal block of */
/*                    A is copied to the lower triangular part of T2. */

			if (noconj) {
			    i__1 = jj + jsec - 1 - offd;
			    for (j = jj; j <= i__1; ++j) {
				i__2 = jj + jsec - j - offd;
				zcopy_(&i__2, &a[j + offd + j * a_dim1], &
					c__1, &t2[j - jj + 1 + (j - jj + 1 + 
					offd) * 44 - 45], &c__44);
/* L740: */
			    }
			} else {
			    i__1 = jj + jsec - 1 - offd;
			    for (j = jj; j <= i__1; ++j) {
				i__2 = jj + jsec - 1;
				for (i__ = j + offd; i__ <= i__2; ++i__) {
				    i__3 = j - jj + 1 + (i__ - jj + 1) * 44 - 
					    45;
				    d_cnjg(&z__1, &a[i__ + j * a_dim1]);
				    t2[i__3].r = z__1.r, t2[i__3].i = z__1.i;
/* L750: */
				}
/* L760: */
			    }
			}
			i__1 = *m;
			for (ii = 1; ii <= i__1; ii += 44) {
/* Computing MIN */
			    i__2 = 44, i__3 = *m - ii + 1;
			    isec = min(i__2,i__3);

/*                       T1 := C, a rectangular block of C is copied */
/*                       to T1. */

			    i__2 = jj + jsec - 1;
			    for (j = jj; j <= i__2; ++j) {
				zcopy_(&isec, &c__[ii + j * c_dim1], &c__1, &
					t1[(j - jj + 1) * 44 - 44], &c__1);
/* L770: */
			    }

/*                       C := gamma*T1*T2 + delta*C, triangular matrix */
/*                       multiply where the value of delta depends on */
/*                       whether T2 is a unit or non-unit triangular */
/*                       matrix. Gamma and tsec are used to compensate */
/*                       for a deficiency in ZGEMV that appears if the */
/*                       second dimension (tsec) is zero. */

			    i__2 = jj;
			    for (j = jj + jsec - 1; j >= i__2; --j) {
				if (nounit) {
				    i__3 = j - jj + 1 + (j - jj + 1) * 44 - 
					    45;
				    z__1.r = alpha->r * t2[i__3].r - alpha->i 
					    * t2[i__3].i, z__1.i = alpha->r * 
					    t2[i__3].i + alpha->i * t2[i__3]
					    .r;
				    delta.r = z__1.r, delta.i = z__1.i;
				}
				gamma.r = alpha->r, gamma.i = alpha->i;
				tsec = j - jj;
				if (tsec == 0) {
				    tsec = 1;
				    gamma.r = 0., gamma.i = 0.;
				}
				zgemv_("N", &isec, &tsec, &gamma, t1, &c__44, 
					&t2[(j - jj + 1) * 44 - 44], &c__1, &
					delta, &c__[ii + j * c_dim1], &c__1, (
					ftnlen)1);
/* L780: */
			    }
/* L790: */
			}

/*                    C := alpha*C*A' + C or */
/*                    C := alpha*C*conjg( A' ) + C, matrix multiply */
/*                    involving the transpose of a rectangular block */
/*                    of A. */

			if (jj > 1) {
			    i__1 = jj - 1;
			    zgemm_("N", transa, m, &jsec, &i__1, alpha, &c__[
				    c_dim1 + 1], ldc, &a[jj + a_dim1], lda, &
				    c_b2, &c__[jj * c_dim1 + 1], ldc, (ftnlen)
				    1, (ftnlen)1);
			}
/* L800: */
		    }
		}
	    }
	}
    }

    return 0;

/*     End of ZTRMM. */

} /* ztrmm_ */

