/* zhemm.f -- translated by f2c (version 20030320).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

#include "f2cblas.h"

/* Table of constant values */


/* Subroutine */ int zhemm_(char *side, char *uplo, integer *m, integer *n, 
	doublecomplex *alpha, doublecomplex *a, integer *lda, doublecomplex *
	b, integer *ldb, doublecomplex *beta, doublecomplex *c__, integer *
	ldc, ftnlen side_len, ftnlen uplo_len)
{
doublecomplex c_b1 = {0.,0.};
doublecomplex c_b2 = {1.,0.};
integer c__0 = 0;
integer c__1 = 1;
integer c__80 = 80;
    /* System generated locals */
    integer a_dim1, a_offset, b_dim1, b_offset, c_dim1, c_offset, i__1, i__2, 
	    i__3, i__4, i__5;
    doublereal d__1;
    doublecomplex z__1;

    /* Builtin functions */
    void d_cnjg(doublecomplex *, doublecomplex *);

    /* Local variables */
    integer i__, j;
    doublecomplex t1[6400]	/* was [80][80] */;
    integer ii, jj, ix, jx, isec, jsec, info;
    logical lside;
    
    extern /* Subroutine */ int zgemm_(char *, char *, integer *, integer *, 
	    integer *, doublecomplex *, doublecomplex *, integer *, 
	    doublecomplex *, integer *, doublecomplex *, doublecomplex *, 
	    integer *, ftnlen, ftnlen);
    integer nrowa;
    logical upper;
    extern /* Subroutine */ int zcopy_(integer *, doublecomplex *, integer *, 
	    doublecomplex *, integer *);

/*     .. Scalar Arguments .. */
/*     .. Array Arguments .. */
/*     .. */

/*  Purpose */
/*  ======= */

/*  ZHEMM  performs one of the matrix-matrix operations */

/*     C := alpha*A*B + beta*C, */

/*  or */

/*     C := alpha*B*A + beta*C, */

/*  where alpha and beta are scalars, A is an hermitian matrix and  B and */
/*  C are m by n matrices. */

/*  Parameters */
/*  ========== */

/*  SIDE   - CHARACTER*1. */
/*           On entry,  SIDE  specifies whether  the  hermitian matrix  A */
/*           appears on the  left or right  in the  operation as follows: */

/*              SIDE = 'L' or 'l'   C := alpha*A*B + beta*C, */

/*              SIDE = 'R' or 'r'   C := alpha*B*A + beta*C, */

/*           Unchanged on exit. */

/*  UPLO   - CHARACTER*1. */
/*           On  entry,   UPLO  specifies  whether  the  upper  or  lower */
/*           triangular  part  of  the  hermitian  matrix   A  is  to  be */
/*           referenced as follows: */

/*              UPLO = 'U' or 'u'   Only the upper triangular part of the */
/*                                  hermitian matrix is to be referenced. */

/*              UPLO = 'L' or 'l'   Only the lower triangular part of the */
/*                                  hermitian matrix is to be referenced. */

/*           Unchanged on exit. */

/*  M      - INTEGER. */
/*           On entry,  M  specifies the number of rows of the matrix  C. */
/*           M  must be at least zero. */
/*           Unchanged on exit. */

/*  N      - INTEGER. */
/*           On entry, N specifies the number of columns of the matrix C. */
/*           N  must be at least zero. */
/*           Unchanged on exit. */

/*  ALPHA  - COMPLEX*16      . */
/*           On entry, ALPHA specifies the scalar alpha. */
/*           Unchanged on exit. */

/*  A      - COMPLEX*16       array of DIMENSION ( LDA, ka ), where ka is */
/*           m  when  SIDE = 'L' or 'l'  and is n  otherwise. */
/*           Before entry  with  SIDE = 'L' or 'l',  the  m by m  part of */
/*           the array  A  must contain the  hermitian matrix,  such that */
/*           when  UPLO = 'U' or 'u', the leading m by m upper triangular */
/*           part of the array  A  must contain the upper triangular part */
/*           of the  hermitian matrix and the  strictly  lower triangular */
/*           part of  A  is not referenced,  and when  UPLO = 'L' or 'l', */
/*           the leading  m by m  lower triangular part  of the  array  A */
/*           must  contain  the  lower triangular part  of the  hermitian */
/*           matrix and the  strictly upper triangular part of  A  is not */
/*           referenced. */
/*           Before entry  with  SIDE = 'R' or 'r',  the  n by n  part of */
/*           the array  A  must contain the  hermitian matrix,  such that */
/*           when  UPLO = 'U' or 'u', the leading n by n upper triangular */
/*           part of the array  A  must contain the upper triangular part */
/*           of the  hermitian matrix and the  strictly  lower triangular */
/*           part of  A  is not referenced,  and when  UPLO = 'L' or 'l', */
/*           the leading  n by n  lower triangular part  of the  array  A */
/*           must  contain  the  lower triangular part  of the  hermitian */
/*           matrix and the  strictly upper triangular part of  A  is not */
/*           referenced. */
/*           Note that the imaginary parts  of the diagonal elements need */
/*           not be set, they are assumed to be zero. */
/*           Unchanged on exit. */

/*  LDA    - INTEGER. */
/*           On entry, LDA specifies the first dimension of A as declared */
/*           in the  calling (sub) program. When  SIDE = 'L' or 'l'  then */
/*           LDA must be at least  max( 1, m ), otherwise  LDA must be at */
/*           least max( 1, n ). */
/*           Unchanged on exit. */

/*  B      - COMPLEX*16       array of DIMENSION ( LDB, n ). */
/*           Before entry, the leading  m by n part of the array  B  must */
/*           contain the matrix B. */
/*           Unchanged on exit. */

/*  LDB    - INTEGER. */
/*           On entry, LDB specifies the first dimension of B as declared */
/*           in  the  calling  (sub)  program.   LDB  must  be  at  least */
/*           max( 1, m ). */
/*           Unchanged on exit. */

/*  BETA   - COMPLEX*16      . */
/*           On entry,  BETA  specifies the scalar  beta.  When  BETA  is */
/*           supplied as zero then C need not be set on input. */
/*           Unchanged on exit. */

/*  C      - COMPLEX*16       array of DIMENSION ( LDC, n ). */
/*           Before entry, the leading  m by n  part of the array  C must */
/*           contain the matrix  C,  except when  beta  is zero, in which */
/*           case C need not be set on entry. */
/*           On exit, the array  C  is overwritten by the  m by n updated */
/*           matrix. */

/*  LDC    - INTEGER. */
/*           On entry, LDC specifies the first dimension of C as declared */
/*           in  the  calling  (sub)  program.   LDC  must  be  at  least */
/*           max( 1, m ). */
/*           Unchanged on exit. */


/*  Level 3 Blas routine. */

/*  -- Written on 8-February-1989. */
/*     Jack Dongarra, Argonne National Laboratory. */
/*     Iain Duff, AERE Harwell. */
/*     Jeremy Du Croz, Numerical Algorithms Group Ltd. */
/*     Sven Hammarling, Numerical Algorithms Group Ltd. */

/*  -- Rewritten in May-1994. */
/*     GEMM-Based Level 3 BLAS. */
/*     Per Ling, Institute of Information Processing, */
/*     University of Umea, Sweden. */


/*     .. Local Scalars .. */
/*     .. Intrinsic Functions .. */
/*     .. External Functions .. */
/*     .. External Subroutines .. */
/*     .. Parameters .. */
/*     .. User specified parameters for ZHEMM .. */
/*     .. Local Arrays .. */
/*     .. */
/*     .. Executable Statements .. */

/*     Test the input parameters. */

    /* Parameter adjustments */
    a_dim1 = *lda;
    a_offset = 1 + a_dim1;
    a -= a_offset;
    b_dim1 = *ldb;
    b_offset = 1 + b_dim1;
    b -= b_offset;
    c_dim1 = *ldc;
    c_offset = 1 + c_dim1;
    c__ -= c_offset;

    /* Function Body */
    lside = (side[0]=='L'?1:0);
    upper = (uplo[0]=='U'?1:0);
    if (lside) {
	nrowa = *m;
    } else {
	nrowa = *n;
    }
    info = 0;
    if (! lside && ! (side[0]=='R'?1:0)) {
	info = 1;
    } else if (! upper && ! (uplo[0]=='L'?1:0)) {
	info = 2;
    } else if (*m < 0) {
	info = 3;
    } else if (*n < 0) {
	info = 4;
    } else if (*lda < max(1,nrowa)) {
	info = 7;
    } else if (*ldb < max(1,*m)) {
	info = 9;
    } else if (*ldc < max(1,*m)) {
	info = 12;
    }
    if (info != 0) {
	xerbla_("ZHEMM ", &info, (ftnlen)6);
	return 0;
    }

/*     Quick return if possible. */

    if (*m == 0 || *n == 0 || alpha->r == 0. && alpha->i == 0. && (beta->r == 
	    1. && beta->i == 0.)) {
	return 0;
    }

/*     And when alpha.eq.zero. */

    if (alpha->r == 0. && alpha->i == 0.) {
	i__1 = max(*lda,*ldb);
	i__2 = max(*lda,*ldb);
	zgemm_("N", "N", m, n, &c__0, &c_b1, &a[a_offset], &i__1, &b[b_offset]
		, &i__2, beta, &c__[c_offset], ldc, (ftnlen)1, (ftnlen)1);
	return 0;
    }

/*     Start the operations. */

    if (lside) {
	if (upper) {

/*           Form  C := alpha*A*B + beta*C. Left, Upper. */

	    i__1 = *m;
	    for (ii = 1; ii <= i__1; ii += 80) {
/* Computing MIN */
		i__2 = 80, i__3 = *m - ii + 1;
		isec = min(i__2,i__3);

/*              T1 := A, a upper triangular diagonal block of A is copied */
/*              to the upper triangular part of T1. */

		i__2 = ii + isec - 1;
		for (i__ = ii; i__ <= i__2; ++i__) {
		    i__3 = i__ - ii + 1;
		    zcopy_(&i__3, &a[ii + i__ * a_dim1], &c__1, &t1[(i__ - ii 
			    + 1) * 80 - 80], &c__1);
/* L10: */
		}

/*              Set the imaginary part of diagonal elements of T1 */
/*              to zero. */

		i__2 = isec;
		for (i__ = 1; i__ <= i__2; ++i__) {
		    i__3 = i__ + i__ * 80 - 81;
		    i__4 = i__ + i__ * 80 - 81;
		    d__1 = t1[i__4].r;
		    z__1.r = d__1, z__1.i = 0.;
		    t1[i__3].r = z__1.r, t1[i__3].i = z__1.i;
/* L20: */
		}

/*              T1 :=  conjg( A' ), the conjugated transpose of a */
/*              strictly upper triangular diagonal block of A is copied */
/*              to the strictly lower triangular part of T1. Notice that */
/*              T1 is referenced by row and that the maximum length of a */
/*              vector referenced is CB. */

		i__2 = ii + isec - 1;
		for (jj = ii; jj <= i__2; jj += 44) {
/* Computing MIN */
		    i__3 = 44, i__4 = ii + isec - jj;
		    jsec = min(i__3,i__4);
		    i__3 = ii + isec - 1;
		    for (j = jj + 1; j <= i__3; ++j) {
			i__4 = j - 1;
			for (i__ = jj; i__ <= i__4; ++i__) {
			    i__5 = j - ii + 1 + (i__ - ii + 1) * 80 - 81;
			    d_cnjg(&z__1, &a[i__ + j * a_dim1]);
			    t1[i__5].r = z__1.r, t1[i__5].i = z__1.i;
/* L30: */
			}
/* L40: */
		    }
/* L50: */
		}

/*              C := alpha*T1*B + beta*C, a horizontal block of C is */
/*              updated using the general matrix multiply, ZGEMM. T1 */
/*              corresponds to a full diagonal block of the matrix A. */

		zgemm_("N", "N", &isec, n, &isec, alpha, t1, &c__80, &b[ii + 
			b_dim1], ldb, beta, &c__[ii + c_dim1], ldc, (ftnlen)1,
			 (ftnlen)1);

/*              C := alpha*conjg( A' )*B + C and C := alpha*A*B + C, */
/*              matrix multiply operations involving rectangular blocks */
/*              of A. */

		if (ii > 1) {
		    i__2 = ii - 1;
		    zgemm_("C", "N", &isec, n, &i__2, alpha, &a[ii * a_dim1 + 
			    1], lda, &b[b_dim1 + 1], ldb, &c_b2, &c__[ii + 
			    c_dim1], ldc, (ftnlen)1, (ftnlen)1);
		}
		if (ii + isec <= *m) {
		    i__2 = *m - ii - isec + 1;
		    zgemm_("N", "N", &isec, n, &i__2, alpha, &a[ii + (ii + 
			    isec) * a_dim1], lda, &b[ii + isec + b_dim1], ldb,
			     &c_b2, &c__[ii + c_dim1], ldc, (ftnlen)1, (
			    ftnlen)1);
		}
/* L60: */
	    }
	} else {

/*           Form  C := alpha*A*B + beta*C. Left, Lower. */

	    for (ix = *m; ix >= 1; ix += -80) {
/* Computing MAX */
		i__1 = 1, i__2 = ix - 79;
		ii = max(i__1,i__2);
		isec = ix - ii + 1;

/*              T1 := A, a lower triangular diagonal block of A is copied */
/*              to the lower triangular part of T1. */

		i__1 = ii + isec - 1;
		for (i__ = ii; i__ <= i__1; ++i__) {
		    i__2 = ii + isec - i__;
		    zcopy_(&i__2, &a[i__ + i__ * a_dim1], &c__1, &t1[i__ - ii 
			    + 1 + (i__ - ii + 1) * 80 - 81], &c__1);
/* L70: */
		}

/*              Set the imaginary part of diagonal elements of T1 */
/*              to zero. */

		i__1 = isec;
		for (i__ = 1; i__ <= i__1; ++i__) {
		    i__2 = i__ + i__ * 80 - 81;
		    i__3 = i__ + i__ * 80 - 81;
		    d__1 = t1[i__3].r;
		    z__1.r = d__1, z__1.i = 0.;
		    t1[i__2].r = z__1.r, t1[i__2].i = z__1.i;
/* L80: */
		}

/*              T1 :=  conjg( A' ), the conjugated transpose of a */
/*              strictly lower triangular diagonal block of A is copied */
/*              to the strictly upper triangular part of T1. Notice that */
/*              T1 is referenced by row and that the maximum length of a */
/*              vector referenced is CB. */

		i__1 = ii;
		for (jx = ii + isec - 1; jx >= i__1; jx += -44) {
/* Computing MAX */
		    i__2 = ii, i__3 = jx - 43;
		    jj = max(i__2,i__3);
		    jsec = jx - jj + 1;
		    i__2 = jj + jsec - 2;
		    for (j = ii; j <= i__2; ++j) {
			i__3 = ii + isec - 1;
			for (i__ = j + 1; i__ <= i__3; ++i__) {
			    i__4 = j - ii + 1 + (i__ - ii + 1) * 80 - 81;
			    d_cnjg(&z__1, &a[i__ + j * a_dim1]);
			    t1[i__4].r = z__1.r, t1[i__4].i = z__1.i;
/* L90: */
			}
/* L100: */
		    }
/* L110: */
		}

/*              C := alpha*T1*B + beta*C, a horizontal block of C is */
/*              updated using the general matrix multiply, ZGEMM. T1 */
/*              corresponds to a full diagonal block of the matrix A. */

		zgemm_("N", "N", &isec, n, &isec, alpha, t1, &c__80, &b[ii + 
			b_dim1], ldb, beta, &c__[ii + c_dim1], ldc, (ftnlen)1,
			 (ftnlen)1);

/*              C := alpha*conjg( A' )*B + C and C := alpha*A*B + C, */
/*              matrix multiply operations involving rectangular blocks */
/*              of A. */

		if (ii + isec <= *m) {
		    i__1 = *m - ii - isec + 1;
		    zgemm_("C", "N", &isec, n, &i__1, alpha, &a[ii + isec + 
			    ii * a_dim1], lda, &b[ii + isec + b_dim1], ldb, &
			    c_b2, &c__[ii + c_dim1], ldc, (ftnlen)1, (ftnlen)
			    1);
		}
		if (ii > 1) {
		    i__1 = ii - 1;
		    zgemm_("N", "N", &isec, n, &i__1, alpha, &a[ii + a_dim1], 
			    lda, &b[b_dim1 + 1], ldb, &c_b2, &c__[ii + c_dim1]
			    , ldc, (ftnlen)1, (ftnlen)1);
		}
/* L120: */
	    }
	}
    } else {
	if (upper) {

/*           Form  C := alpha*B*A + beta*C. Right, Upper. */

	    i__1 = *n;
	    for (jj = 1; jj <= i__1; jj += 80) {
/* Computing MIN */
		i__2 = 80, i__3 = *n - jj + 1;
		jsec = min(i__2,i__3);

/*              T1 := A, a upper triangular diagonal block of A is copied */
/*              to the upper triangular part of T1. */

		i__2 = jj + jsec - 1;
		for (j = jj; j <= i__2; ++j) {
		    i__3 = j - jj + 1;
		    zcopy_(&i__3, &a[jj + j * a_dim1], &c__1, &t1[(j - jj + 1)
			     * 80 - 80], &c__1);
/* L130: */
		}

/*              Set the imaginary part of diagonal elements of T1 */
/*              to zero. */

		i__2 = jsec;
		for (j = 1; j <= i__2; ++j) {
		    i__3 = j + j * 80 - 81;
		    i__4 = j + j * 80 - 81;
		    d__1 = t1[i__4].r;
		    z__1.r = d__1, z__1.i = 0.;
		    t1[i__3].r = z__1.r, t1[i__3].i = z__1.i;
/* L140: */
		}

/*              T1 :=  conjg( A' ), the conjugated transpose of a */
/*              strictly upper triangular diagonal block of A is copied */
/*              to the strictly lower triangular part of T1. Notice that */
/*              T1 is referenced by row and that the maximum length of a */
/*              vector referenced is CB. */

		i__2 = jj + jsec - 1;
		for (ii = jj; ii <= i__2; ii += 44) {
/* Computing MIN */
		    i__3 = 44, i__4 = jj + jsec - ii;
		    isec = min(i__3,i__4);
		    i__3 = jj + jsec - 1;
		    for (i__ = ii + 1; i__ <= i__3; ++i__) {
			i__4 = i__ - 1;
			for (j = ii; j <= i__4; ++j) {
			    i__5 = i__ - jj + 1 + (j - jj + 1) * 80 - 81;
			    d_cnjg(&z__1, &a[j + i__ * a_dim1]);
			    t1[i__5].r = z__1.r, t1[i__5].i = z__1.i;
/* L150: */
			}
/* L160: */
		    }
/* L170: */
		}

/*              C := alpha*B*T1 + beta*C, a vertical block of C is */
/*              updated using the general matrix multiply, ZGEMM. T1 */
/*              corresponds to a full diagonal block of the matrix A. */

		zgemm_("N", "N", m, &jsec, &jsec, alpha, &b[jj * b_dim1 + 1], 
			ldb, t1, &c__80, beta, &c__[jj * c_dim1 + 1], ldc, (
			ftnlen)1, (ftnlen)1);

/*              C := alpha*B*A + C and C := alpha*B*conjg( A' ) + C, */
/*              matrix multiply operations involving rectangular blocks */
/*              of A. */

		if (jj > 1) {
		    i__2 = jj - 1;
		    zgemm_("N", "N", m, &jsec, &i__2, alpha, &b[b_dim1 + 1], 
			    ldb, &a[jj * a_dim1 + 1], lda, &c_b2, &c__[jj * 
			    c_dim1 + 1], ldc, (ftnlen)1, (ftnlen)1);
		}
		if (jj + jsec <= *n) {
		    i__2 = *n - jj - jsec + 1;
		    zgemm_("N", "C", m, &jsec, &i__2, alpha, &b[(jj + jsec) * 
			    b_dim1 + 1], ldb, &a[jj + (jj + jsec) * a_dim1], 
			    lda, &c_b2, &c__[jj * c_dim1 + 1], ldc, (ftnlen)1,
			     (ftnlen)1);
		}
/* L180: */
	    }
	} else {

/*           Form  C := alpha*B*A + beta*C. Right, Lower. */

	    for (jx = *n; jx >= 1; jx += -80) {
/* Computing MAX */
		i__1 = 1, i__2 = jx - 79;
		jj = max(i__1,i__2);
		jsec = jx - jj + 1;

/*              T1 := A, a lower triangular diagonal block of A is copied */
/*              to the lower triangular part of T1. */

		i__1 = jj + jsec - 1;
		for (j = jj; j <= i__1; ++j) {
		    i__2 = jj + jsec - j;
		    zcopy_(&i__2, &a[j + j * a_dim1], &c__1, &t1[j - jj + 1 + 
			    (j - jj + 1) * 80 - 81], &c__1);
/* L190: */
		}

/*              Set the imaginary part of diagonal elements of T1 */
/*              to zero. */

		i__1 = jsec;
		for (j = 1; j <= i__1; ++j) {
		    i__2 = j + j * 80 - 81;
		    i__3 = j + j * 80 - 81;
		    d__1 = t1[i__3].r;
		    z__1.r = d__1, z__1.i = 0.;
		    t1[i__2].r = z__1.r, t1[i__2].i = z__1.i;
/* L200: */
		}

/*              T1 :=  conjg( A' ), the conjugated transpose of a */
/*              strictly lower triangular diagonal block of A is copied */
/*              to the strictly upper triangular part of T1. Notice that */
/*              T1 is referenced by row and that the maximum length of a */
/*              vector referenced is CB. */

		i__1 = jj;
		for (ix = jj + jsec - 1; ix >= i__1; ix += -44) {
/* Computing MAX */
		    i__2 = jj, i__3 = ix - 43;
		    ii = max(i__2,i__3);
		    isec = ix - ii + 1;
		    i__2 = ii + isec - 2;
		    for (i__ = jj; i__ <= i__2; ++i__) {
			i__3 = jj + jsec - 1;
			for (j = i__ + 1; j <= i__3; ++j) {
			    i__4 = i__ - jj + 1 + (j - jj + 1) * 80 - 81;
			    d_cnjg(&z__1, &a[j + i__ * a_dim1]);
			    t1[i__4].r = z__1.r, t1[i__4].i = z__1.i;
/* L210: */
			}
/* L220: */
		    }
/* L230: */
		}

/*              C := alpha*B*T1 + beta*C, a vertical block of C is */
/*              updated using the general matrix multiply, ZGEMM. T1 */
/*              corresponds to a full diagonal block of the matrix A. */

		zgemm_("N", "N", m, &jsec, &jsec, alpha, &b[jj * b_dim1 + 1], 
			ldb, t1, &c__80, beta, &c__[jj * c_dim1 + 1], ldc, (
			ftnlen)1, (ftnlen)1);

/*              C := alpha*B*A + C and C := alpha*B*conjg( A' ) + C, */
/*              matrix multiply operations involving rectangular blocks */
/*              of A. */

		if (jj + jsec <= *n) {
		    i__1 = *n - jj - jsec + 1;
		    zgemm_("N", "N", m, &jsec, &i__1, alpha, &b[(jj + jsec) * 
			    b_dim1 + 1], ldb, &a[jj + jsec + jj * a_dim1], 
			    lda, &c_b2, &c__[jj * c_dim1 + 1], ldc, (ftnlen)1,
			     (ftnlen)1);
		}
		if (jj > 1) {
		    i__1 = jj - 1;
		    zgemm_("N", "C", m, &jsec, &i__1, alpha, &b[b_dim1 + 1], 
			    ldb, &a[jj + a_dim1], lda, &c_b2, &c__[jj * 
			    c_dim1 + 1], ldc, (ftnlen)1, (ftnlen)1);
		}
/* L240: */
	    }
	}
    }

    return 0;

/*     End of ZHEMM. */

} /* zhemm_ */

