/* sbigp.f -- translated by f2c (version 20030320).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

#include "f2cblas.h"

logical sbigp_(integer *ip, integer *dim1, integer *dim2)
{
    /* System generated locals */
    logical ret_val;

/*     .. Scalar Arguments .. */
/*     .. */

/*  Purpose */
/*  ======= */

/*  SBIGP determines which of two alternative code sections in a GEMM- */
/*  Based Level 3 BLAS routine that will be the fastest for a particular */
/*  problem. If the problem is considered large enough SBIGP returns */
/*  .TRUE., otherwise .FALSE. is returned. The input parameter IP */
/*  specifies the calling routine and a break point for alternative code */
/*  sections. The input parameters DIM1 and DIM2 are matrix dimensions. */
/*  The returned value is a function of the input parameters and the */
/*  performance characteristics of the two alternative code sections. */

/*  In this simple implementation, the returned values are determined by */
/*  looking at only one of the two dimensions DIM1 and DIM2. It may be */
/*  rewarding to rewrite the logical expressions in SBIGP so that both */
/*  dimensions are involved. The returned values should effectively */
/*  reflect the performance characteristics of the underlying BLAS */
/*  routines. */


/*  Input */
/*  ===== */

/*  IP     - INTEGER */
/*           On entry, IP specifies which routine and which alternative */
/*           code sections that the decision is intended for. */
/*           Unchanged on exit. */

/*  DIM1   - INTEGER. */
/*           On entry, DIM1 specifies the first dimension in the calling */
/*           sequence of the Level 3 routine specified by IP. */
/*           Unchanged on exit. */

/*  DIM2   - INTEGER. */
/*           On entry, DIM2 specifies the second dimension in the */
/*           calling sequence of the Level 3 routine specified by IP. */
/*           Unchanged on exit. */


/*  -- Written in December-1993. */
/*     GEMM-Based Level 3 BLAS. */
/*     Per Ling, Institute of Information Processing, */
/*     University of Umea, Sweden. */


/*     .. User specified parameters for SBIGP .. */
/*     .. */
/*     .. Executable Statements .. */
    if (*ip == 41) {
	ret_val = *dim1 >= 4;
    } else if (*ip == 42) {
	ret_val = *dim2 >= 3;
    } else if (*ip == 81) {
	ret_val = *dim2 >= 4;
    } else if (*ip == 82) {
	ret_val = *dim2 >= 3;
    } else if (*ip == 83) {
	ret_val = *dim1 >= 4;
    } else if (*ip == 91) {
	ret_val = *dim2 >= 4;
    } else if (*ip == 92) {
	ret_val = *dim2 >= 3;
    } else if (*ip == 93) {
	ret_val = *dim1 >= 4;
    } else {
	ret_val = 0;
    }

    return ret_val;

/*     End of SBIGP. */

} /* sbigp_ */

