/*
 *
 * LFC_zher2k.c
 * This program is a C interface to zher2k.
 * Written by Keita Teranishi
 * 4/8/1998
 *
 */

#include <lfc/lfci.h>

void LFC_zher2k(enum LFC_Order Order, enum LFC_UpLo Uplo,
                  enum LFC_Transpose Trans, int N, int K,
                  /*const*/ void *alpha, /*const*/ void *A, int lda,
                  /*const*/ void *B, int ldb, double beta,
                  void *C, int ldc)
{
   char UL, TR;   
#ifdef F77_CHAR
   F77_CHAR F77_TR, F77_UL;
#else
   #define F77_TR &TR  
   #define F77_UL &UL  
#endif

#ifdef F77_INT
   F77_INT F77_N=N, F77_K=K, F77_lda=lda, F77_ldb=ldb;
   F77_INT F77_ldc=ldc;
#else
   #define F77_N N
   #define F77_K K
   #define F77_lda lda
   #define F77_ldb ldb
   #define F77_ldc ldc
#endif

   /* extern int CBLAS_CallFromC; */
   /* extern int RowMajorStrg; */
   double ALPHA[2]; 
   /*const*/ double *alp=(double *)alpha;

   /* CBLAS_CallFromC = 1; */
   /* RowMajorStrg = 0; */

   if( Order == LFC_ColMajor )
   {

      if( Uplo == LFC_Upper) UL='U';
      else if ( Uplo == LFC_Lower ) UL='L';
      else 
      {
         LFC_xerbla(2, "LFC_zher2k", "Illegal Uplo setting, %d\n", Uplo);
         /* CBLAS_CallFromC = 0; */
         /* RowMajorStrg = 0; */
         return;
      }

      if( Trans == LFC_Trans) TR ='T';
      else if ( Trans == LFC_ConjTrans ) TR='C';
      else if ( Trans == LFC_NoTrans )   TR='N';
      else 
      {
         LFC_xerbla(3, "LFC_zher2k", "Illegal Trans setting, %d\n", Trans);
         /* CBLAS_CallFromC = 0; */
         /* RowMajorStrg = 0; */
         return;
      }

      #ifdef F77_CHAR
         F77_UL = C2F_CHAR(&UL);
         F77_TR = C2F_CHAR(&TR);
      #endif

      LFC_F77_zher2k(F77_UL, F77_TR, &F77_N, &F77_K, alpha, A, &F77_lda, B, &F77_ldb, &beta, C, &F77_ldc);
   } else if (Order == LFC_RowMajor)
   {
      /* RowMajorStrg = 1; */
      
      if( Uplo == LFC_Upper) UL='L';
      else if ( Uplo == LFC_Lower ) UL='U';
      else 
      {
         LFC_xerbla(2, "LFC_zher2k", "Illegal Uplo setting, %d\n", Uplo);
         /* CBLAS_CallFromC = 0; */
         /* RowMajorStrg = 0; */
         return;
      }
      if( Trans == LFC_Trans) TR ='N';
      else if ( Trans == LFC_ConjTrans ) TR='N';
      else if ( Trans == LFC_NoTrans )   TR='C';
      else 
      {
         LFC_xerbla(3, "LFC_zher2k", "Illegal Trans setting, %d\n", Trans);
         /* CBLAS_CallFromC = 0; */
         /* RowMajorStrg = 0; */
         return;
      }
      #ifdef F77_CHAR
         F77_UL = C2F_CHAR(&UL);
         F77_TR = C2F_CHAR(&TR);
      #endif

      ALPHA[0]= *alp;
      ALPHA[1]= -alp[1];
      LFC_F77_zher2k(F77_UL,F77_TR, &F77_N, &F77_K, (doublecomplex *)ALPHA, A, &F77_lda, B, &F77_ldb, &beta, C, &F77_ldc);
   } else  LFC_xerbla(1, "LFC_zher2k", "Illegal Order setting, %d\n", Order);
   /* CBLAS_CallFromC = 0; */
   /* RowMajorStrg = 0; */
   return;
}
