/*
 *
 * LFC_ssbmv.c
 * This program is a C interface to ssbmv.
 * Written by Keita Teranishi
 * 4/6/1998
 *
 */
#include <lfc/lfci.h>

void LFC_ssbmv(enum LFC_Order order, enum LFC_UpLo Uplo,
           int N, int K, float alpha, /*const*/ float *A,
           int lda, /*const*/ float *X, int incX,
           float beta, float *Y, int incY)
{
   char UL;
#ifdef F77_CHAR
   F77_CHAR F77_UL;
#else
   #define F77_UL &UL   
#endif

#ifdef F77_INT
   F77_INT F77_N=N, F77_K=K, F77_lda=lda, F77_incX=incX, F77_incY=incY;
#else
   #define F77_N N
   #define F77_K K
   #define F77_lda lda
   #define F77_incX incX
   #define F77_incY incY
#endif
   /* extern int CBLAS_CallFromC; */
   /* extern int RowMajorStrg; */
   /* RowMajorStrg = 0; */

   /* CBLAS_CallFromC = 1; */
   if (order == LFC_ColMajor)
   {
   
      if (Uplo == LFC_Upper) UL = 'U';
      else if (Uplo == LFC_Lower) UL = 'L';
      else 
      {
         LFC_xerbla(2, "LFC_ssbmv","Illegal Uplo setting, %d\n",Uplo );
         /* CBLAS_CallFromC = 0; */
         /* RowMajorStrg = 0; */
         return;
      }
      #ifdef F77_CHAR
         F77_UL = C2F_CHAR(&UL);
      #endif
      LFC_F77_ssbmv(F77_UL, &F77_N, &F77_K, &alpha, A, &F77_lda, X,
      &F77_incX, &beta, Y, &F77_incY);
   }else if (order == LFC_RowMajor)
   {
      /* RowMajorStrg = 1; */
      if (Uplo == LFC_Upper) UL = 'L';
      else if (Uplo == LFC_Lower) UL = 'U';
      else 
      {
         LFC_xerbla(2, "LFC_ssbmv","Illegal Uplo setting, %d\n", Uplo);
         /* CBLAS_CallFromC = 0; */
         /* RowMajorStrg = 0; */
         return;
      }
      #ifdef F77_CHAR
         F77_UL = C2F_CHAR(&UL);
      #endif
      LFC_F77_ssbmv(F77_UL, &F77_N, &F77_K, &alpha, A, &F77_lda, X,
      &F77_incX, &beta, Y, &F77_incY);
   }
   else LFC_xerbla(1, "LFC_ssbmv", "Illegal Order setting, %d\n", order);
   /* CBLAS_CallFromC = 0; */
   /* RowMajorStrg = 0; */
   return;
}
