/*
 *
 * LFC_sger.c
 * This program is a C interface to sger.
 * Written by Keita Teranishi
 * 4/6/1998
 *
 */

#include <lfc/lfci.h>

void LFC_sger(enum LFC_Order order, int M, int N,
                float  alpha, /*const*/ float  *X, int incX,
                /*const*/ float  *Y, int incY, float  *A, int lda)
{
#ifdef F77_INT
   F77_INT F77_M=M, F77_N=N, F77_lda=lda, F77_incX=incX, F77_incY=incY;
#else
   #define F77_M M
   #define F77_N N
   #define F77_incX incX
   #define F77_incY incY
   #define F77_lda lda
#endif

   /* extern int CBLAS_CallFromC; */
   /* extern int RowMajorStrg; */
   /* RowMajorStrg = 0; */

   /* CBLAS_CallFromC = 1; */
   if (order == LFC_ColMajor)
   {
      LFC_F77_sger( &F77_M, &F77_N, &alpha, X, &F77_incX, Y, &F77_incY, A,
       &F77_lda);
   }
   else if (order == LFC_RowMajor)
   {
      /* RowMajorStrg = 1; */
      LFC_F77_sger( &F77_N, &F77_M, &alpha, Y, &F77_incY, X, &F77_incX, A, 
        &F77_lda);
   }
   else LFC_xerbla(1, "LFC_sger", "Illegal Order setting, %d\n", order);
   /* CBLAS_CallFromC = 0; */
   /* RowMajorStrg = 0; */
   return;
}
