/*
 *
 * LFC_sgemv.c
 * This program is a C interface to sgemv.
 * Written by Keita Teranishi
 * 4/6/1998
 * 
 */
#include <lfc/lfci.h>

void LFC_sgemv(enum LFC_Order order,
                 enum LFC_Transpose TransA, int M, int N,
                 float alpha, /*const*/ float  *A, int lda,
                 /*const*/ float  *X, int incX, float beta,
                 float  *Y, int incY)
{
   char TA;
#ifdef F77_CHAR
   F77_CHAR F77_TA;
#else
   #define F77_TA &TA   
#endif
#ifdef F77_INT
   F77_INT F77_M=M, F77_N=N, F77_lda=lda, F77_incX=incX, F77_incY=incY;
#else
   #define F77_M M
   #define F77_N N
   #define F77_lda lda
   #define F77_incX incX
   #define F77_incY incY
#endif

   /* extern int CBLAS_CallFromC; */
   /* extern int RowMajorStrg; */
   /* RowMajorStrg = 0; */

   /* CBLAS_CallFromC = 1; */
   if (order == LFC_ColMajor)
   {
      if (TransA == LFC_NoTrans) TA = 'N';
      else if (TransA == LFC_Trans) TA = 'T';
      else if (TransA == LFC_ConjTrans) TA = 'C';
      else 
      {
         LFC_xerbla(2, "LFC_sgemv","Illegal TransA setting, %d\n", TransA);
         /* CBLAS_CallFromC = 0; */
         /* RowMajorStrg = 0; */
      }
      #ifdef F77_CHAR
         F77_TA = C2F_CHAR(&TA);
      #endif
      LFC_F77_sgemv(F77_TA, &F77_M, &F77_N, &alpha, A, &F77_lda, X, &F77_incX, 
                &beta, Y, &F77_incY);
   }
   else if (order == LFC_RowMajor)
   {
      /* RowMajorStrg = 1; */
      if (TransA == LFC_NoTrans) TA = 'T';
      else if (TransA == LFC_Trans) TA = 'N';
      else if (TransA == LFC_ConjTrans) TA = 'N';
      else 
      {
         LFC_xerbla(2, "LFC_sgemv", "Illegal TransA setting, %d\n", TransA);
         /* CBLAS_CallFromC = 0; */
         /* RowMajorStrg = 0; */
         return;
      }
      #ifdef F77_CHAR
         F77_TA = C2F_CHAR(&TA);
      #endif
      LFC_F77_sgemv(F77_TA, &F77_N, &F77_M, &alpha, A, &F77_lda, X,
                &F77_incX, &beta, Y, &F77_incY);
   }
   else LFC_xerbla(1, "LFC_sgemv", "Illegal Order setting, %d\n", order);
   /* CBLAS_CallFromC = 0; */
   /* RowMajorStrg = 0; */
   return;
}
