/*
 *
 * LFC_sgemm.c
 * This program is a C interface to sgemm.
 * Written by Keita Teranishi
 * 4/8/1998
 *
 */

#include <lfc/lfci.h>

void LFC_sgemm(enum LFC_Order Order, enum LFC_Transpose TransA,
                 enum LFC_Transpose TransB, int M, int N,
                 int K, float alpha, /*const*/ float  *A,
                 int lda, /*const*/ float  *B, int ldb,
                 float beta, float  *C, int ldc)
{
   char TA, TB;   
#ifdef F77_CHAR
   F77_CHAR F77_TA, F77_TB;
#else
   #define F77_TA &TA  
   #define F77_TB &TB  
#endif

#ifdef F77_INT
   F77_INT F77_M=M, F77_N=N, F77_K=K, F77_lda=lda, F77_ldb=ldb;
   F77_INT F77_ldc=ldc;
#else
   #define F77_M M
   #define F77_N N
   #define F77_K K
   #define F77_lda lda
   #define F77_ldb ldb
   #define F77_ldc ldc
#endif
   
   /* extern int CBLAS_CallFromC; */
   /* extern int RowMajorStrg; */
   /* RowMajorStrg = 0; */
   /* CBLAS_CallFromC = 1; */
   if( Order == LFC_ColMajor )
   {
      if(TransA == LFC_Trans) TA='T';
      else if ( TransA == LFC_ConjTrans ) TA='C';
      else if ( TransA == LFC_NoTrans )   TA='N';
      else 
      {
         LFC_xerbla(2, "LFC_sgemm", 
                       "Illegal TransA setting, %d\n", TransA);
         /* CBLAS_CallFromC = 0; */
         /* RowMajorStrg = 0; */
         return;
      }

      if(TransB == LFC_Trans) TB='T';
      else if ( TransB == LFC_ConjTrans ) TB='C';
      else if ( TransB == LFC_NoTrans )   TB='N';
      else 
      {
         LFC_xerbla(3, "LFC_sgemm", 
                       "Illegal TransB setting, %d\n", TransB);
         /* CBLAS_CallFromC = 0; */
         /* RowMajorStrg = 0; */
         return;
      }

      #ifdef F77_CHAR
         F77_TA = C2F_CHAR(&TA);
         F77_TB = C2F_CHAR(&TB);
      #endif

      LFC_F77_sgemm(F77_TA, F77_TB, &F77_M, &F77_N, &F77_K, &alpha, A, &F77_lda, B, &F77_ldb, &beta, C, &F77_ldc);
   } else if (Order == LFC_RowMajor)
   {
      /* RowMajorStrg = 1; */
      if(TransA == LFC_Trans) TB='T';
      else if ( TransA == LFC_ConjTrans ) TB='C';
      else if ( TransA == LFC_NoTrans )   TB='N';
      else 
      {
         LFC_xerbla(2, "LFC_sgemm", 
                       "Illegal TransA setting, %d\n", TransA);
         /* CBLAS_CallFromC = 0; */
         /* RowMajorStrg = 0; */
         return;
      }
      if(TransB == LFC_Trans) TA='T';
      else if ( TransB == LFC_ConjTrans ) TA='C';
      else if ( TransB == LFC_NoTrans )   TA='N';
      else 
      {
         LFC_xerbla(2, "LFC_sgemm", 
                       "Illegal TransA setting, %d\n", TransA);
         /* CBLAS_CallFromC = 0; */
         /* RowMajorStrg = 0; */
         return;
      }
      #ifdef F77_CHAR
         F77_TA = C2F_CHAR(&TA);
         F77_TB = C2F_CHAR(&TB);
      #endif

      LFC_F77_sgemm(F77_TA, F77_TB, &F77_N, &F77_M, &F77_K, &alpha, B, &F77_ldb, A, &F77_lda, &beta, C, &F77_ldc);
   } else  
     LFC_xerbla(1, "LFC_sgemm",
                     "Illegal Order setting, %d\n", Order);
   /* CBLAS_CallFromC = 0; */
   /* RowMajorStrg = 0; */
}
