/*
 * LFC_isamax.c
 *
 * The program is a C interface to isamax.
 * It calls the fortran wrapper before calling isamax.
 *
 * Written by Keita Teranishi.  2/11/1998
 *
 */
#include <lfc/lfci.h>

int LFC_isamax( int N, /*const*/ float *X, int incX)
{
   int iamax;
#ifdef F77_INT
   F77_INT F77_N=N, F77_incX=incX;
#else 
   #define F77_N N
   #define F77_incX incX
#endif
   iamax = LFC_F77_isamax( &F77_N, X, &F77_incX );
   return iamax ? iamax-1 : 0;
}
