/*
 * LFC_dzasum.c
 *
 * The program is a C interface to dzasum.
 * It calls the fortran wrapper before calling dzasum.
 *
 * Written by Keita Teranishi.  2/11/1998
 *
 */
#include <lfc/lfci.h>

double LFC_dzasum( int N, /*const*/ void *X, int incX) 
{
   double asum;
#ifdef F77_INT
   F77_INT F77_N=N, F77_incX=incX;
#else 
   #define F77_N N
   #define F77_incX incX
#endif
   asum = LFC_F77_dzasum( &F77_N, X, &F77_incX );
   return asum;
}
