/*
 * LFC_dtrsv.c
 * The program is a C interface to dtrsv.
 *
 * Keita Teranishi  5/20/98
 *
 */
#include <lfc/lfci.h>

void LFC_dtrsv(enum LFC_Order order, enum LFC_UpLo Uplo,
                 enum LFC_Transpose TransA, enum LFC_Diag Diag,
                 int N, /*const*/ double  *A, int lda, double  *X,
                 int incX)

{
   char TA;
   char UL;
   char DI;
#ifdef F77_CHAR
   F77_CHAR F77_TA, F77_UL, F77_DI;
#else
   #define F77_TA &TA
   #define F77_UL &UL
   #define F77_DI &DI   
#endif
#ifdef F77_INT
   F77_INT F77_N=N, F77_lda=lda, F77_incX=incX;
#else
   #define F77_N N
   #define F77_lda lda
   #define F77_incX incX
#endif
   /* extern int CBLAS_CallFromC; */
   /* extern int RowMajorStrg; */
   /* RowMajorStrg = 0; */

   /* CBLAS_CallFromC = 1; */
   if (order == LFC_ColMajor)
   {
      if (Uplo == LFC_Upper) UL = 'U';
      else if (Uplo == LFC_Lower) UL = 'L';
      else 
      {
         LFC_xerbla(2, "LFC_dtrsv","Illegal Uplo setting, %d\n", Uplo);
         /* CBLAS_CallFromC = 0; */
         /* RowMajorStrg = 0; */
         return;
      }
      if (TransA == LFC_NoTrans) TA = 'N';
      else if (TransA == LFC_Trans) TA = 'T';
      else if (TransA == LFC_ConjTrans) TA = 'C';
      else 
      {
         LFC_xerbla(3, "LFC_dtrsv","Illegal TransA setting, %d\n", TransA);
         /* CBLAS_CallFromC = 0; */
         /* RowMajorStrg = 0; */
         return;
      }
      if (Diag == LFC_Unit) DI = 'U';
      else if (Diag == LFC_NonUnit) DI = 'N';
      else 
      {
         LFC_xerbla(4, "LFC_dtrsv","Illegal Diag setting, %d\n", Diag);
         /* CBLAS_CallFromC = 0; */
         /* RowMajorStrg = 0; */
         return;
      }
      #ifdef F77_CHAR
         F77_UL = C2F_CHAR(&UL);
         F77_TA = C2F_CHAR(&TA);
         F77_DI = C2F_CHAR(&DI);
      #endif
      LFC_F77_dtrsv( F77_UL, F77_TA, F77_DI, &F77_N, A, &F77_lda, X,
                      &F77_incX);
   }
   else if (order == LFC_RowMajor)
   {
      /* RowMajorStrg = 1; */
      if (Uplo == LFC_Upper) UL = 'L';
      else if (Uplo == LFC_Lower) UL = 'U';
      else 
      {
         LFC_xerbla(2, "LFC_dtrsv","Illegal Uplo setting, %d\n", Uplo);
         /* CBLAS_CallFromC = 0; */
         /* RowMajorStrg = 0; */
         return;
      }

      if (TransA == LFC_NoTrans) TA = 'T';
      else if (TransA == LFC_Trans) TA = 'N';
      else if (TransA == LFC_ConjTrans) TA = 'N';
      else 
      {
         LFC_xerbla(3, "LFC_dtrsv","Illegal TransA setting, %d\n", TransA);
         /* CBLAS_CallFromC = 0; */
         /* RowMajorStrg = 0; */
         return;
      }

      if (Diag == LFC_Unit) DI = 'U';
      else if (Diag == LFC_NonUnit) DI = 'N';
      else 
      {
         LFC_xerbla(4, "LFC_dtrsv","Illegal Diag setting, %d\n", Diag);
         /* CBLAS_CallFromC = 0; */
         /* RowMajorStrg = 0; */
         return;
      }
      #ifdef F77_CHAR
         F77_UL = C2F_CHAR(&UL);
         F77_TA = C2F_CHAR(&TA);
         F77_DI = C2F_CHAR(&DI);
      #endif
      LFC_F77_dtrsv( F77_UL, F77_TA, F77_DI, &F77_N, A, &F77_lda, X,
                      &F77_incX);
   }
   else LFC_xerbla(1, "LFC_dtrsv", "Illegal Order setting, %d\n", order);
   /* CBLAS_CallFromC = 0; */
   /* RowMajorStrg = 0; */
   return;
}
