/*
 *
 * LFC_dsyr.c
 * This program is a C interface to dsyr.
 * Written by Keita Teranishi
 * 4/6/1998
 *
 */

#include <lfc/lfci.h>

void LFC_dsyr(enum LFC_Order order, enum LFC_UpLo Uplo,
                int N, double  alpha, /*const*/ double  *X,
                int incX, double  *A, int lda)
{
   char UL;
#ifdef F77_CHAR
   F77_CHAR F77_UL;
#else
   #define F77_UL &UL
#endif

#ifdef F77_INT
   F77_INT F77_N=N, F77_incX=incX, F77_lda=lda;
#else
   #define F77_N N
   #define F77_incX incX
   #define F77_lda  lda
#endif
   /* extern int CBLAS_CallFromC; */
   /* extern int RowMajorStrg; */
   /* RowMajorStrg = 0; */
   /* CBLAS_CallFromC = 1; */
   if (order == LFC_ColMajor)
   {
      if (Uplo == LFC_Lower) UL = 'L';
      else if (Uplo == LFC_Upper) UL = 'U';
      else 
      {
         LFC_xerbla(2, "LFC_dsyr","Illegal Uplo setting, %d\n",Uplo );
         /* CBLAS_CallFromC = 0; */
         /* RowMajorStrg = 0; */
         return;
      }
      #ifdef F77_CHAR
         F77_UL = C2F_CHAR(&UL);
      #endif

      LFC_F77_dsyr(F77_UL, &F77_N, &alpha, X, &F77_incX, A, &F77_lda);

   }  else if (order == LFC_RowMajor) 
   {
      /* RowMajorStrg = 1; */
      if (Uplo == LFC_Lower) UL = 'U';
      else if (Uplo == LFC_Upper) UL = 'L';
      else 
      {
         LFC_xerbla(2, "LFC_dsyr","Illegal Uplo setting, %d\n",Uplo );
         /* CBLAS_CallFromC = 0; */
         /* RowMajorStrg = 0; */
         return;
      }
      #ifdef F77_CHAR
         F77_UL = C2F_CHAR(&UL);
      #endif  
      LFC_F77_dsyr(F77_UL, &F77_N, &alpha, X, &F77_incX, A, &F77_lda); 
   } else LFC_xerbla(1, "LFC_dsyr", "Illegal Order setting, %d\n", order);
   /* CBLAS_CallFromC = 0; */
   /* RowMajorStrg = 0; */
   return;
} 
