/*
 * LFC_dnrm2.c
 *
 * The program is a C interface to dnrm2.
 * It calls the fortranwrapper before calling dnrm2.
 *
 * Written by Keita Teranishi.  2/11/1998
 *
 */
#include <lfc/lfci.h>

double LFC_dnrm2( int N, /*const*/ double *X, int incX) 
{
   double nrm2;
#ifdef F77_INT
   F77_INT F77_N=N, F77_incX=incX;
#else 
   #define F77_N N
   #define F77_incX incX
#endif
   nrm2=LFC_F77_dnrm2(&F77_N, X,&F77_incX);
   return nrm2;
}
