/*
 * LFC_ctbsv.c
 * The program is a C interface to ctbsv.
 * 
 * Keita Teranishi  3/23/98
 *
 */
#include <lfc/lfci.h>

void LFC_ctbsv(enum LFC_Order order, enum LFC_UpLo Uplo,
                 enum LFC_Transpose TransA, enum LFC_Diag Diag,
                 int N, int K, /*const*/ void  *A, int lda,
                 void  *X, int incX)
{
   char TA;
   char UL;
   char DI;
#ifdef F77_CHAR
   F77_CHAR F77_TA, F77_UL, F77_DI;
#else
   #define F77_TA &TA
   #define F77_UL &UL
   #define F77_DI &DI   
#endif
#ifdef F77_INT
   F77_INT F77_N=N, F77_lda=lda, F77_K=K, F77_incX=incX;
#else
   #define F77_N N
   #define F77_K K
   #define F77_lda lda
   #define F77_incX incX
#endif
   int n, i=0, tincX; 
   float *st=0,*x=(float *)X;
   /* extern int CBLAS_CallFromC; */
   /* extern int RowMajorStrg; */
   /* RowMajorStrg = 0; */

   /* CBLAS_CallFromC = 1; */
   if (order == LFC_ColMajor)
   {
      if (Uplo == LFC_Upper) UL = 'U';
      else if (Uplo == LFC_Lower) UL = 'L';
      else 
      {
         LFC_xerbla(2, "LFC_ctbsv","Illegal Uplo setting, %d\n", Uplo);
         /* CBLAS_CallFromC = 0; */
         /* RowMajorStrg = 0; */
         return;
      }
      if (TransA == LFC_NoTrans) TA = 'N';
      else if (TransA == LFC_Trans) TA = 'T';
      else if (TransA == LFC_ConjTrans) TA = 'C';
      else 
      {
         LFC_xerbla(3, "LFC_ctbsv","Illegal TransA setting, %d\n", TransA);
         /* CBLAS_CallFromC = 0; */
         /* RowMajorStrg = 0; */
         return;
      }
      if (Diag == LFC_Unit) DI = 'U';
      else if (Diag == LFC_NonUnit) DI = 'N';
      else 
      {
         LFC_xerbla(4, "LFC_ctbsv","Illegal Diag setting, %d\n", Diag);
         /* CBLAS_CallFromC = 0; */
         /* RowMajorStrg = 0; */
         return;
      }
      #ifdef F77_CHAR
         F77_UL = C2F_CHAR(&UL);
         F77_TA = C2F_CHAR(&TA);
         F77_DI = C2F_CHAR(&DI);
      #endif
      LFC_F77_ctbsv( F77_UL, F77_TA, F77_DI, &F77_N, &F77_K, A, &F77_lda, X,
                      &F77_incX);
   }
   else if (order == LFC_RowMajor)
   {
      /* RowMajorStrg = 1; */
      if (Uplo == LFC_Upper) UL = 'L';
      else if (Uplo == LFC_Lower) UL = 'U';
      else 
      {
         LFC_xerbla(2, "LFC_ctbsv","Illegal Uplo setting, %d\n", Uplo);
         /* CBLAS_CallFromC = 0; */
         /* RowMajorStrg = 0; */
         return;
      }

      if (TransA == LFC_NoTrans) TA = 'T';
      else if (TransA == LFC_Trans) TA = 'N';
      else if (TransA == LFC_ConjTrans)
      {
         TA = 'N';
         if ( N > 0)
         {
            if ( incX > 0 )
               tincX = incX;
            else
               tincX = -incX;
 
            n = N*2*(tincX);
  
            x++;

            st=x+n;

            i = tincX << 1;
            do
            {
               *x = -(*x);
               x+=i;
            }
            while (x != st);
            x -= n;
         }
      }
      else 
      {
         LFC_xerbla(3, "LFC_ctbsv","Illegal TransA setting, %d\n", TransA);
         /* CBLAS_CallFromC = 0; */
         /* RowMajorStrg = 0; */
         return;
      }

      if (Diag == LFC_Unit) DI = 'U';
      else if (Diag == LFC_NonUnit) DI = 'N';
      else 
      {
         LFC_xerbla(4, "LFC_ctbsv","Illegal Diag setting, %d\n", Diag);
         /* CBLAS_CallFromC = 0; */
         /* RowMajorStrg = 0; */
         return;
      }
      #ifdef F77_CHAR
         F77_UL = C2F_CHAR(&UL);
         F77_TA = C2F_CHAR(&TA);
         F77_DI = C2F_CHAR(&DI);
      #endif

      LFC_F77_ctbsv( F77_UL, F77_TA, F77_DI, &F77_N, &F77_K, A, &F77_lda, X,
                      &F77_incX);

      if (TransA == LFC_ConjTrans)
      {
         if (N > 0)
         {
            do
            {
               *x = -(*x);
               x+= i;
            }
            while (x != st);
         }
      }
   }
   else LFC_xerbla(1, "LFC_ctbsv", "Illegal Order setting, %d\n", order);
   /* CBLAS_CallFromC = 0; */
   /* RowMajorStrg = 0; */
   return;
}
