
#include <lfc/lfci.h>

#define max(x,y) ((x)<(y)?(y):(x))
#define min(x,y) ((x)>(y)?(y):(x))

#define xerbla_(rout,info,l) LFC_xerbla(*(info),rout,"%d\n",1)

/* These are libf2c routines that are defined in liblfc to make it
   independependent and simplify linkage. */
#define r_imag lfc_r_imag
#define d_imag lfc_d_imag
#define r_cnjg lfc_r_cnjg
#define d_cnjg lfc_d_cnjg
#define c_div lfc_c_div
#define z_div lfc_z_div

/*
  single precision real
*/

#define sbigp_  LFC_F77_sbigp
#define scld_  LFC_F77_scld

#define saxpy_  LFC_F77_saxpy
#define scopy_  LFC_F77_scopy
#define sdot_   LFC_F77_sdot
#define srot_   LFC_F77_srot
#define sger_   LFC_F77_sger
#define snrm2_  LFC_F77_snrm2
#define sasum_  LFC_F77_sasum
#define sscal_  LFC_F77_sscal
#define sswap_  LFC_F77_sswap
#define isamax_ LFC_F77_isamax

#define ssyr_(u,n,al,x,incx,a,lda,l1) LFC_F77_ssyr(u,n,al,x,incx,a,lda)
#define ssyr2_(u,n,al,x,incx,y,incy,a,lda,l1) LFC_F77_ssyr2(u,n,al,x,incx,y,incy,a,lda)
#define ssyr2k_(u,t,n,k,al,a,lda,b,ldb,bt,c,ldc,l1,l2) LFC_F77_ssyr2k(u,t,n,k,al,a,lda,b,ldb,bt,c,ldc)
#define ssbmv_(u,n,k,al,a,lda,x,incx,bt,y,incy,l1) LFC_F77_ssbmv(u,n,k,al,a,lda,x,incx,bt,y,incy)
#define ssymv_(u,n,al,a,lda,x,incx,bt,y,incy,l1) LFC_F77_ssymv(u,n,al,a,lda,x,incx,bt,y,incy)

#define sgemv_(t,m,n,al,a,lda,x,incx,bt,y,incy,l1) LFC_F77_sgemv(t,m,n,al,a,lda,x,incx,bt,y,incy)
#define strmv_(u,t,d,n,a,lda,x,incx,l1,l2,l3) LFC_F77_strmv(u,t,d,n,a,lda,x,incx)
#define strsv_(u,t,d,n,a,lda,x,incx,l1,l2,l3) LFC_F77_strsv(u,t,d,n,a,lda,x,incx)
#define sgbmv_(t,m,n,l,u,al,a,lda,x,incx,bt,y,incy,l1) LFC_F77_sgbmv(t,m,n,l,u,al,a,lda,x,incx,bt,y,incy)
#define stbsv_(u,t,d,n,k,a,lda,x,incx,l1,l2,l3) LFC_F77_stbsv(u,t,d,n,k,a,lda,x,incx)

#define ssymm_(s,u,m,n,al,a,lda,b,ldb,bt,c,ldc,l1,l2) LFC_F77_ssymm(s,u,m,n,al,a,lda,b,ldb,bt,c,ldc)
#define ssyrk_(u,t,n,k,al,a,lda,bt,c,ldc,l1,l2) LFC_F77_ssyrk(u,t,n,k,al,a,lda,bt,c,ldc)
#define ssyr2k_(u,t,n,k,al,a,lda,b,ldb,bt,c,ldc,l1,l2) LFC_F77_ssyr2k(u,t,n,k,al,a,lda,b,ldb,bt,c,ldc)
#define sgemm_(ta,tb,m,n,k,al,a,lda,b,ldb,bt,c,ldc,l1,l2) LFC_F77_sgemm(ta,tb,m,n,k,al,a,lda,b,ldb,bt,c,ldc)
#define strmm_(s,u,t,d,m,n,al,a,lda,b,ldb,l1,l2,l3,l4) LFC_F77_strmm(s,u,t,d,m,n,al,a,lda,b,ldb)
#define strsm_(s,u,t,d,m,n,al,a,lda,b,ldb,l1,l2,l3,l4) LFC_F77_strsm(s,u,t,d,m,n,al,a,lda,b,ldb)

/*
  double precision real
*/

#define dbigp_  LFC_F77_dbigp
#define dcld_  LFC_F77_dcld

#define daxpy_  LFC_F77_daxpy
#define dcopy_  LFC_F77_dcopy
#define ddot_   LFC_F77_ddot
#define drot_   LFC_F77_drot
#define dger_   LFC_F77_dger
#define dnrm2_  LFC_F77_dnrm2
#define dasum_  LFC_F77_dasum
#define dscal_  LFC_F77_dscal
#define dswap_  LFC_F77_dswap
#define idamax_ LFC_F77_idamax

#define dsyr_(u,n,al,x,incx,a,lda,l1) LFC_F77_dsyr(u,n,al,x,incx,a,lda)
#define dsyr2_(u,n,al,x,incx,y,incy,a,lda,l1) LFC_F77_dsyr2(u,n,al,x,incx,y,incy,a,lda)
#define dsyr2k_(u,t,n,k,al,a,lda,b,ldb,bt,c,ldc,l1,l2) LFC_F77_dsyr2k(u,t,n,k,al,a,lda,b,ldb,bt,c,ldc)
#define dsbmv_(u,n,k,al,a,lda,x,incx,bt,y,incy,l1) LFC_F77_dsbmv(u,n,k,al,a,lda,x,incx,bt,y,incy)
#define dsymv_(u,n,al,a,lda,x,incx,bt,y,incy,l1) LFC_F77_dsymv(u,n,al,a,lda,x,incx,bt,y,incy)

#define dgemv_(t,m,n,al,a,lda,x,incx,bt,y,incy,l1) LFC_F77_dgemv(t,m,n,al,a,lda,x,incx,bt,y,incy)
#define dtrmv_(u,t,d,n,a,lda,x,incx,l1,l2,l3) LFC_F77_dtrmv(u,t,d,n,a,lda,x,incx)
#define dtrsv_(u,t,d,n,a,lda,x,incx,l1,l2,l3) LFC_F77_dtrsv(u,t,d,n,a,lda,x,incx)
#define dgbmv_(t,m,n,l,u,al,a,lda,x,incx,bt,y,incy,l1) LFC_F77_dgbmv(t,m,n,l,u,al,a,lda,x,incx,bt,y,incy)
#define dtbsv_(u,t,d,n,k,a,lda,x,incx,l1,l2,l3) LFC_F77_dtbsv(u,t,d,n,k,a,lda,x,incx)

#define dsymm_(s,u,m,n,al,a,lda,b,ldb,bt,c,ldc,l1,l2) LFC_F77_dsymm(s,u,m,n,al,a,lda,b,ldb,bt,c,ldc)
#define dsyrk_(u,t,n,k,al,a,lda,bt,c,ldc,l1,l2) LFC_F77_dsyrk(u,t,n,k,al,a,lda,bt,c,ldc)
#define dsyr2k_(u,t,n,k,al,a,lda,b,ldb,bt,c,ldc,l1,l2) LFC_F77_dsyr2k(u,t,n,k,al,a,lda,b,ldb,bt,c,ldc)
#define dgemm_(ta,tb,m,n,k,al,a,lda,b,ldb,bt,c,ldc,l1,l2) LFC_F77_dgemm(ta,tb,m,n,k,al,a,lda,b,ldb,bt,c,ldc)
#define dtrmm_(s,u,t,d,m,n,al,a,lda,b,ldb,l1,l2,l3,l4) LFC_F77_dtrmm(s,u,t,d,m,n,al,a,lda,b,ldb)
#define dtrsm_(s,u,t,d,m,n,al,a,lda,b,ldb,l1,l2,l3,l4) LFC_F77_dtrsm(s,u,t,d,m,n,al,a,lda,b,ldb)

/*
  single precision complex
*/

#define chbmv_(u,n,k,al,a,lda,x,incx,bt,y,incy,l1) LFC_F77_chbmv(u,n,k,al,a,lda,x,incx,bt,y,incy)
#define chemm_(s,u,m,n,al,a,lda,b,ldb,bt,c,ldc,l1,l2) LFC_F77_chemm(s,u,m,n,al,a,lda,b,ldb,bt,c,ldc)
#define chemv_(u,n,al,a,lda,x,incx,bt,y,incy,l1) LFC_F77_chemv(u,n,al,a,lda,x,incx,bt,y,incy)
#define cher2_(u,n,al,x,incx,y,incy,a,lda,l1) LFC_F77_cher2(u,n,al,x,incx,y,incy,a,lda)
#define cher2k_(u,t,n,k,al,a,lda,b,ldb,bt,c,ldc,l1,l2) LFC_F77_cher2k(u,t,n,k,al,a,lda,b,ldb,bt,c,ldc)
#define cher_(u,n,al,x,incx,a,lda,l1) LFC_F77_cher(u,n,al,x,incx,a,lda)
#define cherk_(u,t,n,k,al,a,lda,bt,c,ldc,l1,l2) LFC_F77_cherk(u,t,n,k,al,a,lda,bt,c,ldc)

#define cbigp_  LFC_F77_cbigp
#define ccld_  LFC_F77_ccld

#define caxpy_  LFC_F77_caxpy
#define ccopy_  LFC_F77_ccopy
#define cdot_   LFC_F77_cdot
#define cgeru_   LFC_F77_cgeru
#define cgerc_   LFC_F77_cgerc
#define scnrm2_  LFC_F77_scnrm2
#define scasum_  LFC_F77_scasum
#define cscal_  LFC_F77_cscal
#define csscal_  LFC_F77_csscal
#define cswap_  LFC_F77_cswap
#define icamax_ LFC_F77_icamax

#define cgemv_(t,m,n,al,a,lda,x,incx,bt,y,incy,l1) LFC_F77_cgemv(t,m,n,al,a,lda,x,incx,bt,y,incy)
#define ctrmv_(u,t,d,n,a,lda,x,incx,l1,l2,l3) LFC_F77_ctrmv(u,t,d,n,a,lda,x,incx)
#define ctrsv_(u,t,d,n,a,lda,x,incx,l1,l2,l3) LFC_F77_ctrsv(u,t,d,n,a,lda,x,incx)
#define cgbmv_(t,m,n,l,u,al,a,lda,x,incx,bt,y,incy,l1) LFC_F77_cgbmv(t,m,n,l,u,al,a,lda,x,incx,bt,y,incy)
#define ctbsv_(u,t,d,n,k,a,lda,x,incx,l1,l2,l3) LFC_F77_ctbsv(u,t,d,n,k,a,lda,x,incx)

#define csymm_(s,u,m,n,al,a,lda,b,ldb,bt,c,ldc,l1,l2) LFC_F77_csymm(s,u,m,n,al,a,lda,b,ldb,bt,c,ldc)
#define csyrk_(u,t,n,k,al,a,lda,bt,c,ldc,l1,l2) LFC_F77_csyrk(u,t,n,k,al,a,lda,bt,c,ldc)
#define csyr2k_(u,t,n,k,al,a,lda,b,ldb,bt,c,ldc,l1,l2) LFC_F77_csyr2k(u,t,n,k,al,a,lda,b,ldb,bt,c,ldc)
#define cgemm_(ta,tb,m,n,k,al,a,lda,b,ldb,bt,c,ldc,l1,l2) LFC_F77_cgemm(ta,tb,m,n,k,al,a,lda,b,ldb,bt,c,ldc)
#define ctrmm_(s,u,t,d,m,n,al,a,lda,b,ldb,l1,l2,l3,l4) LFC_F77_ctrmm(s,u,t,d,m,n,al,a,lda,b,ldb)
#define ctrsm_(s,u,t,d,m,n,al,a,lda,b,ldb,l1,l2,l3,l4) LFC_F77_ctrsm(s,u,t,d,m,n,al,a,lda,b,ldb)

/*
  double precision complex
*/

#define zhbmv_(u,n,k,al,a,lda,x,incx,bt,y,incy,l1) LFC_F77_zhbmv(u,n,k,al,a,lda,x,incx,bt,y,incy)
#define zhemm_(s,u,m,n,al,a,lda,b,ldb,bt,c,ldc,l1,l2) LFC_F77_zhemm(s,u,m,n,al,a,lda,b,ldb,bt,c,ldc)
#define zhemv_(u,n,al,a,lda,x,incx,bt,y,incy,l1) LFC_F77_zhemv(u,n,al,a,lda,x,incx,bt,y,incy)
#define zher2_(u,n,al,x,incx,y,incy,a,lda,l1) LFC_F77_zher2(u,n,al,x,incx,y,incy,a,lda)
#define zher2k_(u,t,n,k,al,a,lda,b,ldb,bt,c,ldc,l1,l2) LFC_F77_zher2k(u,t,n,k,al,a,lda,b,ldb,bt,c,ldc)
#define zher_(u,n,al,x,incx,a,lda,l1) LFC_F77_zher(u,n,al,x,incx,a,lda)
#define zherk_(u,t,n,k,al,a,lda,bt,c,ldc,l1,l2) LFC_F77_zherk(u,t,n,k,al,a,lda,bt,c,ldc)

#define zbigp_  LFC_F77_zbigp
#define zcld_  LFC_F77_zcld

#define zaxpy_  LFC_F77_zaxpy
#define zcopy_  LFC_F77_zcopy
#define zdot_   LFC_F77_zdot
#define zgeru_   LFC_F77_zgeru
#define zgerc_   LFC_F77_zgerc
#define dznrm2_  LFC_F77_dznrm2
#define dzasum_  LFC_F77_dzasum
#define zscal_  LFC_F77_zscal
#define zdscal_  LFC_F77_zdscal
#define zswap_  LFC_F77_zswap
#define izamax_ LFC_F77_izamax

#define zgemv_(t,m,n,al,a,lda,x,incx,bt,y,incy,l1) LFC_F77_zgemv(t,m,n,al,a,lda,x,incx,bt,y,incy)
#define ztrmv_(u,t,d,n,a,lda,x,incx,l1,l2,l3) LFC_F77_ztrmv(u,t,d,n,a,lda,x,incx)
#define ztrsv_(u,t,d,n,a,lda,x,incx,l1,l2,l3) LFC_F77_ztrsv(u,t,d,n,a,lda,x,incx)
#define zgbmv_(t,m,n,l,u,al,a,lda,x,incx,bt,y,incy,l1) LFC_F77_zgbmv(t,m,n,l,u,al,a,lda,x,incx,bt,y,incy)
#define ztbsv_(u,t,d,n,k,a,lda,x,incx,l1,l2,l3) LFC_F77_ztbsv(u,t,d,n,k,a,lda,x,incx)

#define zsymm_(s,u,m,n,al,a,lda,b,ldb,bt,c,ldc,l1,l2) LFC_F77_zsymm(s,u,m,n,al,a,lda,b,ldb,bt,c,ldc)
#define zsyrk_(u,t,n,k,al,a,lda,bt,c,ldc,l1,l2) LFC_F77_zsyrk(u,t,n,k,al,a,lda,bt,c,ldc)
#define zsyr2k_(u,t,n,k,al,a,lda,b,ldb,bt,c,ldc,l1,l2) LFC_F77_zsyr2k(u,t,n,k,al,a,lda,b,ldb,bt,c,ldc)
#define zgemm_(ta,tb,m,n,k,al,a,lda,b,ldb,bt,c,ldc,l1,l2) LFC_F77_zgemm(ta,tb,m,n,k,al,a,lda,b,ldb,bt,c,ldc)
#define ztrmm_(s,u,t,d,m,n,al,a,lda,b,ldb,l1,l2,l3,l4) LFC_F77_ztrmm(s,u,t,d,m,n,al,a,lda,b,ldb)
#define ztrsm_(s,u,t,d,m,n,al,a,lda,b,ldb,l1,l2,l3,l4) LFC_F77_ztrsm(s,u,t,d,m,n,al,a,lda,b,ldb)
