/* dtrmm.f -- translated by f2c (version 20030320).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

#include "f2cblas.h"

/* Table of constant values */


/* Subroutine */ int dtrmm_(char *side, char *uplo, char *transa, char *diag, 
	integer *m, integer *n, doublereal *alpha, doublereal *a, integer *
	lda, doublereal *c__, integer *ldc, ftnlen side_len, ftnlen uplo_len, 
	ftnlen transa_len, ftnlen diag_len)
{
integer c__0 = 0;
doublereal c_b15 = 0.;
integer c__81 = 81;
integer c__82 = 82;
integer c__1 = 1;
integer c__64 = 64;
doublereal c_b38 = 1.;
integer c__83 = 83;
    /* System generated locals */
    integer a_dim1, a_offset, c_dim1, c_offset, i__1, i__2, i__3, i__4;

    /* Local variables */
    integer i__, j;
    doublereal t1[4096]	/* was [64][64] */, t2[4096]	/* was [64][64] */, 
	    t3[4096]	/* was [64][64] */;
    integer ii, jj, ix, jx;
    logical cldc;
    extern logical dcld_(integer *);
    integer offd, isec, jsec, info, tsec;
    logical notr;
    doublereal gamma;
    extern logical dbigp_(integer *, integer *, integer *);
    doublereal delta;
    extern /* Subroutine */ int dgemm_(char *, char *, integer *, integer *, 
	    integer *, doublereal *, doublereal *, integer *, doublereal *, 
	    integer *, doublereal *, doublereal *, integer *, ftnlen, ftnlen);
    logical lside;
    
    extern /* Subroutine */ int dgemv_(char *, integer *, integer *, 
	    doublereal *, doublereal *, integer *, doublereal *, integer *, 
	    doublereal *, doublereal *, integer *, ftnlen), dcopy_(integer *, 
	    doublereal *, integer *, doublereal *, integer *);
    integer nrowa;
    logical upper;
    extern /* Subroutine */ int dtrmv_(char *, char *, char *, integer *, 
	    doublereal *, integer *, doublereal *, integer *, ftnlen, ftnlen, 
	    ftnlen);
    logical tinym, tinyn;
    
    logical smalln, nounit;

/*     .. Scalar Arguments .. */
/*     .. Array Arguments .. */
/*     .. */

/*  Purpose */
/*  ======= */

/*  DTRMM  performs one of the matrix-matrix operations */

/*     C := alpha*op( A )*C,   or   C := alpha*C*op( A ), */

/*  where  alpha  is a scalar,  C  is an m by n matrix,  A  is a unit, or */
/*  non-unit,  upper or lower triangular matrix  and  op( A )  is one  of */

/*     op( A ) = A   or   op( A ) = A'. */

/*  Parameters */
/*  ========== */

/*  SIDE   - CHARACTER*1. */
/*           On entry,  SIDE specifies whether  op( A ) multiplies C from */
/*           the left or right as follows: */

/*              SIDE = 'L' or 'l'   C := alpha*op( A )*C. */

/*              SIDE = 'R' or 'r'   C := alpha*C*op( A ). */

/*           Unchanged on exit. */

/*  UPLO   - CHARACTER*1. */
/*           On entry, UPLO specifies whether the matrix A is an upper or */
/*           lower triangular matrix as follows: */

/*              UPLO = 'U' or 'u'   A is an upper triangular matrix. */

/*              UPLO = 'L' or 'l'   A is a lower triangular matrix. */

/*           Unchanged on exit. */

/*  TRANSA - CHARACTER*1. */
/*           On entry, TRANSA specifies the form of op( A ) to be used in */
/*           the matrix multiplication as follows: */

/*              TRANSA = 'N' or 'n'   op( A ) = A. */

/*              TRANSA = 'T' or 't'   op( A ) = A'. */

/*              TRANSA = 'C' or 'c'   op( A ) = A'. */

/*           Unchanged on exit. */

/*  DIAG   - CHARACTER*1. */
/*           On entry, DIAG specifies whether or not A is unit triangular */
/*           as follows: */

/*              DIAG = 'U' or 'u'   A is assumed to be unit triangular. */

/*              DIAG = 'N' or 'n'   A is not assumed to be unit */
/*                                  triangular. */

/*           Unchanged on exit. */

/*  M      - INTEGER. */
/*           On entry, M specifies the number of rows of C. M must be at */
/*           least zero. */
/*           Unchanged on exit. */

/*  N      - INTEGER. */
/*           On entry, N specifies the number of columns of C.  N must be */
/*           at least zero. */
/*           Unchanged on exit. */

/*  ALPHA  - DOUBLE PRECISION. */
/*           On entry,  ALPHA specifies the scalar  alpha. When  alpha is */
/*           zero then  A is not referenced and  C need not be set before */
/*           entry. */
/*           Unchanged on exit. */

/*  A      - DOUBLE PRECISION array of DIMENSION ( LDA, k ), where k is m */
/*           when  SIDE = 'L' or 'l'  and is  n  when  SIDE = 'R' or 'r'. */
/*           Before entry  with  UPLO = 'U' or 'u',  the  leading  k by k */
/*           upper triangular part of the array  A must contain the upper */
/*           triangular matrix  and the strictly lower triangular part of */
/*           A is not referenced. */
/*           Before entry  with  UPLO = 'L' or 'l',  the  leading  k by k */
/*           lower triangular part of the array  A must contain the lower */
/*           triangular matrix  and the strictly upper triangular part of */
/*           A is not referenced. */
/*           Note that when  DIAG = 'U' or 'u',  the diagonal elements of */
/*           A  are not referenced either,  but are assumed to be  unity. */
/*           Unchanged on exit. */

/*  LDA    - INTEGER. */
/*           On entry, LDA specifies the first dimension of A as declared */
/*           in the calling (sub) program.  When  SIDE = 'L' or 'l'  then */
/*           LDA  must be at least  max( 1, m ),  when  SIDE = 'R' or 'r' */
/*           then LDA must be at least max( 1, n ). */
/*           Unchanged on exit. */

/*  C      - DOUBLE PRECISION array of DIMENSION ( LDC, n ). */
/*           Before entry,  the leading  m by n part of the array  C must */
/*           contain the matrix  C,  and  on exit  is overwritten  by the */
/*           transformed matrix. */

/*  LDC    - INTEGER. */
/*           On entry, LDC specifies the first dimension of C as declared */
/*           in  the  calling  (sub)  program.   LDC  must  be  at  least */
/*           max( 1, m ). */
/*           Unchanged on exit. */


/*  Level 3 Blas routine. */

/*  -- Written on 8-February-1989. */
/*     Jack Dongarra, Argonne National Laboratory. */
/*     Iain Duff, AERE Harwell. */
/*     Jeremy Du Croz, Numerical Algorithms Group Ltd. */
/*     Sven Hammarling, Numerical Algorithms Group Ltd. */

/*  -- Rewritten in December-1993. */
/*     GEMM-Based Level 3 BLAS. */
/*     Per Ling, Institute of Information Processing, */
/*     University of Umea, Sweden. */


/*     .. Local Scalars .. */
/*     .. Intrinsic Functions .. */
/*     .. External Functions .. */
/*     .. External Subroutines .. */
/*     .. Parameters .. */
/*     .. User specified parameters for DTRMM .. */
/*     .. */
/*     .. Executable Statements .. */

/*     Test the input parameters. */

    /* Parameter adjustments */
    a_dim1 = *lda;
    a_offset = 1 + a_dim1;
    a -= a_offset;
    c_dim1 = *ldc;
    c_offset = 1 + c_dim1;
    c__ -= c_offset;

    /* Function Body */
    lside = (side[0]=='L'?1:0);
    upper = (uplo[0]=='U'?1:0);
    notr = (transa[0]=='N'?1:0);
    nounit = (diag[0]=='N'?1:0);
    if (nounit) {
	offd = 0;
    } else {
	offd = 1;
    }
    if (lside) {
	nrowa = *m;
    } else {
	nrowa = *n;
    }
    info = 0;
    if (! lside && ! (side[0]=='R'?1:0)) {
	info = 1;
    } else if (! upper && ! (uplo[0]=='L'?1:0)) {
	info = 2;
    } else if (! notr && ! (transa[0]=='T'?1:0) && ! 
	    (transa[0]=='C'?1:0)) {
	info = 3;
    } else if (! nounit && ! (diag[0]=='U'?1:0)) {
	info = 4;
    } else if (*m < 0) {
	info = 5;
    } else if (*n < 0) {
	info = 6;
    } else if (*lda < max(1,nrowa)) {
	info = 9;
    } else if (*ldc < max(1,*m)) {
	info = 11;
    }
    if (info != 0) {
	xerbla_("DTRMM ", &info, (ftnlen)6);
	return 0;
    }

/*     Quick return if possible. */

    if (*m == 0 || *n == 0) {
	return 0;
    }

/*     And when alpha.eq.zero. */

    if (*alpha == 0.) {
	i__1 = max(*lda,*ldc);
	i__2 = max(*lda,*ldc);
	dgemm_("N", "N", m, n, &c__0, &c_b15, &c__[c_offset], &i__1, &c__[
		c_offset], &i__2, &c_b15, &c__[c_offset], ldc, (ftnlen)1, (
		ftnlen)1);
	return 0;
    }

/*     Start the operations. */

    if (lside) {
	if (upper) {
	    if (notr) {

/*              Form  C := alpha*A*C. Left, Upper, No transpose. */

		smalln = ! dbigp_(&c__81, m, n);
		if (smalln) {
		    tinyn = ! dbigp_(&c__82, m, n);
		    i__1 = *m;
		    for (ii = 1; ii <= i__1; ii += 64) {
/* Computing MIN */
			i__2 = 64, i__3 = *m - ii + 1;
			isec = min(i__2,i__3);

/*                    C := alpha*C, scale the rectangular block of C */
/*                    with alpha. */

			if (*alpha != 1.) {
			    dgemm_("N", "N", &isec, n, &c__0, &c_b15, &a[
				    a_offset], lda, &c__[c_offset], ldc, 
				    alpha, &c__[ii + c_dim1], ldc, (ftnlen)1, 
				    (ftnlen)1);
			}
			if (tinyn) {

/*                       C := A*C, triangular matrix multiply involving */
/*                       a upper triangular diagonal block of A. */

			    i__2 = *n;
			    for (j = 1; j <= i__2; ++j) {
				dtrmv_("U", "N", diag, &isec, &a[ii + ii * 
					a_dim1], lda, &c__[ii + j * c_dim1], &
					c__1, (ftnlen)1, (ftnlen)1, (ftnlen)1)
					;
/* L10: */
			    }
			} else {

/*                       T3 := A, a upper unit or non-unit triangular */
/*                       diagonal block of A is copied to the upper */
/*                       triangular part of T3. */

			    i__2 = ii + isec - 1;
			    for (i__ = ii + offd; i__ <= i__2; ++i__) {
				i__3 = i__ - ii + 1 - offd;
				dcopy_(&i__3, &a[ii + i__ * a_dim1], &c__1, &
					t3[(i__ - ii + 1 << 6) - 64], &c__1);
/* L20: */
			    }

/*                       C := T3*C, triangular matrix multiply involving */
/*                       a upper triangular diagonal block of A stored */
/*                       in T3. */

			    i__2 = *n;
			    for (j = 1; j <= i__2; ++j) {
				dtrmv_("U", "N", diag, &isec, t3, &c__64, &
					c__[ii + j * c_dim1], &c__1, (ftnlen)
					1, (ftnlen)1, (ftnlen)1);
/* L30: */
			    }
			}

/*                    C := alpha*A*C + C, general matrix multiply */
/*                    involving a rectangular block of A. */

			if (ii + isec <= *m) {
			    i__2 = *m - ii - isec + 1;
			    dgemm_("N", "N", &isec, n, &i__2, alpha, &a[ii + (
				    ii + isec) * a_dim1], lda, &c__[ii + isec 
				    + c_dim1], ldc, &c_b38, &c__[ii + c_dim1],
				     ldc, (ftnlen)1, (ftnlen)1);
			}
/* L40: */
		    }
		} else {
		    delta = *alpha;
		    cldc = dcld_(ldc);
		    i__1 = *m;
		    for (ii = 1; ii <= i__1; ii += 64) {
/* Computing MIN */
			i__2 = 64, i__3 = *m - ii + 1;
			isec = min(i__2,i__3);

/*                    T2 := A', the transpose of a upper unit or non-unit */
/*                    triangular diagonal block of A is copied to the */
/*                    lower triangular part of T2. */

			i__2 = ii + isec - 1;
			for (i__ = ii + offd; i__ <= i__2; ++i__) {
			    i__3 = i__ - ii + 1 - offd;
			    dcopy_(&i__3, &a[ii + i__ * a_dim1], &c__1, &t2[
				    i__ - ii], &c__64);
/* L50: */
			}
			i__2 = *n;
			for (jj = 1; jj <= i__2; jj += 64) {
/* Computing MIN */
			    i__3 = 64, i__4 = *n - jj + 1;
			    jsec = min(i__3,i__4);

/*                       T1 := C', the transpose of a rectangular block */
/*                       of C is copied to T1. */

			    if (cldc) {
				i__3 = jj + jsec - 1;
				for (j = jj; j <= i__3; ++j) {
				    dcopy_(&isec, &c__[ii + j * c_dim1], &
					    c__1, &t1[j - jj], &c__64);
/* L60: */
				}
			    } else {
				i__3 = ii + isec - 1;
				for (i__ = ii; i__ <= i__3; ++i__) {
				    dcopy_(&jsec, &c__[i__ + jj * c_dim1], 
					    ldc, &t1[(i__ - ii + 1 << 6) - 64]
					    , &c__1);
/* L70: */
				}
			    }

/*                       T1 := gamma*T1*T2 + delta*T1, triangular matrix */
/*                       multiply where the value of delta depends on */
/*                       whether T2 stores a unit or non-unit triangular */
/*                       block. Gamma and tsec are used to compensate for */
/*                       a deficiency in DGEMV that appears if the second */
/*                       dimension (tsec) is zero. */

			    i__3 = ii + isec - 1;
			    for (i__ = ii; i__ <= i__3; ++i__) {
				if (nounit) {
				    delta = *alpha * t2[i__ - ii + 1 + (i__ - 
					    ii + 1 << 6) - 65];
				}
				gamma = *alpha;
				tsec = ii + isec - 1 - i__;
				if (tsec == 0) {
				    tsec = 1;
				    gamma = 0.;
				}
				dgemv_("N", &jsec, &tsec, &gamma, &t1[(i__ - 
					ii + 2 << 6) - 64], &c__64, &t2[i__ - 
					ii + 2 + (i__ - ii + 1 << 6) - 65], &
					c__1, &delta, &t1[(i__ - ii + 1 << 6) 
					- 64], &c__1, (ftnlen)1);
/* L80: */
			    }

/*                       C := T1', the transpose of T1 is copied back */
/*                       to C. */

			    i__3 = jj + jsec - 1;
			    for (j = jj; j <= i__3; ++j) {
				dcopy_(&isec, &t1[j - jj], &c__64, &c__[ii + 
					j * c_dim1], &c__1);
/* L90: */
			    }
/* L100: */
			}

/*                    C := alpha*A*C + C, general matrix multiply */
/*                    involving a rectangular block of A. */

			if (ii + isec <= *m) {
			    i__2 = *m - ii - isec + 1;
			    dgemm_("N", "N", &isec, n, &i__2, alpha, &a[ii + (
				    ii + isec) * a_dim1], lda, &c__[ii + isec 
				    + c_dim1], ldc, &c_b38, &c__[ii + c_dim1],
				     ldc, (ftnlen)1, (ftnlen)1);
			}
/* L110: */
		    }
		}
	    } else {

/*              Form  C := alpha*A'*C. Left, Upper, Transpose. */

		smalln = ! dbigp_(&c__81, m, n);
		if (smalln) {
		    tinyn = ! dbigp_(&c__82, m, n);
		    for (ii = *m - (*m - 1) % 64; ii >= 1; ii += -64) {
/* Computing MIN */
			i__1 = 64, i__2 = *m - ii + 1;
			isec = min(i__1,i__2);

/*                    C := alpha*C, scale the rectangular block of C */
/*                    with alpha. */

			if (*alpha != 1.) {
			    dgemm_("T", "N", &isec, n, &c__0, &c_b15, &a[
				    a_offset], lda, &c__[c_offset], ldc, 
				    alpha, &c__[ii + c_dim1], ldc, (ftnlen)1, 
				    (ftnlen)1);
			}
			if (tinyn) {

/*                       C := A'*C, triangular matrix multiply involving */
/*                       a upper triangular diagonal block of A. */

			    i__1 = *n;
			    for (j = 1; j <= i__1; ++j) {
				dtrmv_("U", "T", diag, &isec, &a[ii + ii * 
					a_dim1], lda, &c__[ii + j * c_dim1], &
					c__1, (ftnlen)1, (ftnlen)1, (ftnlen)1)
					;
/* L120: */
			    }
			} else {

/*                       T3 :=  A', the transpose of a upper unit or */
/*                       non-unit triangular diagonal block of A is */
/*                       copied to the lower triangular part of T3. */

			    i__1 = ii + isec - 1;
			    for (i__ = ii + offd; i__ <= i__1; ++i__) {
				i__2 = i__ - ii + 1 - offd;
				dcopy_(&i__2, &a[ii + i__ * a_dim1], &c__1, &
					t3[i__ - ii], &c__64);
/* L130: */
			    }

/*                       C := T3*C, triangular matrix multiply involving */
/*                       the transpose of a upper triangular diagonal */
/*                       block of A stored in T3. */

			    i__1 = *n;
			    for (j = 1; j <= i__1; ++j) {
				dtrmv_("L", "N", diag, &isec, t3, &c__64, &
					c__[ii + j * c_dim1], &c__1, (ftnlen)
					1, (ftnlen)1, (ftnlen)1);
/* L140: */
			    }
			}

/*                    C := alpha*A'*C + C, general matrix multiply */
/*                    involving the transpose of a rectangular block */
/*                    of A. */

			if (ii > 1) {
			    i__1 = ii - 1;
			    dgemm_("T", "N", &isec, n, &i__1, alpha, &a[ii * 
				    a_dim1 + 1], lda, &c__[c_dim1 + 1], ldc, &
				    c_b38, &c__[ii + c_dim1], ldc, (ftnlen)1, 
				    (ftnlen)1);
			}
/* L150: */
		    }
		} else {
		    delta = *alpha;
		    cldc = dcld_(ldc);
		    for (ii = *m - (*m - 1) % 64; ii >= 1; ii += -64) {
/* Computing MIN */
			i__1 = 64, i__2 = *m - ii + 1;
			isec = min(i__1,i__2);
			i__1 = *n;
			for (jj = 1; jj <= i__1; jj += 64) {
/* Computing MIN */
			    i__2 = 64, i__3 = *n - jj + 1;
			    jsec = min(i__2,i__3);

/*                       T1 := C', the transpose of a rectangular block */
/*                       of C is copied to T1. */

			    if (cldc) {
				i__2 = jj + jsec - 1;
				for (j = jj; j <= i__2; ++j) {
				    dcopy_(&isec, &c__[ii + j * c_dim1], &
					    c__1, &t1[j - jj], &c__64);
/* L160: */
				}
			    } else {
				i__2 = ii + isec - 1;
				for (i__ = ii; i__ <= i__2; ++i__) {
				    dcopy_(&jsec, &c__[i__ + jj * c_dim1], 
					    ldc, &t1[(i__ - ii + 1 << 6) - 64]
					    , &c__1);
/* L170: */
				}
			    }

/*                       T1 := gamma*T1*A + delta*T1, triangular matrix */
/*                       multiply where the value of delta depends on */
/*                       whether A is a unit or non-unit triangular */
/*                       matrix. Gamma and tsec are used to compensate */
/*                       for a deficiency in DGEMV that appears if the */
/*                       second dimension (tsec) is zero. */

			    i__2 = ii;
			    for (i__ = ii + isec - 1; i__ >= i__2; --i__) {
				if (nounit) {
				    delta = *alpha * a[i__ + i__ * a_dim1];
				}
				gamma = *alpha;
				tsec = i__ - ii;
				if (tsec == 0) {
				    tsec = 1;
				    gamma = 0.;
				}
				dgemv_("N", &jsec, &tsec, &gamma, t1, &c__64, 
					&a[ii + i__ * a_dim1], &c__1, &delta, 
					&t1[(i__ - ii + 1 << 6) - 64], &c__1, 
					(ftnlen)1);
/* L180: */
			    }

/*                       C := T1', the transpose of T1 is copied back */
/*                       to C. */

			    i__2 = jj + jsec - 1;
			    for (j = jj; j <= i__2; ++j) {
				dcopy_(&isec, &t1[j - jj], &c__64, &c__[ii + 
					j * c_dim1], &c__1);
/* L190: */
			    }
/* L200: */
			}

/*                    C := alpha*A'*C + C, general matrix multiply */
/*                    involving the transpose of a rectangular block */
/*                    of A. */

			if (ii > 1) {
			    i__1 = ii - 1;
			    dgemm_("T", "N", &isec, n, &i__1, alpha, &a[ii * 
				    a_dim1 + 1], lda, &c__[c_dim1 + 1], ldc, &
				    c_b38, &c__[ii + c_dim1], ldc, (ftnlen)1, 
				    (ftnlen)1);
			}
/* L210: */
		    }
		}
	    }
	} else {
	    if (notr) {

/*              Form  C := alpha*A*C. Left, Lower, No transpose. */

		smalln = ! dbigp_(&c__81, m, n);
		if (smalln) {
		    tinyn = ! dbigp_(&c__82, m, n);
		    for (ix = *m; ix >= 1; ix += -64) {
/* Computing MAX */
			i__1 = 1, i__2 = ix - 63;
			ii = max(i__1,i__2);
			isec = ix - ii + 1;

/*                    C := alpha*C, scale the rectangular block of C */
/*                    with alpha. */

			if (*alpha != 1.) {
			    dgemm_("N", "N", &isec, n, &c__0, &c_b15, &a[
				    a_offset], lda, &c__[c_offset], ldc, 
				    alpha, &c__[ii + c_dim1], ldc, (ftnlen)1, 
				    (ftnlen)1);
			}
			if (tinyn) {

/*                       C := A*C, triangular matrix multiply involving */
/*                       a lower triangular diagonal block of A. */

			    i__1 = *n;
			    for (j = 1; j <= i__1; ++j) {
				dtrmv_("L", "N", diag, &isec, &a[ii + ii * 
					a_dim1], lda, &c__[ii + j * c_dim1], &
					c__1, (ftnlen)1, (ftnlen)1, (ftnlen)1)
					;
/* L220: */
			    }
			} else {

/*                       T3 := A, a lower unit or non-unit triangular */
/*                       diagonal block of A is copied to the lower */
/*                       triangular part of T3. */

			    i__1 = ii + isec - 1 - offd;
			    for (i__ = ii; i__ <= i__1; ++i__) {
				i__2 = ii + isec - i__ - offd;
				dcopy_(&i__2, &a[i__ + offd + i__ * a_dim1], &
					c__1, &t3[i__ - ii + 1 + offd + (i__ 
					- ii + 1 << 6) - 65], &c__1);
/* L230: */
			    }

/*                       C := T3*C, triangular matrix multiply involving */
/*                       a lower triangular diagonal block of A stored */
/*                       in T3. */

			    i__1 = *n;
			    for (j = 1; j <= i__1; ++j) {
				dtrmv_("L", "N", diag, &isec, t3, &c__64, &
					c__[ii + j * c_dim1], &c__1, (ftnlen)
					1, (ftnlen)1, (ftnlen)1);
/* L240: */
			    }
			}

/*                    C := alpha*A'*C + C, general matrix multiply */
/*                    involving a rectangular block of A. */

			if (ii > 1) {
			    i__1 = ii - 1;
			    dgemm_("N", "N", &isec, n, &i__1, alpha, &a[ii + 
				    a_dim1], lda, &c__[c_dim1 + 1], ldc, &
				    c_b38, &c__[ii + c_dim1], ldc, (ftnlen)1, 
				    (ftnlen)1);
			}
/* L250: */
		    }
		} else {
		    delta = *alpha;
		    cldc = dcld_(ldc);
		    for (ix = *m; ix >= 1; ix += -64) {
/* Computing MAX */
			i__1 = 1, i__2 = ix - 63;
			ii = max(i__1,i__2);
			isec = ix - ii + 1;

/*                    T2 := A', the transpose of a lower unit or non-unit */
/*                    triangular diagonal block of A is copied to the */
/*                    upper triangular part of T2. */

			i__1 = ii + isec - 1 - offd;
			for (i__ = ii; i__ <= i__1; ++i__) {
			    i__2 = ii + isec - i__ - offd;
			    dcopy_(&i__2, &a[i__ + offd + i__ * a_dim1], &
				    c__1, &t2[i__ - ii + 1 + (i__ - ii + 1 + 
				    offd << 6) - 65], &c__64);
/* L260: */
			}
			i__1 = *n;
			for (jj = 1; jj <= i__1; jj += 64) {
/* Computing MIN */
			    i__2 = 64, i__3 = *n - jj + 1;
			    jsec = min(i__2,i__3);

/*                       T1 := C', the transpose of a rectangular block */
/*                       of C is copied to T1. */

			    if (cldc) {
				i__2 = jj + jsec - 1;
				for (j = jj; j <= i__2; ++j) {
				    dcopy_(&isec, &c__[ii + j * c_dim1], &
					    c__1, &t1[j - jj], &c__64);
/* L270: */
				}
			    } else {
				i__2 = ii + isec - 1;
				for (i__ = ii; i__ <= i__2; ++i__) {
				    dcopy_(&jsec, &c__[i__ + jj * c_dim1], 
					    ldc, &t1[(i__ - ii + 1 << 6) - 64]
					    , &c__1);
/* L280: */
				}
			    }

/*                       T1 := gamma*T1*T2 + delta*T1, triangular matrix */
/*                       multiply where the value of delta depends on */
/*                       whether T2 stores a unit or non-unit triangular */
/*                       block. Gamma and tsec are used to compensate for */
/*                       a deficiency in DGEMV that appears if the second */
/*                       dimension (tsec) is zero. */

			    i__2 = ii;
			    for (i__ = ii + isec - 1; i__ >= i__2; --i__) {
				if (nounit) {
				    delta = *alpha * t2[i__ - ii + 1 + (i__ - 
					    ii + 1 << 6) - 65];
				}
				gamma = *alpha;
				tsec = i__ - ii;
				if (tsec == 0) {
				    tsec = 1;
				    gamma = 0.;
				}
				dgemv_("N", &jsec, &tsec, &gamma, t1, &c__64, 
					&t2[(i__ - ii + 1 << 6) - 64], &c__1, 
					&delta, &t1[(i__ - ii + 1 << 6) - 64],
					 &c__1, (ftnlen)1);
/* L290: */
			    }

/*                       C := T1', the transpose of T1 is copied back */
/*                       to C. */

			    i__2 = jj + jsec - 1;
			    for (j = jj; j <= i__2; ++j) {
				dcopy_(&isec, &t1[j - jj], &c__64, &c__[ii + 
					j * c_dim1], &c__1);
/* L300: */
			    }
/* L310: */
			}

/*                    C := alpha*A'*C + C, general matrix multiply */
/*                    involving a rectangular block of A. */

			if (ii > 1) {
			    i__1 = ii - 1;
			    dgemm_("N", "N", &isec, n, &i__1, alpha, &a[ii + 
				    a_dim1], lda, &c__[c_dim1 + 1], ldc, &
				    c_b38, &c__[ii + c_dim1], ldc, (ftnlen)1, 
				    (ftnlen)1);
			}
/* L320: */
		    }
		}
	    } else {

/*              Form  C := alpha*A'*C. Left, Lower, Transpose. */

		smalln = ! dbigp_(&c__81, m, n);
		if (smalln) {
		    tinyn = ! dbigp_(&c__82, m, n);
		    i__1 = *m;
		    for (ix = (*m - 1) % 64 + 1; ix <= i__1; ix += 64) {
/* Computing MAX */
			i__2 = 1, i__3 = ix - 63;
			ii = max(i__2,i__3);
			isec = ix - ii + 1;

/*                    C := alpha*C, scale the rectangular block of C */
/*                    with alpha. */

			if (*alpha != 1.) {
			    dgemm_("T", "N", &isec, n, &c__0, &c_b15, &a[
				    a_offset], lda, &c__[c_offset], ldc, 
				    alpha, &c__[ii + c_dim1], ldc, (ftnlen)1, 
				    (ftnlen)1);
			}
			if (tinyn) {

/*                       C := A'*C, triangular matrix multiply involving */
/*                       a lower triangular diagonal block of A. */

			    i__2 = *n;
			    for (j = 1; j <= i__2; ++j) {
				dtrmv_("L", "T", diag, &isec, &a[ii + ii * 
					a_dim1], lda, &c__[ii + j * c_dim1], &
					c__1, (ftnlen)1, (ftnlen)1, (ftnlen)1)
					;
/* L330: */
			    }
			} else {

/*                       T3 :=  A', the transpose of a lower unit or */
/*                       non-unit triangular diagonal block of A is */
/*                       copied to the upper triangular part of T3. */

			    i__2 = ii + isec - 1 - offd;
			    for (i__ = ii; i__ <= i__2; ++i__) {
				i__3 = ii + isec - i__ - offd;
				dcopy_(&i__3, &a[i__ + offd + i__ * a_dim1], &
					c__1, &t3[i__ - ii + 1 + (i__ - ii + 
					1 + offd << 6) - 65], &c__64);
/* L340: */
			    }

/*                       C := alpha*T3*C, triangular matrix multiply */
/*                       involving the transpose of a lower triangular */
/*                       diagonal block of A stored in T3. */

			    i__2 = *n;
			    for (j = 1; j <= i__2; ++j) {
				dtrmv_("U", "N", diag, &isec, t3, &c__64, &
					c__[ii + j * c_dim1], &c__1, (ftnlen)
					1, (ftnlen)1, (ftnlen)1);
/* L350: */
			    }
			}

/*                    C := alpha*A'*C + C, general matrix multiply */
/*                    involving the transpose of a rectangular block */
/*                    of A. */

			if (ii + isec <= *m) {
			    i__2 = *m - ii - isec + 1;
			    dgemm_("T", "N", &isec, n, &i__2, alpha, &a[ii + 
				    isec + ii * a_dim1], lda, &c__[ii + isec 
				    + c_dim1], ldc, &c_b38, &c__[ii + c_dim1],
				     ldc, (ftnlen)1, (ftnlen)1);
			}
/* L360: */
		    }
		} else {
		    delta = *alpha;
		    cldc = dcld_(ldc);
		    i__1 = *m;
		    for (ix = (*m - 1) % 64 + 1; ix <= i__1; ix += 64) {
/* Computing MAX */
			i__2 = 1, i__3 = ix - 63;
			ii = max(i__2,i__3);
			isec = ix - ii + 1;
			i__2 = *n;
			for (jj = 1; jj <= i__2; jj += 64) {
/* Computing MIN */
			    i__3 = 64, i__4 = *n - jj + 1;
			    jsec = min(i__3,i__4);

/*                       T1 := C', the transpose of a rectangular block */
/*                       of C is copied to T1. */

			    if (cldc) {
				i__3 = jj + jsec - 1;
				for (j = jj; j <= i__3; ++j) {
				    dcopy_(&isec, &c__[ii + j * c_dim1], &
					    c__1, &t1[j - jj], &c__64);
/* L370: */
				}
			    } else {
				i__3 = ii + isec - 1;
				for (i__ = ii; i__ <= i__3; ++i__) {
				    dcopy_(&jsec, &c__[i__ + jj * c_dim1], 
					    ldc, &t1[(i__ - ii + 1 << 6) - 64]
					    , &c__1);
/* L380: */
				}
			    }

/*                       T1 := gamma*T1*A + delta*T1, triangular matrix */
/*                       multiply where the value of delta depends on */
/*                       whether A is a unit or non-unit triangular */
/*                       matrix. Gamma and tsec are used to compensate */
/*                       for a deficiency in DGEMV that appears if the */
/*                       second dimension (tsec) is zero. */

			    i__3 = ii + isec - 1;
			    for (i__ = ii; i__ <= i__3; ++i__) {
				if (nounit) {
				    delta = *alpha * a[i__ + i__ * a_dim1];
				}
				gamma = *alpha;
				tsec = ii + isec - 1 - i__;
				if (tsec == 0) {
				    tsec = 1;
				    gamma = 0.;
				}
				dgemv_("N", &jsec, &tsec, &gamma, &t1[(i__ - 
					ii + 2 << 6) - 64], &c__64, &a[i__ + 
					1 + i__ * a_dim1], &c__1, &delta, &t1[
					(i__ - ii + 1 << 6) - 64], &c__1, (
					ftnlen)1);
/* L390: */
			    }

/*                       C := T1', the transpose of T1 is copied back */
/*                       to C. */

			    i__3 = jj + jsec - 1;
			    for (j = jj; j <= i__3; ++j) {
				dcopy_(&isec, &t1[j - jj], &c__64, &c__[ii + 
					j * c_dim1], &c__1);
/* L400: */
			    }
/* L410: */
			}

/*                    C := alpha*A'*C + C, general matrix multiply */
/*                    involving the transpose of a rectangular block */
/*                    of A. */

			if (ii + isec <= *m) {
			    i__2 = *m - ii - isec + 1;
			    dgemm_("T", "N", &isec, n, &i__2, alpha, &a[ii + 
				    isec + ii * a_dim1], lda, &c__[ii + isec 
				    + c_dim1], ldc, &c_b38, &c__[ii + c_dim1],
				     ldc, (ftnlen)1, (ftnlen)1);
			}
/* L420: */
		    }
		}
	    }
	}
    } else {
	if (upper) {
	    if (notr) {

/*              Form  C := alpha*C*A. Right, Upper, No transpose. */

		tinym = ! dbigp_(&c__83, m, n);
		if (tinym) {
		    for (jj = *n - (*n - 1) % 64; jj >= 1; jj += -64) {
/* Computing MIN */
			i__1 = 64, i__2 = *n - jj + 1;
			jsec = min(i__1,i__2);

/*                    C := alpha*C, scale the rectangular block of C */
/*                    with alpha. */

			if (*alpha != 1.) {
			    dgemm_("N", "N", m, &jsec, &c__0, &c_b15, &c__[
				    c_offset], ldc, &a[a_offset], lda, alpha, 
				    &c__[jj * c_dim1 + 1], ldc, (ftnlen)1, (
				    ftnlen)1);
			}

/*                    C := C*A, triangular matrix multiply involving a */
/*                    upper triangular diagonal block of A. */

			i__1 = *m;
			for (i__ = 1; i__ <= i__1; ++i__) {
			    dtrmv_("U", "T", diag, &jsec, &a[jj + jj * a_dim1]
				    , lda, &c__[i__ + jj * c_dim1], ldc, (
				    ftnlen)1, (ftnlen)1, (ftnlen)1);
/* L430: */
			}

/*                    C := alpha*C*A + C, general matrix multiply */
/*                    involving a rectangular block of A. */

			if (jj > 1) {
			    i__1 = jj - 1;
			    dgemm_("N", "N", m, &jsec, &i__1, alpha, &c__[
				    c_dim1 + 1], ldc, &a[jj * a_dim1 + 1], 
				    lda, &c_b38, &c__[jj * c_dim1 + 1], ldc, (
				    ftnlen)1, (ftnlen)1);
			}
/* L440: */
		    }
		} else {
		    delta = *alpha;
		    for (jj = *n - (*n - 1) % 64; jj >= 1; jj += -64) {
/* Computing MIN */
			i__1 = 64, i__2 = *n - jj + 1;
			jsec = min(i__1,i__2);
			i__1 = *m;
			for (ii = 1; ii <= i__1; ii += 64) {
/* Computing MIN */
			    i__2 = 64, i__3 = *m - ii + 1;
			    isec = min(i__2,i__3);

/*                       T1 := C, a rectangular block of C is copied */
/*                       to T1. */

			    i__2 = jj + jsec - 1;
			    for (j = jj; j <= i__2; ++j) {
				dcopy_(&isec, &c__[ii + j * c_dim1], &c__1, &
					t1[(j - jj + 1 << 6) - 64], &c__1);
/* L450: */
			    }

/*                       C := gamma*T1*A + delta*C, triangular matrix */
/*                       multiply where the value of delta depends on */
/*                       whether A is a unit or non-unit triangular */
/*                       matrix. Gamma and tsec are used to compensate */
/*                       for a deficiency in DGEMV that appears if the */
/*                       second dimension (tsec) is zero. */

			    i__2 = jj;
			    for (j = jj + jsec - 1; j >= i__2; --j) {
				if (nounit) {
				    delta = *alpha * a[j + j * a_dim1];
				}
				gamma = *alpha;
				tsec = j - jj;
				if (tsec == 0) {
				    tsec = 1;
				    gamma = 0.;
				}
				dgemv_("N", &isec, &tsec, &gamma, t1, &c__64, 
					&a[jj + j * a_dim1], &c__1, &delta, &
					c__[ii + j * c_dim1], &c__1, (ftnlen)
					1);
/* L460: */
			    }
/* L470: */
			}

/*                    C := alpha*C*A + C, general matrix multiply */
/*                    involving a rectangular block of A. */

			if (jj > 1) {
			    i__1 = jj - 1;
			    dgemm_("N", "N", m, &jsec, &i__1, alpha, &c__[
				    c_dim1 + 1], ldc, &a[jj * a_dim1 + 1], 
				    lda, &c_b38, &c__[jj * c_dim1 + 1], ldc, (
				    ftnlen)1, (ftnlen)1);
			}
/* L480: */
		    }
		}
	    } else {

/*              Form  C := alpha*C*A'. Right, Upper, Transpose. */

		tinym = ! dbigp_(&c__83, m, n);
		if (tinym) {
		    i__1 = *n;
		    for (jj = 1; jj <= i__1; jj += 64) {
/* Computing MIN */
			i__2 = 64, i__3 = *n - jj + 1;
			jsec = min(i__2,i__3);

/*                    C := alpha*C, scale the rectangular block of C */
/*                    with alpha. */

			if (*alpha != 1.) {
			    dgemm_("N", "T", m, &jsec, &c__0, &c_b15, &c__[
				    c_offset], ldc, &a[a_offset], lda, alpha, 
				    &c__[jj * c_dim1 + 1], ldc, (ftnlen)1, (
				    ftnlen)1);
			}

/*                    C := C*A', triangular matrix multiply involving a */
/*                    upper triangular diagonal block of A. */

			i__2 = *m;
			for (i__ = 1; i__ <= i__2; ++i__) {
			    dtrmv_("U", "N", diag, &jsec, &a[jj + jj * a_dim1]
				    , lda, &c__[i__ + jj * c_dim1], ldc, (
				    ftnlen)1, (ftnlen)1, (ftnlen)1);
/* L490: */
			}

/*                    C := alpha*C*A' + C, general matrix multiply */
/*                    involving the transpose of a rectangular block */
/*                    of A. */

			if (jj + jsec <= *n) {
			    i__2 = *n - jj - jsec + 1;
			    dgemm_("N", "T", m, &jsec, &i__2, alpha, &c__[(jj 
				    + jsec) * c_dim1 + 1], ldc, &a[jj + (jj + 
				    jsec) * a_dim1], lda, &c_b38, &c__[jj * 
				    c_dim1 + 1], ldc, (ftnlen)1, (ftnlen)1);
			}
/* L500: */
		    }
		} else {
		    delta = *alpha;
		    i__1 = *n;
		    for (jj = 1; jj <= i__1; jj += 64) {
/* Computing MIN */
			i__2 = 64, i__3 = *n - jj + 1;
			jsec = min(i__2,i__3);

/*                    T2 := A', the transpose of a upper unit or non-unit */
/*                    triangular diagonal block of A is copied to the */
/*                    lower triangular part of T2. */

			i__2 = jj + jsec - 1;
			for (j = jj + offd; j <= i__2; ++j) {
			    i__3 = j - jj + 1 - offd;
			    dcopy_(&i__3, &a[jj + j * a_dim1], &c__1, &t2[j - 
				    jj], &c__64);
/* L510: */
			}
			i__2 = *m;
			for (ii = 1; ii <= i__2; ii += 64) {
/* Computing MIN */
			    i__3 = 64, i__4 = *m - ii + 1;
			    isec = min(i__3,i__4);

/*                       T1 := C, a rectangular block of C is copied */
/*                       to T1. */

			    i__3 = jj + jsec - 1;
			    for (j = jj; j <= i__3; ++j) {
				dcopy_(&isec, &c__[ii + j * c_dim1], &c__1, &
					t1[(j - jj + 1 << 6) - 64], &c__1);
/* L520: */
			    }

/*                       C := gamma*T1*T2 + delta*C, triangular matrix */
/*                       multiply where the value of delta depends on */
/*                       whether T2 is a unit or non-unit triangular */
/*                       matrix. Gamma and tsec are used to compensate */
/*                       for a deficiency in DGEMV that appears if the */
/*                       second dimension (tsec) is zero. */

			    i__3 = jj + jsec - 1;
			    for (j = jj; j <= i__3; ++j) {
				if (nounit) {
				    delta = *alpha * t2[j - jj + 1 + (j - jj 
					    + 1 << 6) - 65];
				}
				gamma = *alpha;
				tsec = jj + jsec - 1 - j;
				if (tsec == 0) {
				    tsec = 1;
				    gamma = 0.;
				}
				dgemv_("N", &isec, &tsec, &gamma, &t1[(j - jj 
					+ 2 << 6) - 64], &c__64, &t2[j - jj + 
					2 + (j - jj + 1 << 6) - 65], &c__1, &
					delta, &c__[ii + j * c_dim1], &c__1, (
					ftnlen)1);
/* L530: */
			    }
/* L540: */
			}

/*                    C := alpha*C*A' + C, general matrix multiply */
/*                    involving the transpose of a rectangular block */
/*                    of A. */

			if (jj + jsec <= *n) {
			    i__2 = *n - jj - jsec + 1;
			    dgemm_("N", "T", m, &jsec, &i__2, alpha, &c__[(jj 
				    + jsec) * c_dim1 + 1], ldc, &a[jj + (jj + 
				    jsec) * a_dim1], lda, &c_b38, &c__[jj * 
				    c_dim1 + 1], ldc, (ftnlen)1, (ftnlen)1);
			}
/* L550: */
		    }
		}
	    }
	} else {
	    if (notr) {

/*              Form  C := alpha*C*A. Right, Lower, No transpose. */

		tinym = ! dbigp_(&c__83, m, n);
		if (tinym) {
		    i__1 = *n;
		    for (jx = (*n - 1) % 64 + 1; jx <= i__1; jx += 64) {
/* Computing MAX */
			i__2 = 1, i__3 = jx - 63;
			jj = max(i__2,i__3);
			jsec = jx - jj + 1;

/*                    C := alpha*C, scale the rectangular block of C */
/*                    with alpha. */

			if (*alpha != 1.) {
			    dgemm_("N", "N", m, &jsec, &c__0, &c_b15, &c__[
				    c_offset], ldc, &a[a_offset], lda, alpha, 
				    &c__[jj * c_dim1 + 1], ldc, (ftnlen)1, (
				    ftnlen)1);
			}

/*                    C := C*A, triangular matrix multiply involving a */
/*                    lower triangular diagonal block of A. */

			i__2 = *m;
			for (i__ = 1; i__ <= i__2; ++i__) {
			    dtrmv_("L", "T", diag, &jsec, &a[jj + jj * a_dim1]
				    , lda, &c__[i__ + jj * c_dim1], ldc, (
				    ftnlen)1, (ftnlen)1, (ftnlen)1);
/* L560: */
			}

/*                    C := alpha*C*A + C, general matrix multiply */
/*                    involving a rectangular block of A. */

			if (jj + jsec <= *n) {
			    i__2 = *n - jj - jsec + 1;
			    dgemm_("N", "N", m, &jsec, &i__2, alpha, &c__[(jj 
				    + jsec) * c_dim1 + 1], ldc, &a[jj + jsec 
				    + jj * a_dim1], lda, &c_b38, &c__[jj * 
				    c_dim1 + 1], ldc, (ftnlen)1, (ftnlen)1);
			}
/* L570: */
		    }
		} else {
		    delta = *alpha;
		    i__1 = *n;
		    for (jx = (*n - 1) % 64 + 1; jx <= i__1; jx += 64) {
/* Computing MAX */
			i__2 = 1, i__3 = jx - 63;
			jj = max(i__2,i__3);
			jsec = jx - jj + 1;
			i__2 = *m;
			for (ii = 1; ii <= i__2; ii += 64) {
/* Computing MIN */
			    i__3 = 64, i__4 = *m - ii + 1;
			    isec = min(i__3,i__4);

/*                       T1 := C, a rectangular block of C is copied */
/*                       to T1. */

			    i__3 = jj + jsec - 1;
			    for (j = jj; j <= i__3; ++j) {
				dcopy_(&isec, &c__[ii + j * c_dim1], &c__1, &
					t1[(j - jj + 1 << 6) - 64], &c__1);
/* L580: */
			    }

/*                       C := gamma*T1*A + delta*C, triangular matrix */
/*                       multiply where the value of delta depends on */
/*                       whether A is a unit or non-unit triangular */
/*                       matrix. Gamma and tsec are used to compensate */
/*                       for a deficiency in DGEMV that appears if the */
/*                       second dimension (tsec) is zero. */

			    i__3 = jj + jsec - 1;
			    for (j = jj; j <= i__3; ++j) {
				if (nounit) {
				    delta = *alpha * a[j + j * a_dim1];
				}
				gamma = *alpha;
				tsec = jj + jsec - 1 - j;
				if (tsec == 0) {
				    tsec = 1;
				    gamma = 0.;
				}
				dgemv_("N", &isec, &tsec, &gamma, &t1[(j - jj 
					+ 2 << 6) - 64], &c__64, &a[j + 1 + j 
					* a_dim1], &c__1, &delta, &c__[ii + j 
					* c_dim1], &c__1, (ftnlen)1);
/* L590: */
			    }
/* L600: */
			}

/*                    C := alpha*C*A + C, general matrix multiply */
/*                    involving a rectangular block of A. */

			if (jj + jsec <= *n) {
			    i__2 = *n - jj - jsec + 1;
			    dgemm_("N", "N", m, &jsec, &i__2, alpha, &c__[(jj 
				    + jsec) * c_dim1 + 1], ldc, &a[jj + jsec 
				    + jj * a_dim1], lda, &c_b38, &c__[jj * 
				    c_dim1 + 1], ldc, (ftnlen)1, (ftnlen)1);
			}
/* L610: */
		    }
		}
	    } else {

/*              Form  C := alpha*C*A'. Right, Lower, Transpose. */

		tinym = ! dbigp_(&c__83, m, n);
		if (tinym) {
		    for (jx = *n; jx >= 1; jx += -64) {
/* Computing MAX */
			i__1 = 1, i__2 = jx - 63;
			jj = max(i__1,i__2);
			jsec = jx - jj + 1;

/*                    C := alpha*C, scale the rectangular block of C */
/*                    with alpha. */

			if (*alpha != 1.) {
			    dgemm_("N", "T", m, &jsec, &c__0, &c_b15, &c__[
				    c_offset], ldc, &a[a_offset], lda, alpha, 
				    &c__[jj * c_dim1 + 1], ldc, (ftnlen)1, (
				    ftnlen)1);
			}

/*                    C := C*A', triangular matrix multiply involving */
/*                    a lower triangular diagonal block of A. */

			i__1 = *m;
			for (i__ = 1; i__ <= i__1; ++i__) {
			    dtrmv_("L", "N", diag, &jsec, &a[jj + jj * a_dim1]
				    , lda, &c__[i__ + jj * c_dim1], ldc, (
				    ftnlen)1, (ftnlen)1, (ftnlen)1);
/* L620: */
			}

/*                    C := alpha*C*A' + C, general matrix multiply */
/*                    involving the transpose of a rectangular block */
/*                    of A. */

			if (jj > 1) {
			    i__1 = jj - 1;
			    dgemm_("N", "T", m, &jsec, &i__1, alpha, &c__[
				    c_dim1 + 1], ldc, &a[jj + a_dim1], lda, &
				    c_b38, &c__[jj * c_dim1 + 1], ldc, (
				    ftnlen)1, (ftnlen)1);
			}
/* L630: */
		    }
		} else {
		    delta = *alpha;
		    for (jx = *n; jx >= 1; jx += -64) {
/* Computing MAX */
			i__1 = 1, i__2 = jx - 63;
			jj = max(i__1,i__2);
			jsec = jx - jj + 1;

/*                    T2 := A', the transpose of a lower unit or non-unit */
/*                    triangular diagonal block of A is copied to the */
/*                    upper triangular part of T2. */

			i__1 = jj + jsec - 1 - offd;
			for (j = jj; j <= i__1; ++j) {
			    i__2 = jj + jsec - j - offd;
			    dcopy_(&i__2, &a[j + offd + j * a_dim1], &c__1, &
				    t2[j - jj + 1 + (j - jj + 1 + offd << 6) 
				    - 65], &c__64);
/* L640: */
			}
			i__1 = *m;
			for (ii = 1; ii <= i__1; ii += 64) {
/* Computing MIN */
			    i__2 = 64, i__3 = *m - ii + 1;
			    isec = min(i__2,i__3);

/*                       T1 := C, a rectangular block of C is copied */
/*                       to T1. */

			    i__2 = jj + jsec - 1;
			    for (j = jj; j <= i__2; ++j) {
				dcopy_(&isec, &c__[ii + j * c_dim1], &c__1, &
					t1[(j - jj + 1 << 6) - 64], &c__1);
/* L650: */
			    }

/*                       C := gamma*T1*T2 + delta*C, triangular matrix */
/*                       multiply where the value of delta depends on */
/*                       whether T2 is a unit or non-unit triangular */
/*                       matrix. Gamma and tsec are used to compensate */
/*                       for a deficiency in DGEMV that appears if the */
/*                       second dimension (tsec) is zero. */

			    i__2 = jj;
			    for (j = jj + jsec - 1; j >= i__2; --j) {
				if (nounit) {
				    delta = *alpha * t2[j - jj + 1 + (j - jj 
					    + 1 << 6) - 65];
				}
				gamma = *alpha;
				tsec = j - jj;
				if (tsec == 0) {
				    tsec = 1;
				    gamma = 0.;
				}
				dgemv_("N", &isec, &tsec, &gamma, t1, &c__64, 
					&t2[(j - jj + 1 << 6) - 64], &c__1, &
					delta, &c__[ii + j * c_dim1], &c__1, (
					ftnlen)1);
/* L660: */
			    }
/* L670: */
			}

/*                    C := alpha*C*A' + C, general matrix multiply */
/*                    involving the transpose of a rectangular block */
/*                    of A. */

			if (jj > 1) {
			    i__1 = jj - 1;
			    dgemm_("N", "T", m, &jsec, &i__1, alpha, &c__[
				    c_dim1 + 1], ldc, &a[jj + a_dim1], lda, &
				    c_b38, &c__[jj * c_dim1 + 1], ldc, (
				    ftnlen)1, (ftnlen)1);
			}
/* L680: */
		    }
		}
	    }
	}
    }

    return 0;

/*     End of DTRMM. */

} /* dtrmm_ */

