/* dsyrk.f -- translated by f2c (version 20030320).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

#include "f2cblas.h"

/* Table of constant values */


/* Subroutine */ int dsyrk_(char *uplo, char *trans, integer *n, integer *k, 
	doublereal *alpha, doublereal *a, integer *lda, doublereal *beta, 
	doublereal *c__, integer *ldc, ftnlen uplo_len, ftnlen trans_len)
{
integer c__1 = 1;
integer c__41 = 41;
integer c__42 = 42;
integer c__64 = 64;
    /* System generated locals */
    integer a_dim1, a_offset, c_dim1, c_offset, i__1, i__2, i__3, i__4;

    /* Local variables */
    integer i__, l;
    doublereal t1[4096]	/* was [64][64] */, t2[4096]	/* was [64][64] */, 
	    t3[4096]	/* was [64][64] */;
    integer ii, ll, ix;
    logical clda;
    extern logical dcld_(integer *);
    integer isec, lsec, info;
    extern /* Subroutine */ int dsyr_(char *, integer *, doublereal *, 
	    doublereal *, integer *, doublereal *, integer *, ftnlen);
    logical notr;
    extern logical dbigp_(integer *, integer *, integer *);
    extern /* Subroutine */ int dscal_(integer *, doublereal *, doublereal *, 
	    integer *);
    doublereal delta;
    extern /* Subroutine */ int dgemm_(char *, char *, integer *, integer *, 
	    integer *, doublereal *, doublereal *, integer *, doublereal *, 
	    integer *, doublereal *, doublereal *, integer *, ftnlen, ftnlen);
    
    extern /* Subroutine */ int dgemv_(char *, integer *, integer *, 
	    doublereal *, doublereal *, integer *, doublereal *, integer *, 
	    doublereal *, doublereal *, integer *, ftnlen), dcopy_(integer *, 
	    doublereal *, integer *, doublereal *, integer *);
    integer nrowa;
    logical upper, tinyk;
    
    logical smalln;

/*     .. Scalar Arguments .. */
/*     .. Array Arguments .. */
/*     .. */

/*  Purpose */
/*  ======= */

/*  DSYRK  performs one of the symmetric rank k operations */

/*     C := alpha*A*A' + beta*C, */

/*  or */

/*     C := alpha*A'*A + beta*C, */

/*  where  alpha and beta  are scalars, C is an  n by n  symmetric matrix */
/*  and  A  is an  n by k  matrix in the first case and a  k by n  matrix */
/*  in the second case. */

/*  Parameters */
/*  ========== */

/*  UPLO   - CHARACTER*1. */
/*           On  entry,   UPLO  specifies  whether  the  upper  or  lower */
/*           triangular  part  of the  array  C  is to be  referenced  as */
/*           follows: */

/*              UPLO = 'U' or 'u'   Only the  upper triangular part of  C */
/*                                  is to be referenced. */

/*              UPLO = 'L' or 'l'   Only the  lower triangular part of  C */
/*                                  is to be referenced. */

/*           Unchanged on exit. */

/*  TRANS  - CHARACTER*1. */
/*           On entry,  TRANS  specifies the operation to be performed as */
/*           follows: */

/*              TRANS = 'N' or 'n'   C := alpha*A*A' + beta*C. */

/*              TRANS = 'T' or 't'   C := alpha*A'*A + beta*C. */

/*              TRANS = 'C' or 'c'   C := alpha*A'*A + beta*C. */

/*           Unchanged on exit. */

/*  N      - INTEGER. */
/*           On entry,  N specifies the order of the matrix C.  N must be */
/*           at least zero. */
/*           Unchanged on exit. */

/*  K      - INTEGER. */
/*           On entry with  TRANS = 'N' or 'n',  K  specifies  the number */
/*           of  columns   of  the   matrix   A,   and  on   entry   with */
/*           TRANS = 'T' or 't' or 'C' or 'c',  K  specifies  the  number */
/*           of rows of the matrix  A.  K must be at least zero. */
/*           Unchanged on exit. */

/*  ALPHA  - DOUBLE PRECISION. */
/*           On entry, ALPHA specifies the scalar alpha. */
/*           Unchanged on exit. */

/*  A      - DOUBLE PRECISION array of DIMENSION ( LDA, ka ), where ka is */
/*           k  when  TRANS = 'N' or 'n',  and is  n  otherwise. */
/*           Before entry with  TRANS = 'N' or 'n',  the  leading  n by k */
/*           part of the array  A  must contain the matrix  A,  otherwise */
/*           the leading  k by n  part of the array  A  must contain  the */
/*           matrix A. */
/*           Unchanged on exit. */

/*  LDA    - INTEGER. */
/*           On entry, LDA specifies the first dimension of A as declared */
/*           in  the  calling  (sub)  program.   When  TRANS = 'N' or 'n' */
/*           then  LDA must be at least  max( 1, n ), otherwise  LDA must */
/*           be at least  max( 1, k ). */
/*           Unchanged on exit. */

/*  BETA   - DOUBLE PRECISION. */
/*           On entry, BETA specifies the scalar beta. */
/*           Unchanged on exit. */

/*  C      - DOUBLE PRECISION array of DIMENSION ( LDC, n ). */
/*           Before entry  with  UPLO = 'U' or 'u',  the leading  n by n */
/*           upper triangular part of the array C must contain the upper */
/*           triangular part  of the  symmetric matrix  and the strictly */
/*           lower triangular part of C is not referenced.  On exit, the */
/*           upper triangular part of the array  C is overwritten by the */
/*           upper triangular part of the updated matrix. */
/*           Before entry  with  UPLO = 'L' or 'l',  the leading  n by n */
/*           lower triangular part of the array C must contain the lower */
/*           triangular part  of the  symmetric matrix  and the strictly */
/*           upper triangular part of C is not referenced.  On exit, the */
/*           lower triangular part of the array  C is overwritten by the */
/*           lower triangular part of the updated matrix. */

/*  LDC    - INTEGER. */
/*           On entry, LDC specifies the first dimension of C as declared */
/*           in  the  calling  (sub)  program.   LDC  must  be  at  least */
/*           max( 1, n ). */
/*           Unchanged on exit. */


/*  Level 3 Blas routine. */

/*  -- Written on 8-February-1989. */
/*     Jack Dongarra, Argonne National Laboratory. */
/*     Iain Duff, AERE Harwell. */
/*     Jeremy Du Croz, Numerical Algorithms Group Ltd. */
/*     Sven Hammarling, Numerical Algorithms Group Ltd. */

/*  -- Rewritten in December-1993. */
/*     GEMM-Based Level 3 BLAS. */
/*     Per Ling, Institute of Information Processing, */
/*     University of Umea, Sweden. */


/*     .. Local Scalars .. */
/*     .. Intrinsic Functions .. */
/*     .. External Functions .. */
/*     .. External Subroutines .. */
/*     .. Parameters .. */
/*     .. User specified parameters for DSYRK .. */
/*     .. Local Arrays .. */
/*     .. */
/*     .. Executable Statements .. */

/*     Test the input parameters. */

    /* Parameter adjustments */
    a_dim1 = *lda;
    a_offset = 1 + a_dim1;
    a -= a_offset;
    c_dim1 = *ldc;
    c_offset = 1 + c_dim1;
    c__ -= c_offset;

    /* Function Body */
    upper = (uplo[0]=='U'?1:0);
    notr = (trans[0]=='N'?1:0);
    if (notr) {
	nrowa = *n;
    } else {
	nrowa = *k;
    }
    info = 0;
    if (! upper && ! (uplo[0]=='L'?1:0)) {
	info = 1;
    } else if (! notr && ! (trans[0]=='T'?1:0) && ! 
	    (trans[0]=='C'?1:0)) {
	info = 2;
    } else if (*n < 0) {
	info = 3;
    } else if (*k < 0) {
	info = 4;
    } else if (*lda < max(1,nrowa)) {
	info = 7;
    } else if (*ldc < max(1,*n)) {
	info = 10;
    }
    if (info != 0) {
	xerbla_("DSYRK ", &info, (ftnlen)6);
	return 0;
    }

/*     Quick return if possible. */

    if (*n == 0 || (*alpha == 0. || *k == 0) && *beta == 1.) {
	return 0;
    }

/*     And when alpha.eq.zero or k.eq.0. */

    if (*alpha == 0. || *k == 0) {
	if (upper) {
	    i__1 = *n;
	    for (i__ = 1; i__ <= i__1; ++i__) {
		dscal_(&i__, beta, &c__[i__ * c_dim1 + 1], &c__1);
/* L10: */
	    }
	} else {
	    i__1 = *n;
	    for (i__ = 1; i__ <= i__1; ++i__) {
		i__2 = *n - i__ + 1;
		dscal_(&i__2, beta, &c__[i__ + i__ * c_dim1], &c__1);
/* L20: */
	    }
	}
	return 0;
    }

/*     Start the operations. */

    if (upper) {
	if (notr) {

/*           Form  C := alpha*A*A' + beta*C. Upper, Notr. */

	    smalln = ! dbigp_(&c__41, n, k);
	    if (smalln) {
		tinyk = ! dbigp_(&c__42, n, k);
		i__1 = *n;
		for (ii = 1; ii <= i__1; ii += 64) {
/* Computing MIN */
		    i__2 = 64, i__3 = *n - ii + 1;
		    isec = min(i__2,i__3);

/*                 C := alpha*A*A' + beta*C, general matrix multiply on */
/*                 upper vertical blocks of C. */

		    if (ii > 1) {
			i__2 = ii - 1;
			dgemm_("N", "T", &i__2, &isec, k, alpha, &a[a_dim1 + 
				1], lda, &a[ii + a_dim1], lda, beta, &c__[ii *
				 c_dim1 + 1], ldc, (ftnlen)1, (ftnlen)1);
		    }
		    if (tinyk) {

/*                    C :=  beta*C, a upper triangular diagonal block */
/*                    of C is updated with beta. */

			if (*beta != 1.) {
			    i__2 = ii + isec - 1;
			    for (i__ = ii; i__ <= i__2; ++i__) {
				i__3 = i__ - ii + 1;
				dscal_(&i__3, beta, &c__[ii + i__ * c_dim1], &
					c__1);
/* L30: */
			    }
			}

/*                    C := alpha*A*A' + C, symmetric matrix multiply. */
/*                    C is a symmetric diagonal block having upper */
/*                    triangular storage format. */

			i__2 = *k;
			for (l = 1; l <= i__2; ++l) {
			    dsyr_("U", &isec, alpha, &a[ii + l * a_dim1], &
				    c__1, &c__[ii + ii * c_dim1], ldc, (
				    ftnlen)1);
/* L40: */
			}
		    } else {

/*                    T2 := C, a upper triangular diagonal block of the */
/*                    symmetric matrix C is copied to the upper */
/*                    triangular part of T2. */

			i__2 = ii + isec - 1;
			for (i__ = ii; i__ <= i__2; ++i__) {
			    i__3 = i__ - ii + 1;
			    dcopy_(&i__3, &c__[ii + i__ * c_dim1], &c__1, &t2[
				    (i__ - ii + 1 << 6) - 64], &c__1);
/* L50: */
			}

/*                    T2 :=  beta*T2, the upper triangular part of T2 is */
/*                    updated with beta. */

			if (*beta != 1.) {
			    i__2 = ii + isec - 1;
			    for (i__ = ii; i__ <= i__2; ++i__) {
				i__3 = i__ - ii + 1;
				dscal_(&i__3, beta, &t2[(i__ - ii + 1 << 6) - 
					64], &c__1);
/* L60: */
			    }
			}

/*                    T2 := alpha*A*A' + T2, symmetric matrix multiply. */
/*                    T2 contains a symmetric block having upper */
/*                    triangular storage format. */

			i__2 = *k;
			for (l = 1; l <= i__2; ++l) {
			    dsyr_("U", &isec, alpha, &a[ii + l * a_dim1], &
				    c__1, t2, &c__64, (ftnlen)1);
/* L70: */
			}

/*                    C := T2, the upper triangular part of T2 is copied */
/*                    back to C. */

			i__2 = ii + isec - 1;
			for (i__ = ii; i__ <= i__2; ++i__) {
			    i__3 = i__ - ii + 1;
			    dcopy_(&i__3, &t2[(i__ - ii + 1 << 6) - 64], &
				    c__1, &c__[ii + i__ * c_dim1], &c__1);
/* L80: */
			}
		    }
/* L90: */
		}
	    } else {
		i__1 = *n;
		for (ii = 1; ii <= i__1; ii += 64) {
/* Computing MIN */
		    i__2 = 64, i__3 = *n - ii + 1;
		    isec = min(i__2,i__3);

/*                 C := alpha*A*A' + beta*C, general matrix multiply on */
/*                 upper vertical blocks of C. */

		    if (ii > 1) {
			i__2 = ii - 1;
			dgemm_("N", "T", &i__2, &isec, k, alpha, &a[a_dim1 + 
				1], lda, &a[ii + a_dim1], lda, beta, &c__[ii *
				 c_dim1 + 1], ldc, (ftnlen)1, (ftnlen)1);
		    }
		    delta = *beta;
		    i__2 = *k;
		    for (ll = 1; ll <= i__2; ll += 64) {
/* Computing MIN */
			i__3 = 64, i__4 = *k - ll + 1;
			lsec = min(i__3,i__4);

/*                    T1 := A, a rectangular block of A is copied to T1. */

			i__3 = ll + lsec - 1;
			for (l = ll; l <= i__3; ++l) {
			    dcopy_(&isec, &a[ii + l * a_dim1], &c__1, &t1[(l 
				    - ll + 1 << 6) - 64], &c__1);
/* L100: */
			}

/*                    C := alpha*T1*T1' + delta*C, C is symmetric having */
/*                    triangular storage format. Delta is used instead */
/*                    of beta to avoid updating the block of C with beta */
/*                    multiple times. */

			i__3 = ii + isec - 1;
			for (i__ = ii; i__ <= i__3; ++i__) {
			    i__4 = i__ - ii + 1;
			    dgemv_("N", &i__4, &lsec, alpha, t1, &c__64, &t1[
				    i__ - ii], &c__64, &delta, &c__[ii + i__ *
				     c_dim1], &c__1, (ftnlen)1);
/* L110: */
			}
			delta = 1.;
/* L120: */
		    }
/* L130: */
		}
	    }
	} else {

/*           Form  C := alpha*A'*A + beta*C. Upper, Trans. */

	    smalln = ! dbigp_(&c__41, n, k);
	    if (smalln) {
		tinyk = ! dbigp_(&c__42, n, k);
		i__1 = *n;
		for (ii = 1; ii <= i__1; ii += 64) {
/* Computing MIN */
		    i__2 = 64, i__3 = *n - ii + 1;
		    isec = min(i__2,i__3);

/*                 C := alpha*A'*A + beta*C, general matrix multiply on */
/*                 upper vertical blocks of C. */

		    if (ii > 1) {
			i__2 = ii - 1;
			dgemm_("T", "N", &i__2, &isec, k, alpha, &a[a_dim1 + 
				1], lda, &a[ii * a_dim1 + 1], lda, beta, &c__[
				ii * c_dim1 + 1], ldc, (ftnlen)1, (ftnlen)1);
		    }
		    if (tinyk) {

/*                    C :=  beta*C, a upper triangular diagonal block */
/*                    of C is updated with beta. */

			if (*beta != 1.) {
			    i__2 = ii + isec - 1;
			    for (i__ = ii; i__ <= i__2; ++i__) {
				i__3 = i__ - ii + 1;
				dscal_(&i__3, beta, &c__[ii + i__ * c_dim1], &
					c__1);
/* L140: */
			    }
			}

/*                    C := alpha*A*A' + C, symmetric matrix multiply. */
/*                    C is a symmetric diagonal block having upper */
/*                    triangular storage format. */

			i__2 = *k;
			for (l = 1; l <= i__2; ++l) {
			    dsyr_("U", &isec, alpha, &a[l + ii * a_dim1], lda,
				     &c__[ii + ii * c_dim1], ldc, (ftnlen)1);
/* L150: */
			}
		    } else {

/*                    T2 := C, a upper triangular diagonal block of the */
/*                    symmetric matrix C is copied to the upper */
/*                    triangular part of T2. */

			i__2 = ii + isec - 1;
			for (i__ = ii; i__ <= i__2; ++i__) {
			    i__3 = i__ - ii + 1;
			    dcopy_(&i__3, &c__[ii + i__ * c_dim1], &c__1, &t2[
				    (i__ - ii + 1 << 6) - 64], &c__1);
/* L160: */
			}

/*                    T2 :=  beta*T2, the upper triangular part of T2 is */
/*                    updated with beta. */

			if (*beta != 1.) {
			    i__2 = ii + isec - 1;
			    for (i__ = ii; i__ <= i__2; ++i__) {
				i__3 = i__ - ii + 1;
				dscal_(&i__3, beta, &t2[(i__ - ii + 1 << 6) - 
					64], &c__1);
/* L170: */
			    }
			}
			i__2 = *k;
			for (ll = 1; ll <= i__2; ll += 64) {
/* Computing MIN */
			    i__3 = 64, i__4 = *k - ll + 1;
			    lsec = min(i__3,i__4);

/*                       T3 :=  A', the transpose of a square block of A */
/*                       is copied to T3. */

			    i__3 = ii + isec - 1;
			    for (i__ = ii; i__ <= i__3; ++i__) {
				dcopy_(&lsec, &a[ll + i__ * a_dim1], &c__1, &
					t3[i__ - ii], &c__64);
/* L180: */
			    }

/*                       T2 := alpha*T3*T3' + T2, symmetric matrix */
/*                       multiply. T2 contains a symmetric block having */
/*                       upper triangular storage format. */

			    i__3 = ll + lsec - 1;
			    for (l = ll; l <= i__3; ++l) {
				dsyr_("U", &isec, alpha, &t3[(l - ll + 1 << 6)
					 - 64], &c__1, t2, &c__64, (ftnlen)1);
/* L190: */
			    }
/* L200: */
			}

/*                    C := T2, the upper triangular part of T2 is copied */
/*                    back to C. */

			i__2 = ii + isec - 1;
			for (i__ = ii; i__ <= i__2; ++i__) {
			    i__3 = i__ - ii + 1;
			    dcopy_(&i__3, &t2[(i__ - ii + 1 << 6) - 64], &
				    c__1, &c__[ii + i__ * c_dim1], &c__1);
/* L210: */
			}
		    }
/* L220: */
		}
	    } else {
		clda = dcld_(lda);
		i__1 = *n;
		for (ii = 1; ii <= i__1; ii += 64) {
/* Computing MIN */
		    i__2 = 64, i__3 = *n - ii + 1;
		    isec = min(i__2,i__3);

/*                 C := alpha*A'*A + beta*C, general matrix multiply on */
/*                 upper vertical blocks of C. */

		    if (ii > 1) {
			i__2 = ii - 1;
			dgemm_("T", "N", &i__2, &isec, k, alpha, &a[a_dim1 + 
				1], lda, &a[ii * a_dim1 + 1], lda, beta, &c__[
				ii * c_dim1 + 1], ldc, (ftnlen)1, (ftnlen)1);
		    }
		    delta = *beta;
		    i__2 = *k;
		    for (ll = 1; ll <= i__2; ll += 64) {
/* Computing MIN */
			i__3 = 64, i__4 = *k - ll + 1;
			lsec = min(i__3,i__4);

/*                    T1 := A', the transpose of a rectangular block */
/*                    of A is copied to T1. */

			if (clda) {
			    i__3 = ii + isec - 1;
			    for (i__ = ii; i__ <= i__3; ++i__) {
				dcopy_(&lsec, &a[ll + i__ * a_dim1], &c__1, &
					t1[i__ - ii], &c__64);
/* L230: */
			    }
			} else {
			    i__3 = ll + lsec - 1;
			    for (l = ll; l <= i__3; ++l) {
				dcopy_(&isec, &a[l + ii * a_dim1], lda, &t1[(
					l - ll + 1 << 6) - 64], &c__1);
/* L240: */
			    }
			}

/*                    C := alpha*T1*T1' + delta*C, C is symmetric having */
/*                    triangular storage format. Delta is used instead */
/*                    of beta to avoid updating the block of C with beta */
/*                    multiple times. */

			i__3 = ii + isec - 1;
			for (i__ = ii; i__ <= i__3; ++i__) {
			    i__4 = i__ - ii + 1;
			    dgemv_("N", &i__4, &lsec, alpha, t1, &c__64, &t1[
				    i__ - ii], &c__64, &delta, &c__[ii + i__ *
				     c_dim1], &c__1, (ftnlen)1);
/* L250: */
			}
			delta = 1.;
/* L260: */
		    }
/* L270: */
		}
	    }
	}
    } else {
	if (notr) {

/*           Form  C := alpha*A*A' + beta*C. Lower, Notr. */

	    smalln = ! dbigp_(&c__41, n, k);
	    if (smalln) {
		tinyk = ! dbigp_(&c__42, n, k);
		for (ix = *n; ix >= 1; ix += -64) {
/* Computing MAX */
		    i__1 = 1, i__2 = ix - 63;
		    ii = max(i__1,i__2);
		    isec = ix - ii + 1;
		    if (tinyk) {

/*                    C :=  beta*C, a lower triangular diagonal block */
/*                    of C is updated with beta. */

			if (*beta != 1.) {
			    i__1 = ii + isec - 1;
			    for (i__ = ii; i__ <= i__1; ++i__) {
				i__2 = ii + isec - i__;
				dscal_(&i__2, beta, &c__[i__ + i__ * c_dim1], 
					&c__1);
/* L280: */
			    }
			}

/*                    C := alpha*A*A' + C, symmetric matrix multiply. */
/*                    C is a symmetric diagonal block having lower */
/*                    triangular storage format. */

			i__1 = *k;
			for (l = 1; l <= i__1; ++l) {
			    dsyr_("L", &isec, alpha, &a[ii + l * a_dim1], &
				    c__1, &c__[ii + ii * c_dim1], ldc, (
				    ftnlen)1);
/* L290: */
			}
		    } else {

/*                    T2 := C, a lower triangular diagonal block of the */
/*                    symmetric matrix C is copied to the lower */
/*                    triangular part of T2. */

			i__1 = ii + isec - 1;
			for (i__ = ii; i__ <= i__1; ++i__) {
			    i__2 = ii + isec - i__;
			    dcopy_(&i__2, &c__[i__ + i__ * c_dim1], &c__1, &
				    t2[i__ - ii + 1 + (i__ - ii + 1 << 6) - 
				    65], &c__1);
/* L300: */
			}

/*                    T2 :=  beta*T2, the lower triangular part of T2 is */
/*                    updated with beta. */

			if (*beta != 1.) {
			    i__1 = ii + isec - 1;
			    for (i__ = ii; i__ <= i__1; ++i__) {
				i__2 = ii + isec - i__;
				dscal_(&i__2, beta, &t2[i__ - ii + 1 + (i__ - 
					ii + 1 << 6) - 65], &c__1);
/* L310: */
			    }
			}

/*                    T2 := alpha*A*A' + T2, symmetric matrix multiply. */
/*                    T2 contains a symmetric block having lower */
/*                    triangular storage format. */

			i__1 = *k;
			for (l = 1; l <= i__1; ++l) {
			    dsyr_("L", &isec, alpha, &a[ii + l * a_dim1], &
				    c__1, t2, &c__64, (ftnlen)1);
/* L320: */
			}

/*                    C := T2, the lower triangular part of T2 is copied */
/*                    back to C. */

			i__1 = ii + isec - 1;
			for (i__ = ii; i__ <= i__1; ++i__) {
			    i__2 = ii + isec - i__;
			    dcopy_(&i__2, &t2[i__ - ii + 1 + (i__ - ii + 1 << 
				    6) - 65], &c__1, &c__[i__ + i__ * c_dim1],
				     &c__1);
/* L330: */
			}
		    }

/*                 C := alpha*A*A' + beta*C, general matrix multiply on */
/*                 lower vertical blocks of C. */

		    if (ii + isec <= *n) {
			i__1 = *n - ii - isec + 1;
			dgemm_("N", "T", &i__1, &isec, k, alpha, &a[ii + isec 
				+ a_dim1], lda, &a[ii + a_dim1], lda, beta, &
				c__[ii + isec + ii * c_dim1], ldc, (ftnlen)1, 
				(ftnlen)1);
		    }
/* L340: */
		}
	    } else {
		for (ix = *n; ix >= 1; ix += -64) {
/* Computing MAX */
		    i__1 = 1, i__2 = ix - 63;
		    ii = max(i__1,i__2);
		    isec = ix - ii + 1;
		    delta = *beta;
		    i__1 = *k;
		    for (ll = 1; ll <= i__1; ll += 64) {
/* Computing MIN */
			i__2 = 64, i__3 = *k - ll + 1;
			lsec = min(i__2,i__3);

/*                    T1 := A, a rectangular block of A is copied to T1. */

			i__2 = ll + lsec - 1;
			for (l = ll; l <= i__2; ++l) {
			    dcopy_(&isec, &a[ii + l * a_dim1], &c__1, &t1[(l 
				    - ll + 1 << 6) - 64], &c__1);
/* L350: */
			}

/*                    C := alpha*T1*T1' + delta*C, C is symmetric having */
/*                    triangular storage format. Delta is used instead */
/*                    of beta to avoid updating the block of C with beta */
/*                    multiple times. */

			i__2 = ii + isec - 1;
			for (i__ = ii; i__ <= i__2; ++i__) {
			    i__3 = ii + isec - i__;
			    dgemv_("N", &i__3, &lsec, alpha, &t1[i__ - ii], &
				    c__64, &t1[i__ - ii], &c__64, &delta, &
				    c__[i__ + i__ * c_dim1], &c__1, (ftnlen)1)
				    ;
/* L360: */
			}
			delta = 1.;
/* L370: */
		    }

/*                 C := alpha*A*A' + beta*C, general matrix multiply on */
/*                 lower vertical blocks of C. */

		    if (ii + isec <= *n) {
			i__1 = *n - ii - isec + 1;
			dgemm_("N", "T", &i__1, &isec, k, alpha, &a[ii + isec 
				+ a_dim1], lda, &a[ii + a_dim1], lda, beta, &
				c__[ii + isec + ii * c_dim1], ldc, (ftnlen)1, 
				(ftnlen)1);
		    }
/* L380: */
		}
	    }
	} else {

/*           Form  C := alpha*A'*A + beta*C. Lower, Trans. */

	    smalln = ! dbigp_(&c__41, n, k);
	    if (smalln) {
		tinyk = ! dbigp_(&c__42, n, k);
		for (ix = *n; ix >= 1; ix += -64) {
/* Computing MAX */
		    i__1 = 1, i__2 = ix - 63;
		    ii = max(i__1,i__2);
		    isec = ix - ii + 1;
		    if (tinyk) {

/*                    C :=  beta*C, a lower triangular diagonal block */
/*                    of C is updated with beta. */

			if (*beta != 1.) {
			    i__1 = ii + isec - 1;
			    for (i__ = ii; i__ <= i__1; ++i__) {
				i__2 = ii + isec - i__;
				dscal_(&i__2, beta, &c__[i__ + i__ * c_dim1], 
					&c__1);
/* L390: */
			    }
			}

/*                    C := alpha*A*A' + C, symmetric matrix multiply. */
/*                    C is a symmetric diagonal block having lower */
/*                    triangular storage format. */

			i__1 = *k;
			for (l = 1; l <= i__1; ++l) {
			    dsyr_("L", &isec, alpha, &a[l + ii * a_dim1], lda,
				     &c__[ii + ii * c_dim1], ldc, (ftnlen)1);
/* L400: */
			}
		    } else {

/*                    T2 := C, a lower triangular diagonal block of the */
/*                    symmetric matrix C is copied to the lower */
/*                    triangular part of T2. */

			i__1 = ii + isec - 1;
			for (i__ = ii; i__ <= i__1; ++i__) {
			    i__2 = ii + isec - i__;
			    dcopy_(&i__2, &c__[i__ + i__ * c_dim1], &c__1, &
				    t2[i__ - ii + 1 + (i__ - ii + 1 << 6) - 
				    65], &c__1);
/* L410: */
			}

/*                    T2 :=  beta*T2, the lower triangular part of T2 is */
/*                    updated with beta. */

			if (*beta != 1.) {
			    i__1 = ii + isec - 1;
			    for (i__ = ii; i__ <= i__1; ++i__) {
				i__2 = ii + isec - i__;
				dscal_(&i__2, beta, &t2[i__ - ii + 1 + (i__ - 
					ii + 1 << 6) - 65], &c__1);
/* L420: */
			    }
			}
			i__1 = *k;
			for (ll = 1; ll <= i__1; ll += 64) {
/* Computing MIN */
			    i__2 = 64, i__3 = *k - ll + 1;
			    lsec = min(i__2,i__3);

/*                       T3 :=  A', the transpose of a square block of A */
/*                       is copied to T3. */

			    i__2 = ii + isec - 1;
			    for (i__ = ii; i__ <= i__2; ++i__) {
				dcopy_(&lsec, &a[ll + i__ * a_dim1], &c__1, &
					t3[i__ - ii], &c__64);
/* L430: */
			    }

/*                       T2 := alpha*T3*T3' + T2, symmetric matrix */
/*                       multiply. T2 contains a symmetric block having */
/*                       lower triangular storage format. */

			    i__2 = ll + lsec - 1;
			    for (l = ll; l <= i__2; ++l) {
				dsyr_("L", &isec, alpha, &t3[(l - ll + 1 << 6)
					 - 64], &c__1, t2, &c__64, (ftnlen)1);
/* L440: */
			    }
/* L450: */
			}

/*                    C := T2, the lower triangular part of T2 is copied */
/*                    back to C. */

			i__1 = ii + isec - 1;
			for (i__ = ii; i__ <= i__1; ++i__) {
			    i__2 = ii + isec - i__;
			    dcopy_(&i__2, &t2[i__ - ii + 1 + (i__ - ii + 1 << 
				    6) - 65], &c__1, &c__[i__ + i__ * c_dim1],
				     &c__1);
/* L460: */
			}
		    }

/*                 C := alpha*A'*A + beta*C, general matrix multiply on */
/*                 lower vertical blocks of C. */

		    if (ii + isec <= *n) {
			i__1 = *n - ii - isec + 1;
			dgemm_("T", "N", &i__1, &isec, k, alpha, &a[(ii + 
				isec) * a_dim1 + 1], lda, &a[ii * a_dim1 + 1],
				 lda, beta, &c__[ii + isec + ii * c_dim1], 
				ldc, (ftnlen)1, (ftnlen)1);
		    }
/* L470: */
		}
	    } else {
		clda = dcld_(lda);
		for (ix = *n; ix >= 1; ix += -64) {
/* Computing MAX */
		    i__1 = 1, i__2 = ix - 63;
		    ii = max(i__1,i__2);
		    isec = ix - ii + 1;
		    delta = *beta;
		    i__1 = *k;
		    for (ll = 1; ll <= i__1; ll += 64) {
/* Computing MIN */
			i__2 = 64, i__3 = *k - ll + 1;
			lsec = min(i__2,i__3);

/*                    T1 := A', the transpose of a rectangular block */
/*                    of A is copied to T1. */

			if (clda) {
			    i__2 = ii + isec - 1;
			    for (i__ = ii; i__ <= i__2; ++i__) {
				dcopy_(&lsec, &a[ll + i__ * a_dim1], &c__1, &
					t1[i__ - ii], &c__64);
/* L480: */
			    }
			} else {
			    i__2 = ll + lsec - 1;
			    for (l = ll; l <= i__2; ++l) {
				dcopy_(&isec, &a[l + ii * a_dim1], lda, &t1[(
					l - ll + 1 << 6) - 64], &c__1);
/* L490: */
			    }
			}

/*                    C := alpha*T1*T1' + delta*C, C is symmetric having */
/*                    triangular storage format. Delta is used instead */
/*                    of beta to avoid updating the block of C with beta */
/*                    multiple times. */

			i__2 = ii + isec - 1;
			for (i__ = ii; i__ <= i__2; ++i__) {
			    i__3 = ii + isec - i__;
			    dgemv_("N", &i__3, &lsec, alpha, &t1[i__ - ii], &
				    c__64, &t1[i__ - ii], &c__64, &delta, &
				    c__[i__ + i__ * c_dim1], &c__1, (ftnlen)1)
				    ;
/* L500: */
			}
			delta = 1.;
/* L510: */
		    }

/*                 C := alpha*A'*A + beta*C, general matrix multiply on */
/*                 lower vertical blocks of C. */

		    if (ii + isec <= *n) {
			i__1 = *n - ii - isec + 1;
			dgemm_("T", "N", &i__1, &isec, k, alpha, &a[(ii + 
				isec) * a_dim1 + 1], lda, &a[ii * a_dim1 + 1],
				 lda, beta, &c__[ii + isec + ii * c_dim1], 
				ldc, (ftnlen)1, (ftnlen)1);
		    }
/* L520: */
		}
	    }
	}
    }

    return 0;

/*     End of DSYRK. */

} /* dsyrk_ */

