/* dgemm.f -- translated by f2c (version 20030320).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

#include "f2cblas.h"

/* Subroutine */ int dgemm_(char *transa, char *transb, integer *m, integer *
	n, integer *k, doublereal *alpha, doublereal *a, integer *lda, 
	doublereal *b, integer *ldb, doublereal *beta, doublereal *c__, 
	integer *ldc, ftnlen transa_len, ftnlen transb_len)
{
    /* System generated locals */
    integer a_dim1, a_offset, b_dim1, b_offset, c_dim1, c_offset, i__1, i__2, 
	    i__3, i__4, i__5, i__6;

    /* Local variables */
    integer i__, j, l;
    doublereal t1[1024]	/* was [32][32] */, t2[3072]	/* was [32][96] */, 
	    f11, f12, f21, f22, f31, f32, f41, f42, f13, f14;
    integer ii;
    doublereal f23;
    integer jj;
    doublereal f24, f33, f34;
    integer ll;
    doublereal f43, f44;
    integer isec, jsec, lsec, info;
    logical nota, notb;
    doublereal delta;
    
    integer uisec, ujsec, ulsec, nrowa, nrowb;
    

/*     .. Scalar Arguments .. */
/*     .. Array Arguments .. */
/*     .. */

/*  Purpose */
/*  ======= */

/*  DGEMM  performs one of the matrix-matrix operations */

/*     C := alpha*op( A )*op( B ) + beta*C, */

/*  where  op( X ) is one of */

/*     op( X ) = X   or   op( X ) = X', */

/*  alpha and beta are scalars, and A, B and C are matrices, with op( A ) */
/*  an m by k matrix,  op( B )  a  k by n matrix and  C an m by n matrix. */

/*  Parameters */
/*  ========== */

/*  TRANSA - CHARACTER*1. */
/*           On entry, TRANSA specifies the form of op( A ) to be used in */
/*           the matrix multiplication as follows: */

/*              TRANSA = 'N' or 'n',  op( A ) = A. */

/*              TRANSA = 'T' or 't',  op( A ) = A'. */

/*              TRANSA = 'C' or 'c',  op( A ) = A'. */

/*           Unchanged on exit. */

/*  TRANSB - CHARACTER*1. */
/*           On entry, TRANSB specifies the form of op( B ) to be used in */
/*           the matrix multiplication as follows: */

/*              TRANSB = 'N' or 'n',  op( B ) = B. */

/*              TRANSB = 'T' or 't',  op( B ) = B'. */

/*              TRANSB = 'C' or 'c',  op( B ) = B'. */

/*           Unchanged on exit. */

/*  M      - INTEGER. */
/*           On entry,  M  specifies  the number  of rows  of the  matrix */
/*           op( A )  and of the  matrix  C.  M  must  be at least  zero. */
/*           Unchanged on exit. */

/*  N      - INTEGER. */
/*           On entry,  N  specifies the number  of columns of the matrix */
/*           op( B ) and the number of columns of the matrix C. N must be */
/*           at least zero. */
/*           Unchanged on exit. */

/*  K      - INTEGER. */
/*           On entry,  K  specifies  the number of columns of the matrix */
/*           op( A ) and the number of rows of the matrix op( B ). K must */
/*           be at least  zero. */
/*           Unchanged on exit. */

/*  ALPHA  - DOUBLE PRECISION. */
/*           On entry, ALPHA specifies the scalar alpha. */
/*           Unchanged on exit. */

/*  A      - DOUBLE PRECISION array of DIMENSION ( LDA, ka ), where ka is */
/*           k  when  TRANSA = 'N' or 'n',  and is  m  otherwise. */
/*           Before entry with  TRANSA = 'N' or 'n',  the leading  m by k */
/*           part of the array  A  must contain the matrix  A,  otherwise */
/*           the leading  k by m  part of the array  A  must contain  the */
/*           matrix A. */
/*           Unchanged on exit. */

/*  LDA    - INTEGER. */
/*           On entry, LDA specifies the first dimension of A as declared */
/*           in the calling (sub) program. When  TRANSA = 'N' or 'n' then */
/*           LDA must be at least  max( 1, m ), otherwise  LDA must be at */
/*           least  max( 1, k ). */
/*           Unchanged on exit. */

/*  B      - DOUBLE PRECISION array of DIMENSION ( LDB, kb ), where kb is */
/*           n  when  TRANSB = 'N' or 'n',  and is  k  otherwise. */
/*           Before entry with  TRANSB = 'N' or 'n',  the leading  k by n */
/*           part of the array  B  must contain the matrix  B,  otherwise */
/*           the leading  n by k  part of the array  B  must contain  the */
/*           matrix B. */
/*           Unchanged on exit. */

/*  LDB    - INTEGER. */
/*           On entry, LDB specifies the first dimension of B as declared */
/*           in the calling (sub) program. When  TRANSB = 'N' or 'n' then */
/*           LDB must be at least  max( 1, k ), otherwise  LDB must be at */
/*           least  max( 1, n ). */
/*           Unchanged on exit. */

/*  BETA   - DOUBLE PRECISION. */
/*           On entry,  BETA  specifies the scalar  beta.  When  BETA  is */
/*           supplied as zero then C need not be set on input. */
/*           Unchanged on exit. */

/*  C      - DOUBLE PRECISION array of DIMENSION ( LDC, n ). */
/*           Before entry, the leading  m by n  part of the array  C must */
/*           contain the matrix  C,  except when  beta  is zero, in which */
/*           case C need not be set on entry. */
/*           On exit, the array  C  is overwritten by the  m by n  matrix */
/*           ( alpha*op( A )*op( B ) + beta*C ). */

/*  LDC    - INTEGER. */
/*           On entry, LDC specifies the first dimension of C as declared */
/*           in  the  calling  (sub)  program.   LDC  must  be  at  least */
/*           max( 1, m ). */
/*           Unchanged on exit. */


/*  Level 3 Blas routine. */

/*  -- Written on 8-February-1989. */
/*     Jack Dongarra, Argonne National Laboratory. */
/*     Iain Duff, AERE Harwell. */
/*     Jeremy Du Croz, Numerical Algorithms Group Ltd. */
/*     Sven Hammarling, Numerical Algorithms Group Ltd. */

/*  -- Modified in October-1997. */
/*     Superscalar GEMM-Based Level 3 BLAS (Version 0.1). */
/*     Per Ling, Department of Computing Science, */
/*     Umea University, Sweden. */


/*     .. Local Scalars .. */
/*     .. Intrinsic Functions .. */
/*     .. External Functions .. */
/*     .. External Subroutines .. */
/*     .. Parameters .. */
/*     .. User specified parameters for DGEMM .. */
/*     .. */
/*     .. Executable Statements .. */

/*     Set  NOTA  and  NOTB  as  true if  A  and  B  respectively are not */
/*     transposed and set NROWA and NROWB as the number of rows of A  and */
/*     the number of rows of B respectively. */

    /* Parameter adjustments */
    a_dim1 = *lda;
    a_offset = 1 + a_dim1;
    a -= a_offset;
    b_dim1 = *ldb;
    b_offset = 1 + b_dim1;
    b -= b_offset;
    c_dim1 = *ldc;
    c_offset = 1 + c_dim1;
    c__ -= c_offset;

    /* Function Body */
    nota = (transa[0]=='N'?1:0);
    notb = (transb[0]=='N'?1:0);
    if (nota) {
	nrowa = *m;
    } else {
	nrowa = *k;
    }
    if (notb) {
	nrowb = *k;
    } else {
	nrowb = *n;
    }

/*     Test the input parameters. */

    info = 0;
    if (! nota && ! (transa[0]=='C'?1:0) && ! (transa[0]=='T'?1:0)) {
	info = 1;
    } else if (! notb && ! (transb[0]=='C'?1:0) && ! 
	    (transb[0]=='T'?1:0)) {
	info = 2;
    } else if (*m < 0) {
	info = 3;
    } else if (*n < 0) {
	info = 4;
    } else if (*k < 0) {
	info = 5;
    } else if (*lda < max(1,nrowa)) {
	info = 8;
    } else if (*ldb < max(1,nrowb)) {
	info = 10;
    } else if (*ldc < max(1,*m)) {
	info = 13;
    }
    if (info != 0) {
	xerbla_("DGEMM ", &info, (ftnlen)6);
	return 0;
    }

/*     Quick return if possible. */

    if (*m == 0 || *n == 0 || (*alpha == 0. || *k == 0) && *beta == 1.) {
	return 0;
    }

/*     And when alpha.eq.zero. */

    if (*alpha == 0. || *k == 0) {
	if (*beta == 0.) {
	    uisec = *m - *m % 4;
	    i__1 = *n;
	    for (j = 1; j <= i__1; ++j) {
		i__2 = uisec;
		for (i__ = 1; i__ <= i__2; i__ += 4) {
		    c__[i__ + j * c_dim1] = 0.;
		    c__[i__ + 1 + j * c_dim1] = 0.;
		    c__[i__ + 2 + j * c_dim1] = 0.;
		    c__[i__ + 3 + j * c_dim1] = 0.;
/* L10: */
		}
		i__2 = *m;
		for (i__ = uisec + 1; i__ <= i__2; ++i__) {
		    c__[i__ + j * c_dim1] = 0.;
/* L20: */
		}
/* L30: */
	    }
	} else {
	    uisec = *m - *m % 4;
	    i__1 = *n;
	    for (j = 1; j <= i__1; ++j) {
		i__2 = uisec;
		for (i__ = 1; i__ <= i__2; i__ += 4) {
		    c__[i__ + j * c_dim1] = *beta * c__[i__ + j * c_dim1];
		    c__[i__ + 1 + j * c_dim1] = *beta * c__[i__ + 1 + j * 
			    c_dim1];
		    c__[i__ + 2 + j * c_dim1] = *beta * c__[i__ + 2 + j * 
			    c_dim1];
		    c__[i__ + 3 + j * c_dim1] = *beta * c__[i__ + 3 + j * 
			    c_dim1];
/* L40: */
		}
		i__2 = *m;
		for (i__ = uisec + 1; i__ <= i__2; ++i__) {
		    c__[i__ + j * c_dim1] = *beta * c__[i__ + j * c_dim1];
/* L50: */
		}
/* L60: */
	    }
	}
	return 0;
    }

/*     Start the operations. */

    if (notb) {

/*        Form  C := alpha*A*B + beta*C or C := alpha*A'*B + beta*C. */

	i__1 = *n;
	for (jj = 1; jj <= i__1; jj += 1024) {
/* Computing MIN */
	    i__2 = 1024, i__3 = *n - jj + 1;
	    jsec = min(i__2,i__3);
	    ujsec = jsec - jsec % 4;
	    i__2 = *k;
	    for (ll = 1; ll <= i__2; ll += 32) {
/* Computing MIN */
		i__3 = 32, i__4 = *k - ll + 1;
		lsec = min(i__3,i__4);
		ulsec = lsec - lsec % 2;

/*              Determine if the block of C should be updated with */
/*              beta or not. */

		delta = 1.;
		if (ll == 1) {
		    delta = *beta;
		}

		i__3 = *m;
		for (ii = 1; ii <= i__3; ii += 32) {
/* Computing MIN */
		    i__4 = 32, i__5 = *m - ii + 1;
		    isec = min(i__4,i__5);

/*                 T1 := alpha*A' or T1 := alpha*A, copy the transpose */
/*                 or the non-transpose of a rectangular block of */
/*                 alpha*A to T1. */

		    uisec = isec - isec % 2;
		    if (nota) {
			i__4 = ll + ulsec - 1;
			for (l = ll; l <= i__4; l += 2) {
			    i__5 = ii + uisec - 1;
			    for (i__ = ii; i__ <= i__5; i__ += 2) {
				t1[l - ll + 1 + (i__ - ii + 1 << 5) - 33] = *
					alpha * a[i__ + l * a_dim1];
				t1[l - ll + 2 + (i__ - ii + 1 << 5) - 33] = *
					alpha * a[i__ + (l + 1) * a_dim1];
				t1[l - ll + 1 + (i__ - ii + 2 << 5) - 33] = *
					alpha * a[i__ + 1 + l * a_dim1];
				t1[l - ll + 2 + (i__ - ii + 2 << 5) - 33] = *
					alpha * a[i__ + 1 + (l + 1) * a_dim1];
/* L70: */
			    }
			    if (uisec < isec) {
				t1[l - ll + 1 + (isec << 5) - 33] = *alpha * 
					a[ii + isec - 1 + l * a_dim1];
				t1[l - ll + 2 + (isec << 5) - 33] = *alpha * 
					a[ii + isec - 1 + (l + 1) * a_dim1];
			    }
/* L80: */
			}
			if (ulsec < lsec) {
			    i__4 = ii + isec - 1;
			    for (i__ = ii; i__ <= i__4; ++i__) {
				t1[lsec + (i__ - ii + 1 << 5) - 33] = *alpha *
					 a[i__ + (ll + lsec - 1) * a_dim1];
/* L90: */
			    }
			}
		    } else {
			i__4 = ii + uisec - 1;
			for (i__ = ii; i__ <= i__4; i__ += 2) {
			    i__5 = ll + ulsec - 1;
			    for (l = ll; l <= i__5; l += 2) {
				t1[l - ll + 1 + (i__ - ii + 1 << 5) - 33] = *
					alpha * a[l + i__ * a_dim1];
				t1[l - ll + 1 + (i__ - ii + 2 << 5) - 33] = *
					alpha * a[l + (i__ + 1) * a_dim1];
				t1[l - ll + 2 + (i__ - ii + 1 << 5) - 33] = *
					alpha * a[l + 1 + i__ * a_dim1];
				t1[l - ll + 2 + (i__ - ii + 2 << 5) - 33] = *
					alpha * a[l + 1 + (i__ + 1) * a_dim1];
/* L100: */
			    }
			    if (ulsec < lsec) {
				t1[lsec + (i__ - ii + 1 << 5) - 33] = *alpha *
					 a[ll + lsec - 1 + i__ * a_dim1];
				t1[lsec + (i__ - ii + 2 << 5) - 33] = *alpha *
					 a[ll + lsec - 1 + (i__ + 1) * a_dim1]
					;
			    }
/* L110: */
			}
			if (uisec < isec) {
			    i__4 = ll + lsec - 1;
			    for (l = ll; l <= i__4; ++l) {
				t1[l - ll + 1 + (isec << 5) - 33] = *alpha * 
					a[l + (ii + isec - 1) * a_dim1];
/* L120: */
			    }
			}
		    }

/*                 C := T1'*B + beta*C, update a rectangular block */
/*                 of C using 4 by 4 unrolling. */

		    uisec = isec - isec % 4;
		    i__4 = jj + ujsec - 1;
		    for (j = jj; j <= i__4; j += 4) {
			i__5 = ii + uisec - 1;
			for (i__ = ii; i__ <= i__5; i__ += 4) {
			    f11 = delta * c__[i__ + j * c_dim1];
			    f21 = delta * c__[i__ + 1 + j * c_dim1];
			    f12 = delta * c__[i__ + (j + 1) * c_dim1];
			    f22 = delta * c__[i__ + 1 + (j + 1) * c_dim1];
			    f13 = delta * c__[i__ + (j + 2) * c_dim1];
			    f23 = delta * c__[i__ + 1 + (j + 2) * c_dim1];
			    f14 = delta * c__[i__ + (j + 3) * c_dim1];
			    f24 = delta * c__[i__ + 1 + (j + 3) * c_dim1];
			    f31 = delta * c__[i__ + 2 + j * c_dim1];
			    f41 = delta * c__[i__ + 3 + j * c_dim1];
			    f32 = delta * c__[i__ + 2 + (j + 1) * c_dim1];
			    f42 = delta * c__[i__ + 3 + (j + 1) * c_dim1];
			    f33 = delta * c__[i__ + 2 + (j + 2) * c_dim1];
			    f43 = delta * c__[i__ + 3 + (j + 2) * c_dim1];
			    f34 = delta * c__[i__ + 2 + (j + 3) * c_dim1];
			    f44 = delta * c__[i__ + 3 + (j + 3) * c_dim1];
			    i__6 = ll + lsec - 1;
			    for (l = ll; l <= i__6; ++l) {
				f11 += t1[l - ll + 1 + (i__ - ii + 1 << 5) - 
					33] * b[l + j * b_dim1];
				f21 += t1[l - ll + 1 + (i__ - ii + 2 << 5) - 
					33] * b[l + j * b_dim1];
				f12 += t1[l - ll + 1 + (i__ - ii + 1 << 5) - 
					33] * b[l + (j + 1) * b_dim1];
				f22 += t1[l - ll + 1 + (i__ - ii + 2 << 5) - 
					33] * b[l + (j + 1) * b_dim1];
				f13 += t1[l - ll + 1 + (i__ - ii + 1 << 5) - 
					33] * b[l + (j + 2) * b_dim1];
				f23 += t1[l - ll + 1 + (i__ - ii + 2 << 5) - 
					33] * b[l + (j + 2) * b_dim1];
				f14 += t1[l - ll + 1 + (i__ - ii + 1 << 5) - 
					33] * b[l + (j + 3) * b_dim1];
				f24 += t1[l - ll + 1 + (i__ - ii + 2 << 5) - 
					33] * b[l + (j + 3) * b_dim1];
				f31 += t1[l - ll + 1 + (i__ - ii + 3 << 5) - 
					33] * b[l + j * b_dim1];
				f41 += t1[l - ll + 1 + (i__ - ii + 4 << 5) - 
					33] * b[l + j * b_dim1];
				f32 += t1[l - ll + 1 + (i__ - ii + 3 << 5) - 
					33] * b[l + (j + 1) * b_dim1];
				f42 += t1[l - ll + 1 + (i__ - ii + 4 << 5) - 
					33] * b[l + (j + 1) * b_dim1];
				f33 += t1[l - ll + 1 + (i__ - ii + 3 << 5) - 
					33] * b[l + (j + 2) * b_dim1];
				f43 += t1[l - ll + 1 + (i__ - ii + 4 << 5) - 
					33] * b[l + (j + 2) * b_dim1];
				f34 += t1[l - ll + 1 + (i__ - ii + 3 << 5) - 
					33] * b[l + (j + 3) * b_dim1];
				f44 += t1[l - ll + 1 + (i__ - ii + 4 << 5) - 
					33] * b[l + (j + 3) * b_dim1];
/* L130: */
			    }
			    c__[i__ + j * c_dim1] = f11;
			    c__[i__ + 1 + j * c_dim1] = f21;
			    c__[i__ + (j + 1) * c_dim1] = f12;
			    c__[i__ + 1 + (j + 1) * c_dim1] = f22;
			    c__[i__ + (j + 2) * c_dim1] = f13;
			    c__[i__ + 1 + (j + 2) * c_dim1] = f23;
			    c__[i__ + (j + 3) * c_dim1] = f14;
			    c__[i__ + 1 + (j + 3) * c_dim1] = f24;
			    c__[i__ + 2 + j * c_dim1] = f31;
			    c__[i__ + 3 + j * c_dim1] = f41;
			    c__[i__ + 2 + (j + 1) * c_dim1] = f32;
			    c__[i__ + 3 + (j + 1) * c_dim1] = f42;
			    c__[i__ + 2 + (j + 2) * c_dim1] = f33;
			    c__[i__ + 3 + (j + 2) * c_dim1] = f43;
			    c__[i__ + 2 + (j + 3) * c_dim1] = f34;
			    c__[i__ + 3 + (j + 3) * c_dim1] = f44;
/* L140: */
			}
			if (uisec < isec) {
			    i__5 = ii + isec - 1;
			    for (i__ = ii + uisec; i__ <= i__5; ++i__) {
				f11 = delta * c__[i__ + j * c_dim1];
				f12 = delta * c__[i__ + (j + 1) * c_dim1];
				f13 = delta * c__[i__ + (j + 2) * c_dim1];
				f14 = delta * c__[i__ + (j + 3) * c_dim1];
				i__6 = ll + lsec - 1;
				for (l = ll; l <= i__6; ++l) {
				    f11 += t1[l - ll + 1 + (i__ - ii + 1 << 5)
					     - 33] * b[l + j * b_dim1];
				    f12 += t1[l - ll + 1 + (i__ - ii + 1 << 5)
					     - 33] * b[l + (j + 1) * b_dim1];
				    f13 += t1[l - ll + 1 + (i__ - ii + 1 << 5)
					     - 33] * b[l + (j + 2) * b_dim1];
				    f14 += t1[l - ll + 1 + (i__ - ii + 1 << 5)
					     - 33] * b[l + (j + 3) * b_dim1];
/* L150: */
				}
				c__[i__ + j * c_dim1] = f11;
				c__[i__ + (j + 1) * c_dim1] = f12;
				c__[i__ + (j + 2) * c_dim1] = f13;
				c__[i__ + (j + 3) * c_dim1] = f14;
/* L160: */
			    }
			}
/* L170: */
		    }
		    if (ujsec < jsec) {
			i__4 = jj + jsec - 1;
			for (j = jj + ujsec; j <= i__4; ++j) {
			    i__5 = ii + uisec - 1;
			    for (i__ = ii; i__ <= i__5; i__ += 4) {
				f11 = delta * c__[i__ + j * c_dim1];
				f21 = delta * c__[i__ + 1 + j * c_dim1];
				f31 = delta * c__[i__ + 2 + j * c_dim1];
				f41 = delta * c__[i__ + 3 + j * c_dim1];
				i__6 = ll + lsec - 1;
				for (l = ll; l <= i__6; ++l) {
				    f11 += t1[l - ll + 1 + (i__ - ii + 1 << 5)
					     - 33] * b[l + j * b_dim1];
				    f21 += t1[l - ll + 1 + (i__ - ii + 2 << 5)
					     - 33] * b[l + j * b_dim1];
				    f31 += t1[l - ll + 1 + (i__ - ii + 3 << 5)
					     - 33] * b[l + j * b_dim1];
				    f41 += t1[l - ll + 1 + (i__ - ii + 4 << 5)
					     - 33] * b[l + j * b_dim1];
/* L180: */
				}
				c__[i__ + j * c_dim1] = f11;
				c__[i__ + 1 + j * c_dim1] = f21;
				c__[i__ + 2 + j * c_dim1] = f31;
				c__[i__ + 3 + j * c_dim1] = f41;
/* L190: */
			    }
			    i__5 = ii + isec - 1;
			    for (i__ = ii + uisec; i__ <= i__5; ++i__) {
				f11 = delta * c__[i__ + j * c_dim1];
				i__6 = ll + lsec - 1;
				for (l = ll; l <= i__6; ++l) {
				    f11 += t1[l - ll + 1 + (i__ - ii + 1 << 5)
					     - 33] * b[l + j * b_dim1];
/* L200: */
				}
				c__[i__ + j * c_dim1] = f11;
/* L210: */
			    }
/* L220: */
			}
		    }
/* L230: */
		}
/* L240: */
	    }
/* L250: */
	}
    } else {

/*        Form  C := alpha*A*B' + beta*C or C := alpha*A'*B' + beta*C. */

	i__1 = *n;
	for (jj = 1; jj <= i__1; jj += 96) {
/* Computing MIN */
	    i__2 = 96, i__3 = *n - jj + 1;
	    jsec = min(i__2,i__3);
	    i__2 = *k;
	    for (ll = 1; ll <= i__2; ll += 32) {
/* Computing MIN */
		i__3 = 32, i__4 = *k - ll + 1;
		lsec = min(i__3,i__4);

/*              Determine if the block of C should be updated with */
/*              beta or not. */

		delta = 1.;
		if (ll == 1) {
		    delta = *beta;
		}

/*              T2 := alpha*B', copy the transpose of a rectangular */
/*              block of alpha*A to T2. */

		ulsec = lsec - lsec % 2;
		ujsec = jsec - jsec % 2;
		i__3 = ll + ulsec - 1;
		for (l = ll; l <= i__3; l += 2) {
		    i__4 = jj + ujsec - 1;
		    for (j = jj; j <= i__4; j += 2) {
			t2[l - ll + 1 + (j - jj + 1 << 5) - 33] = *alpha * b[
				j + l * b_dim1];
			t2[l - ll + 2 + (j - jj + 1 << 5) - 33] = *alpha * b[
				j + (l + 1) * b_dim1];
			t2[l - ll + 1 + (j - jj + 2 << 5) - 33] = *alpha * b[
				j + 1 + l * b_dim1];
			t2[l - ll + 2 + (j - jj + 2 << 5) - 33] = *alpha * b[
				j + 1 + (l + 1) * b_dim1];
/* L260: */
		    }
		    if (ujsec < jsec) {
			t2[l - ll + 1 + (jsec << 5) - 33] = *alpha * b[jj + 
				jsec - 1 + l * b_dim1];
			t2[l - ll + 2 + (jsec << 5) - 33] = *alpha * b[jj + 
				jsec - 1 + (l + 1) * b_dim1];
		    }
/* L270: */
		}
		if (ulsec < lsec) {
		    i__3 = jj + jsec - 1;
		    for (j = jj; j <= i__3; ++j) {
			t2[lsec + (j - jj + 1 << 5) - 33] = *alpha * b[j + (
				ll + lsec - 1) * b_dim1];
/* L280: */
		    }
		}

		ujsec = jsec - jsec % 4;
		i__3 = *m;
		for (ii = 1; ii <= i__3; ii += 32) {
/* Computing MIN */
		    i__4 = 32, i__5 = *m - ii + 1;
		    isec = min(i__4,i__5);

/*                 T1 := alpha*A' or T1 := alpha*A, copy the transpose */
/*                 or the non-transpose of a rectangular block of */
/*                 alpha*A to T1. */

		    uisec = isec - isec % 2;
		    if (nota) {
			i__4 = ll + ulsec - 1;
			for (l = ll; l <= i__4; l += 2) {
			    i__5 = ii + uisec - 1;
			    for (i__ = ii; i__ <= i__5; i__ += 2) {
				t1[l - ll + 1 + (i__ - ii + 1 << 5) - 33] = a[
					i__ + l * a_dim1];
				t1[l - ll + 2 + (i__ - ii + 1 << 5) - 33] = a[
					i__ + (l + 1) * a_dim1];
				t1[l - ll + 1 + (i__ - ii + 2 << 5) - 33] = a[
					i__ + 1 + l * a_dim1];
				t1[l - ll + 2 + (i__ - ii + 2 << 5) - 33] = a[
					i__ + 1 + (l + 1) * a_dim1];
/* L290: */
			    }
			    if (uisec < isec) {
				t1[l - ll + 1 + (isec << 5) - 33] = a[ii + 
					isec - 1 + l * a_dim1];
				t1[l - ll + 2 + (isec << 5) - 33] = a[ii + 
					isec - 1 + (l + 1) * a_dim1];
			    }
/* L300: */
			}
			if (ulsec < lsec) {
			    i__4 = ii + isec - 1;
			    for (i__ = ii; i__ <= i__4; ++i__) {
				t1[lsec + (i__ - ii + 1 << 5) - 33] = a[i__ + 
					(ll + lsec - 1) * a_dim1];
/* L310: */
			    }
			}
		    } else {
			i__4 = ii + uisec - 1;
			for (i__ = ii; i__ <= i__4; i__ += 2) {
			    i__5 = ll + ulsec - 1;
			    for (l = ll; l <= i__5; l += 2) {
				t1[l - ll + 1 + (i__ - ii + 1 << 5) - 33] = a[
					l + i__ * a_dim1];
				t1[l - ll + 1 + (i__ - ii + 2 << 5) - 33] = a[
					l + (i__ + 1) * a_dim1];
				t1[l - ll + 2 + (i__ - ii + 1 << 5) - 33] = a[
					l + 1 + i__ * a_dim1];
				t1[l - ll + 2 + (i__ - ii + 2 << 5) - 33] = a[
					l + 1 + (i__ + 1) * a_dim1];
/* L320: */
			    }
			    if (ulsec < lsec) {
				t1[lsec + (i__ - ii + 1 << 5) - 33] = a[ll + 
					lsec - 1 + i__ * a_dim1];
				t1[lsec + (i__ - ii + 2 << 5) - 33] = a[ll + 
					lsec - 1 + (i__ + 1) * a_dim1];
			    }
/* L330: */
			}
			if (uisec < isec) {
			    i__4 = ll + lsec - 1;
			    for (l = ll; l <= i__4; ++l) {
				t1[l - ll + 1 + (isec << 5) - 33] = a[l + (ii 
					+ isec - 1) * a_dim1];
/* L340: */
			    }
			}
		    }

/*                 C := T1'*B + beta*C, update a rectangular block */
/*                 of C using 4 by 4 unrolling. */

		    uisec = isec - isec % 4;
		    i__4 = jj + ujsec - 1;
		    for (j = jj; j <= i__4; j += 4) {
			i__5 = ii + uisec - 1;
			for (i__ = ii; i__ <= i__5; i__ += 4) {
			    f11 = delta * c__[i__ + j * c_dim1];
			    f21 = delta * c__[i__ + 1 + j * c_dim1];
			    f12 = delta * c__[i__ + (j + 1) * c_dim1];
			    f22 = delta * c__[i__ + 1 + (j + 1) * c_dim1];
			    f13 = delta * c__[i__ + (j + 2) * c_dim1];
			    f23 = delta * c__[i__ + 1 + (j + 2) * c_dim1];
			    f14 = delta * c__[i__ + (j + 3) * c_dim1];
			    f24 = delta * c__[i__ + 1 + (j + 3) * c_dim1];
			    f31 = delta * c__[i__ + 2 + j * c_dim1];
			    f41 = delta * c__[i__ + 3 + j * c_dim1];
			    f32 = delta * c__[i__ + 2 + (j + 1) * c_dim1];
			    f42 = delta * c__[i__ + 3 + (j + 1) * c_dim1];
			    f33 = delta * c__[i__ + 2 + (j + 2) * c_dim1];
			    f43 = delta * c__[i__ + 3 + (j + 2) * c_dim1];
			    f34 = delta * c__[i__ + 2 + (j + 3) * c_dim1];
			    f44 = delta * c__[i__ + 3 + (j + 3) * c_dim1];
			    i__6 = ll + lsec - 1;
			    for (l = ll; l <= i__6; ++l) {
				f11 += t1[l - ll + 1 + (i__ - ii + 1 << 5) - 
					33] * t2[l - ll + 1 + (j - jj + 1 << 
					5) - 33];
				f21 += t1[l - ll + 1 + (i__ - ii + 2 << 5) - 
					33] * t2[l - ll + 1 + (j - jj + 1 << 
					5) - 33];
				f12 += t1[l - ll + 1 + (i__ - ii + 1 << 5) - 
					33] * t2[l - ll + 1 + (j - jj + 2 << 
					5) - 33];
				f22 += t1[l - ll + 1 + (i__ - ii + 2 << 5) - 
					33] * t2[l - ll + 1 + (j - jj + 2 << 
					5) - 33];
				f13 += t1[l - ll + 1 + (i__ - ii + 1 << 5) - 
					33] * t2[l - ll + 1 + (j - jj + 3 << 
					5) - 33];
				f23 += t1[l - ll + 1 + (i__ - ii + 2 << 5) - 
					33] * t2[l - ll + 1 + (j - jj + 3 << 
					5) - 33];
				f14 += t1[l - ll + 1 + (i__ - ii + 1 << 5) - 
					33] * t2[l - ll + 1 + (j - jj + 4 << 
					5) - 33];
				f24 += t1[l - ll + 1 + (i__ - ii + 2 << 5) - 
					33] * t2[l - ll + 1 + (j - jj + 4 << 
					5) - 33];
				f31 += t1[l - ll + 1 + (i__ - ii + 3 << 5) - 
					33] * t2[l - ll + 1 + (j - jj + 1 << 
					5) - 33];
				f41 += t1[l - ll + 1 + (i__ - ii + 4 << 5) - 
					33] * t2[l - ll + 1 + (j - jj + 1 << 
					5) - 33];
				f32 += t1[l - ll + 1 + (i__ - ii + 3 << 5) - 
					33] * t2[l - ll + 1 + (j - jj + 2 << 
					5) - 33];
				f42 += t1[l - ll + 1 + (i__ - ii + 4 << 5) - 
					33] * t2[l - ll + 1 + (j - jj + 2 << 
					5) - 33];
				f33 += t1[l - ll + 1 + (i__ - ii + 3 << 5) - 
					33] * t2[l - ll + 1 + (j - jj + 3 << 
					5) - 33];
				f43 += t1[l - ll + 1 + (i__ - ii + 4 << 5) - 
					33] * t2[l - ll + 1 + (j - jj + 3 << 
					5) - 33];
				f34 += t1[l - ll + 1 + (i__ - ii + 3 << 5) - 
					33] * t2[l - ll + 1 + (j - jj + 4 << 
					5) - 33];
				f44 += t1[l - ll + 1 + (i__ - ii + 4 << 5) - 
					33] * t2[l - ll + 1 + (j - jj + 4 << 
					5) - 33];
/* L350: */
			    }
			    c__[i__ + j * c_dim1] = f11;
			    c__[i__ + 1 + j * c_dim1] = f21;
			    c__[i__ + (j + 1) * c_dim1] = f12;
			    c__[i__ + 1 + (j + 1) * c_dim1] = f22;
			    c__[i__ + (j + 2) * c_dim1] = f13;
			    c__[i__ + 1 + (j + 2) * c_dim1] = f23;
			    c__[i__ + (j + 3) * c_dim1] = f14;
			    c__[i__ + 1 + (j + 3) * c_dim1] = f24;
			    c__[i__ + 2 + j * c_dim1] = f31;
			    c__[i__ + 3 + j * c_dim1] = f41;
			    c__[i__ + 2 + (j + 1) * c_dim1] = f32;
			    c__[i__ + 3 + (j + 1) * c_dim1] = f42;
			    c__[i__ + 2 + (j + 2) * c_dim1] = f33;
			    c__[i__ + 3 + (j + 2) * c_dim1] = f43;
			    c__[i__ + 2 + (j + 3) * c_dim1] = f34;
			    c__[i__ + 3 + (j + 3) * c_dim1] = f44;
/* L360: */
			}
			if (uisec < isec) {
			    i__5 = ii + isec - 1;
			    for (i__ = ii + uisec; i__ <= i__5; ++i__) {
				f11 = delta * c__[i__ + j * c_dim1];
				f12 = delta * c__[i__ + (j + 1) * c_dim1];
				f13 = delta * c__[i__ + (j + 2) * c_dim1];
				f14 = delta * c__[i__ + (j + 3) * c_dim1];
				i__6 = ll + lsec - 1;
				for (l = ll; l <= i__6; ++l) {
				    f11 += t1[l - ll + 1 + (i__ - ii + 1 << 5)
					     - 33] * t2[l - ll + 1 + (j - jj 
					    + 1 << 5) - 33];
				    f12 += t1[l - ll + 1 + (i__ - ii + 1 << 5)
					     - 33] * t2[l - ll + 1 + (j - jj 
					    + 2 << 5) - 33];
				    f13 += t1[l - ll + 1 + (i__ - ii + 1 << 5)
					     - 33] * t2[l - ll + 1 + (j - jj 
					    + 3 << 5) - 33];
				    f14 += t1[l - ll + 1 + (i__ - ii + 1 << 5)
					     - 33] * t2[l - ll + 1 + (j - jj 
					    + 4 << 5) - 33];
/* L370: */
				}
				c__[i__ + j * c_dim1] = f11;
				c__[i__ + (j + 1) * c_dim1] = f12;
				c__[i__ + (j + 2) * c_dim1] = f13;
				c__[i__ + (j + 3) * c_dim1] = f14;
/* L380: */
			    }
			}
/* L390: */
		    }
		    if (ujsec < jsec) {
			i__4 = jj + jsec - 1;
			for (j = jj + ujsec; j <= i__4; ++j) {
			    i__5 = ii + uisec - 1;
			    for (i__ = ii; i__ <= i__5; i__ += 4) {
				f11 = delta * c__[i__ + j * c_dim1];
				f21 = delta * c__[i__ + 1 + j * c_dim1];
				f31 = delta * c__[i__ + 2 + j * c_dim1];
				f41 = delta * c__[i__ + 3 + j * c_dim1];
				i__6 = ll + lsec - 1;
				for (l = ll; l <= i__6; ++l) {
				    f11 += t1[l - ll + 1 + (i__ - ii + 1 << 5)
					     - 33] * t2[l - ll + 1 + (j - jj 
					    + 1 << 5) - 33];
				    f21 += t1[l - ll + 1 + (i__ - ii + 2 << 5)
					     - 33] * t2[l - ll + 1 + (j - jj 
					    + 1 << 5) - 33];
				    f31 += t1[l - ll + 1 + (i__ - ii + 3 << 5)
					     - 33] * t2[l - ll + 1 + (j - jj 
					    + 1 << 5) - 33];
				    f41 += t1[l - ll + 1 + (i__ - ii + 4 << 5)
					     - 33] * t2[l - ll + 1 + (j - jj 
					    + 1 << 5) - 33];
/* L400: */
				}
				c__[i__ + j * c_dim1] = f11;
				c__[i__ + 1 + j * c_dim1] = f21;
				c__[i__ + 2 + j * c_dim1] = f31;
				c__[i__ + 3 + j * c_dim1] = f41;
/* L410: */
			    }
			    i__5 = ii + isec - 1;
			    for (i__ = ii + uisec; i__ <= i__5; ++i__) {
				f11 = delta * c__[i__ + j * c_dim1];
				i__6 = ll + lsec - 1;
				for (l = ll; l <= i__6; ++l) {
				    f11 += t1[l - ll + 1 + (i__ - ii + 1 << 5)
					     - 33] * t2[l - ll + 1 + (j - jj 
					    + 1 << 5) - 33];
/* L420: */
				}
				c__[i__ + j * c_dim1] = f11;
/* L430: */
			    }
/* L440: */
			}
		    }
/* L450: */
		}
/* L460: */
	    }
/* L470: */
	}
    }

    return 0;

/*     End of DGEMM. */

} /* dgemm_ */

