/* csyrk.f -- translated by f2c (version 20030320).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

#include "f2cblas.h"

/* Table of constant values */


/* Subroutine */ int csyrk_(char *uplo, char *trans, integer *n, integer *k, 
	complex *alpha, complex *a, integer *lda, complex *beta, complex *c__,
	 integer *ldc, ftnlen uplo_len, ftnlen trans_len)
{
integer c__1 = 1;
integer c__41 = 41;
integer c__42 = 42;
integer c__64 = 64;
    /* System generated locals */
    integer a_dim1, a_offset, c_dim1, c_offset, i__1, i__2, i__3, i__4, i__5, 
	    i__6;
    complex q__1;

    /* Local variables */
    integer i__, l;
    complex t1[4096]	/* was [64][64] */, t2[4096]	/* was [64][64] */, 
	    t3[4096]	/* was [64][64] */;
    integer ii, ll, ix;
    logical clda;
    extern logical ccld_(integer *);
    integer isec, lsec, info;
    logical notr;
    extern logical cbigp_(integer *, integer *, integer *);
    extern /* Subroutine */ int cscal_(integer *, complex *, complex *, 
	    integer *), cgemm_(char *, char *, integer *, integer *, integer *
	    , complex *, complex *, integer *, complex *, integer *, complex *
	    , complex *, integer *, ftnlen, ftnlen);
    complex delta;
    
    extern /* Subroutine */ int cgemv_(char *, integer *, integer *, complex *
	    , complex *, integer *, complex *, integer *, complex *, complex *
	    , integer *, ftnlen), ccopy_(integer *, complex *, integer *, 
	    complex *, integer *), caxpy_(integer *, complex *, complex *, 
	    integer *, complex *, integer *);
    integer nrowa;
    logical upper, tinyk;
    
    logical smalln;

/*     .. Scalar Arguments .. */
/*     .. Array Arguments .. */
/*     .. */

/*  Purpose */
/*  ======= */

/*  CSYRK  performs one of the symmetric rank k operations */

/*     C := alpha*A*A' + beta*C, */

/*  or */

/*     C := alpha*A'*A + beta*C, */

/*  where  alpha and beta  are scalars,  C is an  n by n symmetric matrix */
/*  and  A  is an  n by k  matrix in the first case and a  k by n  matrix */
/*  in the second case. */

/*  Parameters */
/*  ========== */

/*  UPLO   - CHARACTER*1. */
/*           On  entry,   UPLO  specifies  whether  the  upper  or  lower */
/*           triangular  part  of the  array  C  is to be  referenced  as */
/*           follows: */

/*              UPLO = 'U' or 'u'   Only the  upper triangular part of  C */
/*                                  is to be referenced. */

/*              UPLO = 'L' or 'l'   Only the  lower triangular part of  C */
/*                                  is to be referenced. */

/*           Unchanged on exit. */

/*  TRANS  - CHARACTER*1. */
/*           On entry,  TRANS  specifies the operation to be performed as */
/*           follows: */

/*              TRANS = 'N' or 'n'   C := alpha*A*A' + beta*C. */

/*              TRANS = 'T' or 't'   C := alpha*A'*A + beta*C. */

/*           Unchanged on exit. */

/*  N      - INTEGER. */
/*           On entry,  N specifies the order of the matrix C.  N must be */
/*           at least zero. */
/*           Unchanged on exit. */

/*  K      - INTEGER. */
/*           On entry with  TRANS = 'N' or 'n',  K  specifies  the number */
/*           of  columns   of  the   matrix   A,   and  on   entry   with */
/*           TRANS = 'T' or 't',  K  specifies  the number of rows of the */
/*           matrix A.  K must be at least zero. */
/*           Unchanged on exit. */

/*  ALPHA  - COMPLEX      . */
/*           On entry, ALPHA specifies the scalar alpha. */
/*           Unchanged on exit. */

/*  A      - COMPLEX       array of DIMENSION ( LDA, ka ), where ka is */
/*           k  when  TRANS = 'N' or 'n',  and is  n  otherwise. */
/*           Before entry with  TRANS = 'N' or 'n',  the  leading  n by k */
/*           part of the array  A  must contain the matrix  A,  otherwise */
/*           the leading  k by n  part of the array  A  must contain  the */
/*           matrix A. */
/*           Unchanged on exit. */

/*  LDA    - INTEGER. */
/*           On entry, LDA specifies the first dimension of A as declared */
/*           in  the  calling  (sub)  program.   When  TRANS = 'N' or 'n' */
/*           then  LDA must be at least  max( 1, n ), otherwise  LDA must */
/*           be at least  max( 1, k ). */
/*           Unchanged on exit. */

/*  BETA   - COMPLEX      . */
/*           On entry, BETA specifies the scalar beta. */
/*           Unchanged on exit. */

/*  C      - COMPLEX       array of DIMENSION ( LDC, n ). */
/*           Before entry  with  UPLO = 'U' or 'u',  the leading  n by n */
/*           upper triangular part of the array C must contain the upper */
/*           triangular part  of the  symmetric matrix  and the strictly */
/*           lower triangular part of C is not referenced.  On exit, the */
/*           upper triangular part of the array  C is overwritten by the */
/*           upper triangular part of the updated matrix. */
/*           Before entry  with  UPLO = 'L' or 'l',  the leading  n by n */
/*           lower triangular part of the array C must contain the lower */
/*           triangular part  of the  symmetric matrix  and the strictly */
/*           upper triangular part of C is not referenced.  On exit, the */
/*           lower triangular part of the array  C is overwritten by the */
/*           lower triangular part of the updated matrix. */

/*  LDC    - INTEGER. */
/*           On entry, LDC specifies the first dimension of C as declared */
/*           in  the  calling  (sub)  program.   LDC  must  be  at  least */
/*           max( 1, n ). */
/*           Unchanged on exit. */


/*  Level 3 Blas routine. */

/*  -- Written on 8-February-1989. */
/*     Jack Dongarra, Argonne National Laboratory. */
/*     Iain Duff, AERE Harwell. */
/*     Jeremy Du Croz, Numerical Algorithms Group Ltd. */
/*     Sven Hammarling, Numerical Algorithms Group Ltd. */

/*  -- Rewritten in May-1994. */
/*     GEMM-Based Level 3 BLAS. */
/*     Per Ling, Institute of Information Processing, */
/*     University of Umea, Sweden. */


/*     .. Local Scalars .. */
/*     .. Intrinsic Functions .. */
/*     .. External Functions .. */
/*     .. External Subroutines .. */
/*     .. Parameters .. */
/*     .. User specified parameters for CSYRK .. */
/*     .. Local Arrays .. */
/*     .. */
/*     .. Executable Statements .. */

/*     Test the input parameters. */

    /* Parameter adjustments */
    a_dim1 = *lda;
    a_offset = 1 + a_dim1;
    a -= a_offset;
    c_dim1 = *ldc;
    c_offset = 1 + c_dim1;
    c__ -= c_offset;

    /* Function Body */
    upper = (uplo[0]=='U'?1:0);
    notr = (trans[0]=='N'?1:0);
    if (notr) {
	nrowa = *n;
    } else {
	nrowa = *k;
    }
    info = 0;
    if (! upper && ! (uplo[0]=='L'?1:0)) {
	info = 1;
    } else if (! notr && ! (trans[0]=='T'?1:0)) {
	info = 2;
    } else if (*n < 0) {
	info = 3;
    } else if (*k < 0) {
	info = 4;
    } else if (*lda < max(1,nrowa)) {
	info = 7;
    } else if (*ldc < max(1,*n)) {
	info = 10;
    }
    if (info != 0) {
	xerbla_("CSYRK ", &info, (ftnlen)6);
	return 0;
    }

/*     Quick return if possible. */

    if (*n == 0 || (alpha->r == 0.f && alpha->i == 0.f || *k == 0) && (
	    beta->r == 1.f && beta->i == 0.f)) {
	return 0;
    }

/*     And when alpha.eq.zero or k.eq.0. */

    if (alpha->r == 0.f && alpha->i == 0.f || *k == 0) {
	if (upper) {
	    i__1 = *n;
	    for (i__ = 1; i__ <= i__1; ++i__) {
		cscal_(&i__, beta, &c__[i__ * c_dim1 + 1], &c__1);
/* L10: */
	    }
	} else {
	    i__1 = *n;
	    for (i__ = 1; i__ <= i__1; ++i__) {
		i__2 = *n - i__ + 1;
		cscal_(&i__2, beta, &c__[i__ + i__ * c_dim1], &c__1);
/* L20: */
	    }
	}
	return 0;
    }

/*     Start the operations. */

    if (upper) {
	if (notr) {

/*           Form  C := alpha*A*A' + beta*C. Upper, Notr. */

	    smalln = ! cbigp_(&c__41, n, k);
	    if (smalln) {
		tinyk = ! cbigp_(&c__42, n, k);
		i__1 = *n;
		for (ii = 1; ii <= i__1; ii += 64) {
/* Computing MIN */
		    i__2 = 64, i__3 = *n - ii + 1;
		    isec = min(i__2,i__3);

/*                 C := alpha*A*A' + beta*C, general matrix multiply on */
/*                 upper vertical blocks of C. */

		    if (ii > 1) {
			i__2 = ii - 1;
			cgemm_("N", "T", &i__2, &isec, k, alpha, &a[a_dim1 + 
				1], lda, &a[ii + a_dim1], lda, beta, &c__[ii *
				 c_dim1 + 1], ldc, (ftnlen)1, (ftnlen)1);
		    }
		    if (tinyk) {

/*                    C :=  beta*C, a upper triangular diagonal block */
/*                    of C is updated with beta. */

			if (beta->r != 1.f || beta->i != 0.f) {
			    i__2 = ii + isec - 1;
			    for (i__ = ii; i__ <= i__2; ++i__) {
				i__3 = i__ - ii + 1;
				cscal_(&i__3, beta, &c__[ii + i__ * c_dim1], &
					c__1);
/* L30: */
			    }
			}

/*                    C := alpha*A*A' + C, symmetric matrix multiply. */
/*                    C is a symmetric diagonal block having upper */
/*                    triangular storage format. */

			i__2 = ii + isec - 1;
			for (i__ = ii; i__ <= i__2; ++i__) {
			    i__3 = *k;
			    for (l = 1; l <= i__3; ++l) {
				i__4 = i__ - ii + 1;
				i__5 = i__ + l * a_dim1;
				q__1.r = alpha->r * a[i__5].r - alpha->i * a[
					i__5].i, q__1.i = alpha->r * a[i__5]
					.i + alpha->i * a[i__5].r;
				caxpy_(&i__4, &q__1, &a[ii + l * a_dim1], &
					c__1, &c__[ii + i__ * c_dim1], &c__1);
/* L40: */
			    }
/* L50: */
			}
		    } else {

/*                    T2 := C, a upper triangular diagonal block of the */
/*                    symmetric matrix C is copied to the upper */
/*                    triangular part of T2. */

			i__2 = ii + isec - 1;
			for (i__ = ii; i__ <= i__2; ++i__) {
			    i__3 = i__ - ii + 1;
			    ccopy_(&i__3, &c__[ii + i__ * c_dim1], &c__1, &t2[
				    (i__ - ii + 1 << 6) - 64], &c__1);
/* L60: */
			}

/*                    T2 :=  beta*T2, the upper triangular part of T2 is */
/*                    updated with beta. */

			if (beta->r != 1.f || beta->i != 0.f) {
			    i__2 = ii + isec - 1;
			    for (i__ = ii; i__ <= i__2; ++i__) {
				i__3 = i__ - ii + 1;
				cscal_(&i__3, beta, &t2[(i__ - ii + 1 << 6) - 
					64], &c__1);
/* L70: */
			    }
			}

/*                    T2 := alpha*A*A' + T2, symmetric matrix multiply. */
/*                    T2 contains a symmetric block having upper */
/*                    triangular storage format. */

			i__2 = ii + isec - 1;
			for (i__ = ii; i__ <= i__2; ++i__) {
			    i__3 = *k;
			    for (l = 1; l <= i__3; ++l) {
				i__4 = i__ - ii + 1;
				i__5 = i__ + l * a_dim1;
				q__1.r = alpha->r * a[i__5].r - alpha->i * a[
					i__5].i, q__1.i = alpha->r * a[i__5]
					.i + alpha->i * a[i__5].r;
				caxpy_(&i__4, &q__1, &a[ii + l * a_dim1], &
					c__1, &t2[(i__ - ii + 1 << 6) - 64], &
					c__1);
/* L80: */
			    }
/* L90: */
			}

/*                    C := T2, the upper triangular part of T2 is copied */
/*                    back to C. */

			i__2 = ii + isec - 1;
			for (i__ = ii; i__ <= i__2; ++i__) {
			    i__3 = i__ - ii + 1;
			    ccopy_(&i__3, &t2[(i__ - ii + 1 << 6) - 64], &
				    c__1, &c__[ii + i__ * c_dim1], &c__1);
/* L100: */
			}
		    }
/* L110: */
		}
	    } else {
		i__1 = *n;
		for (ii = 1; ii <= i__1; ii += 64) {
/* Computing MIN */
		    i__2 = 64, i__3 = *n - ii + 1;
		    isec = min(i__2,i__3);

/*                 C := alpha*A*A' + beta*C, general matrix multiply on */
/*                 upper vertical blocks of C. */

		    if (ii > 1) {
			i__2 = ii - 1;
			cgemm_("N", "T", &i__2, &isec, k, alpha, &a[a_dim1 + 
				1], lda, &a[ii + a_dim1], lda, beta, &c__[ii *
				 c_dim1 + 1], ldc, (ftnlen)1, (ftnlen)1);
		    }
		    delta.r = beta->r, delta.i = beta->i;
		    i__2 = *k;
		    for (ll = 1; ll <= i__2; ll += 64) {
/* Computing MIN */
			i__3 = 64, i__4 = *k - ll + 1;
			lsec = min(i__3,i__4);

/*                    T1 := A, a rectangular block of A is copied to T1. */

			i__3 = ll + lsec - 1;
			for (l = ll; l <= i__3; ++l) {
			    ccopy_(&isec, &a[ii + l * a_dim1], &c__1, &t1[(l 
				    - ll + 1 << 6) - 64], &c__1);
/* L120: */
			}

/*                    C := alpha*T1*T1' + delta*C, C is symmetric having */
/*                    triangular storage format. Delta is used instead */
/*                    of beta to avoid updating the block of C with beta */
/*                    multiple times. */

			i__3 = ii + isec - 1;
			for (i__ = ii; i__ <= i__3; ++i__) {
			    i__4 = i__ - ii + 1;
			    cgemv_("N", &i__4, &lsec, alpha, t1, &c__64, &t1[
				    i__ - ii], &c__64, &delta, &c__[ii + i__ *
				     c_dim1], &c__1, (ftnlen)1);
/* L130: */
			}
			delta.r = 1.f, delta.i = 0.f;
/* L140: */
		    }
/* L150: */
		}
	    }
	} else {

/*           Form  C := alpha*A'*A + beta*C. Upper, Trans. */

	    smalln = ! cbigp_(&c__41, n, k);
	    if (smalln) {
		tinyk = ! cbigp_(&c__42, n, k);
		i__1 = *n;
		for (ii = 1; ii <= i__1; ii += 64) {
/* Computing MIN */
		    i__2 = 64, i__3 = *n - ii + 1;
		    isec = min(i__2,i__3);

/*                 C := alpha*A'*A + beta*C, general matrix multiply on */
/*                 upper vertical blocks of C. */

		    if (ii > 1) {
			i__2 = ii - 1;
			cgemm_("T", "N", &i__2, &isec, k, alpha, &a[a_dim1 + 
				1], lda, &a[ii * a_dim1 + 1], lda, beta, &c__[
				ii * c_dim1 + 1], ldc, (ftnlen)1, (ftnlen)1);
		    }
		    if (tinyk) {

/*                    C :=  beta*C, a upper triangular diagonal block */
/*                    of C is updated with beta. */

			if (beta->r != 1.f || beta->i != 0.f) {
			    i__2 = ii + isec - 1;
			    for (i__ = ii; i__ <= i__2; ++i__) {
				i__3 = i__ - ii + 1;
				cscal_(&i__3, beta, &c__[ii + i__ * c_dim1], &
					c__1);
/* L160: */
			    }
			}

/*                    C := alpha*A*A' + C, symmetric matrix multiply. */
/*                    C is a symmetric diagonal block having upper */
/*                    triangular storage format. */

			i__2 = ii + isec - 1;
			for (i__ = ii; i__ <= i__2; ++i__) {
			    i__3 = *k;
			    for (l = 1; l <= i__3; ++l) {
				i__4 = i__ - ii + 1;
				i__5 = l + i__ * a_dim1;
				q__1.r = alpha->r * a[i__5].r - alpha->i * a[
					i__5].i, q__1.i = alpha->r * a[i__5]
					.i + alpha->i * a[i__5].r;
				caxpy_(&i__4, &q__1, &a[l + ii * a_dim1], lda,
					 &c__[ii + i__ * c_dim1], &c__1);
/* L170: */
			    }
/* L180: */
			}
		    } else {

/*                    T2 := C, a upper triangular diagonal block of the */
/*                    symmetric matrix C is copied to the upper */
/*                    triangular part of T2. */

			i__2 = ii + isec - 1;
			for (i__ = ii; i__ <= i__2; ++i__) {
			    i__3 = i__ - ii + 1;
			    ccopy_(&i__3, &c__[ii + i__ * c_dim1], &c__1, &t2[
				    (i__ - ii + 1 << 6) - 64], &c__1);
/* L190: */
			}

/*                    T2 :=  beta*T2, the upper triangular part of T2 is */
/*                    updated with beta. */

			if (beta->r != 1.f || beta->i != 0.f) {
			    i__2 = ii + isec - 1;
			    for (i__ = ii; i__ <= i__2; ++i__) {
				i__3 = i__ - ii + 1;
				cscal_(&i__3, beta, &t2[(i__ - ii + 1 << 6) - 
					64], &c__1);
/* L200: */
			    }
			}
			i__2 = *k;
			for (ll = 1; ll <= i__2; ll += 64) {
/* Computing MIN */
			    i__3 = 64, i__4 = *k - ll + 1;
			    lsec = min(i__3,i__4);

/*                       T3 :=  A', the transpose of a square block of A */
/*                       is copied to T3. */

			    i__3 = ii + isec - 1;
			    for (i__ = ii; i__ <= i__3; ++i__) {
				ccopy_(&lsec, &a[ll + i__ * a_dim1], &c__1, &
					t3[i__ - ii], &c__64);
/* L210: */
			    }

/*                       T2 := alpha*T3*T3' + T2, symmetric matrix */
/*                       multiply. T2 contains a symmetric block having */
/*                       upper triangular storage format. */

			    i__3 = ii + isec - 1;
			    for (i__ = ii; i__ <= i__3; ++i__) {
				i__4 = ll + lsec - 1;
				for (l = ll; l <= i__4; ++l) {
				    i__5 = i__ - ii + 1;
				    i__6 = i__ - ii + 1 + (l - ll + 1 << 6) - 
					    65;
				    q__1.r = alpha->r * t3[i__6].r - alpha->i 
					    * t3[i__6].i, q__1.i = alpha->r * 
					    t3[i__6].i + alpha->i * t3[i__6]
					    .r;
				    caxpy_(&i__5, &q__1, &t3[(l - ll + 1 << 6)
					     - 64], &c__1, &t2[(i__ - ii + 1 
					    << 6) - 64], &c__1);
/* L220: */
				}
/* L230: */
			    }
/* L240: */
			}

/*                    C := T2, the upper triangular part of T2 is copied */
/*                    back to C. */

			i__2 = ii + isec - 1;
			for (i__ = ii; i__ <= i__2; ++i__) {
			    i__3 = i__ - ii + 1;
			    ccopy_(&i__3, &t2[(i__ - ii + 1 << 6) - 64], &
				    c__1, &c__[ii + i__ * c_dim1], &c__1);
/* L250: */
			}
		    }
/* L260: */
		}
	    } else {
		clda = ccld_(lda);
		i__1 = *n;
		for (ii = 1; ii <= i__1; ii += 64) {
/* Computing MIN */
		    i__2 = 64, i__3 = *n - ii + 1;
		    isec = min(i__2,i__3);

/*                 C := alpha*A'*A + beta*C, general matrix multiply on */
/*                 upper vertical blocks of C. */

		    if (ii > 1) {
			i__2 = ii - 1;
			cgemm_("T", "N", &i__2, &isec, k, alpha, &a[a_dim1 + 
				1], lda, &a[ii * a_dim1 + 1], lda, beta, &c__[
				ii * c_dim1 + 1], ldc, (ftnlen)1, (ftnlen)1);
		    }
		    delta.r = beta->r, delta.i = beta->i;
		    i__2 = *k;
		    for (ll = 1; ll <= i__2; ll += 64) {
/* Computing MIN */
			i__3 = 64, i__4 = *k - ll + 1;
			lsec = min(i__3,i__4);

/*                    T1 := A', the transpose of a rectangular block */
/*                    of A is copied to T1. */

			if (clda) {
			    i__3 = ii + isec - 1;
			    for (i__ = ii; i__ <= i__3; ++i__) {
				ccopy_(&lsec, &a[ll + i__ * a_dim1], &c__1, &
					t1[i__ - ii], &c__64);
/* L270: */
			    }
			} else {
			    i__3 = ll + lsec - 1;
			    for (l = ll; l <= i__3; ++l) {
				ccopy_(&isec, &a[l + ii * a_dim1], lda, &t1[(
					l - ll + 1 << 6) - 64], &c__1);
/* L280: */
			    }
			}

/*                    C := alpha*T1*T1' + delta*C, C is symmetric having */
/*                    triangular storage format. Delta is used instead */
/*                    of beta to avoid updating the block of C with beta */
/*                    multiple times. */

			i__3 = ii + isec - 1;
			for (i__ = ii; i__ <= i__3; ++i__) {
			    i__4 = i__ - ii + 1;
			    cgemv_("N", &i__4, &lsec, alpha, t1, &c__64, &t1[
				    i__ - ii], &c__64, &delta, &c__[ii + i__ *
				     c_dim1], &c__1, (ftnlen)1);
/* L290: */
			}
			delta.r = 1.f, delta.i = 0.f;
/* L300: */
		    }
/* L310: */
		}
	    }
	}
    } else {
	if (notr) {

/*           Form  C := alpha*A*A' + beta*C. Lower, Notr. */

	    smalln = ! cbigp_(&c__41, n, k);
	    if (smalln) {
		tinyk = ! cbigp_(&c__42, n, k);
		for (ix = *n; ix >= 1; ix += -64) {
/* Computing MAX */
		    i__1 = 1, i__2 = ix - 63;
		    ii = max(i__1,i__2);
		    isec = ix - ii + 1;
		    if (tinyk) {

/*                    C :=  beta*C, a lower triangular diagonal block */
/*                    of C is updated with beta. */

			if (beta->r != 1.f || beta->i != 0.f) {
			    i__1 = ii + isec - 1;
			    for (i__ = ii; i__ <= i__1; ++i__) {
				i__2 = ii + isec - i__;
				cscal_(&i__2, beta, &c__[i__ + i__ * c_dim1], 
					&c__1);
/* L320: */
			    }
			}

/*                    C := alpha*A*A' + C, symmetric matrix multiply. */
/*                    C is a symmetric diagonal block having lower */
/*                    triangular storage format. */

			i__1 = ii + isec - 1;
			for (i__ = ii; i__ <= i__1; ++i__) {
			    i__2 = *k;
			    for (l = 1; l <= i__2; ++l) {
				i__3 = ii + isec - i__;
				i__4 = i__ + l * a_dim1;
				q__1.r = alpha->r * a[i__4].r - alpha->i * a[
					i__4].i, q__1.i = alpha->r * a[i__4]
					.i + alpha->i * a[i__4].r;
				caxpy_(&i__3, &q__1, &a[i__ + l * a_dim1], &
					c__1, &c__[i__ + i__ * c_dim1], &c__1)
					;
/* L330: */
			    }
/* L340: */
			}
		    } else {

/*                    T2 := C, a lower triangular diagonal block of the */
/*                    symmetric matrix C is copied to the lower */
/*                    triangular part of T2. */

			i__1 = ii + isec - 1;
			for (i__ = ii; i__ <= i__1; ++i__) {
			    i__2 = ii + isec - i__;
			    ccopy_(&i__2, &c__[i__ + i__ * c_dim1], &c__1, &
				    t2[i__ - ii + 1 + (i__ - ii + 1 << 6) - 
				    65], &c__1);
/* L350: */
			}

/*                    T2 :=  beta*T2, the lower triangular part of T2 is */
/*                    updated with beta. */

			if (beta->r != 1.f || beta->i != 0.f) {
			    i__1 = ii + isec - 1;
			    for (i__ = ii; i__ <= i__1; ++i__) {
				i__2 = ii + isec - i__;
				cscal_(&i__2, beta, &t2[i__ - ii + 1 + (i__ - 
					ii + 1 << 6) - 65], &c__1);
/* L360: */
			    }
			}

/*                    T2 := alpha*A*A' + T2, symmetric matrix multiply. */
/*                    T2 contains a symmetric block having lower */
/*                    triangular storage format. */

			i__1 = ii + isec - 1;
			for (i__ = ii; i__ <= i__1; ++i__) {
			    i__2 = *k;
			    for (l = 1; l <= i__2; ++l) {
				i__3 = ii + isec - i__;
				i__4 = i__ + l * a_dim1;
				q__1.r = alpha->r * a[i__4].r - alpha->i * a[
					i__4].i, q__1.i = alpha->r * a[i__4]
					.i + alpha->i * a[i__4].r;
				caxpy_(&i__3, &q__1, &a[i__ + l * a_dim1], &
					c__1, &t2[i__ - ii + 1 + (i__ - ii + 
					1 << 6) - 65], &c__1);
/* L370: */
			    }
/* L380: */
			}

/*                    C := T2, the lower triangular part of T2 is copied */
/*                    back to C. */

			i__1 = ii + isec - 1;
			for (i__ = ii; i__ <= i__1; ++i__) {
			    i__2 = ii + isec - i__;
			    ccopy_(&i__2, &t2[i__ - ii + 1 + (i__ - ii + 1 << 
				    6) - 65], &c__1, &c__[i__ + i__ * c_dim1],
				     &c__1);
/* L390: */
			}
		    }

/*                 C := alpha*A*A' + beta*C, general matrix multiply on */
/*                 lower vertical blocks of C. */

		    if (ii + isec <= *n) {
			i__1 = *n - ii - isec + 1;
			cgemm_("N", "T", &i__1, &isec, k, alpha, &a[ii + isec 
				+ a_dim1], lda, &a[ii + a_dim1], lda, beta, &
				c__[ii + isec + ii * c_dim1], ldc, (ftnlen)1, 
				(ftnlen)1);
		    }
/* L400: */
		}
	    } else {
		for (ix = *n; ix >= 1; ix += -64) {
/* Computing MAX */
		    i__1 = 1, i__2 = ix - 63;
		    ii = max(i__1,i__2);
		    isec = ix - ii + 1;
		    delta.r = beta->r, delta.i = beta->i;
		    i__1 = *k;
		    for (ll = 1; ll <= i__1; ll += 64) {
/* Computing MIN */
			i__2 = 64, i__3 = *k - ll + 1;
			lsec = min(i__2,i__3);

/*                    T1 := A, a rectangular block of A is copied to T1. */

			i__2 = ll + lsec - 1;
			for (l = ll; l <= i__2; ++l) {
			    ccopy_(&isec, &a[ii + l * a_dim1], &c__1, &t1[(l 
				    - ll + 1 << 6) - 64], &c__1);
/* L410: */
			}

/*                    C := alpha*T1*T1' + delta*C, C is symmetric having */
/*                    triangular storage format. Delta is used instead */
/*                    of beta to avoid updating the block of C with beta */
/*                    multiple times. */

			i__2 = ii + isec - 1;
			for (i__ = ii; i__ <= i__2; ++i__) {
			    i__3 = ii + isec - i__;
			    cgemv_("N", &i__3, &lsec, alpha, &t1[i__ - ii], &
				    c__64, &t1[i__ - ii], &c__64, &delta, &
				    c__[i__ + i__ * c_dim1], &c__1, (ftnlen)1)
				    ;
/* L420: */
			}
			delta.r = 1.f, delta.i = 0.f;
/* L430: */
		    }

/*                 C := alpha*A*A' + beta*C, general matrix multiply on */
/*                 lower vertical blocks of C. */

		    if (ii + isec <= *n) {
			i__1 = *n - ii - isec + 1;
			cgemm_("N", "T", &i__1, &isec, k, alpha, &a[ii + isec 
				+ a_dim1], lda, &a[ii + a_dim1], lda, beta, &
				c__[ii + isec + ii * c_dim1], ldc, (ftnlen)1, 
				(ftnlen)1);
		    }
/* L440: */
		}
	    }
	} else {

/*           Form  C := alpha*A'*A + beta*C. Lower, Trans. */

	    smalln = ! cbigp_(&c__41, n, k);
	    if (smalln) {
		tinyk = ! cbigp_(&c__42, n, k);
		for (ix = *n; ix >= 1; ix += -64) {
/* Computing MAX */
		    i__1 = 1, i__2 = ix - 63;
		    ii = max(i__1,i__2);
		    isec = ix - ii + 1;
		    if (tinyk) {

/*                    C :=  beta*C, a lower triangular diagonal block */
/*                    of C is updated with beta. */

			if (beta->r != 1.f || beta->i != 0.f) {
			    i__1 = ii + isec - 1;
			    for (i__ = ii; i__ <= i__1; ++i__) {
				i__2 = ii + isec - i__;
				cscal_(&i__2, beta, &c__[i__ + i__ * c_dim1], 
					&c__1);
/* L450: */
			    }
			}

/*                    C := alpha*A*A' + C, symmetric matrix multiply. */
/*                    C is a symmetric diagonal block having lower */
/*                    triangular storage format. */

			i__1 = ii + isec - 1;
			for (i__ = ii; i__ <= i__1; ++i__) {
			    i__2 = *k;
			    for (l = 1; l <= i__2; ++l) {
				i__3 = ii + isec - i__;
				i__4 = l + i__ * a_dim1;
				q__1.r = alpha->r * a[i__4].r - alpha->i * a[
					i__4].i, q__1.i = alpha->r * a[i__4]
					.i + alpha->i * a[i__4].r;
				caxpy_(&i__3, &q__1, &a[l + i__ * a_dim1], 
					lda, &c__[i__ + i__ * c_dim1], &c__1);
/* L460: */
			    }
/* L470: */
			}
		    } else {

/*                    T2 := C, a lower triangular diagonal block of the */
/*                    symmetric matrix C is copied to the lower */
/*                    triangular part of T2. */

			i__1 = ii + isec - 1;
			for (i__ = ii; i__ <= i__1; ++i__) {
			    i__2 = ii + isec - i__;
			    ccopy_(&i__2, &c__[i__ + i__ * c_dim1], &c__1, &
				    t2[i__ - ii + 1 + (i__ - ii + 1 << 6) - 
				    65], &c__1);
/* L480: */
			}

/*                    T2 :=  beta*T2, the lower triangular part of T2 is */
/*                    updated with beta. */

			if (beta->r != 1.f || beta->i != 0.f) {
			    i__1 = ii + isec - 1;
			    for (i__ = ii; i__ <= i__1; ++i__) {
				i__2 = ii + isec - i__;
				cscal_(&i__2, beta, &t2[i__ - ii + 1 + (i__ - 
					ii + 1 << 6) - 65], &c__1);
/* L490: */
			    }
			}
			i__1 = *k;
			for (ll = 1; ll <= i__1; ll += 64) {
/* Computing MIN */
			    i__2 = 64, i__3 = *k - ll + 1;
			    lsec = min(i__2,i__3);

/*                       T3 :=  A', the transpose of a square block of A */
/*                       is copied to T3. */

			    i__2 = ii + isec - 1;
			    for (i__ = ii; i__ <= i__2; ++i__) {
				ccopy_(&lsec, &a[ll + i__ * a_dim1], &c__1, &
					t3[i__ - ii], &c__64);
/* L500: */
			    }

/*                       T2 := alpha*T3*T3' + T2, symmetric matrix */
/*                       multiply. T2 contains a symmetric block having */
/*                       lower triangular storage format. */

			    i__2 = ii + isec - 1;
			    for (i__ = ii; i__ <= i__2; ++i__) {
				i__3 = ll + lsec - 1;
				for (l = ll; l <= i__3; ++l) {
				    i__4 = ii + isec - i__;
				    i__5 = i__ - ii + 1 + (l - ll + 1 << 6) - 
					    65;
				    q__1.r = alpha->r * t3[i__5].r - alpha->i 
					    * t3[i__5].i, q__1.i = alpha->r * 
					    t3[i__5].i + alpha->i * t3[i__5]
					    .r;
				    caxpy_(&i__4, &q__1, &t3[i__ - ii + 1 + (
					    l - ll + 1 << 6) - 65], &c__1, &
					    t2[i__ - ii + 1 + (i__ - ii + 1 <<
					     6) - 65], &c__1);
/* L510: */
				}
/* L520: */
			    }
/* L530: */
			}

/*                    C := T2, the lower triangular part of T2 is copied */
/*                    back to C. */

			i__1 = ii + isec - 1;
			for (i__ = ii; i__ <= i__1; ++i__) {
			    i__2 = ii + isec - i__;
			    ccopy_(&i__2, &t2[i__ - ii + 1 + (i__ - ii + 1 << 
				    6) - 65], &c__1, &c__[i__ + i__ * c_dim1],
				     &c__1);
/* L540: */
			}
		    }

/*                 C := alpha*A'*A + beta*C, general matrix multiply on */
/*                 lower vertical blocks of C. */

		    if (ii + isec <= *n) {
			i__1 = *n - ii - isec + 1;
			cgemm_("T", "N", &i__1, &isec, k, alpha, &a[(ii + 
				isec) * a_dim1 + 1], lda, &a[ii * a_dim1 + 1],
				 lda, beta, &c__[ii + isec + ii * c_dim1], 
				ldc, (ftnlen)1, (ftnlen)1);
		    }
/* L550: */
		}
	    } else {
		clda = ccld_(lda);
		for (ix = *n; ix >= 1; ix += -64) {
/* Computing MAX */
		    i__1 = 1, i__2 = ix - 63;
		    ii = max(i__1,i__2);
		    isec = ix - ii + 1;
		    delta.r = beta->r, delta.i = beta->i;
		    i__1 = *k;
		    for (ll = 1; ll <= i__1; ll += 64) {
/* Computing MIN */
			i__2 = 64, i__3 = *k - ll + 1;
			lsec = min(i__2,i__3);

/*                    T1 := A', the transpose of a rectangular block */
/*                    of A is copied to T1. */

			if (clda) {
			    i__2 = ii + isec - 1;
			    for (i__ = ii; i__ <= i__2; ++i__) {
				ccopy_(&lsec, &a[ll + i__ * a_dim1], &c__1, &
					t1[i__ - ii], &c__64);
/* L560: */
			    }
			} else {
			    i__2 = ll + lsec - 1;
			    for (l = ll; l <= i__2; ++l) {
				ccopy_(&isec, &a[l + ii * a_dim1], lda, &t1[(
					l - ll + 1 << 6) - 64], &c__1);
/* L570: */
			    }
			}

/*                    C := alpha*T1*T1' + delta*C, C is symmetric having */
/*                    triangular storage format. Delta is used instead */
/*                    of beta to avoid updating the block of C with beta */
/*                    multiple times. */

			i__2 = ii + isec - 1;
			for (i__ = ii; i__ <= i__2; ++i__) {
			    i__3 = ii + isec - i__;
			    cgemv_("N", &i__3, &lsec, alpha, &t1[i__ - ii], &
				    c__64, &t1[i__ - ii], &c__64, &delta, &
				    c__[i__ + i__ * c_dim1], &c__1, (ftnlen)1)
				    ;
/* L580: */
			}
			delta.r = 1.f, delta.i = 0.f;
/* L590: */
		    }

/*                 C := alpha*A'*A + beta*C, general matrix multiply on */
/*                 lower vertical blocks of C. */

		    if (ii + isec <= *n) {
			i__1 = *n - ii - isec + 1;
			cgemm_("T", "N", &i__1, &isec, k, alpha, &a[(ii + 
				isec) * a_dim1 + 1], lda, &a[ii * a_dim1 + 1],
				 lda, beta, &c__[ii + isec + ii * c_dim1], 
				ldc, (ftnlen)1, (ftnlen)1);
		    }
/* L600: */
		}
	    }
	}
    }

    return 0;

/*     End of CSYRK. */

} /* csyrk_ */

