/* csymm.f -- translated by f2c (version 20030320).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

#include "f2cblas.h"

/* Table of constant values */


/* Subroutine */ int csymm_(char *side, char *uplo, integer *m, integer *n, 
	complex *alpha, complex *a, integer *lda, complex *b, integer *ldb, 
	complex *beta, complex *c__, integer *ldc, ftnlen side_len, ftnlen 
	uplo_len)
{
complex c_b1 = {0.f,0.f};
complex c_b2 = {1.f,0.f};
integer c__0 = 0;
integer c__1 = 1;
integer c__128 = 128;
    /* System generated locals */
    integer a_dim1, a_offset, b_dim1, b_offset, c_dim1, c_offset, i__1, i__2, 
	    i__3, i__4, i__5, i__6, i__7, i__8, i__9;

    /* Local variables */
    integer i__, j;
    complex t1[16384]	/* was [128][128] */;
    integer ii, jj, ix, jx, isec, jsec, info;
    extern /* Subroutine */ int cgemm_(char *, char *, integer *, integer *, 
	    integer *, complex *, complex *, integer *, complex *, integer *, 
	    complex *, complex *, integer *, ftnlen, ftnlen);
    logical lside;
    
    extern /* Subroutine */ int ccopy_(integer *, complex *, integer *, 
	    complex *, integer *);
    integer nrowa;
    logical upper;
    

/*     .. Scalar Arguments .. */
/*     .. Array Arguments .. */
/*     .. */

/*  Purpose */
/*  ======= */

/*  CSYMM  performs one of the matrix-matrix operations */

/*     C := alpha*A*B + beta*C, */

/*  or */

/*     C := alpha*B*A + beta*C, */

/*  where alpha and beta are scalars,  A is a symmetric matrix and  B and */
/*  C are  m by n matrices. */

/*  Parameters */
/*  ========== */

/*  SIDE   - CHARACTER*1. */
/*           On entry,  SIDE  specifies whether  the  symmetric matrix  A */
/*           appears on the  left or right  in the  operation as follows: */

/*              SIDE = 'L' or 'l'   C := alpha*A*B + beta*C, */

/*              SIDE = 'R' or 'r'   C := alpha*B*A + beta*C, */

/*           Unchanged on exit. */

/*  UPLO   - CHARACTER*1. */
/*           On  entry,   UPLO  specifies  whether  the  upper  or  lower */
/*           triangular  part  of  the  symmetric  matrix   A  is  to  be */
/*           referenced as follows: */

/*              UPLO = 'U' or 'u'   Only the upper triangular part of the */
/*                                  symmetric matrix is to be referenced. */

/*              UPLO = 'L' or 'l'   Only the lower triangular part of the */
/*                                  symmetric matrix is to be referenced. */

/*           Unchanged on exit. */

/*  M      - INTEGER. */
/*           On entry,  M  specifies the number of rows of the matrix  C. */
/*           M  must be at least zero. */
/*           Unchanged on exit. */

/*  N      - INTEGER. */
/*           On entry, N specifies the number of columns of the matrix C. */
/*           N  must be at least zero. */
/*           Unchanged on exit. */

/*  ALPHA  - COMPLEX. */
/*           On entry, ALPHA specifies the scalar alpha. */
/*           Unchanged on exit. */

/*  A      - COMPLEX array of DIMENSION ( LDA, ka ), where ka is */
/*           m  when  SIDE = 'L' or 'l'  and is  n otherwise. */
/*           Before entry  with  SIDE = 'L' or 'l',  the  m by m  part of */
/*           the array  A  must contain the  symmetric matrix,  such that */
/*           when  UPLO = 'U' or 'u', the leading m by m upper triangular */
/*           part of the array  A  must contain the upper triangular part */
/*           of the  symmetric matrix and the  strictly  lower triangular */
/*           part of  A  is not referenced,  and when  UPLO = 'L' or 'l', */
/*           the leading  m by m  lower triangular part  of the  array  A */
/*           must  contain  the  lower triangular part  of the  symmetric */
/*           matrix and the  strictly upper triangular part of  A  is not */
/*           referenced. */
/*           Before entry  with  SIDE = 'R' or 'r',  the  n by n  part of */
/*           the array  A  must contain the  symmetric matrix,  such that */
/*           when  UPLO = 'U' or 'u', the leading n by n upper triangular */
/*           part of the array  A  must contain the upper triangular part */
/*           of the  symmetric matrix and the  strictly  lower triangular */
/*           part of  A  is not referenced,  and when  UPLO = 'L' or 'l', */
/*           the leading  n by n  lower triangular part  of the  array  A */
/*           must  contain  the  lower triangular part  of the  symmetric */
/*           matrix and the  strictly upper triangular part of  A  is not */
/*           referenced. */
/*           Unchanged on exit. */

/*  LDA    - INTEGER. */
/*           On entry, LDA specifies the first dimension of A as declared */
/*           in the calling (sub) program.  When  SIDE = 'L' or 'l'  then */
/*           LDA must be at least  max( 1, m ), otherwise  LDA must be at */
/*           least  max( 1, n ). */
/*           Unchanged on exit. */

/*  B      - COMPLEX array of DIMENSION ( LDB, n ). */
/*           Before entry, the leading  m by n part of the array  B  must */
/*           contain the matrix B. */
/*           Unchanged on exit. */

/*  LDB    - INTEGER. */
/*           On entry, LDB specifies the first dimension of B as declared */
/*           in  the  calling  (sub)  program.   LDB  must  be  at  least */
/*           max( 1, m ). */
/*           Unchanged on exit. */

/*  BETA   - COMPLEX. */
/*           On entry,  BETA  specifies the scalar  beta.  When  BETA  is */
/*           supplied as zero then C need not be set on input. */
/*           Unchanged on exit. */

/*  C      - COMPLEX array of DIMENSION ( LDC, n ). */
/*           Before entry, the leading  m by n  part of the array  C must */
/*           contain the matrix  C,  except when  beta  is zero, in which */
/*           case C need not be set on entry. */
/*           On exit, the array  C  is overwritten by the  m by n updated */
/*           matrix. */

/*  LDC    - INTEGER. */
/*           On entry, LDC specifies the first dimension of C as declared */
/*           in  the  calling  (sub)  program.   LDC  must  be  at  least */
/*           max( 1, m ). */
/*           Unchanged on exit. */


/*  Level 3 Blas routine. */

/*  -- Written on 8-February-1989. */
/*     Jack Dongarra, Argonne National Laboratory. */
/*     Iain Duff, AERE Harwell. */
/*     Jeremy Du Croz, Numerical Algorithms Group Ltd. */
/*     Sven Hammarling, Numerical Algorithms Group Ltd. */

/*  -- Rewritten in May-1994. */
/*     GEMM-Based Level 3 BLAS. */
/*     Per Ling, Institute of Information Processing, */
/*     University of Umea, Sweden. */


/*     .. Local Scalars .. */
/*     .. Intrinsic Functions .. */
/*     .. External Functions .. */
/*     .. External Subroutines .. */
/*     .. Parameters .. */
/*     .. User specified parameters for CSYMM .. */
/*     .. Local Arrays .. */
/*     .. */
/*     .. Executable Statements .. */

/*     Test the input parameters. */

    /* Parameter adjustments */
    a_dim1 = *lda;
    a_offset = 1 + a_dim1;
    a -= a_offset;
    b_dim1 = *ldb;
    b_offset = 1 + b_dim1;
    b -= b_offset;
    c_dim1 = *ldc;
    c_offset = 1 + c_dim1;
    c__ -= c_offset;

    /* Function Body */
    lside = (side[0]=='L'?1:0);
    upper = (uplo[0]=='U'?1:0);
    if (lside) {
	nrowa = *m;
    } else {
	nrowa = *n;
    }
    info = 0;
    if (! lside && ! (side[0]=='R'?1:0)) {
	info = 1;
    } else if (! upper && ! (uplo[0]=='L'?1:0)) {
	info = 2;
    } else if (*m < 0) {
	info = 3;
    } else if (*n < 0) {
	info = 4;
    } else if (*lda < max(1,nrowa)) {
	info = 7;
    } else if (*ldb < max(1,*m)) {
	info = 9;
    } else if (*ldc < max(1,*m)) {
	info = 12;
    }
    if (info != 0) {
	xerbla_("CSYMM ", &info, (ftnlen)6);
	return 0;
    }

/*     Quick return if possible. */

    if (*m == 0 || *n == 0 || alpha->r == 0.f && alpha->i == 0.f && (beta->r 
	    == 1.f && beta->i == 0.f)) {
	return 0;
    }

/*     And when alpha.eq.zero. */

    if (alpha->r == 0.f && alpha->i == 0.f) {
	i__1 = max(*lda,*ldb);
	i__2 = max(*lda,*ldb);
	cgemm_("N", "N", m, n, &c__0, &c_b1, &a[a_offset], &i__1, &b[b_offset]
		, &i__2, beta, &c__[c_offset], ldc, (ftnlen)1, (ftnlen)1);
	return 0;
    }

/*     Start the operations. */

    if (lside) {
	if (upper) {

/*           Form  C := alpha*A*B + beta*C. Left, Upper. */

	    i__1 = *m;
	    for (ii = 1; ii <= i__1; ii += 128) {
/* Computing MIN */
		i__2 = 128, i__3 = *m - ii + 1;
		isec = min(i__2,i__3);

/*              T1 := A, a upper triangular diagonal block of A is copied */
/*              to the upper triangular part of T1. */

		i__2 = ii + isec - 1;
		for (i__ = ii; i__ <= i__2; ++i__) {
		    i__3 = i__ - ii + 1;
		    ccopy_(&i__3, &a[ii + i__ * a_dim1], &c__1, &t1[(i__ - ii 
			    + 1 << 7) - 128], &c__1);
/* L10: */
		}

/*              T1 :=  A', a strictly upper triangular diagonal block of */
/*              A is copied to the strictly lower triangular part of T1. */
/*              Notice that T1 is referenced by row and that the maximum */
/*              length of a vector referenced by CCOPY is CB. */

		i__2 = ii + isec - 1;
		for (jj = ii; jj <= i__2; jj += 64) {
/* Computing MIN */
		    i__3 = 64, i__4 = ii + isec - jj;
		    jsec = min(i__3,i__4);
		    i__3 = ii + isec - 1;
		    for (j = jj + 1; j <= i__3; ++j) {
/* Computing MIN */
			i__5 = jsec, i__6 = j - jj;
			i__4 = min(i__5,i__6);
			ccopy_(&i__4, &a[jj + j * a_dim1], &c__1, &t1[j - ii 
				+ 1 + (jj - ii + 1 << 7) - 129], &c__128);
/* L20: */
		    }
/* L30: */
		}

/*              C := alpha*T1*B + beta*C, a horizontal block of C is */
/*              updated using the general matrix multiply, CGEMM. T1 */
/*              corresponds to a full diagonal block of the matrix A. */

		cgemm_("N", "N", &isec, n, &isec, alpha, t1, &c__128, &b[ii + 
			b_dim1], ldb, beta, &c__[ii + c_dim1], ldc, (ftnlen)1,
			 (ftnlen)1);

/*              C := alpha*A'*B + C and C := alpha*A*B + C, general */
/*              matrix multiply operations involving rectangular blocks */
/*              of A. */

		if (ii > 1) {
		    i__2 = ii - 1;
		    cgemm_("T", "N", &isec, n, &i__2, alpha, &a[ii * a_dim1 + 
			    1], lda, &b[b_dim1 + 1], ldb, &c_b2, &c__[ii + 
			    c_dim1], ldc, (ftnlen)1, (ftnlen)1);
		}
		if (ii + isec <= *m) {
		    i__2 = *m - ii - isec + 1;
		    cgemm_("N", "N", &isec, n, &i__2, alpha, &a[ii + (ii + 
			    isec) * a_dim1], lda, &b[ii + isec + b_dim1], ldb,
			     &c_b2, &c__[ii + c_dim1], ldc, (ftnlen)1, (
			    ftnlen)1);
		}
/* L40: */
	    }
	} else {

/*           Form  C := alpha*A*B + beta*C. Left, Lower. */

	    for (ix = *m; ix >= 1; ix += -128) {
/* Computing MAX */
		i__1 = 1, i__2 = ix - 127;
		ii = max(i__1,i__2);
		isec = ix - ii + 1;

/*              T1 := A, a lower triangular diagonal block of A is copied */
/*              to the lower triangular part of T1. */

		i__1 = ii + isec - 1;
		for (i__ = ii; i__ <= i__1; ++i__) {
		    i__2 = ii + isec - i__;
		    ccopy_(&i__2, &a[i__ + i__ * a_dim1], &c__1, &t1[i__ - ii 
			    + 1 + (i__ - ii + 1 << 7) - 129], &c__1);
/* L50: */
		}

/*              T1 :=  A', a strictly lower triangular diagonal block of */
/*              A is copied to the strictly upper triangular part of T1. */
/*              Notice that T1 is referenced by row and that the maximum */
/*              length of a vector referenced by CCOPY is CB. */

		i__1 = ii;
		for (jx = ii + isec - 1; jx >= i__1; jx += -64) {
/* Computing MAX */
		    i__2 = ii, i__3 = jx - 63;
		    jj = max(i__2,i__3);
		    jsec = jx - jj + 1;
		    i__2 = jj + jsec - 2;
		    for (j = ii; j <= i__2; ++j) {
/* Computing MIN */
			i__4 = jsec, i__5 = jj + jsec - 1 - j;
			i__3 = min(i__4,i__5);
/* Computing MAX */
			i__6 = jj, i__7 = j + 1;
/* Computing MAX */
			i__8 = jj - ii + 1, i__9 = j - ii + 2;
			ccopy_(&i__3, &a[max(i__6,i__7) + j * a_dim1], &c__1, 
				&t1[j - ii + 1 + (max(i__8,i__9) << 7) - 129],
				 &c__128);
/* L60: */
		    }
/* L70: */
		}

/*              C := alpha*T1*B + beta*C, a horizontal block of C is */
/*              updated using the general matrix multiply, CGEMM. T1 */
/*              corresponds to a full diagonal block of the matrix A. */

		cgemm_("N", "N", &isec, n, &isec, alpha, t1, &c__128, &b[ii + 
			b_dim1], ldb, beta, &c__[ii + c_dim1], ldc, (ftnlen)1,
			 (ftnlen)1);

/*              C := alpha*A'*B + C and C := alpha*A*B + C, general */
/*              matrix multiply operations involving rectangular blocks */
/*              of A. */

		if (ii + isec <= *m) {
		    i__1 = *m - ii - isec + 1;
		    cgemm_("T", "N", &isec, n, &i__1, alpha, &a[ii + isec + 
			    ii * a_dim1], lda, &b[ii + isec + b_dim1], ldb, &
			    c_b2, &c__[ii + c_dim1], ldc, (ftnlen)1, (ftnlen)
			    1);
		}
		if (ii > 1) {
		    i__1 = ii - 1;
		    cgemm_("N", "N", &isec, n, &i__1, alpha, &a[ii + a_dim1], 
			    lda, &b[b_dim1 + 1], ldb, &c_b2, &c__[ii + c_dim1]
			    , ldc, (ftnlen)1, (ftnlen)1);
		}
/* L80: */
	    }
	}
    } else {
	if (upper) {

/*           Form  C := alpha*B*A + beta*C. Right, Upper. */

	    i__1 = *n;
	    for (jj = 1; jj <= i__1; jj += 128) {
/* Computing MIN */
		i__2 = 128, i__3 = *n - jj + 1;
		jsec = min(i__2,i__3);

/*              T1 := A, a upper triangular diagonal block of A is copied */
/*              to the upper triangular part of T1. */

		i__2 = jj + jsec - 1;
		for (j = jj; j <= i__2; ++j) {
		    i__3 = j - jj + 1;
		    ccopy_(&i__3, &a[jj + j * a_dim1], &c__1, &t1[(j - jj + 1 
			    << 7) - 128], &c__1);
/* L90: */
		}

/*              T1 :=  A', a strictly upper triangular diagonal block of */
/*              A is copied to the strictly lower triangular part of T1. */
/*              Notice that T1 is referenced by row and that the maximum */
/*              length of a vector referenced by CCOPY is CB. */

		i__2 = jj + jsec - 1;
		for (ii = jj; ii <= i__2; ii += 64) {
/* Computing MIN */
		    i__3 = 64, i__4 = jj + jsec - ii;
		    isec = min(i__3,i__4);
		    i__3 = jj + jsec - 1;
		    for (i__ = ii + 1; i__ <= i__3; ++i__) {
/* Computing MIN */
			i__5 = isec, i__6 = i__ - ii;
			i__4 = min(i__5,i__6);
			ccopy_(&i__4, &a[ii + i__ * a_dim1], &c__1, &t1[i__ - 
				jj + 1 + (ii - jj + 1 << 7) - 129], &c__128);
/* L100: */
		    }
/* L110: */
		}

/*              C := alpha*B*T1 + beta*C, a vertical block of C is updated */
/*              using the general matrix multiply, CGEMM. T1 corresponds */
/*              to a full diagonal block of the matrix A. */

		cgemm_("N", "N", m, &jsec, &jsec, alpha, &b[jj * b_dim1 + 1], 
			ldb, t1, &c__128, beta, &c__[jj * c_dim1 + 1], ldc, (
			ftnlen)1, (ftnlen)1);

/*              C := alpha*B*A + C and C := alpha*B*A' + C, general */
/*              matrix multiply operations involving rectangular blocks */
/*              of A. */

		if (jj > 1) {
		    i__2 = jj - 1;
		    cgemm_("N", "N", m, &jsec, &i__2, alpha, &b[b_dim1 + 1], 
			    ldb, &a[jj * a_dim1 + 1], lda, &c_b2, &c__[jj * 
			    c_dim1 + 1], ldc, (ftnlen)1, (ftnlen)1);
		}
		if (jj + jsec <= *n) {
		    i__2 = *n - jj - jsec + 1;
		    cgemm_("N", "T", m, &jsec, &i__2, alpha, &b[(jj + jsec) * 
			    b_dim1 + 1], ldb, &a[jj + (jj + jsec) * a_dim1], 
			    lda, &c_b2, &c__[jj * c_dim1 + 1], ldc, (ftnlen)1,
			     (ftnlen)1);
		}
/* L120: */
	    }
	} else {

/*           Form  C := alpha*B*A + beta*C. Right, Lower. */

	    for (jx = *n; jx >= 1; jx += -128) {
/* Computing MAX */
		i__1 = 1, i__2 = jx - 127;
		jj = max(i__1,i__2);
		jsec = jx - jj + 1;

/*              T1 := A, a lower triangular diagonal block of A is copied */
/*              to the lower triangular part of T1. */

		i__1 = jj + jsec - 1;
		for (j = jj; j <= i__1; ++j) {
		    i__2 = jj + jsec - j;
		    ccopy_(&i__2, &a[j + j * a_dim1], &c__1, &t1[j - jj + 1 + 
			    (j - jj + 1 << 7) - 129], &c__1);
/* L130: */
		}

/*              T1 :=  A', a strictly lower triangular diagonal block of */
/*              A is copied to the strictly upper triangular part of T1. */
/*              Notice that T1 is referenced by row and that the maximum */
/*              length of a vector referenced by CCOPY is CB. */

		i__1 = jj;
		for (ix = jj + jsec - 1; ix >= i__1; ix += -64) {
/* Computing MAX */
		    i__2 = jj, i__3 = ix - 63;
		    ii = max(i__2,i__3);
		    isec = ix - ii + 1;
		    i__2 = ii + isec - 2;
		    for (i__ = jj; i__ <= i__2; ++i__) {
/* Computing MIN */
			i__4 = isec, i__5 = ii + isec - 1 - i__;
			i__3 = min(i__4,i__5);
/* Computing MAX */
			i__6 = ii, i__7 = i__ + 1;
/* Computing MAX */
			i__8 = ii - jj + 1, i__9 = i__ - jj + 2;
			ccopy_(&i__3, &a[max(i__6,i__7) + i__ * a_dim1], &
				c__1, &t1[i__ - jj + 1 + (max(i__8,i__9) << 7)
				 - 129], &c__128);
/* L140: */
		    }
/* L150: */
		}

/*              C := alpha*B*T1 + beta*C, a vertical block of C is */
/*              updated using the general matrix multiply, CGEMM. T1 */
/*              corresponds to a full diagonal block of the matrix A. */

		cgemm_("N", "N", m, &jsec, &jsec, alpha, &b[jj * b_dim1 + 1], 
			ldb, t1, &c__128, beta, &c__[jj * c_dim1 + 1], ldc, (
			ftnlen)1, (ftnlen)1);

/*              C := alpha*B*A + C and C := alpha*B*A' + C, general */
/*              matrix multiply operations involving rectangular blocks */
/*              of A. */

		if (jj + jsec <= *n) {
		    i__1 = *n - jj - jsec + 1;
		    cgemm_("N", "N", m, &jsec, &i__1, alpha, &b[(jj + jsec) * 
			    b_dim1 + 1], ldb, &a[jj + jsec + jj * a_dim1], 
			    lda, &c_b2, &c__[jj * c_dim1 + 1], ldc, (ftnlen)1,
			     (ftnlen)1);
		}
		if (jj > 1) {
		    i__1 = jj - 1;
		    cgemm_("N", "T", m, &jsec, &i__1, alpha, &b[b_dim1 + 1], 
			    ldb, &a[jj + a_dim1], lda, &c_b2, &c__[jj * 
			    c_dim1 + 1], ldc, (ftnlen)1, (ftnlen)1);
		}
/* L160: */
	    }
	}
    }

    return 0;

/*     End of CSYMM. */

} /* csymm_ */

