/* cher2k.f -- translated by f2c (version 20030320).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

#include "f2cblas.h"

/* Table of constant values */


/* Subroutine */ int cher2k_(char *uplo, char *trans, integer *n, integer *k, 
	complex *alpha, complex *a, integer *lda, complex *b, integer *ldb, 
	real *beta, complex *c__, integer *ldc, ftnlen uplo_len, ftnlen 
	trans_len)
{
complex c_b1 = {1.f,0.f};
complex c_b2 = {0.f,0.f};
integer c__1 = 1;
integer c__128 = 128;
    /* System generated locals */
    integer a_dim1, a_offset, b_dim1, b_offset, c_dim1, c_offset, i__1, i__2, 
	    i__3, i__4, i__5, i__6;
    real r__1;
    complex q__1, q__2;

    /* Builtin functions */
    void r_cnjg(complex *, complex *);

    /* Local variables */
    integer i__, j;
    complex t1[16384]	/* was [128][128] */;
    integer ii, jj, ix, jx, isec, jsec, info;
    logical notr;
    complex cbeta;
    extern /* Subroutine */ int cscal_(integer *, complex *, complex *, 
	    integer *), cgemm_(char *, char *, integer *, integer *, integer *
	    , complex *, complex *, integer *, complex *, integer *, complex *
	    , complex *, integer *, ftnlen, ftnlen);
    
    extern /* Subroutine */ int caxpy_(integer *, complex *, complex *, 
	    integer *, complex *, integer *);
    integer nrowa;
    logical upper;
    

/*     .. Scalar Arguments .. */
/*     .. Array Arguments .. */
/*     .. */

/*  Purpose */
/*  ======= */

/*  CHER2K  performs one of the hermitian rank 2k operations */

/*     C := alpha*A*conjg( B' ) + conjg( alpha )*B*conjg( A' ) + beta*C, */

/*  or */

/*     C := alpha*conjg( A' )*B + conjg( alpha )*conjg( B' )*A + beta*C, */

/*  where  alpha and beta  are scalars with  beta  real,  C is an  n by n */
/*  hermitian matrix and  A and B  are  n by k matrices in the first case */
/*  and  k by n  matrices in the second case. */

/*  Parameters */
/*  ========== */

/*  UPLO   - CHARACTER*1. */
/*           On  entry,   UPLO  specifies  whether  the  upper  or  lower */
/*           triangular  part  of the  array  C  is to be  referenced  as */
/*           follows: */

/*              UPLO = 'U' or 'u'   Only the  upper triangular part of  C */
/*                                  is to be referenced. */

/*              UPLO = 'L' or 'l'   Only the  lower triangular part of  C */
/*                                  is to be referenced. */

/*           Unchanged on exit. */

/*  TRANS  - CHARACTER*1. */
/*           On entry,  TRANS  specifies the operation to be performed as */
/*           follows: */

/*              TRANS = 'N' or 'n'    C := alpha*A*conjg( B' )          + */
/*                                         conjg( alpha )*B*conjg( A' ) + */
/*                                         beta*C. */

/*              TRANS = 'C' or 'c'    C := alpha*conjg( A' )*B          + */
/*                                         conjg( alpha )*conjg( B' )*A + */
/*                                         beta*C. */

/*           Unchanged on exit. */

/*  N      - INTEGER. */
/*           On entry,  N specifies the order of the matrix C.  N must be */
/*           at least zero. */
/*           Unchanged on exit. */

/*  K      - INTEGER. */
/*           On entry with  TRANS = 'N' or 'n',  K  specifies  the number */
/*           of  columns  of the  matrices  A and B,  and on  entry  with */
/*           TRANS = 'C' or 'c',  K  specifies  the number of rows of the */
/*           matrices  A and B.  K must be at least zero. */
/*           Unchanged on exit. */

/*  ALPHA  - COMPLEX      . */
/*           On entry, ALPHA specifies the scalar alpha. */
/*           Unchanged on exit. */

/*  A      - COMPLEX       array of DIMENSION ( LDA, ka ), where ka is */
/*           k  when  TRANS = 'N' or 'n',  and is  n  otherwise. */
/*           Before entry with  TRANS = 'N' or 'n',  the  leading  n by k */
/*           part of the array  A  must contain the matrix  A,  otherwise */
/*           the leading  k by n  part of the array  A  must contain  the */
/*           matrix A. */
/*           Unchanged on exit. */

/*  LDA    - INTEGER. */
/*           On entry, LDA specifies the first dimension of A as declared */
/*           in  the  calling  (sub)  program.   When  TRANS = 'N' or 'n' */
/*           then  LDA must be at least  max( 1, n ), otherwise  LDA must */
/*           be at least  max( 1, k ). */
/*           Unchanged on exit. */

/*  B      - COMPLEX       array of DIMENSION ( LDB, kb ), where kb is */
/*           k  when  TRANS = 'N' or 'n',  and is  n  otherwise. */
/*           Before entry with  TRANS = 'N' or 'n',  the  leading  n by k */
/*           part of the array  B  must contain the matrix  B,  otherwise */
/*           the leading  k by n  part of the array  B  must contain  the */
/*           matrix B. */
/*           Unchanged on exit. */

/*  LDB    - INTEGER. */
/*           On entry, LDB specifies the first dimension of B as declared */
/*           in  the  calling  (sub)  program.   When  TRANS = 'N' or 'n' */
/*           then  LDB must be at least  max( 1, n ), otherwise  LDB must */
/*           be at least  max( 1, k ). */
/*           Unchanged on exit. */

/*  BETA   - REAL. */
/*           On entry, BETA specifies the scalar beta. */
/*           Unchanged on exit. */

/*  C      - COMPLEX       array of DIMENSION ( LDC, n ). */
/*           Before entry  with  UPLO = 'U' or 'u',  the leading  n by n */
/*           upper triangular part of the array C must contain the upper */
/*           triangular part  of the  hermitian matrix  and the strictly */
/*           lower triangular part of C is not referenced.  On exit, the */
/*           upper triangular part of the array  C is overwritten by the */
/*           upper triangular part of the updated matrix. */
/*           Before entry  with  UPLO = 'L' or 'l',  the leading  n by n */
/*           lower triangular part of the array C must contain the lower */
/*           triangular part  of the  hermitian matrix  and the strictly */
/*           upper triangular part of C is not referenced.  On exit, the */
/*           lower triangular part of the array  C is overwritten by the */
/*           lower triangular part of the updated matrix. */
/*           Note that the imaginary parts of the diagonal elements need */
/*           not be set,  they are assumed to be zero,  and on exit they */
/*           are set to zero. */

/*  LDC    - INTEGER. */
/*           On entry, LDC specifies the first dimension of C as declared */
/*           in  the  calling  (sub)  program.   LDC  must  be  at  least */
/*           max( 1, n ). */
/*           Unchanged on exit. */


/*  Level 3 Blas routine. */

/*  -- Written on 8-February-1989. */
/*     Jack Dongarra, Argonne National Laboratory. */
/*     Iain Duff, AERE Harwell. */
/*     Jeremy Du Croz, Numerical Algorithms Group Ltd. */
/*     Sven Hammarling, Numerical Algorithms Group Ltd. */

/*  -- Rewritten in May-1994. */
/*     GEMM-Based Level 3 BLAS. */
/*     Per Ling, Institute of Information Processing, */
/*     University of Umea, Sweden. */


/*     .. Local Scalars .. */
/*     .. Intrinsic Functions .. */
/*     .. External Functions .. */
/*     .. External Subroutines .. */
/*     .. Parameters .. */
/*     .. User specified parameters for CHER2K .. */
/*     .. Local Arrays .. */
/*     .. */
/*     .. Executable Statements .. */

/*     Test the input parameters. */

    /* Parameter adjustments */
    a_dim1 = *lda;
    a_offset = 1 + a_dim1;
    a -= a_offset;
    b_dim1 = *ldb;
    b_offset = 1 + b_dim1;
    b -= b_offset;
    c_dim1 = *ldc;
    c_offset = 1 + c_dim1;
    c__ -= c_offset;

    /* Function Body */
    upper = (uplo[0]=='U'?1:0);
    notr = (trans[0]=='N'?1:0);
    if (notr) {
	nrowa = *n;
    } else {
	nrowa = *k;
    }
    info = 0;
    if (! upper && ! (uplo[0]=='L'?1:0)) {
	info = 1;
    } else if (! notr && ! (trans[0]=='C'?1:0)) {
	info = 2;
    } else if (*n < 0) {
	info = 3;
    } else if (*k < 0) {
	info = 4;
    } else if (*lda < max(1,nrowa)) {
	info = 7;
    } else if (*ldb < max(1,nrowa)) {
	info = 9;
    } else if (*ldc < max(1,*n)) {
	info = 12;
    }
    if (info != 0) {
	xerbla_("CHER2K", &info, (ftnlen)6);
	return 0;
    }

/*     Quick return if possible. */

    if (*n == 0 || (alpha->r == 0.f && alpha->i == 0.f || *k == 0) && *beta ==
	     1.f) {
	return 0;
    }

    q__1.r = *beta, q__1.i = 0.f;
    cbeta.r = q__1.r, cbeta.i = q__1.i;

/*     And when alpha.eq.zero or k.eq.0. */

    if (alpha->r == 0.f && alpha->i == 0.f || *k == 0) {
	if (upper) {
	    i__1 = c_dim1 + 1;
	    i__2 = c_dim1 + 1;
	    r__1 = *beta * c__[i__2].r;
	    q__1.r = r__1, q__1.i = 0.f;
	    c__[i__1].r = q__1.r, c__[i__1].i = q__1.i;
	    i__1 = *n;
	    for (i__ = 2; i__ <= i__1; ++i__) {
		i__2 = i__ - 1;
		cscal_(&i__2, &cbeta, &c__[i__ * c_dim1 + 1], &c__1);
		i__2 = i__ + i__ * c_dim1;
		i__3 = i__ + i__ * c_dim1;
		r__1 = *beta * c__[i__3].r;
		q__1.r = r__1, q__1.i = 0.f;
		c__[i__2].r = q__1.r, c__[i__2].i = q__1.i;
/* L10: */
	    }
	} else {
	    i__1 = *n - 1;
	    for (i__ = 1; i__ <= i__1; ++i__) {
		i__2 = i__ + i__ * c_dim1;
		i__3 = i__ + i__ * c_dim1;
		r__1 = *beta * c__[i__3].r;
		q__1.r = r__1, q__1.i = 0.f;
		c__[i__2].r = q__1.r, c__[i__2].i = q__1.i;
		i__2 = *n - i__;
		cscal_(&i__2, &cbeta, &c__[i__ + 1 + i__ * c_dim1], &c__1);
/* L20: */
	    }
	    i__1 = *n + *n * c_dim1;
	    i__2 = *n + *n * c_dim1;
	    r__1 = *beta * c__[i__2].r;
	    q__1.r = r__1, q__1.i = 0.f;
	    c__[i__1].r = q__1.r, c__[i__1].i = q__1.i;
	}
	return 0;
    }

/*     Start the operations. */

    if (upper) {
	if (notr) {

/*           Form  C := alpha*A*conjg( B' ) + */
/*           conjg( alpha )*B*conjg( A' ) + beta*C. Upper, Notr. */

	    i__1 = *n;
	    for (ii = 1; ii <= i__1; ii += 128) {
/* Computing MIN */
		i__2 = 128, i__3 = *n - ii + 1;
		isec = min(i__2,i__3);

/*              T1 := alpha*A*conjg( B' ), matrix multiply on rectangular */
/*              blocks of A and B. T1 is a square block. */

		cgemm_("N", "C", &isec, &isec, k, alpha, &a[ii + a_dim1], lda,
			 &b[ii + b_dim1], ldb, &c_b2, t1, &c__128, (ftnlen)1, 
			(ftnlen)1);

/*              C :=  beta*C, a upper triangular diagonal block of C is */
/*              updated with beta. */

		if (*beta != 1.f) {
		    i__2 = ii + isec - 1;
		    for (i__ = ii; i__ <= i__2; ++i__) {
			i__3 = i__ - ii + 1;
			cscal_(&i__3, &cbeta, &c__[ii + i__ * c_dim1], &c__1);
/* L30: */
		    }
		}

/*              C := T1 + C, the upper triangular part of T1 is added to */
/*              the upper triangular diagonal block of C. */

		i__2 = ii + isec - 1;
		for (i__ = ii; i__ <= i__2; ++i__) {
		    i__3 = i__ - ii + 1;
		    caxpy_(&i__3, &c_b1, &t1[(i__ - ii + 1 << 7) - 128], &
			    c__1, &c__[ii + i__ * c_dim1], &c__1);
/* L40: */
		}

/*              C := conjg( T1' ) + C, the conjugated transpose of the */
/*              lower triangular part of T1 is added to the upper */
/*              triangular diagonal block of C. Notice that T1 is */
/*              referenced by row and that the maximum length of a vector */
/*              referenced by CAXPY is CB. */

		i__2 = ii + isec - 1;
		for (jj = ii; jj <= i__2; jj += 64) {
/* Computing MIN */
		    i__3 = 64, i__4 = ii + isec - jj;
		    jsec = min(i__3,i__4);
		    i__3 = ii + isec - 1;
		    for (i__ = jj; i__ <= i__3; ++i__) {
/* Computing MIN */
			i__5 = jj + jsec - 1;
			i__4 = min(i__5,i__);
			for (j = jj; j <= i__4; ++j) {
			    i__5 = j + i__ * c_dim1;
			    i__6 = j + i__ * c_dim1;
			    r_cnjg(&q__2, &t1[i__ - ii + 1 + (j - ii + 1 << 7)
				     - 129]);
			    q__1.r = c__[i__6].r + q__2.r, q__1.i = c__[i__6]
				    .i + q__2.i;
			    c__[i__5].r = q__1.r, c__[i__5].i = q__1.i;
/* L50: */
			}
/* L60: */
		    }
/* L70: */
		}

/*              Set the imaginary part of diagonal elements of C */
/*              to zero. */

		i__2 = ii + isec - 1;
		for (i__ = ii; i__ <= i__2; ++i__) {
		    i__3 = i__ + i__ * c_dim1;
		    i__4 = i__ + i__ * c_dim1;
		    r__1 = c__[i__4].r;
		    q__1.r = r__1, q__1.i = 0.f;
		    c__[i__3].r = q__1.r, c__[i__3].i = q__1.i;
/* L80: */
		}

/*              C := alpha*A*conjg( B' ) + beta*C  and */
/*              C := conjg( alpha )*B*conjg( A' ) + C, matrix multiply */
/*              updating upper vertical blocks of C. */

		if (ii > 1) {
		    i__2 = ii - 1;
		    cgemm_("N", "C", &i__2, &isec, k, alpha, &a[a_dim1 + 1], 
			    lda, &b[ii + b_dim1], ldb, &cbeta, &c__[ii * 
			    c_dim1 + 1], ldc, (ftnlen)1, (ftnlen)1);
		    i__2 = ii - 1;
		    r_cnjg(&q__1, alpha);
		    cgemm_("N", "C", &i__2, &isec, k, &q__1, &b[b_dim1 + 1], 
			    ldb, &a[ii + a_dim1], lda, &c_b1, &c__[ii * 
			    c_dim1 + 1], ldc, (ftnlen)1, (ftnlen)1);
		}
/* L90: */
	    }
	} else {

/*           Form  C := alpha*conjg( A' )*B + */
/*           conjg( alpha )*conjg( B' )*A + beta*C. Upper, Trans. */

	    i__1 = *n;
	    for (ii = 1; ii <= i__1; ii += 128) {
/* Computing MIN */
		i__2 = 128, i__3 = *n - ii + 1;
		isec = min(i__2,i__3);

/*              T1 := alpha*conjg( A' )*B, matrix multiply on */
/*              rectangular blocks of A and B. T1 is a square block. */

		cgemm_("C", "N", &isec, &isec, k, alpha, &a[ii * a_dim1 + 1], 
			lda, &b[ii * b_dim1 + 1], ldb, &c_b2, t1, &c__128, (
			ftnlen)1, (ftnlen)1);

/*              C :=  beta*C, a upper triangular diagonal block of C is */
/*              updated with beta. */

		if (*beta != 1.f) {
		    i__2 = ii + isec - 1;
		    for (i__ = ii; i__ <= i__2; ++i__) {
			i__3 = i__ - ii + 1;
			cscal_(&i__3, &cbeta, &c__[ii + i__ * c_dim1], &c__1);
/* L100: */
		    }
		}

/*              C := T1 + C, the upper triangular part of T1 is added to */
/*              the upper triangular diagonal block of C. */

		i__2 = ii + isec - 1;
		for (i__ = ii; i__ <= i__2; ++i__) {
		    i__3 = i__ - ii + 1;
		    caxpy_(&i__3, &c_b1, &t1[(i__ - ii + 1 << 7) - 128], &
			    c__1, &c__[ii + i__ * c_dim1], &c__1);
/* L110: */
		}

/*              C := conjg( T1' ) + C, the conjugated transpose of the */
/*              lower triangular part of T1 is added to the upper */
/*              triangular diagonal block of C. Notice that T1 is */
/*              referenced by row and that the maximum length of a vector */
/*              referenced by CAXPY is CB. */

		i__2 = ii + isec - 1;
		for (jj = ii; jj <= i__2; jj += 64) {
/* Computing MIN */
		    i__3 = 64, i__4 = ii + isec - jj;
		    jsec = min(i__3,i__4);
		    i__3 = ii + isec - 1;
		    for (i__ = jj; i__ <= i__3; ++i__) {
/* Computing MIN */
			i__5 = jj + jsec - 1;
			i__4 = min(i__5,i__);
			for (j = jj; j <= i__4; ++j) {
			    i__5 = j + i__ * c_dim1;
			    i__6 = j + i__ * c_dim1;
			    r_cnjg(&q__2, &t1[i__ - ii + 1 + (j - ii + 1 << 7)
				     - 129]);
			    q__1.r = c__[i__6].r + q__2.r, q__1.i = c__[i__6]
				    .i + q__2.i;
			    c__[i__5].r = q__1.r, c__[i__5].i = q__1.i;
/* L120: */
			}
/* L130: */
		    }
/* L140: */
		}

/*              Set the imaginary part of diagonal elements of C */
/*              to zero. */

		i__2 = ii + isec - 1;
		for (i__ = ii; i__ <= i__2; ++i__) {
		    i__3 = i__ + i__ * c_dim1;
		    i__4 = i__ + i__ * c_dim1;
		    r__1 = c__[i__4].r;
		    q__1.r = r__1, q__1.i = 0.f;
		    c__[i__3].r = q__1.r, c__[i__3].i = q__1.i;
/* L150: */
		}

/*              C := alpha*conjg( A' )*B + beta*C  and */
/*              C := alpha*conjg( B' )*A + C, matrix multiply on upper */
/*              vertical blocks of C. */

		if (ii > 1) {
		    i__2 = ii - 1;
		    cgemm_("C", "N", &i__2, &isec, k, alpha, &a[a_dim1 + 1], 
			    lda, &b[ii * b_dim1 + 1], ldb, &cbeta, &c__[ii * 
			    c_dim1 + 1], ldc, (ftnlen)1, (ftnlen)1);
		    i__2 = ii - 1;
		    r_cnjg(&q__1, alpha);
		    cgemm_("C", "N", &i__2, &isec, k, &q__1, &b[b_dim1 + 1], 
			    ldb, &a[ii * a_dim1 + 1], lda, &c_b1, &c__[ii * 
			    c_dim1 + 1], ldc, (ftnlen)1, (ftnlen)1);
		}
/* L160: */
	    }
	}
    } else {
	if (notr) {

/*           Form  C := alpha*A*conjg( B' ) + */
/*           alpha*B*conjg( A' ) + beta*C. Lower, Notr. */

	    for (ix = *n; ix >= 1; ix += -128) {
/* Computing MAX */
		i__1 = 1, i__2 = ix - 127;
		ii = max(i__1,i__2);
		isec = ix - ii + 1;

/*              T1 := alpha*A*conjg( B' ), matrix multiply on rectangular */
/*              blocks of A and B. T1 is a square block. */

		cgemm_("N", "C", &isec, &isec, k, alpha, &a[ii + a_dim1], lda,
			 &b[ii + b_dim1], ldb, &c_b2, t1, &c__128, (ftnlen)1, 
			(ftnlen)1);

/*              C :=  beta*C, a lower triangular diagonal block of C is */
/*              updated with beta. */

		if (*beta != 1.f) {
		    i__1 = ii + isec - 1;
		    for (i__ = ii; i__ <= i__1; ++i__) {
			i__2 = ii + isec - i__;
			cscal_(&i__2, &cbeta, &c__[i__ + i__ * c_dim1], &c__1)
				;
/* L170: */
		    }
		}

/*              C := T1 + C, the lower triangular part of T1 is added to */
/*              the lower triangular diagonal block of C. */

		i__1 = ii + isec - 1;
		for (i__ = ii; i__ <= i__1; ++i__) {
		    i__2 = ii + isec - i__;
		    caxpy_(&i__2, &c_b1, &t1[i__ - ii + 1 + (i__ - ii + 1 << 
			    7) - 129], &c__1, &c__[i__ + i__ * c_dim1], &c__1)
			    ;
/* L180: */
		}

/*              C := conjg( T1' ) + C, the conjugated transpose of the */
/*              upper triangular part of T1 is added to the lower */
/*              triangular diagonal block of C. Notice that T1 is */
/*              referenced by row and that the maximum length of a vector */
/*              referenced by CAXPY is CB. */

		i__1 = ii;
		for (jx = ii + isec - 1; jx >= i__1; jx += -64) {
/* Computing MAX */
		    i__2 = ii, i__3 = jx - 63;
		    jj = max(i__2,i__3);
		    jsec = jx - jj + 1;
		    i__2 = jj + jsec - 1;
		    for (i__ = ii; i__ <= i__2; ++i__) {
			i__3 = jj + jsec - 1;
			for (j = max(jj,i__); j <= i__3; ++j) {
			    i__4 = j + i__ * c_dim1;
			    i__5 = j + i__ * c_dim1;
			    r_cnjg(&q__2, &t1[i__ - ii + 1 + (j - ii + 1 << 7)
				     - 129]);
			    q__1.r = c__[i__5].r + q__2.r, q__1.i = c__[i__5]
				    .i + q__2.i;
			    c__[i__4].r = q__1.r, c__[i__4].i = q__1.i;
/* L190: */
			}
/* L200: */
		    }
/* L210: */
		}

/*              Set the imaginary part of diagonal elements of C */
/*              to zero. */

		i__1 = ii + isec - 1;
		for (i__ = ii; i__ <= i__1; ++i__) {
		    i__2 = i__ + i__ * c_dim1;
		    i__3 = i__ + i__ * c_dim1;
		    r__1 = c__[i__3].r;
		    q__1.r = r__1, q__1.i = 0.f;
		    c__[i__2].r = q__1.r, c__[i__2].i = q__1.i;
/* L220: */
		}

/*              C := alpha*A*conjg( B' ) + beta*C  and */
/*              C := alpha*B*conjg( A' ) + C, matrix multiply on lower */
/*              vertical blocks of C. */

		if (ii + isec <= *n) {
		    i__1 = *n - ii - isec + 1;
		    cgemm_("N", "C", &i__1, &isec, k, alpha, &a[ii + isec + 
			    a_dim1], lda, &b[ii + b_dim1], ldb, &cbeta, &c__[
			    ii + isec + ii * c_dim1], ldc, (ftnlen)1, (ftnlen)
			    1);
		    i__1 = *n - ii - isec + 1;
		    r_cnjg(&q__1, alpha);
		    cgemm_("N", "C", &i__1, &isec, k, &q__1, &b[ii + isec + 
			    b_dim1], ldb, &a[ii + a_dim1], lda, &c_b1, &c__[
			    ii + isec + ii * c_dim1], ldc, (ftnlen)1, (ftnlen)
			    1);
		}
/* L230: */
	    }
	} else {

/*           Form  C := alpha*conjg( A' )*B + */
/*           alpha*conjg( B' )*A + beta*C. Lower, Trans. */

	    for (ix = *n; ix >= 1; ix += -128) {
/* Computing MAX */
		i__1 = 1, i__2 = ix - 127;
		ii = max(i__1,i__2);
		isec = ix - ii + 1;

/*              T1 := alpha*A*conjg( B' ), matrix multiply on rectangular */
/*              blocks of A and B. T1 is a square block. */

		cgemm_("C", "N", &isec, &isec, k, alpha, &a[ii * a_dim1 + 1], 
			lda, &b[ii * b_dim1 + 1], ldb, &c_b2, t1, &c__128, (
			ftnlen)1, (ftnlen)1);

/*              C :=  beta*C, a lower triangular diagonal block of C is */
/*              updated with beta. */

		if (*beta != 1.f) {
		    i__1 = ii + isec - 1;
		    for (i__ = ii; i__ <= i__1; ++i__) {
			i__2 = ii + isec - i__;
			cscal_(&i__2, &cbeta, &c__[i__ + i__ * c_dim1], &c__1)
				;
/* L240: */
		    }
		}

/*              C := T1 + C, the lower triangular part of T1 is added to */
/*              the lower triangular diagonal block of C. */

		i__1 = ii + isec - 1;
		for (i__ = ii; i__ <= i__1; ++i__) {
		    i__2 = ii + isec - i__;
		    caxpy_(&i__2, &c_b1, &t1[i__ - ii + 1 + (i__ - ii + 1 << 
			    7) - 129], &c__1, &c__[i__ + i__ * c_dim1], &c__1)
			    ;
/* L250: */
		}

/*              C := conjg( T1' ) + C, the conjugated transpose of the */
/*              upper triangular part of T1 is added to the lower */
/*              triangular diagonal block of C. Notice that T1 is */
/*              referenced by row and that the maximum length of a vector */
/*              referenced by CAXPY is CB. */

		i__1 = ii;
		for (jx = ii + isec - 1; jx >= i__1; jx += -64) {
/* Computing MAX */
		    i__2 = ii, i__3 = jx - 63;
		    jj = max(i__2,i__3);
		    jsec = jx - jj + 1;
		    i__2 = jj + jsec - 1;
		    for (i__ = ii; i__ <= i__2; ++i__) {
			i__3 = jj + jsec - 1;
			for (j = max(jj,i__); j <= i__3; ++j) {
			    i__4 = j + i__ * c_dim1;
			    i__5 = j + i__ * c_dim1;
			    r_cnjg(&q__2, &t1[i__ - ii + 1 + (j - ii + 1 << 7)
				     - 129]);
			    q__1.r = c__[i__5].r + q__2.r, q__1.i = c__[i__5]
				    .i + q__2.i;
			    c__[i__4].r = q__1.r, c__[i__4].i = q__1.i;
/* L260: */
			}
/* L270: */
		    }
/* L280: */
		}

/*              Set the imaginary part of diagonal elements of C */
/*              to zero. */

		i__1 = ii + isec - 1;
		for (i__ = ii; i__ <= i__1; ++i__) {
		    i__2 = i__ + i__ * c_dim1;
		    i__3 = i__ + i__ * c_dim1;
		    r__1 = c__[i__3].r;
		    q__1.r = r__1, q__1.i = 0.f;
		    c__[i__2].r = q__1.r, c__[i__2].i = q__1.i;
/* L290: */
		}

/*              C := alpha*conjg( A' )*B + beta*C  and */
/*              C := alpha*conjg( B' )*A + C, matrix multiply on lower */
/*              vertical blocks of C. */

		if (ii + isec <= *n) {
		    i__1 = *n - ii - isec + 1;
		    cgemm_("C", "N", &i__1, &isec, k, alpha, &a[(ii + isec) * 
			    a_dim1 + 1], lda, &b[ii * b_dim1 + 1], ldb, &
			    cbeta, &c__[ii + isec + ii * c_dim1], ldc, (
			    ftnlen)1, (ftnlen)1);
		    i__1 = *n - ii - isec + 1;
		    r_cnjg(&q__1, alpha);
		    cgemm_("C", "N", &i__1, &isec, k, &q__1, &b[(ii + isec) * 
			    b_dim1 + 1], ldb, &a[ii * a_dim1 + 1], lda, &c_b1,
			     &c__[ii + isec + ii * c_dim1], ldc, (ftnlen)1, (
			    ftnlen)1);
		}
/* L300: */
	    }
	}
    }

    return 0;

/*     End of CHER2K. */

} /* cher2k_ */

