/* cgemm.f -- translated by f2c (version 20030320).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

#include "f2cblas.h"

/* Subroutine */ int cgemm_(char *transa, char *transb, integer *m, integer *
	n, integer *k, complex *alpha, complex *a, integer *lda, complex *b, 
	integer *ldb, complex *beta, complex *c__, integer *ldc, ftnlen 
	transa_len, ftnlen transb_len)
{
    /* System generated locals */
    integer a_dim1, a_offset, b_dim1, b_offset, c_dim1, c_offset, i__1, i__2, 
	    i__3, i__4, i__5, i__6, i__7, i__8;
    complex q__1, q__2;

    /* Builtin functions */
    void r_cnjg(complex *, complex *);

    /* Local variables */
    integer i__, j, l;
    complex t1[1024]	/* was [32][32] */, t2[3072]	/* was [32][96] */, 
	    f11, f12, f21, f22, f31, f32, f41, f42, f13, f14;
    integer ii;
    complex f23;
    integer jj;
    complex f24, f33, f34;
    integer ll;
    complex f43, f44;
    integer isec, jsec, lsec, info;
    logical nota, notb;
    complex delta;
    logical conja, conjb;
    
    integer uisec, ujsec, ulsec, nrowa, nrowb;
    

/*     .. Scalar Arguments .. */
/*     .. Array Arguments .. */
/*     .. */

/*  Purpose */
/*  ======= */

/*  CGEMM  performs one of the matrix-matrix operations */

/*     C := alpha*op( A )*op( B ) + beta*C, */

/*  where  op( X ) is one of */

/*     op( X ) = X   or   op( X ) = X', */

/*  alpha and beta are scalars, and A, B and C are matrices, with op( A ) */
/*  an m by k matrix,  op( B )  a  k by n matrix and  C an m by n matrix. */

/*  Parameters */
/*  ========== */

/*  TRANSA - CHARACTER*1. */
/*           On entry, TRANSA specifies the form of op( A ) to be used in */
/*           the matrix multiplication as follows: */

/*              TRANSA = 'N' or 'n',  op( A ) = A. */

/*              TRANSA = 'T' or 't',  op( A ) = A'. */

/*              TRANSA = 'C' or 'c',  op( A ) = A'. */

/*           Unchanged on exit. */

/*  TRANSB - CHARACTER*1. */
/*           On entry, TRANSB specifies the form of op( B ) to be used in */
/*           the matrix multiplication as follows: */

/*              TRANSB = 'N' or 'n',  op( B ) = B. */

/*              TRANSB = 'T' or 't',  op( B ) = B'. */

/*              TRANSB = 'C' or 'c',  op( B ) = B'. */

/*           Unchanged on exit. */

/*  M      - INTEGER. */
/*           On entry,  M  specifies  the number  of rows  of the  matrix */
/*           op( A )  and of the  matrix  C.  M  must  be at least  zero. */
/*           Unchanged on exit. */

/*  N      - INTEGER. */
/*           On entry,  N  specifies the number  of columns of the matrix */
/*           op( B ) and the number of columns of the matrix C. N must be */
/*           at least zero. */
/*           Unchanged on exit. */

/*  K      - INTEGER. */
/*           On entry,  K  specifies  the number of columns of the matrix */
/*           op( A ) and the number of rows of the matrix op( B ). K must */
/*           be at least  zero. */
/*           Unchanged on exit. */

/*  ALPHA  - COMPLEX         . */
/*           On entry, ALPHA specifies the scalar alpha. */
/*           Unchanged on exit. */

/*  A      - COMPLEX          array of DIMENSION ( LDA, ka ), where ka is */
/*           k  when  TRANSA = 'N' or 'n',  and is  m  otherwise. */
/*           Before entry with  TRANSA = 'N' or 'n',  the leading  m by k */
/*           part of the array  A  must contain the matrix  A,  otherwise */
/*           the leading  k by m  part of the array  A  must contain  the */
/*           matrix A. */
/*           Unchanged on exit. */

/*  LDA    - INTEGER. */
/*           On entry, LDA specifies the first dimension of A as declared */
/*           in the calling (sub) program. When  TRANSA = 'N' or 'n' then */
/*           LDA must be at least  max( 1, m ), otherwise  LDA must be at */
/*           least  max( 1, k ). */
/*           Unchanged on exit. */

/*  B      - COMPLEX          array of DIMENSION ( LDB, kb ), where kb is */
/*           n  when  TRANSB = 'N' or 'n',  and is  k  otherwise. */
/*           Before entry with  TRANSB = 'N' or 'n',  the leading  k by n */
/*           part of the array  B  must contain the matrix  B,  otherwise */
/*           the leading  n by k  part of the array  B  must contain  the */
/*           matrix B. */
/*           Unchanged on exit. */

/*  LDB    - INTEGER. */
/*           On entry, LDB specifies the first dimension of B as declared */
/*           in the calling (sub) program. When  TRANSB = 'N' or 'n' then */
/*           LDB must be at least  max( 1, k ), otherwise  LDB must be at */
/*           least  max( 1, n ). */
/*           Unchanged on exit. */

/*  BETA   - COMPLEX         . */
/*           On entry,  BETA  specifies the scalar  beta.  When  BETA  is */
/*           supplied as zero then C need not be set on input. */
/*           Unchanged on exit. */

/*  C      - COMPLEX          array of DIMENSION ( LDC, n ). */
/*           Before entry, the leading  m by n  part of the array  C must */
/*           contain the matrix  C,  except when  beta  is zero, in which */
/*           case C need not be set on entry. */
/*           On exit, the array  C  is overwritten by the  m by n  matrix */
/*           ( alpha*op( A )*op( B ) + beta*C ). */

/*  LDC    - INTEGER. */
/*           On entry, LDC specifies the first dimension of C as declared */
/*           in  the  calling  (sub)  program.   LDC  must  be  at  least */
/*           max( 1, m ). */
/*           Unchanged on exit. */


/*  Level 3 Blas routine. */

/*  -- Written on 8-February-1989. */
/*     Jack Dongarra, Argonne National Laboratory. */
/*     Iain Duff, AERE Harwell. */
/*     Jeremy Du Croz, Numerical Algorithms Group Ltd. */
/*     Sven Hammarling, Numerical Algorithms Group Ltd. */

/*  -- Modified in October-1997. */
/*     Superscalar GEMM-Based Level 3 BLAS (Version 0.1). */
/*     Per Ling, Department of Computing Science, */
/*     Umea University, Sweden. */


/*     .. Local Scalars .. */
/*     .. Intrinsic Functions .. */
/*     .. External Functions .. */
/*     .. External Subroutines .. */
/*     .. Parameters .. */
/*     .. User specified parameters for CGEMM .. */
/*     .. */
/*     .. Executable Statements .. */

/*     Set  NOTA  and  NOTB  as  true if  A  and  B  respectively are not */
/*     transposed and set NROWA and NROWB as the number of rows of A  and */
/*     the number of rows of B respectively. */

    /* Parameter adjustments */
    a_dim1 = *lda;
    a_offset = 1 + a_dim1;
    a -= a_offset;
    b_dim1 = *ldb;
    b_offset = 1 + b_dim1;
    b -= b_offset;
    c_dim1 = *ldc;
    c_offset = 1 + c_dim1;
    c__ -= c_offset;

    /* Function Body */
    nota = (transa[0]=='N'?1:0);
    notb = (transb[0]=='N'?1:0);
    conja = (transa[0]=='C'?1:0);
    conjb = (transb[0]=='C'?1:0);
    if (nota) {
	nrowa = *m;
    } else {
	nrowa = *k;
    }
    if (notb) {
	nrowb = *k;
    } else {
	nrowb = *n;
    }

/*     Test the input parameters. */

    info = 0;
    if (! nota && ! (transa[0]=='C'?1:0) && ! (transa[0]=='T'?1:0)) {
	info = 1;
    } else if (! notb && ! (transb[0]=='C'?1:0) && ! 
	    (transb[0]=='T'?1:0)) {
	info = 2;
    } else if (*m < 0) {
	info = 3;
    } else if (*n < 0) {
	info = 4;
    } else if (*k < 0) {
	info = 5;
    } else if (*lda < max(1,nrowa)) {
	info = 8;
    } else if (*ldb < max(1,nrowb)) {
	info = 10;
    } else if (*ldc < max(1,*m)) {
	info = 13;
    }
    if (info != 0) {
	xerbla_("CGEMM ", &info, (ftnlen)6);
	return 0;
    }

/*     Quick return if possible. */

    if (*m == 0 || *n == 0 || (alpha->r == 0.f && alpha->i == 0.f || *k == 0) 
	    && (beta->r == 1.f && beta->i == 0.f)) {
	return 0;
    }

/*     And when alpha.eq.zero. */

    if (alpha->r == 0.f && alpha->i == 0.f || *k == 0) {
	if (beta->r == 0.f && beta->i == 0.f) {
	    uisec = *m - *m % 4;
	    i__1 = *n;
	    for (j = 1; j <= i__1; ++j) {
		i__2 = uisec;
		for (i__ = 1; i__ <= i__2; i__ += 4) {
		    i__3 = i__ + j * c_dim1;
		    c__[i__3].r = 0.f, c__[i__3].i = 0.f;
		    i__3 = i__ + 1 + j * c_dim1;
		    c__[i__3].r = 0.f, c__[i__3].i = 0.f;
		    i__3 = i__ + 2 + j * c_dim1;
		    c__[i__3].r = 0.f, c__[i__3].i = 0.f;
		    i__3 = i__ + 3 + j * c_dim1;
		    c__[i__3].r = 0.f, c__[i__3].i = 0.f;
/* L10: */
		}
		i__2 = *m;
		for (i__ = uisec + 1; i__ <= i__2; ++i__) {
		    i__3 = i__ + j * c_dim1;
		    c__[i__3].r = 0.f, c__[i__3].i = 0.f;
/* L20: */
		}
/* L30: */
	    }
	} else {
	    uisec = *m - *m % 4;
	    i__1 = *n;
	    for (j = 1; j <= i__1; ++j) {
		i__2 = uisec;
		for (i__ = 1; i__ <= i__2; i__ += 4) {
		    i__3 = i__ + j * c_dim1;
		    i__4 = i__ + j * c_dim1;
		    q__1.r = beta->r * c__[i__4].r - beta->i * c__[i__4].i, 
			    q__1.i = beta->r * c__[i__4].i + beta->i * c__[
			    i__4].r;
		    c__[i__3].r = q__1.r, c__[i__3].i = q__1.i;
		    i__3 = i__ + 1 + j * c_dim1;
		    i__4 = i__ + 1 + j * c_dim1;
		    q__1.r = beta->r * c__[i__4].r - beta->i * c__[i__4].i, 
			    q__1.i = beta->r * c__[i__4].i + beta->i * c__[
			    i__4].r;
		    c__[i__3].r = q__1.r, c__[i__3].i = q__1.i;
		    i__3 = i__ + 2 + j * c_dim1;
		    i__4 = i__ + 2 + j * c_dim1;
		    q__1.r = beta->r * c__[i__4].r - beta->i * c__[i__4].i, 
			    q__1.i = beta->r * c__[i__4].i + beta->i * c__[
			    i__4].r;
		    c__[i__3].r = q__1.r, c__[i__3].i = q__1.i;
		    i__3 = i__ + 3 + j * c_dim1;
		    i__4 = i__ + 3 + j * c_dim1;
		    q__1.r = beta->r * c__[i__4].r - beta->i * c__[i__4].i, 
			    q__1.i = beta->r * c__[i__4].i + beta->i * c__[
			    i__4].r;
		    c__[i__3].r = q__1.r, c__[i__3].i = q__1.i;
/* L40: */
		}
		i__2 = *m;
		for (i__ = uisec + 1; i__ <= i__2; ++i__) {
		    i__3 = i__ + j * c_dim1;
		    i__4 = i__ + j * c_dim1;
		    q__1.r = beta->r * c__[i__4].r - beta->i * c__[i__4].i, 
			    q__1.i = beta->r * c__[i__4].i + beta->i * c__[
			    i__4].r;
		    c__[i__3].r = q__1.r, c__[i__3].i = q__1.i;
/* L50: */
		}
/* L60: */
	    }
	}
	return 0;
    }

/*     Start the operations. */

    if (notb) {

/*        Form  C := alpha*A*B + beta*C or C := alpha*A'*B + beta*C. */
/*        or C := alpha*conj(A')*B + beta*C */

	i__1 = *n;
	for (jj = 1; jj <= i__1; jj += 1024) {
/* Computing MIN */
	    i__2 = 1024, i__3 = *n - jj + 1;
	    jsec = min(i__2,i__3);
	    ujsec = jsec - jsec % 4;
	    i__2 = *k;
	    for (ll = 1; ll <= i__2; ll += 32) {
/* Computing MIN */
		i__3 = 32, i__4 = *k - ll + 1;
		lsec = min(i__3,i__4);
		ulsec = lsec - lsec % 2;

/*              Determine if the block of C should be updated with */
/*              beta or not. */

		delta.r = 1.f, delta.i = 0.f;
		if (ll == 1) {
		    delta.r = beta->r, delta.i = beta->i;
		}

		i__3 = *m;
		for (ii = 1; ii <= i__3; ii += 32) {
/* Computing MIN */
		    i__4 = 32, i__5 = *m - ii + 1;
		    isec = min(i__4,i__5);

/*                 T1 := alpha*A' or T1 := alpha*A, copy the transpose */
/*                 or the non-transpose of a rectangular block of */
/*                 alpha*A to T1. */

		    uisec = isec - isec % 2;
		    if (nota) {
			i__4 = ll + ulsec - 1;
			for (l = ll; l <= i__4; l += 2) {
			    i__5 = ii + uisec - 1;
			    for (i__ = ii; i__ <= i__5; i__ += 2) {
				i__6 = l - ll + 1 + (i__ - ii + 1 << 5) - 33;
				i__7 = i__ + l * a_dim1;
				q__1.r = alpha->r * a[i__7].r - alpha->i * a[
					i__7].i, q__1.i = alpha->r * a[i__7]
					.i + alpha->i * a[i__7].r;
				t1[i__6].r = q__1.r, t1[i__6].i = q__1.i;
				i__6 = l - ll + 2 + (i__ - ii + 1 << 5) - 33;
				i__7 = i__ + (l + 1) * a_dim1;
				q__1.r = alpha->r * a[i__7].r - alpha->i * a[
					i__7].i, q__1.i = alpha->r * a[i__7]
					.i + alpha->i * a[i__7].r;
				t1[i__6].r = q__1.r, t1[i__6].i = q__1.i;
				i__6 = l - ll + 1 + (i__ - ii + 2 << 5) - 33;
				i__7 = i__ + 1 + l * a_dim1;
				q__1.r = alpha->r * a[i__7].r - alpha->i * a[
					i__7].i, q__1.i = alpha->r * a[i__7]
					.i + alpha->i * a[i__7].r;
				t1[i__6].r = q__1.r, t1[i__6].i = q__1.i;
				i__6 = l - ll + 2 + (i__ - ii + 2 << 5) - 33;
				i__7 = i__ + 1 + (l + 1) * a_dim1;
				q__1.r = alpha->r * a[i__7].r - alpha->i * a[
					i__7].i, q__1.i = alpha->r * a[i__7]
					.i + alpha->i * a[i__7].r;
				t1[i__6].r = q__1.r, t1[i__6].i = q__1.i;
/* L70: */
			    }
			    if (uisec < isec) {
				i__5 = l - ll + 1 + (isec << 5) - 33;
				i__6 = ii + isec - 1 + l * a_dim1;
				q__1.r = alpha->r * a[i__6].r - alpha->i * a[
					i__6].i, q__1.i = alpha->r * a[i__6]
					.i + alpha->i * a[i__6].r;
				t1[i__5].r = q__1.r, t1[i__5].i = q__1.i;
				i__5 = l - ll + 2 + (isec << 5) - 33;
				i__6 = ii + isec - 1 + (l + 1) * a_dim1;
				q__1.r = alpha->r * a[i__6].r - alpha->i * a[
					i__6].i, q__1.i = alpha->r * a[i__6]
					.i + alpha->i * a[i__6].r;
				t1[i__5].r = q__1.r, t1[i__5].i = q__1.i;
			    }
/* L80: */
			}
			if (ulsec < lsec) {
			    i__4 = ii + isec - 1;
			    for (i__ = ii; i__ <= i__4; ++i__) {
				i__5 = lsec + (i__ - ii + 1 << 5) - 33;
				i__6 = i__ + (ll + lsec - 1) * a_dim1;
				q__1.r = alpha->r * a[i__6].r - alpha->i * a[
					i__6].i, q__1.i = alpha->r * a[i__6]
					.i + alpha->i * a[i__6].r;
				t1[i__5].r = q__1.r, t1[i__5].i = q__1.i;
/* L90: */
			    }
			}
		    } else if (conja) {
			i__4 = ii + uisec - 1;
			for (i__ = ii; i__ <= i__4; i__ += 2) {
			    i__5 = ll + ulsec - 1;
			    for (l = ll; l <= i__5; l += 2) {
				i__6 = l - ll + 1 + (i__ - ii + 1 << 5) - 33;
				r_cnjg(&q__2, &a[l + i__ * a_dim1]);
				q__1.r = alpha->r * q__2.r - alpha->i * 
					q__2.i, q__1.i = alpha->r * q__2.i + 
					alpha->i * q__2.r;
				t1[i__6].r = q__1.r, t1[i__6].i = q__1.i;
				i__6 = l - ll + 1 + (i__ - ii + 2 << 5) - 33;
				r_cnjg(&q__2, &a[l + (i__ + 1) * a_dim1]);
				q__1.r = alpha->r * q__2.r - alpha->i * 
					q__2.i, q__1.i = alpha->r * q__2.i + 
					alpha->i * q__2.r;
				t1[i__6].r = q__1.r, t1[i__6].i = q__1.i;
				i__6 = l - ll + 2 + (i__ - ii + 1 << 5) - 33;
				r_cnjg(&q__2, &a[l + 1 + i__ * a_dim1]);
				q__1.r = alpha->r * q__2.r - alpha->i * 
					q__2.i, q__1.i = alpha->r * q__2.i + 
					alpha->i * q__2.r;
				t1[i__6].r = q__1.r, t1[i__6].i = q__1.i;
				i__6 = l - ll + 2 + (i__ - ii + 2 << 5) - 33;
				r_cnjg(&q__2, &a[l + 1 + (i__ + 1) * a_dim1]);
				q__1.r = alpha->r * q__2.r - alpha->i * 
					q__2.i, q__1.i = alpha->r * q__2.i + 
					alpha->i * q__2.r;
				t1[i__6].r = q__1.r, t1[i__6].i = q__1.i;
/* L500: */
			    }
			    if (ulsec < lsec) {
				i__5 = lsec + (i__ - ii + 1 << 5) - 33;
				r_cnjg(&q__2, &a[ll + lsec - 1 + i__ * a_dim1]
					);
				q__1.r = alpha->r * q__2.r - alpha->i * 
					q__2.i, q__1.i = alpha->r * q__2.i + 
					alpha->i * q__2.r;
				t1[i__5].r = q__1.r, t1[i__5].i = q__1.i;
				i__5 = lsec + (i__ - ii + 2 << 5) - 33;
				r_cnjg(&q__2, &a[ll + lsec - 1 + (i__ + 1) * 
					a_dim1]);
				q__1.r = alpha->r * q__2.r - alpha->i * 
					q__2.i, q__1.i = alpha->r * q__2.i + 
					alpha->i * q__2.r;
				t1[i__5].r = q__1.r, t1[i__5].i = q__1.i;
			    }
/* L510: */
			}
			if (uisec < isec) {
			    i__4 = ll + lsec - 1;
			    for (l = ll; l <= i__4; ++l) {
				i__5 = l - ll + 1 + (isec << 5) - 33;
				r_cnjg(&q__2, &a[l + (ii + isec - 1) * a_dim1]
					);
				q__1.r = alpha->r * q__2.r - alpha->i * 
					q__2.i, q__1.i = alpha->r * q__2.i + 
					alpha->i * q__2.r;
				t1[i__5].r = q__1.r, t1[i__5].i = q__1.i;
/* L520: */
			    }
			}
		    } else {
			i__4 = ii + uisec - 1;
			for (i__ = ii; i__ <= i__4; i__ += 2) {
			    i__5 = ll + ulsec - 1;
			    for (l = ll; l <= i__5; l += 2) {
				i__6 = l - ll + 1 + (i__ - ii + 1 << 5) - 33;
				i__7 = l + i__ * a_dim1;
				q__1.r = alpha->r * a[i__7].r - alpha->i * a[
					i__7].i, q__1.i = alpha->r * a[i__7]
					.i + alpha->i * a[i__7].r;
				t1[i__6].r = q__1.r, t1[i__6].i = q__1.i;
				i__6 = l - ll + 1 + (i__ - ii + 2 << 5) - 33;
				i__7 = l + (i__ + 1) * a_dim1;
				q__1.r = alpha->r * a[i__7].r - alpha->i * a[
					i__7].i, q__1.i = alpha->r * a[i__7]
					.i + alpha->i * a[i__7].r;
				t1[i__6].r = q__1.r, t1[i__6].i = q__1.i;
				i__6 = l - ll + 2 + (i__ - ii + 1 << 5) - 33;
				i__7 = l + 1 + i__ * a_dim1;
				q__1.r = alpha->r * a[i__7].r - alpha->i * a[
					i__7].i, q__1.i = alpha->r * a[i__7]
					.i + alpha->i * a[i__7].r;
				t1[i__6].r = q__1.r, t1[i__6].i = q__1.i;
				i__6 = l - ll + 2 + (i__ - ii + 2 << 5) - 33;
				i__7 = l + 1 + (i__ + 1) * a_dim1;
				q__1.r = alpha->r * a[i__7].r - alpha->i * a[
					i__7].i, q__1.i = alpha->r * a[i__7]
					.i + alpha->i * a[i__7].r;
				t1[i__6].r = q__1.r, t1[i__6].i = q__1.i;
/* L100: */
			    }
			    if (ulsec < lsec) {
				i__5 = lsec + (i__ - ii + 1 << 5) - 33;
				i__6 = ll + lsec - 1 + i__ * a_dim1;
				q__1.r = alpha->r * a[i__6].r - alpha->i * a[
					i__6].i, q__1.i = alpha->r * a[i__6]
					.i + alpha->i * a[i__6].r;
				t1[i__5].r = q__1.r, t1[i__5].i = q__1.i;
				i__5 = lsec + (i__ - ii + 2 << 5) - 33;
				i__6 = ll + lsec - 1 + (i__ + 1) * a_dim1;
				q__1.r = alpha->r * a[i__6].r - alpha->i * a[
					i__6].i, q__1.i = alpha->r * a[i__6]
					.i + alpha->i * a[i__6].r;
				t1[i__5].r = q__1.r, t1[i__5].i = q__1.i;
			    }
/* L110: */
			}
			if (uisec < isec) {
			    i__4 = ll + lsec - 1;
			    for (l = ll; l <= i__4; ++l) {
				i__5 = l - ll + 1 + (isec << 5) - 33;
				i__6 = l + (ii + isec - 1) * a_dim1;
				q__1.r = alpha->r * a[i__6].r - alpha->i * a[
					i__6].i, q__1.i = alpha->r * a[i__6]
					.i + alpha->i * a[i__6].r;
				t1[i__5].r = q__1.r, t1[i__5].i = q__1.i;
/* L120: */
			    }
			}
		    }

/*                 C := T1'*B + beta*C, update a rectangular block */
/*                 of C using 4 by 4 unrolling. */

		    uisec = isec - isec % 4;
		    i__4 = jj + ujsec - 1;
		    for (j = jj; j <= i__4; j += 4) {
			i__5 = ii + uisec - 1;
			for (i__ = ii; i__ <= i__5; i__ += 4) {
			    i__6 = i__ + j * c_dim1;
			    q__1.r = delta.r * c__[i__6].r - delta.i * c__[
				    i__6].i, q__1.i = delta.r * c__[i__6].i + 
				    delta.i * c__[i__6].r;
			    f11.r = q__1.r, f11.i = q__1.i;
			    i__6 = i__ + 1 + j * c_dim1;
			    q__1.r = delta.r * c__[i__6].r - delta.i * c__[
				    i__6].i, q__1.i = delta.r * c__[i__6].i + 
				    delta.i * c__[i__6].r;
			    f21.r = q__1.r, f21.i = q__1.i;
			    i__6 = i__ + (j + 1) * c_dim1;
			    q__1.r = delta.r * c__[i__6].r - delta.i * c__[
				    i__6].i, q__1.i = delta.r * c__[i__6].i + 
				    delta.i * c__[i__6].r;
			    f12.r = q__1.r, f12.i = q__1.i;
			    i__6 = i__ + 1 + (j + 1) * c_dim1;
			    q__1.r = delta.r * c__[i__6].r - delta.i * c__[
				    i__6].i, q__1.i = delta.r * c__[i__6].i + 
				    delta.i * c__[i__6].r;
			    f22.r = q__1.r, f22.i = q__1.i;
			    i__6 = i__ + (j + 2) * c_dim1;
			    q__1.r = delta.r * c__[i__6].r - delta.i * c__[
				    i__6].i, q__1.i = delta.r * c__[i__6].i + 
				    delta.i * c__[i__6].r;
			    f13.r = q__1.r, f13.i = q__1.i;
			    i__6 = i__ + 1 + (j + 2) * c_dim1;
			    q__1.r = delta.r * c__[i__6].r - delta.i * c__[
				    i__6].i, q__1.i = delta.r * c__[i__6].i + 
				    delta.i * c__[i__6].r;
			    f23.r = q__1.r, f23.i = q__1.i;
			    i__6 = i__ + (j + 3) * c_dim1;
			    q__1.r = delta.r * c__[i__6].r - delta.i * c__[
				    i__6].i, q__1.i = delta.r * c__[i__6].i + 
				    delta.i * c__[i__6].r;
			    f14.r = q__1.r, f14.i = q__1.i;
			    i__6 = i__ + 1 + (j + 3) * c_dim1;
			    q__1.r = delta.r * c__[i__6].r - delta.i * c__[
				    i__6].i, q__1.i = delta.r * c__[i__6].i + 
				    delta.i * c__[i__6].r;
			    f24.r = q__1.r, f24.i = q__1.i;
			    i__6 = i__ + 2 + j * c_dim1;
			    q__1.r = delta.r * c__[i__6].r - delta.i * c__[
				    i__6].i, q__1.i = delta.r * c__[i__6].i + 
				    delta.i * c__[i__6].r;
			    f31.r = q__1.r, f31.i = q__1.i;
			    i__6 = i__ + 3 + j * c_dim1;
			    q__1.r = delta.r * c__[i__6].r - delta.i * c__[
				    i__6].i, q__1.i = delta.r * c__[i__6].i + 
				    delta.i * c__[i__6].r;
			    f41.r = q__1.r, f41.i = q__1.i;
			    i__6 = i__ + 2 + (j + 1) * c_dim1;
			    q__1.r = delta.r * c__[i__6].r - delta.i * c__[
				    i__6].i, q__1.i = delta.r * c__[i__6].i + 
				    delta.i * c__[i__6].r;
			    f32.r = q__1.r, f32.i = q__1.i;
			    i__6 = i__ + 3 + (j + 1) * c_dim1;
			    q__1.r = delta.r * c__[i__6].r - delta.i * c__[
				    i__6].i, q__1.i = delta.r * c__[i__6].i + 
				    delta.i * c__[i__6].r;
			    f42.r = q__1.r, f42.i = q__1.i;
			    i__6 = i__ + 2 + (j + 2) * c_dim1;
			    q__1.r = delta.r * c__[i__6].r - delta.i * c__[
				    i__6].i, q__1.i = delta.r * c__[i__6].i + 
				    delta.i * c__[i__6].r;
			    f33.r = q__1.r, f33.i = q__1.i;
			    i__6 = i__ + 3 + (j + 2) * c_dim1;
			    q__1.r = delta.r * c__[i__6].r - delta.i * c__[
				    i__6].i, q__1.i = delta.r * c__[i__6].i + 
				    delta.i * c__[i__6].r;
			    f43.r = q__1.r, f43.i = q__1.i;
			    i__6 = i__ + 2 + (j + 3) * c_dim1;
			    q__1.r = delta.r * c__[i__6].r - delta.i * c__[
				    i__6].i, q__1.i = delta.r * c__[i__6].i + 
				    delta.i * c__[i__6].r;
			    f34.r = q__1.r, f34.i = q__1.i;
			    i__6 = i__ + 3 + (j + 3) * c_dim1;
			    q__1.r = delta.r * c__[i__6].r - delta.i * c__[
				    i__6].i, q__1.i = delta.r * c__[i__6].i + 
				    delta.i * c__[i__6].r;
			    f44.r = q__1.r, f44.i = q__1.i;
			    i__6 = ll + lsec - 1;
			    for (l = ll; l <= i__6; ++l) {
				i__7 = l - ll + 1 + (i__ - ii + 1 << 5) - 33;
				i__8 = l + j * b_dim1;
				q__2.r = t1[i__7].r * b[i__8].r - t1[i__7].i *
					 b[i__8].i, q__2.i = t1[i__7].r * b[
					i__8].i + t1[i__7].i * b[i__8].r;
				q__1.r = f11.r + q__2.r, q__1.i = f11.i + 
					q__2.i;
				f11.r = q__1.r, f11.i = q__1.i;
				i__7 = l - ll + 1 + (i__ - ii + 2 << 5) - 33;
				i__8 = l + j * b_dim1;
				q__2.r = t1[i__7].r * b[i__8].r - t1[i__7].i *
					 b[i__8].i, q__2.i = t1[i__7].r * b[
					i__8].i + t1[i__7].i * b[i__8].r;
				q__1.r = f21.r + q__2.r, q__1.i = f21.i + 
					q__2.i;
				f21.r = q__1.r, f21.i = q__1.i;
				i__7 = l - ll + 1 + (i__ - ii + 1 << 5) - 33;
				i__8 = l + (j + 1) * b_dim1;
				q__2.r = t1[i__7].r * b[i__8].r - t1[i__7].i *
					 b[i__8].i, q__2.i = t1[i__7].r * b[
					i__8].i + t1[i__7].i * b[i__8].r;
				q__1.r = f12.r + q__2.r, q__1.i = f12.i + 
					q__2.i;
				f12.r = q__1.r, f12.i = q__1.i;
				i__7 = l - ll + 1 + (i__ - ii + 2 << 5) - 33;
				i__8 = l + (j + 1) * b_dim1;
				q__2.r = t1[i__7].r * b[i__8].r - t1[i__7].i *
					 b[i__8].i, q__2.i = t1[i__7].r * b[
					i__8].i + t1[i__7].i * b[i__8].r;
				q__1.r = f22.r + q__2.r, q__1.i = f22.i + 
					q__2.i;
				f22.r = q__1.r, f22.i = q__1.i;
				i__7 = l - ll + 1 + (i__ - ii + 1 << 5) - 33;
				i__8 = l + (j + 2) * b_dim1;
				q__2.r = t1[i__7].r * b[i__8].r - t1[i__7].i *
					 b[i__8].i, q__2.i = t1[i__7].r * b[
					i__8].i + t1[i__7].i * b[i__8].r;
				q__1.r = f13.r + q__2.r, q__1.i = f13.i + 
					q__2.i;
				f13.r = q__1.r, f13.i = q__1.i;
				i__7 = l - ll + 1 + (i__ - ii + 2 << 5) - 33;
				i__8 = l + (j + 2) * b_dim1;
				q__2.r = t1[i__7].r * b[i__8].r - t1[i__7].i *
					 b[i__8].i, q__2.i = t1[i__7].r * b[
					i__8].i + t1[i__7].i * b[i__8].r;
				q__1.r = f23.r + q__2.r, q__1.i = f23.i + 
					q__2.i;
				f23.r = q__1.r, f23.i = q__1.i;
				i__7 = l - ll + 1 + (i__ - ii + 1 << 5) - 33;
				i__8 = l + (j + 3) * b_dim1;
				q__2.r = t1[i__7].r * b[i__8].r - t1[i__7].i *
					 b[i__8].i, q__2.i = t1[i__7].r * b[
					i__8].i + t1[i__7].i * b[i__8].r;
				q__1.r = f14.r + q__2.r, q__1.i = f14.i + 
					q__2.i;
				f14.r = q__1.r, f14.i = q__1.i;
				i__7 = l - ll + 1 + (i__ - ii + 2 << 5) - 33;
				i__8 = l + (j + 3) * b_dim1;
				q__2.r = t1[i__7].r * b[i__8].r - t1[i__7].i *
					 b[i__8].i, q__2.i = t1[i__7].r * b[
					i__8].i + t1[i__7].i * b[i__8].r;
				q__1.r = f24.r + q__2.r, q__1.i = f24.i + 
					q__2.i;
				f24.r = q__1.r, f24.i = q__1.i;
				i__7 = l - ll + 1 + (i__ - ii + 3 << 5) - 33;
				i__8 = l + j * b_dim1;
				q__2.r = t1[i__7].r * b[i__8].r - t1[i__7].i *
					 b[i__8].i, q__2.i = t1[i__7].r * b[
					i__8].i + t1[i__7].i * b[i__8].r;
				q__1.r = f31.r + q__2.r, q__1.i = f31.i + 
					q__2.i;
				f31.r = q__1.r, f31.i = q__1.i;
				i__7 = l - ll + 1 + (i__ - ii + 4 << 5) - 33;
				i__8 = l + j * b_dim1;
				q__2.r = t1[i__7].r * b[i__8].r - t1[i__7].i *
					 b[i__8].i, q__2.i = t1[i__7].r * b[
					i__8].i + t1[i__7].i * b[i__8].r;
				q__1.r = f41.r + q__2.r, q__1.i = f41.i + 
					q__2.i;
				f41.r = q__1.r, f41.i = q__1.i;
				i__7 = l - ll + 1 + (i__ - ii + 3 << 5) - 33;
				i__8 = l + (j + 1) * b_dim1;
				q__2.r = t1[i__7].r * b[i__8].r - t1[i__7].i *
					 b[i__8].i, q__2.i = t1[i__7].r * b[
					i__8].i + t1[i__7].i * b[i__8].r;
				q__1.r = f32.r + q__2.r, q__1.i = f32.i + 
					q__2.i;
				f32.r = q__1.r, f32.i = q__1.i;
				i__7 = l - ll + 1 + (i__ - ii + 4 << 5) - 33;
				i__8 = l + (j + 1) * b_dim1;
				q__2.r = t1[i__7].r * b[i__8].r - t1[i__7].i *
					 b[i__8].i, q__2.i = t1[i__7].r * b[
					i__8].i + t1[i__7].i * b[i__8].r;
				q__1.r = f42.r + q__2.r, q__1.i = f42.i + 
					q__2.i;
				f42.r = q__1.r, f42.i = q__1.i;
				i__7 = l - ll + 1 + (i__ - ii + 3 << 5) - 33;
				i__8 = l + (j + 2) * b_dim1;
				q__2.r = t1[i__7].r * b[i__8].r - t1[i__7].i *
					 b[i__8].i, q__2.i = t1[i__7].r * b[
					i__8].i + t1[i__7].i * b[i__8].r;
				q__1.r = f33.r + q__2.r, q__1.i = f33.i + 
					q__2.i;
				f33.r = q__1.r, f33.i = q__1.i;
				i__7 = l - ll + 1 + (i__ - ii + 4 << 5) - 33;
				i__8 = l + (j + 2) * b_dim1;
				q__2.r = t1[i__7].r * b[i__8].r - t1[i__7].i *
					 b[i__8].i, q__2.i = t1[i__7].r * b[
					i__8].i + t1[i__7].i * b[i__8].r;
				q__1.r = f43.r + q__2.r, q__1.i = f43.i + 
					q__2.i;
				f43.r = q__1.r, f43.i = q__1.i;
				i__7 = l - ll + 1 + (i__ - ii + 3 << 5) - 33;
				i__8 = l + (j + 3) * b_dim1;
				q__2.r = t1[i__7].r * b[i__8].r - t1[i__7].i *
					 b[i__8].i, q__2.i = t1[i__7].r * b[
					i__8].i + t1[i__7].i * b[i__8].r;
				q__1.r = f34.r + q__2.r, q__1.i = f34.i + 
					q__2.i;
				f34.r = q__1.r, f34.i = q__1.i;
				i__7 = l - ll + 1 + (i__ - ii + 4 << 5) - 33;
				i__8 = l + (j + 3) * b_dim1;
				q__2.r = t1[i__7].r * b[i__8].r - t1[i__7].i *
					 b[i__8].i, q__2.i = t1[i__7].r * b[
					i__8].i + t1[i__7].i * b[i__8].r;
				q__1.r = f44.r + q__2.r, q__1.i = f44.i + 
					q__2.i;
				f44.r = q__1.r, f44.i = q__1.i;
/* L130: */
			    }
			    i__6 = i__ + j * c_dim1;
			    c__[i__6].r = f11.r, c__[i__6].i = f11.i;
			    i__6 = i__ + 1 + j * c_dim1;
			    c__[i__6].r = f21.r, c__[i__6].i = f21.i;
			    i__6 = i__ + (j + 1) * c_dim1;
			    c__[i__6].r = f12.r, c__[i__6].i = f12.i;
			    i__6 = i__ + 1 + (j + 1) * c_dim1;
			    c__[i__6].r = f22.r, c__[i__6].i = f22.i;
			    i__6 = i__ + (j + 2) * c_dim1;
			    c__[i__6].r = f13.r, c__[i__6].i = f13.i;
			    i__6 = i__ + 1 + (j + 2) * c_dim1;
			    c__[i__6].r = f23.r, c__[i__6].i = f23.i;
			    i__6 = i__ + (j + 3) * c_dim1;
			    c__[i__6].r = f14.r, c__[i__6].i = f14.i;
			    i__6 = i__ + 1 + (j + 3) * c_dim1;
			    c__[i__6].r = f24.r, c__[i__6].i = f24.i;
			    i__6 = i__ + 2 + j * c_dim1;
			    c__[i__6].r = f31.r, c__[i__6].i = f31.i;
			    i__6 = i__ + 3 + j * c_dim1;
			    c__[i__6].r = f41.r, c__[i__6].i = f41.i;
			    i__6 = i__ + 2 + (j + 1) * c_dim1;
			    c__[i__6].r = f32.r, c__[i__6].i = f32.i;
			    i__6 = i__ + 3 + (j + 1) * c_dim1;
			    c__[i__6].r = f42.r, c__[i__6].i = f42.i;
			    i__6 = i__ + 2 + (j + 2) * c_dim1;
			    c__[i__6].r = f33.r, c__[i__6].i = f33.i;
			    i__6 = i__ + 3 + (j + 2) * c_dim1;
			    c__[i__6].r = f43.r, c__[i__6].i = f43.i;
			    i__6 = i__ + 2 + (j + 3) * c_dim1;
			    c__[i__6].r = f34.r, c__[i__6].i = f34.i;
			    i__6 = i__ + 3 + (j + 3) * c_dim1;
			    c__[i__6].r = f44.r, c__[i__6].i = f44.i;
/* L140: */
			}
			if (uisec < isec) {
			    i__5 = ii + isec - 1;
			    for (i__ = ii + uisec; i__ <= i__5; ++i__) {
				i__6 = i__ + j * c_dim1;
				q__1.r = delta.r * c__[i__6].r - delta.i * 
					c__[i__6].i, q__1.i = delta.r * c__[
					i__6].i + delta.i * c__[i__6].r;
				f11.r = q__1.r, f11.i = q__1.i;
				i__6 = i__ + (j + 1) * c_dim1;
				q__1.r = delta.r * c__[i__6].r - delta.i * 
					c__[i__6].i, q__1.i = delta.r * c__[
					i__6].i + delta.i * c__[i__6].r;
				f12.r = q__1.r, f12.i = q__1.i;
				i__6 = i__ + (j + 2) * c_dim1;
				q__1.r = delta.r * c__[i__6].r - delta.i * 
					c__[i__6].i, q__1.i = delta.r * c__[
					i__6].i + delta.i * c__[i__6].r;
				f13.r = q__1.r, f13.i = q__1.i;
				i__6 = i__ + (j + 3) * c_dim1;
				q__1.r = delta.r * c__[i__6].r - delta.i * 
					c__[i__6].i, q__1.i = delta.r * c__[
					i__6].i + delta.i * c__[i__6].r;
				f14.r = q__1.r, f14.i = q__1.i;
				i__6 = ll + lsec - 1;
				for (l = ll; l <= i__6; ++l) {
				    i__7 = l - ll + 1 + (i__ - ii + 1 << 5) - 
					    33;
				    i__8 = l + j * b_dim1;
				    q__2.r = t1[i__7].r * b[i__8].r - t1[i__7]
					    .i * b[i__8].i, q__2.i = t1[i__7]
					    .r * b[i__8].i + t1[i__7].i * b[
					    i__8].r;
				    q__1.r = f11.r + q__2.r, q__1.i = f11.i + 
					    q__2.i;
				    f11.r = q__1.r, f11.i = q__1.i;
				    i__7 = l - ll + 1 + (i__ - ii + 1 << 5) - 
					    33;
				    i__8 = l + (j + 1) * b_dim1;
				    q__2.r = t1[i__7].r * b[i__8].r - t1[i__7]
					    .i * b[i__8].i, q__2.i = t1[i__7]
					    .r * b[i__8].i + t1[i__7].i * b[
					    i__8].r;
				    q__1.r = f12.r + q__2.r, q__1.i = f12.i + 
					    q__2.i;
				    f12.r = q__1.r, f12.i = q__1.i;
				    i__7 = l - ll + 1 + (i__ - ii + 1 << 5) - 
					    33;
				    i__8 = l + (j + 2) * b_dim1;
				    q__2.r = t1[i__7].r * b[i__8].r - t1[i__7]
					    .i * b[i__8].i, q__2.i = t1[i__7]
					    .r * b[i__8].i + t1[i__7].i * b[
					    i__8].r;
				    q__1.r = f13.r + q__2.r, q__1.i = f13.i + 
					    q__2.i;
				    f13.r = q__1.r, f13.i = q__1.i;
				    i__7 = l - ll + 1 + (i__ - ii + 1 << 5) - 
					    33;
				    i__8 = l + (j + 3) * b_dim1;
				    q__2.r = t1[i__7].r * b[i__8].r - t1[i__7]
					    .i * b[i__8].i, q__2.i = t1[i__7]
					    .r * b[i__8].i + t1[i__7].i * b[
					    i__8].r;
				    q__1.r = f14.r + q__2.r, q__1.i = f14.i + 
					    q__2.i;
				    f14.r = q__1.r, f14.i = q__1.i;
/* L150: */
				}
				i__6 = i__ + j * c_dim1;
				c__[i__6].r = f11.r, c__[i__6].i = f11.i;
				i__6 = i__ + (j + 1) * c_dim1;
				c__[i__6].r = f12.r, c__[i__6].i = f12.i;
				i__6 = i__ + (j + 2) * c_dim1;
				c__[i__6].r = f13.r, c__[i__6].i = f13.i;
				i__6 = i__ + (j + 3) * c_dim1;
				c__[i__6].r = f14.r, c__[i__6].i = f14.i;
/* L160: */
			    }
			}
/* L170: */
		    }
		    if (ujsec < jsec) {
			i__4 = jj + jsec - 1;
			for (j = jj + ujsec; j <= i__4; ++j) {
			    i__5 = ii + uisec - 1;
			    for (i__ = ii; i__ <= i__5; i__ += 4) {
				i__6 = i__ + j * c_dim1;
				q__1.r = delta.r * c__[i__6].r - delta.i * 
					c__[i__6].i, q__1.i = delta.r * c__[
					i__6].i + delta.i * c__[i__6].r;
				f11.r = q__1.r, f11.i = q__1.i;
				i__6 = i__ + 1 + j * c_dim1;
				q__1.r = delta.r * c__[i__6].r - delta.i * 
					c__[i__6].i, q__1.i = delta.r * c__[
					i__6].i + delta.i * c__[i__6].r;
				f21.r = q__1.r, f21.i = q__1.i;
				i__6 = i__ + 2 + j * c_dim1;
				q__1.r = delta.r * c__[i__6].r - delta.i * 
					c__[i__6].i, q__1.i = delta.r * c__[
					i__6].i + delta.i * c__[i__6].r;
				f31.r = q__1.r, f31.i = q__1.i;
				i__6 = i__ + 3 + j * c_dim1;
				q__1.r = delta.r * c__[i__6].r - delta.i * 
					c__[i__6].i, q__1.i = delta.r * c__[
					i__6].i + delta.i * c__[i__6].r;
				f41.r = q__1.r, f41.i = q__1.i;
				i__6 = ll + lsec - 1;
				for (l = ll; l <= i__6; ++l) {
				    i__7 = l - ll + 1 + (i__ - ii + 1 << 5) - 
					    33;
				    i__8 = l + j * b_dim1;
				    q__2.r = t1[i__7].r * b[i__8].r - t1[i__7]
					    .i * b[i__8].i, q__2.i = t1[i__7]
					    .r * b[i__8].i + t1[i__7].i * b[
					    i__8].r;
				    q__1.r = f11.r + q__2.r, q__1.i = f11.i + 
					    q__2.i;
				    f11.r = q__1.r, f11.i = q__1.i;
				    i__7 = l - ll + 1 + (i__ - ii + 2 << 5) - 
					    33;
				    i__8 = l + j * b_dim1;
				    q__2.r = t1[i__7].r * b[i__8].r - t1[i__7]
					    .i * b[i__8].i, q__2.i = t1[i__7]
					    .r * b[i__8].i + t1[i__7].i * b[
					    i__8].r;
				    q__1.r = f21.r + q__2.r, q__1.i = f21.i + 
					    q__2.i;
				    f21.r = q__1.r, f21.i = q__1.i;
				    i__7 = l - ll + 1 + (i__ - ii + 3 << 5) - 
					    33;
				    i__8 = l + j * b_dim1;
				    q__2.r = t1[i__7].r * b[i__8].r - t1[i__7]
					    .i * b[i__8].i, q__2.i = t1[i__7]
					    .r * b[i__8].i + t1[i__7].i * b[
					    i__8].r;
				    q__1.r = f31.r + q__2.r, q__1.i = f31.i + 
					    q__2.i;
				    f31.r = q__1.r, f31.i = q__1.i;
				    i__7 = l - ll + 1 + (i__ - ii + 4 << 5) - 
					    33;
				    i__8 = l + j * b_dim1;
				    q__2.r = t1[i__7].r * b[i__8].r - t1[i__7]
					    .i * b[i__8].i, q__2.i = t1[i__7]
					    .r * b[i__8].i + t1[i__7].i * b[
					    i__8].r;
				    q__1.r = f41.r + q__2.r, q__1.i = f41.i + 
					    q__2.i;
				    f41.r = q__1.r, f41.i = q__1.i;
/* L180: */
				}
				i__6 = i__ + j * c_dim1;
				c__[i__6].r = f11.r, c__[i__6].i = f11.i;
				i__6 = i__ + 1 + j * c_dim1;
				c__[i__6].r = f21.r, c__[i__6].i = f21.i;
				i__6 = i__ + 2 + j * c_dim1;
				c__[i__6].r = f31.r, c__[i__6].i = f31.i;
				i__6 = i__ + 3 + j * c_dim1;
				c__[i__6].r = f41.r, c__[i__6].i = f41.i;
/* L190: */
			    }
			    i__5 = ii + isec - 1;
			    for (i__ = ii + uisec; i__ <= i__5; ++i__) {
				i__6 = i__ + j * c_dim1;
				q__1.r = delta.r * c__[i__6].r - delta.i * 
					c__[i__6].i, q__1.i = delta.r * c__[
					i__6].i + delta.i * c__[i__6].r;
				f11.r = q__1.r, f11.i = q__1.i;
				i__6 = ll + lsec - 1;
				for (l = ll; l <= i__6; ++l) {
				    i__7 = l - ll + 1 + (i__ - ii + 1 << 5) - 
					    33;
				    i__8 = l + j * b_dim1;
				    q__2.r = t1[i__7].r * b[i__8].r - t1[i__7]
					    .i * b[i__8].i, q__2.i = t1[i__7]
					    .r * b[i__8].i + t1[i__7].i * b[
					    i__8].r;
				    q__1.r = f11.r + q__2.r, q__1.i = f11.i + 
					    q__2.i;
				    f11.r = q__1.r, f11.i = q__1.i;
/* L200: */
				}
				i__6 = i__ + j * c_dim1;
				c__[i__6].r = f11.r, c__[i__6].i = f11.i;
/* L210: */
			    }
/* L220: */
			}
		    }
/* L230: */
		}
/* L240: */
	    }
/* L250: */
	}
    } else if (! conjb) {

/*        Form  C := alpha*A*B' + beta*C or C := alpha*A'*B' + beta*C. */
/*        or  C := alpha*conj(A')*B' */

	i__1 = *n;
	for (jj = 1; jj <= i__1; jj += 96) {
/* Computing MIN */
	    i__2 = 96, i__3 = *n - jj + 1;
	    jsec = min(i__2,i__3);
	    i__2 = *k;
	    for (ll = 1; ll <= i__2; ll += 32) {
/* Computing MIN */
		i__3 = 32, i__4 = *k - ll + 1;
		lsec = min(i__3,i__4);

/*              Determine if the block of C should be updated with */
/*              beta or not. */

		delta.r = 1.f, delta.i = 0.f;
		if (ll == 1) {
		    delta.r = beta->r, delta.i = beta->i;
		}

/*              T2 := alpha*B', copy the transpose of a rectangular */
/*              block of alpha*A to T2. */

		ulsec = lsec - lsec % 2;
		ujsec = jsec - jsec % 2;
		i__3 = ll + ulsec - 1;
		for (l = ll; l <= i__3; l += 2) {
		    i__4 = jj + ujsec - 1;
		    for (j = jj; j <= i__4; j += 2) {
			i__5 = l - ll + 1 + (j - jj + 1 << 5) - 33;
			i__6 = j + l * b_dim1;
			q__1.r = alpha->r * b[i__6].r - alpha->i * b[i__6].i, 
				q__1.i = alpha->r * b[i__6].i + alpha->i * b[
				i__6].r;
			t2[i__5].r = q__1.r, t2[i__5].i = q__1.i;
			i__5 = l - ll + 2 + (j - jj + 1 << 5) - 33;
			i__6 = j + (l + 1) * b_dim1;
			q__1.r = alpha->r * b[i__6].r - alpha->i * b[i__6].i, 
				q__1.i = alpha->r * b[i__6].i + alpha->i * b[
				i__6].r;
			t2[i__5].r = q__1.r, t2[i__5].i = q__1.i;
			i__5 = l - ll + 1 + (j - jj + 2 << 5) - 33;
			i__6 = j + 1 + l * b_dim1;
			q__1.r = alpha->r * b[i__6].r - alpha->i * b[i__6].i, 
				q__1.i = alpha->r * b[i__6].i + alpha->i * b[
				i__6].r;
			t2[i__5].r = q__1.r, t2[i__5].i = q__1.i;
			i__5 = l - ll + 2 + (j - jj + 2 << 5) - 33;
			i__6 = j + 1 + (l + 1) * b_dim1;
			q__1.r = alpha->r * b[i__6].r - alpha->i * b[i__6].i, 
				q__1.i = alpha->r * b[i__6].i + alpha->i * b[
				i__6].r;
			t2[i__5].r = q__1.r, t2[i__5].i = q__1.i;
/* L260: */
		    }
		    if (ujsec < jsec) {
			i__4 = l - ll + 1 + (jsec << 5) - 33;
			i__5 = jj + jsec - 1 + l * b_dim1;
			q__1.r = alpha->r * b[i__5].r - alpha->i * b[i__5].i, 
				q__1.i = alpha->r * b[i__5].i + alpha->i * b[
				i__5].r;
			t2[i__4].r = q__1.r, t2[i__4].i = q__1.i;
			i__4 = l - ll + 2 + (jsec << 5) - 33;
			i__5 = jj + jsec - 1 + (l + 1) * b_dim1;
			q__1.r = alpha->r * b[i__5].r - alpha->i * b[i__5].i, 
				q__1.i = alpha->r * b[i__5].i + alpha->i * b[
				i__5].r;
			t2[i__4].r = q__1.r, t2[i__4].i = q__1.i;
		    }
/* L270: */
		}
		if (ulsec < lsec) {
		    i__3 = jj + jsec - 1;
		    for (j = jj; j <= i__3; ++j) {
			i__4 = lsec + (j - jj + 1 << 5) - 33;
			i__5 = j + (ll + lsec - 1) * b_dim1;
			q__1.r = alpha->r * b[i__5].r - alpha->i * b[i__5].i, 
				q__1.i = alpha->r * b[i__5].i + alpha->i * b[
				i__5].r;
			t2[i__4].r = q__1.r, t2[i__4].i = q__1.i;
/* L280: */
		    }
		}

		ujsec = jsec - jsec % 4;
		i__3 = *m;
		for (ii = 1; ii <= i__3; ii += 32) {
/* Computing MIN */
		    i__4 = 32, i__5 = *m - ii + 1;
		    isec = min(i__4,i__5);

/*                 T1 := alpha*A' or T1 := alpha*A, copy the transpose */
/*                 or the non-transpose of a rectangular block of */
/*                 alpha*A to T1. */

		    uisec = isec - isec % 2;
		    if (nota) {
			i__4 = ll + ulsec - 1;
			for (l = ll; l <= i__4; l += 2) {
			    i__5 = ii + uisec - 1;
			    for (i__ = ii; i__ <= i__5; i__ += 2) {
				i__6 = l - ll + 1 + (i__ - ii + 1 << 5) - 33;
				i__7 = i__ + l * a_dim1;
				t1[i__6].r = a[i__7].r, t1[i__6].i = a[i__7]
					.i;
				i__6 = l - ll + 2 + (i__ - ii + 1 << 5) - 33;
				i__7 = i__ + (l + 1) * a_dim1;
				t1[i__6].r = a[i__7].r, t1[i__6].i = a[i__7]
					.i;
				i__6 = l - ll + 1 + (i__ - ii + 2 << 5) - 33;
				i__7 = i__ + 1 + l * a_dim1;
				t1[i__6].r = a[i__7].r, t1[i__6].i = a[i__7]
					.i;
				i__6 = l - ll + 2 + (i__ - ii + 2 << 5) - 33;
				i__7 = i__ + 1 + (l + 1) * a_dim1;
				t1[i__6].r = a[i__7].r, t1[i__6].i = a[i__7]
					.i;
/* L290: */
			    }
			    if (uisec < isec) {
				i__5 = l - ll + 1 + (isec << 5) - 33;
				i__6 = ii + isec - 1 + l * a_dim1;
				t1[i__5].r = a[i__6].r, t1[i__5].i = a[i__6]
					.i;
				i__5 = l - ll + 2 + (isec << 5) - 33;
				i__6 = ii + isec - 1 + (l + 1) * a_dim1;
				t1[i__5].r = a[i__6].r, t1[i__5].i = a[i__6]
					.i;
			    }
/* L300: */
			}
			if (ulsec < lsec) {
			    i__4 = ii + isec - 1;
			    for (i__ = ii; i__ <= i__4; ++i__) {
				i__5 = lsec + (i__ - ii + 1 << 5) - 33;
				i__6 = i__ + (ll + lsec - 1) * a_dim1;
				t1[i__5].r = a[i__6].r, t1[i__5].i = a[i__6]
					.i;
/* L310: */
			    }
			}
		    } else if (conja) {
			i__4 = ii + uisec - 1;
			for (i__ = ii; i__ <= i__4; i__ += 2) {
			    i__5 = ll + ulsec - 1;
			    for (l = ll; l <= i__5; l += 2) {
				i__6 = l - ll + 1 + (i__ - ii + 1 << 5) - 33;
				r_cnjg(&q__1, &a[l + i__ * a_dim1]);
				t1[i__6].r = q__1.r, t1[i__6].i = q__1.i;
				i__6 = l - ll + 1 + (i__ - ii + 2 << 5) - 33;
				r_cnjg(&q__1, &a[l + (i__ + 1) * a_dim1]);
				t1[i__6].r = q__1.r, t1[i__6].i = q__1.i;
				i__6 = l - ll + 2 + (i__ - ii + 1 << 5) - 33;
				r_cnjg(&q__1, &a[l + 1 + i__ * a_dim1]);
				t1[i__6].r = q__1.r, t1[i__6].i = q__1.i;
				i__6 = l - ll + 2 + (i__ - ii + 2 << 5) - 33;
				r_cnjg(&q__1, &a[l + 1 + (i__ + 1) * a_dim1]);
				t1[i__6].r = q__1.r, t1[i__6].i = q__1.i;
/* L1020: */
			    }
			    if (ulsec < lsec) {
				i__5 = lsec + (i__ - ii + 1 << 5) - 33;
				r_cnjg(&q__1, &a[ll + lsec - 1 + i__ * a_dim1]
					);
				t1[i__5].r = q__1.r, t1[i__5].i = q__1.i;
				i__5 = lsec + (i__ - ii + 2 << 5) - 33;
				r_cnjg(&q__1, &a[ll + lsec - 1 + (i__ + 1) * 
					a_dim1]);
				t1[i__5].r = q__1.r, t1[i__5].i = q__1.i;
			    }
/* L1030: */
			}
			if (uisec < isec) {
			    i__4 = ll + lsec - 1;
			    for (l = ll; l <= i__4; ++l) {
				i__5 = l - ll + 1 + (isec << 5) - 33;
				r_cnjg(&q__1, &a[l + (ii + isec - 1) * a_dim1]
					);
				t1[i__5].r = q__1.r, t1[i__5].i = q__1.i;
/* L1040: */
			    }
			}
		    } else {
			i__4 = ii + uisec - 1;
			for (i__ = ii; i__ <= i__4; i__ += 2) {
			    i__5 = ll + ulsec - 1;
			    for (l = ll; l <= i__5; l += 2) {
				i__6 = l - ll + 1 + (i__ - ii + 1 << 5) - 33;
				i__7 = l + i__ * a_dim1;
				t1[i__6].r = a[i__7].r, t1[i__6].i = a[i__7]
					.i;
				i__6 = l - ll + 1 + (i__ - ii + 2 << 5) - 33;
				i__7 = l + (i__ + 1) * a_dim1;
				t1[i__6].r = a[i__7].r, t1[i__6].i = a[i__7]
					.i;
				i__6 = l - ll + 2 + (i__ - ii + 1 << 5) - 33;
				i__7 = l + 1 + i__ * a_dim1;
				t1[i__6].r = a[i__7].r, t1[i__6].i = a[i__7]
					.i;
				i__6 = l - ll + 2 + (i__ - ii + 2 << 5) - 33;
				i__7 = l + 1 + (i__ + 1) * a_dim1;
				t1[i__6].r = a[i__7].r, t1[i__6].i = a[i__7]
					.i;
/* L320: */
			    }
			    if (ulsec < lsec) {
				i__5 = lsec + (i__ - ii + 1 << 5) - 33;
				i__6 = ll + lsec - 1 + i__ * a_dim1;
				t1[i__5].r = a[i__6].r, t1[i__5].i = a[i__6]
					.i;
				i__5 = lsec + (i__ - ii + 2 << 5) - 33;
				i__6 = ll + lsec - 1 + (i__ + 1) * a_dim1;
				t1[i__5].r = a[i__6].r, t1[i__5].i = a[i__6]
					.i;
			    }
/* L330: */
			}
			if (uisec < isec) {
			    i__4 = ll + lsec - 1;
			    for (l = ll; l <= i__4; ++l) {
				i__5 = l - ll + 1 + (isec << 5) - 33;
				i__6 = l + (ii + isec - 1) * a_dim1;
				t1[i__5].r = a[i__6].r, t1[i__5].i = a[i__6]
					.i;
/* L340: */
			    }
			}
		    }

/*                 C := T1'*B + beta*C, update a rectangular block */
/*                 of C using 4 by 4 unrolling. */

		    uisec = isec - isec % 4;
		    i__4 = jj + ujsec - 1;
		    for (j = jj; j <= i__4; j += 4) {
			i__5 = ii + uisec - 1;
			for (i__ = ii; i__ <= i__5; i__ += 4) {
			    i__6 = i__ + j * c_dim1;
			    q__1.r = delta.r * c__[i__6].r - delta.i * c__[
				    i__6].i, q__1.i = delta.r * c__[i__6].i + 
				    delta.i * c__[i__6].r;
			    f11.r = q__1.r, f11.i = q__1.i;
			    i__6 = i__ + 1 + j * c_dim1;
			    q__1.r = delta.r * c__[i__6].r - delta.i * c__[
				    i__6].i, q__1.i = delta.r * c__[i__6].i + 
				    delta.i * c__[i__6].r;
			    f21.r = q__1.r, f21.i = q__1.i;
			    i__6 = i__ + (j + 1) * c_dim1;
			    q__1.r = delta.r * c__[i__6].r - delta.i * c__[
				    i__6].i, q__1.i = delta.r * c__[i__6].i + 
				    delta.i * c__[i__6].r;
			    f12.r = q__1.r, f12.i = q__1.i;
			    i__6 = i__ + 1 + (j + 1) * c_dim1;
			    q__1.r = delta.r * c__[i__6].r - delta.i * c__[
				    i__6].i, q__1.i = delta.r * c__[i__6].i + 
				    delta.i * c__[i__6].r;
			    f22.r = q__1.r, f22.i = q__1.i;
			    i__6 = i__ + (j + 2) * c_dim1;
			    q__1.r = delta.r * c__[i__6].r - delta.i * c__[
				    i__6].i, q__1.i = delta.r * c__[i__6].i + 
				    delta.i * c__[i__6].r;
			    f13.r = q__1.r, f13.i = q__1.i;
			    i__6 = i__ + 1 + (j + 2) * c_dim1;
			    q__1.r = delta.r * c__[i__6].r - delta.i * c__[
				    i__6].i, q__1.i = delta.r * c__[i__6].i + 
				    delta.i * c__[i__6].r;
			    f23.r = q__1.r, f23.i = q__1.i;
			    i__6 = i__ + (j + 3) * c_dim1;
			    q__1.r = delta.r * c__[i__6].r - delta.i * c__[
				    i__6].i, q__1.i = delta.r * c__[i__6].i + 
				    delta.i * c__[i__6].r;
			    f14.r = q__1.r, f14.i = q__1.i;
			    i__6 = i__ + 1 + (j + 3) * c_dim1;
			    q__1.r = delta.r * c__[i__6].r - delta.i * c__[
				    i__6].i, q__1.i = delta.r * c__[i__6].i + 
				    delta.i * c__[i__6].r;
			    f24.r = q__1.r, f24.i = q__1.i;
			    i__6 = i__ + 2 + j * c_dim1;
			    q__1.r = delta.r * c__[i__6].r - delta.i * c__[
				    i__6].i, q__1.i = delta.r * c__[i__6].i + 
				    delta.i * c__[i__6].r;
			    f31.r = q__1.r, f31.i = q__1.i;
			    i__6 = i__ + 3 + j * c_dim1;
			    q__1.r = delta.r * c__[i__6].r - delta.i * c__[
				    i__6].i, q__1.i = delta.r * c__[i__6].i + 
				    delta.i * c__[i__6].r;
			    f41.r = q__1.r, f41.i = q__1.i;
			    i__6 = i__ + 2 + (j + 1) * c_dim1;
			    q__1.r = delta.r * c__[i__6].r - delta.i * c__[
				    i__6].i, q__1.i = delta.r * c__[i__6].i + 
				    delta.i * c__[i__6].r;
			    f32.r = q__1.r, f32.i = q__1.i;
			    i__6 = i__ + 3 + (j + 1) * c_dim1;
			    q__1.r = delta.r * c__[i__6].r - delta.i * c__[
				    i__6].i, q__1.i = delta.r * c__[i__6].i + 
				    delta.i * c__[i__6].r;
			    f42.r = q__1.r, f42.i = q__1.i;
			    i__6 = i__ + 2 + (j + 2) * c_dim1;
			    q__1.r = delta.r * c__[i__6].r - delta.i * c__[
				    i__6].i, q__1.i = delta.r * c__[i__6].i + 
				    delta.i * c__[i__6].r;
			    f33.r = q__1.r, f33.i = q__1.i;
			    i__6 = i__ + 3 + (j + 2) * c_dim1;
			    q__1.r = delta.r * c__[i__6].r - delta.i * c__[
				    i__6].i, q__1.i = delta.r * c__[i__6].i + 
				    delta.i * c__[i__6].r;
			    f43.r = q__1.r, f43.i = q__1.i;
			    i__6 = i__ + 2 + (j + 3) * c_dim1;
			    q__1.r = delta.r * c__[i__6].r - delta.i * c__[
				    i__6].i, q__1.i = delta.r * c__[i__6].i + 
				    delta.i * c__[i__6].r;
			    f34.r = q__1.r, f34.i = q__1.i;
			    i__6 = i__ + 3 + (j + 3) * c_dim1;
			    q__1.r = delta.r * c__[i__6].r - delta.i * c__[
				    i__6].i, q__1.i = delta.r * c__[i__6].i + 
				    delta.i * c__[i__6].r;
			    f44.r = q__1.r, f44.i = q__1.i;
			    i__6 = ll + lsec - 1;
			    for (l = ll; l <= i__6; ++l) {
				i__7 = l - ll + 1 + (i__ - ii + 1 << 5) - 33;
				i__8 = l - ll + 1 + (j - jj + 1 << 5) - 33;
				q__2.r = t1[i__7].r * t2[i__8].r - t1[i__7].i 
					* t2[i__8].i, q__2.i = t1[i__7].r * 
					t2[i__8].i + t1[i__7].i * t2[i__8].r;
				q__1.r = f11.r + q__2.r, q__1.i = f11.i + 
					q__2.i;
				f11.r = q__1.r, f11.i = q__1.i;
				i__7 = l - ll + 1 + (i__ - ii + 2 << 5) - 33;
				i__8 = l - ll + 1 + (j - jj + 1 << 5) - 33;
				q__2.r = t1[i__7].r * t2[i__8].r - t1[i__7].i 
					* t2[i__8].i, q__2.i = t1[i__7].r * 
					t2[i__8].i + t1[i__7].i * t2[i__8].r;
				q__1.r = f21.r + q__2.r, q__1.i = f21.i + 
					q__2.i;
				f21.r = q__1.r, f21.i = q__1.i;
				i__7 = l - ll + 1 + (i__ - ii + 1 << 5) - 33;
				i__8 = l - ll + 1 + (j - jj + 2 << 5) - 33;
				q__2.r = t1[i__7].r * t2[i__8].r - t1[i__7].i 
					* t2[i__8].i, q__2.i = t1[i__7].r * 
					t2[i__8].i + t1[i__7].i * t2[i__8].r;
				q__1.r = f12.r + q__2.r, q__1.i = f12.i + 
					q__2.i;
				f12.r = q__1.r, f12.i = q__1.i;
				i__7 = l - ll + 1 + (i__ - ii + 2 << 5) - 33;
				i__8 = l - ll + 1 + (j - jj + 2 << 5) - 33;
				q__2.r = t1[i__7].r * t2[i__8].r - t1[i__7].i 
					* t2[i__8].i, q__2.i = t1[i__7].r * 
					t2[i__8].i + t1[i__7].i * t2[i__8].r;
				q__1.r = f22.r + q__2.r, q__1.i = f22.i + 
					q__2.i;
				f22.r = q__1.r, f22.i = q__1.i;
				i__7 = l - ll + 1 + (i__ - ii + 1 << 5) - 33;
				i__8 = l - ll + 1 + (j - jj + 3 << 5) - 33;
				q__2.r = t1[i__7].r * t2[i__8].r - t1[i__7].i 
					* t2[i__8].i, q__2.i = t1[i__7].r * 
					t2[i__8].i + t1[i__7].i * t2[i__8].r;
				q__1.r = f13.r + q__2.r, q__1.i = f13.i + 
					q__2.i;
				f13.r = q__1.r, f13.i = q__1.i;
				i__7 = l - ll + 1 + (i__ - ii + 2 << 5) - 33;
				i__8 = l - ll + 1 + (j - jj + 3 << 5) - 33;
				q__2.r = t1[i__7].r * t2[i__8].r - t1[i__7].i 
					* t2[i__8].i, q__2.i = t1[i__7].r * 
					t2[i__8].i + t1[i__7].i * t2[i__8].r;
				q__1.r = f23.r + q__2.r, q__1.i = f23.i + 
					q__2.i;
				f23.r = q__1.r, f23.i = q__1.i;
				i__7 = l - ll + 1 + (i__ - ii + 1 << 5) - 33;
				i__8 = l - ll + 1 + (j - jj + 4 << 5) - 33;
				q__2.r = t1[i__7].r * t2[i__8].r - t1[i__7].i 
					* t2[i__8].i, q__2.i = t1[i__7].r * 
					t2[i__8].i + t1[i__7].i * t2[i__8].r;
				q__1.r = f14.r + q__2.r, q__1.i = f14.i + 
					q__2.i;
				f14.r = q__1.r, f14.i = q__1.i;
				i__7 = l - ll + 1 + (i__ - ii + 2 << 5) - 33;
				i__8 = l - ll + 1 + (j - jj + 4 << 5) - 33;
				q__2.r = t1[i__7].r * t2[i__8].r - t1[i__7].i 
					* t2[i__8].i, q__2.i = t1[i__7].r * 
					t2[i__8].i + t1[i__7].i * t2[i__8].r;
				q__1.r = f24.r + q__2.r, q__1.i = f24.i + 
					q__2.i;
				f24.r = q__1.r, f24.i = q__1.i;
				i__7 = l - ll + 1 + (i__ - ii + 3 << 5) - 33;
				i__8 = l - ll + 1 + (j - jj + 1 << 5) - 33;
				q__2.r = t1[i__7].r * t2[i__8].r - t1[i__7].i 
					* t2[i__8].i, q__2.i = t1[i__7].r * 
					t2[i__8].i + t1[i__7].i * t2[i__8].r;
				q__1.r = f31.r + q__2.r, q__1.i = f31.i + 
					q__2.i;
				f31.r = q__1.r, f31.i = q__1.i;
				i__7 = l - ll + 1 + (i__ - ii + 4 << 5) - 33;
				i__8 = l - ll + 1 + (j - jj + 1 << 5) - 33;
				q__2.r = t1[i__7].r * t2[i__8].r - t1[i__7].i 
					* t2[i__8].i, q__2.i = t1[i__7].r * 
					t2[i__8].i + t1[i__7].i * t2[i__8].r;
				q__1.r = f41.r + q__2.r, q__1.i = f41.i + 
					q__2.i;
				f41.r = q__1.r, f41.i = q__1.i;
				i__7 = l - ll + 1 + (i__ - ii + 3 << 5) - 33;
				i__8 = l - ll + 1 + (j - jj + 2 << 5) - 33;
				q__2.r = t1[i__7].r * t2[i__8].r - t1[i__7].i 
					* t2[i__8].i, q__2.i = t1[i__7].r * 
					t2[i__8].i + t1[i__7].i * t2[i__8].r;
				q__1.r = f32.r + q__2.r, q__1.i = f32.i + 
					q__2.i;
				f32.r = q__1.r, f32.i = q__1.i;
				i__7 = l - ll + 1 + (i__ - ii + 4 << 5) - 33;
				i__8 = l - ll + 1 + (j - jj + 2 << 5) - 33;
				q__2.r = t1[i__7].r * t2[i__8].r - t1[i__7].i 
					* t2[i__8].i, q__2.i = t1[i__7].r * 
					t2[i__8].i + t1[i__7].i * t2[i__8].r;
				q__1.r = f42.r + q__2.r, q__1.i = f42.i + 
					q__2.i;
				f42.r = q__1.r, f42.i = q__1.i;
				i__7 = l - ll + 1 + (i__ - ii + 3 << 5) - 33;
				i__8 = l - ll + 1 + (j - jj + 3 << 5) - 33;
				q__2.r = t1[i__7].r * t2[i__8].r - t1[i__7].i 
					* t2[i__8].i, q__2.i = t1[i__7].r * 
					t2[i__8].i + t1[i__7].i * t2[i__8].r;
				q__1.r = f33.r + q__2.r, q__1.i = f33.i + 
					q__2.i;
				f33.r = q__1.r, f33.i = q__1.i;
				i__7 = l - ll + 1 + (i__ - ii + 4 << 5) - 33;
				i__8 = l - ll + 1 + (j - jj + 3 << 5) - 33;
				q__2.r = t1[i__7].r * t2[i__8].r - t1[i__7].i 
					* t2[i__8].i, q__2.i = t1[i__7].r * 
					t2[i__8].i + t1[i__7].i * t2[i__8].r;
				q__1.r = f43.r + q__2.r, q__1.i = f43.i + 
					q__2.i;
				f43.r = q__1.r, f43.i = q__1.i;
				i__7 = l - ll + 1 + (i__ - ii + 3 << 5) - 33;
				i__8 = l - ll + 1 + (j - jj + 4 << 5) - 33;
				q__2.r = t1[i__7].r * t2[i__8].r - t1[i__7].i 
					* t2[i__8].i, q__2.i = t1[i__7].r * 
					t2[i__8].i + t1[i__7].i * t2[i__8].r;
				q__1.r = f34.r + q__2.r, q__1.i = f34.i + 
					q__2.i;
				f34.r = q__1.r, f34.i = q__1.i;
				i__7 = l - ll + 1 + (i__ - ii + 4 << 5) - 33;
				i__8 = l - ll + 1 + (j - jj + 4 << 5) - 33;
				q__2.r = t1[i__7].r * t2[i__8].r - t1[i__7].i 
					* t2[i__8].i, q__2.i = t1[i__7].r * 
					t2[i__8].i + t1[i__7].i * t2[i__8].r;
				q__1.r = f44.r + q__2.r, q__1.i = f44.i + 
					q__2.i;
				f44.r = q__1.r, f44.i = q__1.i;
/* L350: */
			    }
			    i__6 = i__ + j * c_dim1;
			    c__[i__6].r = f11.r, c__[i__6].i = f11.i;
			    i__6 = i__ + 1 + j * c_dim1;
			    c__[i__6].r = f21.r, c__[i__6].i = f21.i;
			    i__6 = i__ + (j + 1) * c_dim1;
			    c__[i__6].r = f12.r, c__[i__6].i = f12.i;
			    i__6 = i__ + 1 + (j + 1) * c_dim1;
			    c__[i__6].r = f22.r, c__[i__6].i = f22.i;
			    i__6 = i__ + (j + 2) * c_dim1;
			    c__[i__6].r = f13.r, c__[i__6].i = f13.i;
			    i__6 = i__ + 1 + (j + 2) * c_dim1;
			    c__[i__6].r = f23.r, c__[i__6].i = f23.i;
			    i__6 = i__ + (j + 3) * c_dim1;
			    c__[i__6].r = f14.r, c__[i__6].i = f14.i;
			    i__6 = i__ + 1 + (j + 3) * c_dim1;
			    c__[i__6].r = f24.r, c__[i__6].i = f24.i;
			    i__6 = i__ + 2 + j * c_dim1;
			    c__[i__6].r = f31.r, c__[i__6].i = f31.i;
			    i__6 = i__ + 3 + j * c_dim1;
			    c__[i__6].r = f41.r, c__[i__6].i = f41.i;
			    i__6 = i__ + 2 + (j + 1) * c_dim1;
			    c__[i__6].r = f32.r, c__[i__6].i = f32.i;
			    i__6 = i__ + 3 + (j + 1) * c_dim1;
			    c__[i__6].r = f42.r, c__[i__6].i = f42.i;
			    i__6 = i__ + 2 + (j + 2) * c_dim1;
			    c__[i__6].r = f33.r, c__[i__6].i = f33.i;
			    i__6 = i__ + 3 + (j + 2) * c_dim1;
			    c__[i__6].r = f43.r, c__[i__6].i = f43.i;
			    i__6 = i__ + 2 + (j + 3) * c_dim1;
			    c__[i__6].r = f34.r, c__[i__6].i = f34.i;
			    i__6 = i__ + 3 + (j + 3) * c_dim1;
			    c__[i__6].r = f44.r, c__[i__6].i = f44.i;
/* L360: */
			}
			if (uisec < isec) {
			    i__5 = ii + isec - 1;
			    for (i__ = ii + uisec; i__ <= i__5; ++i__) {
				i__6 = i__ + j * c_dim1;
				q__1.r = delta.r * c__[i__6].r - delta.i * 
					c__[i__6].i, q__1.i = delta.r * c__[
					i__6].i + delta.i * c__[i__6].r;
				f11.r = q__1.r, f11.i = q__1.i;
				i__6 = i__ + (j + 1) * c_dim1;
				q__1.r = delta.r * c__[i__6].r - delta.i * 
					c__[i__6].i, q__1.i = delta.r * c__[
					i__6].i + delta.i * c__[i__6].r;
				f12.r = q__1.r, f12.i = q__1.i;
				i__6 = i__ + (j + 2) * c_dim1;
				q__1.r = delta.r * c__[i__6].r - delta.i * 
					c__[i__6].i, q__1.i = delta.r * c__[
					i__6].i + delta.i * c__[i__6].r;
				f13.r = q__1.r, f13.i = q__1.i;
				i__6 = i__ + (j + 3) * c_dim1;
				q__1.r = delta.r * c__[i__6].r - delta.i * 
					c__[i__6].i, q__1.i = delta.r * c__[
					i__6].i + delta.i * c__[i__6].r;
				f14.r = q__1.r, f14.i = q__1.i;
				i__6 = ll + lsec - 1;
				for (l = ll; l <= i__6; ++l) {
				    i__7 = l - ll + 1 + (i__ - ii + 1 << 5) - 
					    33;
				    i__8 = l - ll + 1 + (j - jj + 1 << 5) - 
					    33;
				    q__2.r = t1[i__7].r * t2[i__8].r - t1[
					    i__7].i * t2[i__8].i, q__2.i = t1[
					    i__7].r * t2[i__8].i + t1[i__7].i 
					    * t2[i__8].r;
				    q__1.r = f11.r + q__2.r, q__1.i = f11.i + 
					    q__2.i;
				    f11.r = q__1.r, f11.i = q__1.i;
				    i__7 = l - ll + 1 + (i__ - ii + 1 << 5) - 
					    33;
				    i__8 = l - ll + 1 + (j - jj + 2 << 5) - 
					    33;
				    q__2.r = t1[i__7].r * t2[i__8].r - t1[
					    i__7].i * t2[i__8].i, q__2.i = t1[
					    i__7].r * t2[i__8].i + t1[i__7].i 
					    * t2[i__8].r;
				    q__1.r = f12.r + q__2.r, q__1.i = f12.i + 
					    q__2.i;
				    f12.r = q__1.r, f12.i = q__1.i;
				    i__7 = l - ll + 1 + (i__ - ii + 1 << 5) - 
					    33;
				    i__8 = l - ll + 1 + (j - jj + 3 << 5) - 
					    33;
				    q__2.r = t1[i__7].r * t2[i__8].r - t1[
					    i__7].i * t2[i__8].i, q__2.i = t1[
					    i__7].r * t2[i__8].i + t1[i__7].i 
					    * t2[i__8].r;
				    q__1.r = f13.r + q__2.r, q__1.i = f13.i + 
					    q__2.i;
				    f13.r = q__1.r, f13.i = q__1.i;
				    i__7 = l - ll + 1 + (i__ - ii + 1 << 5) - 
					    33;
				    i__8 = l - ll + 1 + (j - jj + 4 << 5) - 
					    33;
				    q__2.r = t1[i__7].r * t2[i__8].r - t1[
					    i__7].i * t2[i__8].i, q__2.i = t1[
					    i__7].r * t2[i__8].i + t1[i__7].i 
					    * t2[i__8].r;
				    q__1.r = f14.r + q__2.r, q__1.i = f14.i + 
					    q__2.i;
				    f14.r = q__1.r, f14.i = q__1.i;
/* L370: */
				}
				i__6 = i__ + j * c_dim1;
				c__[i__6].r = f11.r, c__[i__6].i = f11.i;
				i__6 = i__ + (j + 1) * c_dim1;
				c__[i__6].r = f12.r, c__[i__6].i = f12.i;
				i__6 = i__ + (j + 2) * c_dim1;
				c__[i__6].r = f13.r, c__[i__6].i = f13.i;
				i__6 = i__ + (j + 3) * c_dim1;
				c__[i__6].r = f14.r, c__[i__6].i = f14.i;
/* L380: */
			    }
			}
/* L390: */
		    }
		    if (ujsec < jsec) {
			i__4 = jj + jsec - 1;
			for (j = jj + ujsec; j <= i__4; ++j) {
			    i__5 = ii + uisec - 1;
			    for (i__ = ii; i__ <= i__5; i__ += 4) {
				i__6 = i__ + j * c_dim1;
				q__1.r = delta.r * c__[i__6].r - delta.i * 
					c__[i__6].i, q__1.i = delta.r * c__[
					i__6].i + delta.i * c__[i__6].r;
				f11.r = q__1.r, f11.i = q__1.i;
				i__6 = i__ + 1 + j * c_dim1;
				q__1.r = delta.r * c__[i__6].r - delta.i * 
					c__[i__6].i, q__1.i = delta.r * c__[
					i__6].i + delta.i * c__[i__6].r;
				f21.r = q__1.r, f21.i = q__1.i;
				i__6 = i__ + 2 + j * c_dim1;
				q__1.r = delta.r * c__[i__6].r - delta.i * 
					c__[i__6].i, q__1.i = delta.r * c__[
					i__6].i + delta.i * c__[i__6].r;
				f31.r = q__1.r, f31.i = q__1.i;
				i__6 = i__ + 3 + j * c_dim1;
				q__1.r = delta.r * c__[i__6].r - delta.i * 
					c__[i__6].i, q__1.i = delta.r * c__[
					i__6].i + delta.i * c__[i__6].r;
				f41.r = q__1.r, f41.i = q__1.i;
				i__6 = ll + lsec - 1;
				for (l = ll; l <= i__6; ++l) {
				    i__7 = l - ll + 1 + (i__ - ii + 1 << 5) - 
					    33;
				    i__8 = l - ll + 1 + (j - jj + 1 << 5) - 
					    33;
				    q__2.r = t1[i__7].r * t2[i__8].r - t1[
					    i__7].i * t2[i__8].i, q__2.i = t1[
					    i__7].r * t2[i__8].i + t1[i__7].i 
					    * t2[i__8].r;
				    q__1.r = f11.r + q__2.r, q__1.i = f11.i + 
					    q__2.i;
				    f11.r = q__1.r, f11.i = q__1.i;
				    i__7 = l - ll + 1 + (i__ - ii + 2 << 5) - 
					    33;
				    i__8 = l - ll + 1 + (j - jj + 1 << 5) - 
					    33;
				    q__2.r = t1[i__7].r * t2[i__8].r - t1[
					    i__7].i * t2[i__8].i, q__2.i = t1[
					    i__7].r * t2[i__8].i + t1[i__7].i 
					    * t2[i__8].r;
				    q__1.r = f21.r + q__2.r, q__1.i = f21.i + 
					    q__2.i;
				    f21.r = q__1.r, f21.i = q__1.i;
				    i__7 = l - ll + 1 + (i__ - ii + 3 << 5) - 
					    33;
				    i__8 = l - ll + 1 + (j - jj + 1 << 5) - 
					    33;
				    q__2.r = t1[i__7].r * t2[i__8].r - t1[
					    i__7].i * t2[i__8].i, q__2.i = t1[
					    i__7].r * t2[i__8].i + t1[i__7].i 
					    * t2[i__8].r;
				    q__1.r = f31.r + q__2.r, q__1.i = f31.i + 
					    q__2.i;
				    f31.r = q__1.r, f31.i = q__1.i;
				    i__7 = l - ll + 1 + (i__ - ii + 4 << 5) - 
					    33;
				    i__8 = l - ll + 1 + (j - jj + 1 << 5) - 
					    33;
				    q__2.r = t1[i__7].r * t2[i__8].r - t1[
					    i__7].i * t2[i__8].i, q__2.i = t1[
					    i__7].r * t2[i__8].i + t1[i__7].i 
					    * t2[i__8].r;
				    q__1.r = f41.r + q__2.r, q__1.i = f41.i + 
					    q__2.i;
				    f41.r = q__1.r, f41.i = q__1.i;
/* L400: */
				}
				i__6 = i__ + j * c_dim1;
				c__[i__6].r = f11.r, c__[i__6].i = f11.i;
				i__6 = i__ + 1 + j * c_dim1;
				c__[i__6].r = f21.r, c__[i__6].i = f21.i;
				i__6 = i__ + 2 + j * c_dim1;
				c__[i__6].r = f31.r, c__[i__6].i = f31.i;
				i__6 = i__ + 3 + j * c_dim1;
				c__[i__6].r = f41.r, c__[i__6].i = f41.i;
/* L410: */
			    }
			    i__5 = ii + isec - 1;
			    for (i__ = ii + uisec; i__ <= i__5; ++i__) {
				i__6 = i__ + j * c_dim1;
				q__1.r = delta.r * c__[i__6].r - delta.i * 
					c__[i__6].i, q__1.i = delta.r * c__[
					i__6].i + delta.i * c__[i__6].r;
				f11.r = q__1.r, f11.i = q__1.i;
				i__6 = ll + lsec - 1;
				for (l = ll; l <= i__6; ++l) {
				    i__7 = l - ll + 1 + (i__ - ii + 1 << 5) - 
					    33;
				    i__8 = l - ll + 1 + (j - jj + 1 << 5) - 
					    33;
				    q__2.r = t1[i__7].r * t2[i__8].r - t1[
					    i__7].i * t2[i__8].i, q__2.i = t1[
					    i__7].r * t2[i__8].i + t1[i__7].i 
					    * t2[i__8].r;
				    q__1.r = f11.r + q__2.r, q__1.i = f11.i + 
					    q__2.i;
				    f11.r = q__1.r, f11.i = q__1.i;
/* L420: */
				}
				i__6 = i__ + j * c_dim1;
				c__[i__6].r = f11.r, c__[i__6].i = f11.i;
/* L430: */
			    }
/* L440: */
			}
		    }
/* L450: */
		}
/* L460: */
	    }
/* L470: */
	}
    } else {

/*      Form  C:=alpha*A*conj(B')+beta*C or C:=alpha*A'*conj(B')+beta*C. */
/*       or  C := alpha*conj(A')*conj(B') */

	i__1 = *n;
	for (jj = 1; jj <= i__1; jj += 96) {
/* Computing MIN */
	    i__2 = 96, i__3 = *n - jj + 1;
	    jsec = min(i__2,i__3);
	    i__2 = *k;
	    for (ll = 1; ll <= i__2; ll += 32) {
/* Computing MIN */
		i__3 = 32, i__4 = *k - ll + 1;
		lsec = min(i__3,i__4);

/*              Determine if the block of C should be updated with */
/*              beta or not. */

		delta.r = 1.f, delta.i = 0.f;
		if (ll == 1) {
		    delta.r = beta->r, delta.i = beta->i;
		}

/*              T2 := alpha*B', copy the transpose of a rectangular */
/*              block of alpha*A to T2. */

		ulsec = lsec - lsec % 2;
		ujsec = jsec - jsec % 2;
		i__3 = ll + ulsec - 1;
		for (l = ll; l <= i__3; l += 2) {
		    i__4 = jj + ujsec - 1;
		    for (j = jj; j <= i__4; j += 2) {
			i__5 = l - ll + 1 + (j - jj + 1 << 5) - 33;
			r_cnjg(&q__2, &b[j + l * b_dim1]);
			q__1.r = alpha->r * q__2.r - alpha->i * q__2.i, 
				q__1.i = alpha->r * q__2.i + alpha->i * 
				q__2.r;
			t2[i__5].r = q__1.r, t2[i__5].i = q__1.i;
			i__5 = l - ll + 2 + (j - jj + 1 << 5) - 33;
			r_cnjg(&q__2, &b[j + (l + 1) * b_dim1]);
			q__1.r = alpha->r * q__2.r - alpha->i * q__2.i, 
				q__1.i = alpha->r * q__2.i + alpha->i * 
				q__2.r;
			t2[i__5].r = q__1.r, t2[i__5].i = q__1.i;
			i__5 = l - ll + 1 + (j - jj + 2 << 5) - 33;
			r_cnjg(&q__2, &b[j + 1 + l * b_dim1]);
			q__1.r = alpha->r * q__2.r - alpha->i * q__2.i, 
				q__1.i = alpha->r * q__2.i + alpha->i * 
				q__2.r;
			t2[i__5].r = q__1.r, t2[i__5].i = q__1.i;
			i__5 = l - ll + 2 + (j - jj + 2 << 5) - 33;
			r_cnjg(&q__2, &b[j + 1 + (l + 1) * b_dim1]);
			q__1.r = alpha->r * q__2.r - alpha->i * q__2.i, 
				q__1.i = alpha->r * q__2.i + alpha->i * 
				q__2.r;
			t2[i__5].r = q__1.r, t2[i__5].i = q__1.i;
/* L660: */
		    }
		    if (ujsec < jsec) {
			i__4 = l - ll + 1 + (jsec << 5) - 33;
			r_cnjg(&q__2, &b[jj + jsec - 1 + l * b_dim1]);
			q__1.r = alpha->r * q__2.r - alpha->i * q__2.i, 
				q__1.i = alpha->r * q__2.i + alpha->i * 
				q__2.r;
			t2[i__4].r = q__1.r, t2[i__4].i = q__1.i;
			i__4 = l - ll + 2 + (jsec << 5) - 33;
			r_cnjg(&q__2, &b[jj + jsec - 1 + (l + 1) * b_dim1]);
			q__1.r = alpha->r * q__2.r - alpha->i * q__2.i, 
				q__1.i = alpha->r * q__2.i + alpha->i * 
				q__2.r;
			t2[i__4].r = q__1.r, t2[i__4].i = q__1.i;
		    }
/* L670: */
		}
		if (ulsec < lsec) {
		    i__3 = jj + jsec - 1;
		    for (j = jj; j <= i__3; ++j) {
			i__4 = lsec + (j - jj + 1 << 5) - 33;
			r_cnjg(&q__2, &b[j + (ll + lsec - 1) * b_dim1]);
			q__1.r = alpha->r * q__2.r - alpha->i * q__2.i, 
				q__1.i = alpha->r * q__2.i + alpha->i * 
				q__2.r;
			t2[i__4].r = q__1.r, t2[i__4].i = q__1.i;
/* L680: */
		    }
		}

		ujsec = jsec - jsec % 4;
		i__3 = *m;
		for (ii = 1; ii <= i__3; ii += 32) {
/* Computing MIN */
		    i__4 = 32, i__5 = *m - ii + 1;
		    isec = min(i__4,i__5);

/*                 T1 := alpha*A' or T1 := alpha*A, copy the transpose */
/*                 or the non-transpose of a rectangular block of */
/*                 alpha*A to T1. */

		    uisec = isec - isec % 2;
		    if (nota) {
			i__4 = ll + ulsec - 1;
			for (l = ll; l <= i__4; l += 2) {
			    i__5 = ii + uisec - 1;
			    for (i__ = ii; i__ <= i__5; i__ += 2) {
				i__6 = l - ll + 1 + (i__ - ii + 1 << 5) - 33;
				i__7 = i__ + l * a_dim1;
				t1[i__6].r = a[i__7].r, t1[i__6].i = a[i__7]
					.i;
				i__6 = l - ll + 2 + (i__ - ii + 1 << 5) - 33;
				i__7 = i__ + (l + 1) * a_dim1;
				t1[i__6].r = a[i__7].r, t1[i__6].i = a[i__7]
					.i;
				i__6 = l - ll + 1 + (i__ - ii + 2 << 5) - 33;
				i__7 = i__ + 1 + l * a_dim1;
				t1[i__6].r = a[i__7].r, t1[i__6].i = a[i__7]
					.i;
				i__6 = l - ll + 2 + (i__ - ii + 2 << 5) - 33;
				i__7 = i__ + 1 + (l + 1) * a_dim1;
				t1[i__6].r = a[i__7].r, t1[i__6].i = a[i__7]
					.i;
/* L690: */
			    }
			    if (uisec < isec) {
				i__5 = l - ll + 1 + (isec << 5) - 33;
				i__6 = ii + isec - 1 + l * a_dim1;
				t1[i__5].r = a[i__6].r, t1[i__5].i = a[i__6]
					.i;
				i__5 = l - ll + 2 + (isec << 5) - 33;
				i__6 = ii + isec - 1 + (l + 1) * a_dim1;
				t1[i__5].r = a[i__6].r, t1[i__5].i = a[i__6]
					.i;
			    }
/* L700: */
			}
			if (ulsec < lsec) {
			    i__4 = ii + isec - 1;
			    for (i__ = ii; i__ <= i__4; ++i__) {
				i__5 = lsec + (i__ - ii + 1 << 5) - 33;
				i__6 = i__ + (ll + lsec - 1) * a_dim1;
				t1[i__5].r = a[i__6].r, t1[i__5].i = a[i__6]
					.i;
/* L710: */
			    }
			}
		    } else if (conja) {
			i__4 = ii + uisec - 1;
			for (i__ = ii; i__ <= i__4; i__ += 2) {
			    i__5 = ll + ulsec - 1;
			    for (l = ll; l <= i__5; l += 2) {
				i__6 = l - ll + 1 + (i__ - ii + 1 << 5) - 33;
				r_cnjg(&q__1, &a[l + i__ * a_dim1]);
				t1[i__6].r = q__1.r, t1[i__6].i = q__1.i;
				i__6 = l - ll + 1 + (i__ - ii + 2 << 5) - 33;
				r_cnjg(&q__1, &a[l + (i__ + 1) * a_dim1]);
				t1[i__6].r = q__1.r, t1[i__6].i = q__1.i;
				i__6 = l - ll + 2 + (i__ - ii + 1 << 5) - 33;
				r_cnjg(&q__1, &a[l + 1 + i__ * a_dim1]);
				t1[i__6].r = q__1.r, t1[i__6].i = q__1.i;
				i__6 = l - ll + 2 + (i__ - ii + 2 << 5) - 33;
				r_cnjg(&q__1, &a[l + 1 + (i__ + 1) * a_dim1]);
				t1[i__6].r = q__1.r, t1[i__6].i = q__1.i;
/* L920: */
			    }
			    if (ulsec < lsec) {
				i__5 = lsec + (i__ - ii + 1 << 5) - 33;
				r_cnjg(&q__1, &a[ll + lsec - 1 + i__ * a_dim1]
					);
				t1[i__5].r = q__1.r, t1[i__5].i = q__1.i;
				i__5 = lsec + (i__ - ii + 2 << 5) - 33;
				r_cnjg(&q__1, &a[ll + lsec - 1 + (i__ + 1) * 
					a_dim1]);
				t1[i__5].r = q__1.r, t1[i__5].i = q__1.i;
			    }
/* L930: */
			}
			if (uisec < isec) {
			    i__4 = ll + lsec - 1;
			    for (l = ll; l <= i__4; ++l) {
				i__5 = l - ll + 1 + (isec << 5) - 33;
				r_cnjg(&q__1, &a[l + (ii + isec - 1) * a_dim1]
					);
				t1[i__5].r = q__1.r, t1[i__5].i = q__1.i;
/* L940: */
			    }
			}
		    } else {
			i__4 = ii + uisec - 1;
			for (i__ = ii; i__ <= i__4; i__ += 2) {
			    i__5 = ll + ulsec - 1;
			    for (l = ll; l <= i__5; l += 2) {
				i__6 = l - ll + 1 + (i__ - ii + 1 << 5) - 33;
				i__7 = l + i__ * a_dim1;
				t1[i__6].r = a[i__7].r, t1[i__6].i = a[i__7]
					.i;
				i__6 = l - ll + 1 + (i__ - ii + 2 << 5) - 33;
				i__7 = l + (i__ + 1) * a_dim1;
				t1[i__6].r = a[i__7].r, t1[i__6].i = a[i__7]
					.i;
				i__6 = l - ll + 2 + (i__ - ii + 1 << 5) - 33;
				i__7 = l + 1 + i__ * a_dim1;
				t1[i__6].r = a[i__7].r, t1[i__6].i = a[i__7]
					.i;
				i__6 = l - ll + 2 + (i__ - ii + 2 << 5) - 33;
				i__7 = l + 1 + (i__ + 1) * a_dim1;
				t1[i__6].r = a[i__7].r, t1[i__6].i = a[i__7]
					.i;
/* L720: */
			    }
			    if (ulsec < lsec) {
				i__5 = lsec + (i__ - ii + 1 << 5) - 33;
				i__6 = ll + lsec - 1 + i__ * a_dim1;
				t1[i__5].r = a[i__6].r, t1[i__5].i = a[i__6]
					.i;
				i__5 = lsec + (i__ - ii + 2 << 5) - 33;
				i__6 = ll + lsec - 1 + (i__ + 1) * a_dim1;
				t1[i__5].r = a[i__6].r, t1[i__5].i = a[i__6]
					.i;
			    }
/* L730: */
			}
			if (uisec < isec) {
			    i__4 = ll + lsec - 1;
			    for (l = ll; l <= i__4; ++l) {
				i__5 = l - ll + 1 + (isec << 5) - 33;
				i__6 = l + (ii + isec - 1) * a_dim1;
				t1[i__5].r = a[i__6].r, t1[i__5].i = a[i__6]
					.i;
/* L740: */
			    }
			}
		    }

/*                 C := T1'*B + beta*C, update a rectangular block */
/*                 of C using 4 by 4 unrolling. */

		    uisec = isec - isec % 4;
		    i__4 = jj + ujsec - 1;
		    for (j = jj; j <= i__4; j += 4) {
			i__5 = ii + uisec - 1;
			for (i__ = ii; i__ <= i__5; i__ += 4) {
			    i__6 = i__ + j * c_dim1;
			    q__1.r = delta.r * c__[i__6].r - delta.i * c__[
				    i__6].i, q__1.i = delta.r * c__[i__6].i + 
				    delta.i * c__[i__6].r;
			    f11.r = q__1.r, f11.i = q__1.i;
			    i__6 = i__ + 1 + j * c_dim1;
			    q__1.r = delta.r * c__[i__6].r - delta.i * c__[
				    i__6].i, q__1.i = delta.r * c__[i__6].i + 
				    delta.i * c__[i__6].r;
			    f21.r = q__1.r, f21.i = q__1.i;
			    i__6 = i__ + (j + 1) * c_dim1;
			    q__1.r = delta.r * c__[i__6].r - delta.i * c__[
				    i__6].i, q__1.i = delta.r * c__[i__6].i + 
				    delta.i * c__[i__6].r;
			    f12.r = q__1.r, f12.i = q__1.i;
			    i__6 = i__ + 1 + (j + 1) * c_dim1;
			    q__1.r = delta.r * c__[i__6].r - delta.i * c__[
				    i__6].i, q__1.i = delta.r * c__[i__6].i + 
				    delta.i * c__[i__6].r;
			    f22.r = q__1.r, f22.i = q__1.i;
			    i__6 = i__ + (j + 2) * c_dim1;
			    q__1.r = delta.r * c__[i__6].r - delta.i * c__[
				    i__6].i, q__1.i = delta.r * c__[i__6].i + 
				    delta.i * c__[i__6].r;
			    f13.r = q__1.r, f13.i = q__1.i;
			    i__6 = i__ + 1 + (j + 2) * c_dim1;
			    q__1.r = delta.r * c__[i__6].r - delta.i * c__[
				    i__6].i, q__1.i = delta.r * c__[i__6].i + 
				    delta.i * c__[i__6].r;
			    f23.r = q__1.r, f23.i = q__1.i;
			    i__6 = i__ + (j + 3) * c_dim1;
			    q__1.r = delta.r * c__[i__6].r - delta.i * c__[
				    i__6].i, q__1.i = delta.r * c__[i__6].i + 
				    delta.i * c__[i__6].r;
			    f14.r = q__1.r, f14.i = q__1.i;
			    i__6 = i__ + 1 + (j + 3) * c_dim1;
			    q__1.r = delta.r * c__[i__6].r - delta.i * c__[
				    i__6].i, q__1.i = delta.r * c__[i__6].i + 
				    delta.i * c__[i__6].r;
			    f24.r = q__1.r, f24.i = q__1.i;
			    i__6 = i__ + 2 + j * c_dim1;
			    q__1.r = delta.r * c__[i__6].r - delta.i * c__[
				    i__6].i, q__1.i = delta.r * c__[i__6].i + 
				    delta.i * c__[i__6].r;
			    f31.r = q__1.r, f31.i = q__1.i;
			    i__6 = i__ + 3 + j * c_dim1;
			    q__1.r = delta.r * c__[i__6].r - delta.i * c__[
				    i__6].i, q__1.i = delta.r * c__[i__6].i + 
				    delta.i * c__[i__6].r;
			    f41.r = q__1.r, f41.i = q__1.i;
			    i__6 = i__ + 2 + (j + 1) * c_dim1;
			    q__1.r = delta.r * c__[i__6].r - delta.i * c__[
				    i__6].i, q__1.i = delta.r * c__[i__6].i + 
				    delta.i * c__[i__6].r;
			    f32.r = q__1.r, f32.i = q__1.i;
			    i__6 = i__ + 3 + (j + 1) * c_dim1;
			    q__1.r = delta.r * c__[i__6].r - delta.i * c__[
				    i__6].i, q__1.i = delta.r * c__[i__6].i + 
				    delta.i * c__[i__6].r;
			    f42.r = q__1.r, f42.i = q__1.i;
			    i__6 = i__ + 2 + (j + 2) * c_dim1;
			    q__1.r = delta.r * c__[i__6].r - delta.i * c__[
				    i__6].i, q__1.i = delta.r * c__[i__6].i + 
				    delta.i * c__[i__6].r;
			    f33.r = q__1.r, f33.i = q__1.i;
			    i__6 = i__ + 3 + (j + 2) * c_dim1;
			    q__1.r = delta.r * c__[i__6].r - delta.i * c__[
				    i__6].i, q__1.i = delta.r * c__[i__6].i + 
				    delta.i * c__[i__6].r;
			    f43.r = q__1.r, f43.i = q__1.i;
			    i__6 = i__ + 2 + (j + 3) * c_dim1;
			    q__1.r = delta.r * c__[i__6].r - delta.i * c__[
				    i__6].i, q__1.i = delta.r * c__[i__6].i + 
				    delta.i * c__[i__6].r;
			    f34.r = q__1.r, f34.i = q__1.i;
			    i__6 = i__ + 3 + (j + 3) * c_dim1;
			    q__1.r = delta.r * c__[i__6].r - delta.i * c__[
				    i__6].i, q__1.i = delta.r * c__[i__6].i + 
				    delta.i * c__[i__6].r;
			    f44.r = q__1.r, f44.i = q__1.i;
			    i__6 = ll + lsec - 1;
			    for (l = ll; l <= i__6; ++l) {
				i__7 = l - ll + 1 + (i__ - ii + 1 << 5) - 33;
				i__8 = l - ll + 1 + (j - jj + 1 << 5) - 33;
				q__2.r = t1[i__7].r * t2[i__8].r - t1[i__7].i 
					* t2[i__8].i, q__2.i = t1[i__7].r * 
					t2[i__8].i + t1[i__7].i * t2[i__8].r;
				q__1.r = f11.r + q__2.r, q__1.i = f11.i + 
					q__2.i;
				f11.r = q__1.r, f11.i = q__1.i;
				i__7 = l - ll + 1 + (i__ - ii + 2 << 5) - 33;
				i__8 = l - ll + 1 + (j - jj + 1 << 5) - 33;
				q__2.r = t1[i__7].r * t2[i__8].r - t1[i__7].i 
					* t2[i__8].i, q__2.i = t1[i__7].r * 
					t2[i__8].i + t1[i__7].i * t2[i__8].r;
				q__1.r = f21.r + q__2.r, q__1.i = f21.i + 
					q__2.i;
				f21.r = q__1.r, f21.i = q__1.i;
				i__7 = l - ll + 1 + (i__ - ii + 1 << 5) - 33;
				i__8 = l - ll + 1 + (j - jj + 2 << 5) - 33;
				q__2.r = t1[i__7].r * t2[i__8].r - t1[i__7].i 
					* t2[i__8].i, q__2.i = t1[i__7].r * 
					t2[i__8].i + t1[i__7].i * t2[i__8].r;
				q__1.r = f12.r + q__2.r, q__1.i = f12.i + 
					q__2.i;
				f12.r = q__1.r, f12.i = q__1.i;
				i__7 = l - ll + 1 + (i__ - ii + 2 << 5) - 33;
				i__8 = l - ll + 1 + (j - jj + 2 << 5) - 33;
				q__2.r = t1[i__7].r * t2[i__8].r - t1[i__7].i 
					* t2[i__8].i, q__2.i = t1[i__7].r * 
					t2[i__8].i + t1[i__7].i * t2[i__8].r;
				q__1.r = f22.r + q__2.r, q__1.i = f22.i + 
					q__2.i;
				f22.r = q__1.r, f22.i = q__1.i;
				i__7 = l - ll + 1 + (i__ - ii + 1 << 5) - 33;
				i__8 = l - ll + 1 + (j - jj + 3 << 5) - 33;
				q__2.r = t1[i__7].r * t2[i__8].r - t1[i__7].i 
					* t2[i__8].i, q__2.i = t1[i__7].r * 
					t2[i__8].i + t1[i__7].i * t2[i__8].r;
				q__1.r = f13.r + q__2.r, q__1.i = f13.i + 
					q__2.i;
				f13.r = q__1.r, f13.i = q__1.i;
				i__7 = l - ll + 1 + (i__ - ii + 2 << 5) - 33;
				i__8 = l - ll + 1 + (j - jj + 3 << 5) - 33;
				q__2.r = t1[i__7].r * t2[i__8].r - t1[i__7].i 
					* t2[i__8].i, q__2.i = t1[i__7].r * 
					t2[i__8].i + t1[i__7].i * t2[i__8].r;
				q__1.r = f23.r + q__2.r, q__1.i = f23.i + 
					q__2.i;
				f23.r = q__1.r, f23.i = q__1.i;
				i__7 = l - ll + 1 + (i__ - ii + 1 << 5) - 33;
				i__8 = l - ll + 1 + (j - jj + 4 << 5) - 33;
				q__2.r = t1[i__7].r * t2[i__8].r - t1[i__7].i 
					* t2[i__8].i, q__2.i = t1[i__7].r * 
					t2[i__8].i + t1[i__7].i * t2[i__8].r;
				q__1.r = f14.r + q__2.r, q__1.i = f14.i + 
					q__2.i;
				f14.r = q__1.r, f14.i = q__1.i;
				i__7 = l - ll + 1 + (i__ - ii + 2 << 5) - 33;
				i__8 = l - ll + 1 + (j - jj + 4 << 5) - 33;
				q__2.r = t1[i__7].r * t2[i__8].r - t1[i__7].i 
					* t2[i__8].i, q__2.i = t1[i__7].r * 
					t2[i__8].i + t1[i__7].i * t2[i__8].r;
				q__1.r = f24.r + q__2.r, q__1.i = f24.i + 
					q__2.i;
				f24.r = q__1.r, f24.i = q__1.i;
				i__7 = l - ll + 1 + (i__ - ii + 3 << 5) - 33;
				i__8 = l - ll + 1 + (j - jj + 1 << 5) - 33;
				q__2.r = t1[i__7].r * t2[i__8].r - t1[i__7].i 
					* t2[i__8].i, q__2.i = t1[i__7].r * 
					t2[i__8].i + t1[i__7].i * t2[i__8].r;
				q__1.r = f31.r + q__2.r, q__1.i = f31.i + 
					q__2.i;
				f31.r = q__1.r, f31.i = q__1.i;
				i__7 = l - ll + 1 + (i__ - ii + 4 << 5) - 33;
				i__8 = l - ll + 1 + (j - jj + 1 << 5) - 33;
				q__2.r = t1[i__7].r * t2[i__8].r - t1[i__7].i 
					* t2[i__8].i, q__2.i = t1[i__7].r * 
					t2[i__8].i + t1[i__7].i * t2[i__8].r;
				q__1.r = f41.r + q__2.r, q__1.i = f41.i + 
					q__2.i;
				f41.r = q__1.r, f41.i = q__1.i;
				i__7 = l - ll + 1 + (i__ - ii + 3 << 5) - 33;
				i__8 = l - ll + 1 + (j - jj + 2 << 5) - 33;
				q__2.r = t1[i__7].r * t2[i__8].r - t1[i__7].i 
					* t2[i__8].i, q__2.i = t1[i__7].r * 
					t2[i__8].i + t1[i__7].i * t2[i__8].r;
				q__1.r = f32.r + q__2.r, q__1.i = f32.i + 
					q__2.i;
				f32.r = q__1.r, f32.i = q__1.i;
				i__7 = l - ll + 1 + (i__ - ii + 4 << 5) - 33;
				i__8 = l - ll + 1 + (j - jj + 2 << 5) - 33;
				q__2.r = t1[i__7].r * t2[i__8].r - t1[i__7].i 
					* t2[i__8].i, q__2.i = t1[i__7].r * 
					t2[i__8].i + t1[i__7].i * t2[i__8].r;
				q__1.r = f42.r + q__2.r, q__1.i = f42.i + 
					q__2.i;
				f42.r = q__1.r, f42.i = q__1.i;
				i__7 = l - ll + 1 + (i__ - ii + 3 << 5) - 33;
				i__8 = l - ll + 1 + (j - jj + 3 << 5) - 33;
				q__2.r = t1[i__7].r * t2[i__8].r - t1[i__7].i 
					* t2[i__8].i, q__2.i = t1[i__7].r * 
					t2[i__8].i + t1[i__7].i * t2[i__8].r;
				q__1.r = f33.r + q__2.r, q__1.i = f33.i + 
					q__2.i;
				f33.r = q__1.r, f33.i = q__1.i;
				i__7 = l - ll + 1 + (i__ - ii + 4 << 5) - 33;
				i__8 = l - ll + 1 + (j - jj + 3 << 5) - 33;
				q__2.r = t1[i__7].r * t2[i__8].r - t1[i__7].i 
					* t2[i__8].i, q__2.i = t1[i__7].r * 
					t2[i__8].i + t1[i__7].i * t2[i__8].r;
				q__1.r = f43.r + q__2.r, q__1.i = f43.i + 
					q__2.i;
				f43.r = q__1.r, f43.i = q__1.i;
				i__7 = l - ll + 1 + (i__ - ii + 3 << 5) - 33;
				i__8 = l - ll + 1 + (j - jj + 4 << 5) - 33;
				q__2.r = t1[i__7].r * t2[i__8].r - t1[i__7].i 
					* t2[i__8].i, q__2.i = t1[i__7].r * 
					t2[i__8].i + t1[i__7].i * t2[i__8].r;
				q__1.r = f34.r + q__2.r, q__1.i = f34.i + 
					q__2.i;
				f34.r = q__1.r, f34.i = q__1.i;
				i__7 = l - ll + 1 + (i__ - ii + 4 << 5) - 33;
				i__8 = l - ll + 1 + (j - jj + 4 << 5) - 33;
				q__2.r = t1[i__7].r * t2[i__8].r - t1[i__7].i 
					* t2[i__8].i, q__2.i = t1[i__7].r * 
					t2[i__8].i + t1[i__7].i * t2[i__8].r;
				q__1.r = f44.r + q__2.r, q__1.i = f44.i + 
					q__2.i;
				f44.r = q__1.r, f44.i = q__1.i;
/* L750: */
			    }
			    i__6 = i__ + j * c_dim1;
			    c__[i__6].r = f11.r, c__[i__6].i = f11.i;
			    i__6 = i__ + 1 + j * c_dim1;
			    c__[i__6].r = f21.r, c__[i__6].i = f21.i;
			    i__6 = i__ + (j + 1) * c_dim1;
			    c__[i__6].r = f12.r, c__[i__6].i = f12.i;
			    i__6 = i__ + 1 + (j + 1) * c_dim1;
			    c__[i__6].r = f22.r, c__[i__6].i = f22.i;
			    i__6 = i__ + (j + 2) * c_dim1;
			    c__[i__6].r = f13.r, c__[i__6].i = f13.i;
			    i__6 = i__ + 1 + (j + 2) * c_dim1;
			    c__[i__6].r = f23.r, c__[i__6].i = f23.i;
			    i__6 = i__ + (j + 3) * c_dim1;
			    c__[i__6].r = f14.r, c__[i__6].i = f14.i;
			    i__6 = i__ + 1 + (j + 3) * c_dim1;
			    c__[i__6].r = f24.r, c__[i__6].i = f24.i;
			    i__6 = i__ + 2 + j * c_dim1;
			    c__[i__6].r = f31.r, c__[i__6].i = f31.i;
			    i__6 = i__ + 3 + j * c_dim1;
			    c__[i__6].r = f41.r, c__[i__6].i = f41.i;
			    i__6 = i__ + 2 + (j + 1) * c_dim1;
			    c__[i__6].r = f32.r, c__[i__6].i = f32.i;
			    i__6 = i__ + 3 + (j + 1) * c_dim1;
			    c__[i__6].r = f42.r, c__[i__6].i = f42.i;
			    i__6 = i__ + 2 + (j + 2) * c_dim1;
			    c__[i__6].r = f33.r, c__[i__6].i = f33.i;
			    i__6 = i__ + 3 + (j + 2) * c_dim1;
			    c__[i__6].r = f43.r, c__[i__6].i = f43.i;
			    i__6 = i__ + 2 + (j + 3) * c_dim1;
			    c__[i__6].r = f34.r, c__[i__6].i = f34.i;
			    i__6 = i__ + 3 + (j + 3) * c_dim1;
			    c__[i__6].r = f44.r, c__[i__6].i = f44.i;
/* L760: */
			}
			if (uisec < isec) {
			    i__5 = ii + isec - 1;
			    for (i__ = ii + uisec; i__ <= i__5; ++i__) {
				i__6 = i__ + j * c_dim1;
				q__1.r = delta.r * c__[i__6].r - delta.i * 
					c__[i__6].i, q__1.i = delta.r * c__[
					i__6].i + delta.i * c__[i__6].r;
				f11.r = q__1.r, f11.i = q__1.i;
				i__6 = i__ + (j + 1) * c_dim1;
				q__1.r = delta.r * c__[i__6].r - delta.i * 
					c__[i__6].i, q__1.i = delta.r * c__[
					i__6].i + delta.i * c__[i__6].r;
				f12.r = q__1.r, f12.i = q__1.i;
				i__6 = i__ + (j + 2) * c_dim1;
				q__1.r = delta.r * c__[i__6].r - delta.i * 
					c__[i__6].i, q__1.i = delta.r * c__[
					i__6].i + delta.i * c__[i__6].r;
				f13.r = q__1.r, f13.i = q__1.i;
				i__6 = i__ + (j + 3) * c_dim1;
				q__1.r = delta.r * c__[i__6].r - delta.i * 
					c__[i__6].i, q__1.i = delta.r * c__[
					i__6].i + delta.i * c__[i__6].r;
				f14.r = q__1.r, f14.i = q__1.i;
				i__6 = ll + lsec - 1;
				for (l = ll; l <= i__6; ++l) {
				    i__7 = l - ll + 1 + (i__ - ii + 1 << 5) - 
					    33;
				    i__8 = l - ll + 1 + (j - jj + 1 << 5) - 
					    33;
				    q__2.r = t1[i__7].r * t2[i__8].r - t1[
					    i__7].i * t2[i__8].i, q__2.i = t1[
					    i__7].r * t2[i__8].i + t1[i__7].i 
					    * t2[i__8].r;
				    q__1.r = f11.r + q__2.r, q__1.i = f11.i + 
					    q__2.i;
				    f11.r = q__1.r, f11.i = q__1.i;
				    i__7 = l - ll + 1 + (i__ - ii + 1 << 5) - 
					    33;
				    i__8 = l - ll + 1 + (j - jj + 2 << 5) - 
					    33;
				    q__2.r = t1[i__7].r * t2[i__8].r - t1[
					    i__7].i * t2[i__8].i, q__2.i = t1[
					    i__7].r * t2[i__8].i + t1[i__7].i 
					    * t2[i__8].r;
				    q__1.r = f12.r + q__2.r, q__1.i = f12.i + 
					    q__2.i;
				    f12.r = q__1.r, f12.i = q__1.i;
				    i__7 = l - ll + 1 + (i__ - ii + 1 << 5) - 
					    33;
				    i__8 = l - ll + 1 + (j - jj + 3 << 5) - 
					    33;
				    q__2.r = t1[i__7].r * t2[i__8].r - t1[
					    i__7].i * t2[i__8].i, q__2.i = t1[
					    i__7].r * t2[i__8].i + t1[i__7].i 
					    * t2[i__8].r;
				    q__1.r = f13.r + q__2.r, q__1.i = f13.i + 
					    q__2.i;
				    f13.r = q__1.r, f13.i = q__1.i;
				    i__7 = l - ll + 1 + (i__ - ii + 1 << 5) - 
					    33;
				    i__8 = l - ll + 1 + (j - jj + 4 << 5) - 
					    33;
				    q__2.r = t1[i__7].r * t2[i__8].r - t1[
					    i__7].i * t2[i__8].i, q__2.i = t1[
					    i__7].r * t2[i__8].i + t1[i__7].i 
					    * t2[i__8].r;
				    q__1.r = f14.r + q__2.r, q__1.i = f14.i + 
					    q__2.i;
				    f14.r = q__1.r, f14.i = q__1.i;
/* L770: */
				}
				i__6 = i__ + j * c_dim1;
				c__[i__6].r = f11.r, c__[i__6].i = f11.i;
				i__6 = i__ + (j + 1) * c_dim1;
				c__[i__6].r = f12.r, c__[i__6].i = f12.i;
				i__6 = i__ + (j + 2) * c_dim1;
				c__[i__6].r = f13.r, c__[i__6].i = f13.i;
				i__6 = i__ + (j + 3) * c_dim1;
				c__[i__6].r = f14.r, c__[i__6].i = f14.i;
/* L780: */
			    }
			}
/* L790: */
		    }
		    if (ujsec < jsec) {
			i__4 = jj + jsec - 1;
			for (j = jj + ujsec; j <= i__4; ++j) {
			    i__5 = ii + uisec - 1;
			    for (i__ = ii; i__ <= i__5; i__ += 4) {
				i__6 = i__ + j * c_dim1;
				q__1.r = delta.r * c__[i__6].r - delta.i * 
					c__[i__6].i, q__1.i = delta.r * c__[
					i__6].i + delta.i * c__[i__6].r;
				f11.r = q__1.r, f11.i = q__1.i;
				i__6 = i__ + 1 + j * c_dim1;
				q__1.r = delta.r * c__[i__6].r - delta.i * 
					c__[i__6].i, q__1.i = delta.r * c__[
					i__6].i + delta.i * c__[i__6].r;
				f21.r = q__1.r, f21.i = q__1.i;
				i__6 = i__ + 2 + j * c_dim1;
				q__1.r = delta.r * c__[i__6].r - delta.i * 
					c__[i__6].i, q__1.i = delta.r * c__[
					i__6].i + delta.i * c__[i__6].r;
				f31.r = q__1.r, f31.i = q__1.i;
				i__6 = i__ + 3 + j * c_dim1;
				q__1.r = delta.r * c__[i__6].r - delta.i * 
					c__[i__6].i, q__1.i = delta.r * c__[
					i__6].i + delta.i * c__[i__6].r;
				f41.r = q__1.r, f41.i = q__1.i;
				i__6 = ll + lsec - 1;
				for (l = ll; l <= i__6; ++l) {
				    i__7 = l - ll + 1 + (i__ - ii + 1 << 5) - 
					    33;
				    i__8 = l - ll + 1 + (j - jj + 1 << 5) - 
					    33;
				    q__2.r = t1[i__7].r * t2[i__8].r - t1[
					    i__7].i * t2[i__8].i, q__2.i = t1[
					    i__7].r * t2[i__8].i + t1[i__7].i 
					    * t2[i__8].r;
				    q__1.r = f11.r + q__2.r, q__1.i = f11.i + 
					    q__2.i;
				    f11.r = q__1.r, f11.i = q__1.i;
				    i__7 = l - ll + 1 + (i__ - ii + 2 << 5) - 
					    33;
				    i__8 = l - ll + 1 + (j - jj + 1 << 5) - 
					    33;
				    q__2.r = t1[i__7].r * t2[i__8].r - t1[
					    i__7].i * t2[i__8].i, q__2.i = t1[
					    i__7].r * t2[i__8].i + t1[i__7].i 
					    * t2[i__8].r;
				    q__1.r = f21.r + q__2.r, q__1.i = f21.i + 
					    q__2.i;
				    f21.r = q__1.r, f21.i = q__1.i;
				    i__7 = l - ll + 1 + (i__ - ii + 3 << 5) - 
					    33;
				    i__8 = l - ll + 1 + (j - jj + 1 << 5) - 
					    33;
				    q__2.r = t1[i__7].r * t2[i__8].r - t1[
					    i__7].i * t2[i__8].i, q__2.i = t1[
					    i__7].r * t2[i__8].i + t1[i__7].i 
					    * t2[i__8].r;
				    q__1.r = f31.r + q__2.r, q__1.i = f31.i + 
					    q__2.i;
				    f31.r = q__1.r, f31.i = q__1.i;
				    i__7 = l - ll + 1 + (i__ - ii + 4 << 5) - 
					    33;
				    i__8 = l - ll + 1 + (j - jj + 1 << 5) - 
					    33;
				    q__2.r = t1[i__7].r * t2[i__8].r - t1[
					    i__7].i * t2[i__8].i, q__2.i = t1[
					    i__7].r * t2[i__8].i + t1[i__7].i 
					    * t2[i__8].r;
				    q__1.r = f41.r + q__2.r, q__1.i = f41.i + 
					    q__2.i;
				    f41.r = q__1.r, f41.i = q__1.i;
/* L800: */
				}
				i__6 = i__ + j * c_dim1;
				c__[i__6].r = f11.r, c__[i__6].i = f11.i;
				i__6 = i__ + 1 + j * c_dim1;
				c__[i__6].r = f21.r, c__[i__6].i = f21.i;
				i__6 = i__ + 2 + j * c_dim1;
				c__[i__6].r = f31.r, c__[i__6].i = f31.i;
				i__6 = i__ + 3 + j * c_dim1;
				c__[i__6].r = f41.r, c__[i__6].i = f41.i;
/* L810: */
			    }
			    i__5 = ii + isec - 1;
			    for (i__ = ii + uisec; i__ <= i__5; ++i__) {
				i__6 = i__ + j * c_dim1;
				q__1.r = delta.r * c__[i__6].r - delta.i * 
					c__[i__6].i, q__1.i = delta.r * c__[
					i__6].i + delta.i * c__[i__6].r;
				f11.r = q__1.r, f11.i = q__1.i;
				i__6 = ll + lsec - 1;
				for (l = ll; l <= i__6; ++l) {
				    i__7 = l - ll + 1 + (i__ - ii + 1 << 5) - 
					    33;
				    i__8 = l - ll + 1 + (j - jj + 1 << 5) - 
					    33;
				    q__2.r = t1[i__7].r * t2[i__8].r - t1[
					    i__7].i * t2[i__8].i, q__2.i = t1[
					    i__7].r * t2[i__8].i + t1[i__7].i 
					    * t2[i__8].r;
				    q__1.r = f11.r + q__2.r, q__1.i = f11.i + 
					    q__2.i;
				    f11.r = q__1.r, f11.i = q__1.i;
/* L820: */
				}
				i__6 = i__ + j * c_dim1;
				c__[i__6].r = f11.r, c__[i__6].i = f11.i;
/* L830: */
			    }
/* L840: */
			}
		    }
/* L850: */
		}
/* L860: */
	    }
/* L870: */
	}
    }

    return 0;

/*     End of CGEMM. */

} /* cgemm_ */

